/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.media.AudioAttributes;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioSystem;
import android.media.IPlaybackConfigDispatcher;
import android.media.PlayerBase;
import android.media.VolumeShaper;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.audio.FocusRequester;
import com.android.server.audio.MediaFocusControl;
import com.android.server.audio.PlayerFocusEnforcer;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class PlaybackActivityMonitor
implements AudioPlaybackConfiguration.PlayerDeathMonitor,
PlayerFocusEnforcer {
    public static final String TAG = "AudioService.PlaybackActivityMonitor";
    private static final boolean DEBUG = false;
    private static final int VOLUME_SHAPER_SYSTEM_DUCK_ID = 1;
    private ArrayList<PlayMonitorClient> mClients = new ArrayList();
    private boolean mHasPublicClients = false;
    private final Object mPlayerLock = new Object();
    private HashMap<Integer, AudioPlaybackConfiguration> mPlayers = new HashMap();
    private final ArrayList<Integer> mDuckedPlayers = new ArrayList();
    private final ArrayList<Integer> mMutedPlayers = new ArrayList();
    private final VolumeShaper.Configuration DUCK_VSHAPE = new VolumeShaper.Configuration.Builder().setId(1).setCurve(new float[]{0.0f, 1.0f}, new float[]{1.0f, 0.2f}).setDurationMs(MediaFocusControl.getFocusRampTimeMs(3, new AudioAttributes.Builder().setUsage(5).build())).build();
    private final HashMap<Integer, VolumeShaper> mDuckVolumeShapers = new HashMap();

    PlaybackActivityMonitor() {
        PlayMonitorClient.sListenerDeathMonitor = this;
        AudioPlaybackConfiguration.sPlayerDeathMonitor = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trackPlayer(PlayerBase.PlayerIdCard pic) {
        int newPiid = AudioSystem.newAudioPlayerId();
        AudioPlaybackConfiguration apc = new AudioPlaybackConfiguration(pic, newPiid, Binder.getCallingUid(), Binder.getCallingPid());
        apc.init();
        Object object = this.mPlayerLock;
        synchronized (object) {
            this.mPlayers.put(newPiid, apc);
        }
        return newPiid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerAttributes(int piid, AudioAttributes attr2, int binderUid) {
        boolean change;
        Object object = this.mPlayerLock;
        synchronized (object) {
            AudioPlaybackConfiguration apc = this.mPlayers.get(new Integer(piid));
            if (PlaybackActivityMonitor.checkConfigurationCaller(piid, apc, binderUid)) {
                change = apc.handleAudioAttributesEvent(attr2);
            } else {
                Log.e(TAG, "Error updating audio attributes");
                change = false;
            }
        }
        if (change) {
            this.dispatchPlaybackChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerEvent(int piid, int event, int binderUid) {
        boolean change;
        Object object = this.mPlayerLock;
        synchronized (object) {
            AudioPlaybackConfiguration apc = this.mPlayers.get(new Integer(piid));
            if (apc != null && apc.getPlayerType() == 3) {
                return;
            }
            if (PlaybackActivityMonitor.checkConfigurationCaller(piid, apc, binderUid)) {
                change = apc.handleStateEvent(event);
            } else {
                Log.e(TAG, "Error handling event " + event);
                change = false;
            }
        }
        if (change) {
            this.dispatchPlaybackChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePlayer(int piid, int binderUid) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            AudioPlaybackConfiguration apc = this.mPlayers.get(new Integer(piid));
            if (PlaybackActivityMonitor.checkConfigurationCaller(piid, apc, binderUid)) {
                this.mPlayers.remove(new Integer(piid));
                VolumeShaper vs = this.mDuckVolumeShapers.get(new Integer(piid));
                if (vs != null) {
                    vs.release();
                    this.mDuckVolumeShapers.remove(new Integer(piid));
                }
            } else {
                Log.e(TAG, "Error releasing player " + piid);
            }
        }
    }

    @Override
    public void playerDeath(int piid) {
        this.releasePlayer(piid, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(PrintWriter pw) {
        pw.println("\nPlaybackActivityMonitor dump time: " + DateFormat.getTimeInstance().format(new Date()));
        Object object = this.mPlayerLock;
        synchronized (object) {
            for (AudioPlaybackConfiguration conf : this.mPlayers.values()) {
                conf.dump(pw);
            }
            pw.println("\n  ducked player piids:");
            Iterator<Object> iterator = this.mDuckedPlayers.iterator();
            while (iterator.hasNext()) {
                int piid = (Integer)iterator.next();
                pw.println(" " + piid);
            }
            pw.println("\n  muted player piids:");
            iterator = this.mMutedPlayers.iterator();
            while (iterator.hasNext()) {
                int piid = (Integer)iterator.next();
                pw.println(" " + piid);
            }
        }
    }

    private static boolean checkConfigurationCaller(int piid, AudioPlaybackConfiguration apc, int binderUid) {
        if (apc == null) {
            Log.e(TAG, "Invalid operation: unknown player " + piid);
            return false;
        }
        if (binderUid != 0 && apc.getClientUid() != binderUid) {
            Log.e(TAG, "Forbidden operation from uid " + binderUid + " for player " + piid);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchPlaybackChange() {
        ArrayList<AudioPlaybackConfiguration> configsSystem;
        ArrayList<PlayMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            if (this.mClients.isEmpty()) {
                return;
            }
        }
        ArrayList<PlayMonitorClient> arrayList2 = this.mPlayerLock;
        synchronized (arrayList2) {
            if (this.mPlayers.isEmpty()) {
                return;
            }
            configsSystem = new ArrayList<AudioPlaybackConfiguration>(this.mPlayers.values());
        }
        arrayList2 = this.mClients;
        synchronized (arrayList2) {
            if (this.mClients.isEmpty()) {
                return;
            }
            ArrayList<AudioPlaybackConfiguration> configsPublic = this.mHasPublicClients ? this.anonymizeForPublicConsumption(configsSystem) : null;
            for (PlayMonitorClient pmc : this.mClients) {
                try {
                    if (pmc.mErrorCount >= 5) continue;
                    if (pmc.mIsPrivileged) {
                        pmc.mDispatcherCb.dispatchPlaybackConfigChange(configsSystem);
                        continue;
                    }
                    pmc.mDispatcherCb.dispatchPlaybackConfigChange(configsPublic);
                }
                catch (RemoteException e) {
                    ++pmc.mErrorCount;
                    Log.e(TAG, "Error (" + pmc.mErrorCount + ") trying to dispatch playback config change to " + pmc, e);
                }
            }
        }
    }

    private ArrayList<AudioPlaybackConfiguration> anonymizeForPublicConsumption(List<AudioPlaybackConfiguration> sysConfigs) {
        ArrayList<AudioPlaybackConfiguration> publicConfigs = new ArrayList<AudioPlaybackConfiguration>();
        for (AudioPlaybackConfiguration config : sysConfigs) {
            if (!config.isActive()) continue;
            publicConfigs.add(AudioPlaybackConfiguration.anonymizedCopy(config));
        }
        return publicConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean duckPlayers(FocusRequester winner, FocusRequester loser) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mPlayers.isEmpty()) {
                return true;
            }
            Set<Integer> piidSet = this.mPlayers.keySet();
            for (Integer piid : piidSet) {
                AudioPlaybackConfiguration apc = this.mPlayers.get(piid);
                if (apc == null || winner.hasSameUid(apc.getClientUid()) || !loser.hasSameUid(apc.getClientUid()) || apc.getPlayerState() != 2 || this.mDuckedPlayers.contains(piid)) continue;
                if (apc.getAudioAttributes().getContentType() == 1) {
                    return false;
                }
                if (apc.getPlayerType() == 3) {
                    return false;
                }
                try {
                    VolumeShaper ducker;
                    if (this.mDuckVolumeShapers.containsKey(new Integer(piid))) {
                        ducker = this.mDuckVolumeShapers.get(new Integer(piid));
                    } else {
                        ducker = new VolumeShaper(this.DUCK_VSHAPE, apc.getPlayerProxy(), true);
                        this.mDuckVolumeShapers.put(new Integer(piid), ducker);
                    }
                    ducker.apply(VolumeShaper.Operation.PLAY);
                    this.mDuckedPlayers.add(piid);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error ducking player " + piid, e);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unduckPlayers(FocusRequester winner) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mDuckedPlayers.isEmpty()) {
                return;
            }
            for (int piid : this.mDuckedPlayers) {
                AudioPlaybackConfiguration apc = this.mPlayers.get(piid);
                if (apc != null && winner.hasSameUid(apc.getClientUid())) {
                    try {
                        this.mDuckedPlayers.remove(new Integer(piid));
                        if (!this.mDuckVolumeShapers.containsKey(new Integer(piid))) continue;
                        VolumeShaper ducker = this.mDuckVolumeShapers.get(new Integer(piid));
                        ducker.apply(VolumeShaper.Operation.REVERSE);
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Error unducking player " + piid, e);
                    }
                    continue;
                }
                Log.e(TAG, "Error unducking player " + piid + ", player not found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mutePlayersForCall(int[] usagesToMute) {
        Object object = this.mPlayerLock;
        synchronized (object) {
            Set<Integer> piidSet = this.mPlayers.keySet();
            for (Integer piid : piidSet) {
                AudioPlaybackConfiguration apc = this.mPlayers.get(piid);
                if (apc == null) continue;
                int playerUsage = apc.getAudioAttributes().getUsage();
                boolean mute = false;
                for (int usageToMute : usagesToMute) {
                    if (playerUsage != usageToMute) continue;
                    mute = true;
                    break;
                }
                if (!mute) continue;
                try {
                    apc.getPlayerProxy().setVolume(0.0f);
                    this.mMutedPlayers.add(piid);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error muting player " + piid, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmutePlayersForCall() {
        Object object = this.mPlayerLock;
        synchronized (object) {
            if (this.mMutedPlayers.isEmpty()) {
                return;
            }
            for (int piid : this.mMutedPlayers) {
                AudioPlaybackConfiguration apc = this.mPlayers.get(piid);
                if (apc == null) continue;
                try {
                    apc.getPlayerProxy().setVolume(1.0f);
                }
                catch (Exception e) {
                    Log.e(TAG, "Error unmuting player " + piid, e);
                }
            }
            this.mMutedPlayers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb, boolean isPrivileged) {
        if (pcdb == null) {
            return;
        }
        ArrayList<PlayMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            PlayMonitorClient pmc = new PlayMonitorClient(pcdb, isPrivileged);
            if (pmc.init()) {
                if (!isPrivileged) {
                    this.mHasPublicClients = true;
                }
                this.mClients.add(pmc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) {
        if (pcdb == null) {
            return;
        }
        ArrayList<PlayMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            Iterator<PlayMonitorClient> clientIterator = this.mClients.iterator();
            boolean hasPublicClients = false;
            while (clientIterator.hasNext()) {
                PlayMonitorClient pmc = clientIterator.next();
                if (pcdb.equals(pmc.mDispatcherCb)) {
                    pmc.release();
                    clientIterator.remove();
                    continue;
                }
                if (pmc.mIsPrivileged) continue;
                hasPublicClients = true;
            }
            this.mHasPublicClients = hasPublicClients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AudioPlaybackConfiguration> getActivePlaybackConfigurations(boolean isPrivileged) {
        HashMap<Integer, AudioPlaybackConfiguration> hashMap = this.mPlayers;
        synchronized (hashMap) {
            ArrayList<AudioPlaybackConfiguration> configsPublic;
            if (isPrivileged) {
                return new ArrayList<AudioPlaybackConfiguration>(this.mPlayers.values());
            }
            Object object = this.mPlayerLock;
            synchronized (object) {
                configsPublic = this.anonymizeForPublicConsumption(new ArrayList<AudioPlaybackConfiguration>(this.mPlayers.values()));
            }
            return configsPublic;
        }
    }

    private static final class PlayMonitorClient
    implements IBinder.DeathRecipient {
        static PlaybackActivityMonitor sListenerDeathMonitor;
        final IPlaybackConfigDispatcher mDispatcherCb;
        final boolean mIsPrivileged;
        int mErrorCount = 0;
        static final int MAX_ERRORS = 5;

        PlayMonitorClient(IPlaybackConfigDispatcher pcdb, boolean isPrivileged) {
            this.mDispatcherCb = pcdb;
            this.mIsPrivileged = isPrivileged;
        }

        @Override
        public void binderDied() {
            Log.w(PlaybackActivityMonitor.TAG, "client died");
            sListenerDeathMonitor.unregisterPlaybackCallback(this.mDispatcherCb);
        }

        boolean init() {
            try {
                this.mDispatcherCb.asBinder().linkToDeath(this, 0);
                return true;
            }
            catch (RemoteException e) {
                Log.w(PlaybackActivityMonitor.TAG, "Could not link to client death", e);
                return false;
            }
        }

        void release() {
            this.mDispatcherCb.asBinder().unlinkToDeath(this, 0);
        }
    }
}

