/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.media.AudioFormat;
import android.media.AudioRecordingConfiguration;
import android.media.AudioSystem;
import android.media.IRecordingConfigDispatcher;
import android.media.MediaRecorder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class RecordingActivityMonitor
implements AudioSystem.AudioRecordingCallback {
    public static final String TAG = "AudioService.RecordingActivityMonitor";
    private ArrayList<RecMonitorClient> mClients = new ArrayList();
    private HashMap<Integer, AudioRecordingConfiguration> mRecordConfigs = new HashMap();

    RecordingActivityMonitor() {
        RecMonitorClient.sMonitor = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecordingConfigurationChanged(int event, int session, int source, int[] recordingInfo) {
        if (MediaRecorder.isSystemOnlyAudioSource(source)) {
            return;
        }
        List<AudioRecordingConfiguration> configs = this.updateSnapshot(event, session, source, recordingInfo);
        if (configs != null) {
            ArrayList<RecMonitorClient> arrayList = this.mClients;
            synchronized (arrayList) {
                Iterator<RecMonitorClient> clientIterator = this.mClients.iterator();
                while (clientIterator.hasNext()) {
                    try {
                        clientIterator.next().mDispatcherCb.dispatchRecordingConfigChange(configs);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Could not call dispatchRecordingConfigChange() on client", e);
                    }
                }
            }
        }
    }

    void initMonitor() {
        AudioSystem.setRecordingCallback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerRecordingCallback(IRecordingConfigDispatcher rcdb) {
        if (rcdb == null) {
            return;
        }
        ArrayList<RecMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            RecMonitorClient rmc = new RecMonitorClient(rcdb);
            if (rmc.init()) {
                this.mClients.add(rmc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) {
        if (rcdb == null) {
            return;
        }
        ArrayList<RecMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            Iterator<RecMonitorClient> clientIterator = this.mClients.iterator();
            while (clientIterator.hasNext()) {
                RecMonitorClient rmc = clientIterator.next();
                if (!rcdb.equals(rmc.mDispatcherCb)) continue;
                rmc.release();
                clientIterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AudioRecordingConfiguration> getActiveRecordingConfigurations() {
        HashMap<Integer, AudioRecordingConfiguration> hashMap = this.mRecordConfigs;
        synchronized (hashMap) {
            return new ArrayList<AudioRecordingConfiguration>(this.mRecordConfigs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AudioRecordingConfiguration> updateSnapshot(int event, int session, int source, int[] recordingInfo) {
        ArrayList<AudioRecordingConfiguration> configs;
        HashMap<Integer, AudioRecordingConfiguration> hashMap = this.mRecordConfigs;
        synchronized (hashMap) {
            boolean configChanged;
            switch (event) {
                case 0: {
                    configChanged = this.mRecordConfigs.remove(new Integer(session)) != null;
                    break;
                }
                case 1: {
                    AudioFormat clientFormat = new AudioFormat.Builder().setEncoding(recordingInfo[0]).setChannelMask(recordingInfo[1]).setSampleRate(recordingInfo[2]).build();
                    AudioFormat deviceFormat = new AudioFormat.Builder().setEncoding(recordingInfo[3]).setChannelMask(recordingInfo[4]).setSampleRate(recordingInfo[5]).build();
                    int patchHandle = recordingInfo[6];
                    Integer sessionKey = new Integer(session);
                    if (this.mRecordConfigs.containsKey(sessionKey)) {
                        AudioRecordingConfiguration updatedConfig = new AudioRecordingConfiguration(session, source, clientFormat, deviceFormat, patchHandle);
                        if (updatedConfig.equals(this.mRecordConfigs.get(sessionKey))) {
                            configChanged = false;
                            break;
                        }
                        this.mRecordConfigs.remove(sessionKey);
                        this.mRecordConfigs.put(sessionKey, updatedConfig);
                        configChanged = true;
                        break;
                    }
                    this.mRecordConfigs.put(sessionKey, new AudioRecordingConfiguration(session, source, clientFormat, deviceFormat, patchHandle));
                    configChanged = true;
                    break;
                }
                default: {
                    Log.e(TAG, String.format("Unknown event %d for session %d, source %d", event, session, source));
                    configChanged = false;
                }
            }
            configs = configChanged ? new ArrayList<AudioRecordingConfiguration>(this.mRecordConfigs.values()) : null;
        }
        return configs;
    }

    private static final class RecMonitorClient
    implements IBinder.DeathRecipient {
        static RecordingActivityMonitor sMonitor;
        final IRecordingConfigDispatcher mDispatcherCb;

        RecMonitorClient(IRecordingConfigDispatcher rcdb) {
            this.mDispatcherCb = rcdb;
        }

        @Override
        public void binderDied() {
            Log.w(RecordingActivityMonitor.TAG, "client died");
            sMonitor.unregisterRecordingCallback(this.mDispatcherCb);
        }

        boolean init() {
            try {
                this.mDispatcherCb.asBinder().linkToDeath(this, 0);
                return true;
            }
            catch (RemoteException e) {
                Log.w(RecordingActivityMonitor.TAG, "Could not link to client death", e);
                return false;
            }
        }

        void release() {
            this.mDispatcherCb.asBinder().unlinkToDeath(this, 0);
        }
    }
}

