/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.content.Context;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.Slog;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;

final class AnchoredWindow
implements View.OnLayoutChangeListener,
View.OnTouchListener {
    private static final String TAG = "AutoFill";
    private static final int NULL_HEIGHT = -1;
    private final WindowManager mWm;
    private final IBinder mAppToken;
    private final View mContentView;
    private final View mWindowSizeListenerView;
    private final int mMinMargin;
    private int mLastHeight = -1;
    private Rect mLastBounds;
    private Rect mLastDisplayBounds;

    AnchoredWindow(WindowManager wm, IBinder appToken, View contentView) {
        this.mWm = wm;
        this.mAppToken = appToken;
        this.mContentView = contentView;
        this.mContentView.addOnLayoutChangeListener(this);
        Context context = contentView.getContext();
        this.mWindowSizeListenerView = new FrameLayout(context);
        this.mWindowSizeListenerView.addOnLayoutChangeListener(this);
        this.mMinMargin = context.getResources().getDimensionPixelSize(17104937);
    }

    void show(Rect bounds) {
        Slog.d(TAG, "show bounds=" + bounds);
        if (!this.mWindowSizeListenerView.isAttachedToWindow()) {
            Slog.d(TAG, "adding mWindowSizeListenerView");
            WindowManager.LayoutParams params = AnchoredWindow.createWindowLayoutParams(this.mAppToken, 16);
            params.gravity = 51;
            params.x = 0;
            params.y = 0;
            params.width = -1;
            params.height = -1;
            this.mWm.addView(this.mWindowSizeListenerView, params);
        }
        this.updateBounds(bounds);
    }

    void hide() {
        Slog.d(TAG, "hide");
        this.mLastHeight = -1;
        this.mLastBounds = null;
        this.mLastDisplayBounds = null;
        if (this.mWindowSizeListenerView.isAttachedToWindow()) {
            Slog.d(TAG, "removing mWindowSizeListenerView");
            this.mWm.removeView(this.mWindowSizeListenerView);
        }
        if (this.mContentView.isAttachedToWindow()) {
            Slog.d(TAG, "removing mContentView");
            this.mContentView.setOnTouchListener(null);
            this.mWm.removeView(this.mContentView);
        }
    }

    @Override
    public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (view == this.mWindowSizeListenerView) {
            Slog.d(TAG, "onLayoutChange() for mWindowSizeListenerView");
            Rect displayBounds = new Rect();
            view.getBoundsOnScreen(displayBounds);
            this.updateDisplayBounds(displayBounds);
        } else if (view == this.mContentView) {
            Slog.d(TAG, "onLayoutChange() for mContentView");
            this.updateHeight();
        }
    }

    @Override
    public boolean onTouch(View view, MotionEvent event) {
        if (view == this.mContentView && event.getAction() == 4) {
            this.hide();
            return true;
        }
        return false;
    }

    private boolean updateHeight() {
        Rect displayBounds = this.mLastDisplayBounds;
        if (displayBounds == null) {
            return false;
        }
        this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayBounds.width(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayBounds.height(), Integer.MIN_VALUE));
        int height = this.mContentView.getMeasuredHeight();
        if (height != this.mLastHeight) {
            Slog.d(TAG, "updateLocked height=" + height);
            this.mLastHeight = height;
            this.update(height, this.mLastBounds, displayBounds);
            return true;
        }
        return false;
    }

    private void updateBounds(Rect bounds) {
        if (!bounds.equals(this.mLastBounds)) {
            Slog.d(TAG, "updateLocked bounds=" + bounds);
            this.mLastBounds = bounds;
            this.update(this.mLastHeight, bounds, this.mLastDisplayBounds);
        }
    }

    private void updateDisplayBounds(Rect displayBounds) {
        if (!displayBounds.equals(this.mLastDisplayBounds)) {
            Slog.d(TAG, "updateLocked displayBounds=" + displayBounds);
            this.mLastDisplayBounds = displayBounds;
            if (!this.updateHeight()) {
                this.update(this.mLastHeight, this.mLastBounds, displayBounds);
            }
        }
    }

    private void update(int height, Rect bounds, Rect displayBounds) {
        if (height == -1 || bounds == null || displayBounds == null) {
            return;
        }
        Slog.d(TAG, "updateLocked height=" + height + ", bounds=" + bounds + ", displayBounds=" + displayBounds);
        WindowManager.LayoutParams params = AnchoredWindow.createWindowLayoutParams(this.mAppToken, 262176);
        params.setTitle("AutoFill Fill");
        AnchoredWindow.updatePosition(params, height, this.mMinMargin, bounds, displayBounds);
        if (!this.mContentView.isAttachedToWindow()) {
            Slog.d(TAG, "adding mContentView");
            this.mWm.addView(this.mContentView, params);
            this.mContentView.setOnTouchListener(this);
        } else {
            Slog.d(TAG, "updating mContentView");
            this.mWm.updateViewLayout(this.mContentView, params);
        }
    }

    private static void updatePosition(WindowManager.LayoutParams params, int height, int minMargin, Rect bounds, Rect displayBounds) {
        int y;
        int gravity;
        int verticalSpace;
        boolean below;
        int verticalSpaceBelow = displayBounds.bottom - bounds.bottom - minMargin;
        if (height <= verticalSpaceBelow) {
            below = true;
            verticalSpace = height;
        } else {
            int verticalSpaceAbove = bounds.top - displayBounds.top - minMargin;
            if (height <= verticalSpaceAbove) {
                below = false;
                verticalSpace = height;
            } else if (verticalSpaceBelow >= verticalSpaceAbove) {
                below = true;
                verticalSpace = verticalSpaceBelow;
            } else {
                below = false;
                verticalSpace = verticalSpaceAbove;
            }
        }
        if (below) {
            Slog.d(TAG, "anchorBelow");
            gravity = 51;
            y = bounds.bottom - displayBounds.top;
        } else {
            Slog.d(TAG, "anchorAbove");
            gravity = 83;
            y = displayBounds.bottom - bounds.top;
        }
        int x = bounds.left - displayBounds.left;
        params.gravity = gravity;
        params.x = x;
        params.y = y;
        params.width = bounds.width();
        params.height = verticalSpace;
    }

    private static WindowManager.LayoutParams createWindowLayoutParams(IBinder appToken, int flags) {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.token = appToken;
        params.type = 2002;
        params.flags = flags | 8 | 0x20000;
        params.format = -3;
        return params;
    }
}

