/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.LocalLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.autofill.AutoFillId;
import android.view.autofill.AutoFillValue;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.IResultReceiver;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.autofill.AutoFillManagerServiceImpl;
import com.android.server.autofill.AutoFillManagerServiceShellCommand;
import com.android.server.autofill.AutoFillUI;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public final class AutoFillManagerService
extends SystemService {
    private static final String TAG = "AutoFillManagerService";
    static final String RECEIVER_BUNDLE_EXTRA_SESSIONS = "sessions";
    private final Context mContext;
    private final AutoFillUI mUi;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private SparseArray<AutoFillManagerServiceImpl> mServicesCache = new SparseArray();
    private final LocalLog mRequestsHistory = new LocalLog(100);
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(intent.getAction())) {
                String reason = intent.getStringExtra("reason");
                Slog.d(AutoFillManagerService.TAG, "close system dialogs: " + reason);
                AutoFillManagerService.this.mUi.hideAll();
            }
        }
    };

    public AutoFillManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mUi = new AutoFillUI(this.mContext);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter, null, FgThread.getHandler());
    }

    @Override
    public void onStart() {
        this.publishBinderService("autofill", new AutoFillManagerServiceStub());
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            new SettingsObserver(BackgroundThread.getHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedServiceLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStopUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeCachedServiceLocked(userId);
        }
    }

    AutoFillManagerServiceImpl getServiceForUserLocked(int userId) {
        AutoFillManagerServiceImpl service = this.mServicesCache.get(userId);
        if (service == null) {
            service = new AutoFillManagerServiceImpl(this.mContext, this.mLock, this.mRequestsHistory, userId, this.mUi);
            this.mServicesCache.put(userId, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestSaveForUser(int userId) {
        Slog.i(TAG, "requestSaveForUser(): " + userId);
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        IBinder activityToken = this.getTopActivityForUser();
        if (activityToken != null) {
            Object object = this.mLock;
            synchronized (object) {
                AutoFillManagerServiceImpl service = this.mServicesCache.get(userId);
                if (service == null) {
                    Log.w(TAG, "handleSaveForUser(): no cached service for userId " + userId);
                    return;
                }
                service.requestSaveForUserLocked(activityToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listSessions(int userId, IResultReceiver receiver) {
        Slog.i(TAG, "listSessions() for userId " + userId);
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Bundle resultData = new Bundle();
        ArrayList<String> sessions = new ArrayList<String>();
        Object object = this.mLock;
        synchronized (object) {
            if (userId != -1) {
                this.mServicesCache.get(userId).listSessionsLocked(sessions);
            } else {
                int size = this.mServicesCache.size();
                for (int i = 0; i < size; ++i) {
                    this.mServicesCache.valueAt(i).listSessionsLocked(sessions);
                }
            }
        }
        resultData.putStringArrayList(RECEIVER_BUNDLE_EXTRA_SESSIONS, sessions);
        try {
            receiver.send(0, resultData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Slog.i(TAG, "reset()");
        this.mContext.enforceCallingPermission("android.permission.MANAGE_AUTO_FILL", TAG);
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mServicesCache.size();
            for (int i = 0; i < size; ++i) {
                this.mServicesCache.valueAt(i).destroyLocked();
            }
            this.mServicesCache.clear();
        }
    }

    private void removeCachedServiceLocked(int userId) {
        AutoFillManagerServiceImpl service = this.mServicesCache.get(userId);
        if (service != null) {
            this.mServicesCache.delete(userId);
            service.destroyLocked();
        }
    }

    private void updateCachedServiceLocked(int userId) {
        AutoFillManagerServiceImpl service = this.mServicesCache.get(userId);
        if (service != null) {
            service.updateLocked();
        }
    }

    private IBinder getTopActivityForUser() {
        List<IBinder> topActivities = LocalServices.getService(ActivityManagerInternal.class).getTopVisibleActivities();
        Slog.d(TAG, "Top activities (" + topActivities.size() + "): " + topActivities);
        if (topActivities.isEmpty()) {
            Slog.w(TAG, "Could not get top activity");
            return null;
        }
        return topActivities.get(0);
    }

    private final class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
            ContentResolver resolver = AutoFillManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("auto_fill_service"), false, this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            Object object = AutoFillManagerService.this.mLock;
            synchronized (object) {
                AutoFillManagerService.this.updateCachedServiceLocked(userId);
            }
        }
    }

    final class AutoFillManagerServiceStub
    extends IAutoFillManager.Stub {
        AutoFillManagerServiceStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addClient(IAutoFillManagerClient client, int userId) {
            Object object = AutoFillManagerService.this.mLock;
            synchronized (object) {
                return AutoFillManagerService.this.getServiceForUserLocked(userId).addClientLocked(client);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAuthenticationResult(Bundle data, IBinder activityToken, int userId) {
            Object object = AutoFillManagerService.this.mLock;
            synchronized (object) {
                AutoFillManagerServiceImpl service = AutoFillManagerService.this.getServiceForUserLocked(userId);
                service.setAuthenticationResultLocked(data, activityToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startSession(IBinder activityToken, IBinder appCallback, AutoFillId autoFillId, Rect bounds, AutoFillValue value, int userId) {
            Object object = AutoFillManagerService.this.mLock;
            synchronized (object) {
                AutoFillManagerServiceImpl service = AutoFillManagerService.this.getServiceForUserLocked(userId);
                service.startSessionLocked(activityToken, appCallback, autoFillId, bounds, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateSession(IBinder activityToken, AutoFillId id2, Rect bounds, AutoFillValue value, int flags, int userId) {
            Slog.d(AutoFillManagerService.TAG, "updateSession: flags=" + flags + ", autoFillId=" + id2 + ", bounds=" + bounds + ", value=" + value);
            Object object = AutoFillManagerService.this.mLock;
            synchronized (object) {
                AutoFillManagerServiceImpl service = (AutoFillManagerServiceImpl)AutoFillManagerService.this.mServicesCache.get(UserHandle.getCallingUserId());
                if (service != null) {
                    service.updateSessionLocked(activityToken, id2, bounds, value, flags);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSession(IBinder activityToken, int userId) {
            Object object = AutoFillManagerService.this.mLock;
            synchronized (object) {
                AutoFillManagerServiceImpl service = (AutoFillManagerServiceImpl)AutoFillManagerService.this.mServicesCache.get(UserHandle.getCallingUserId());
                if (service != null) {
                    service.finishSessionLocked(activityToken);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (AutoFillManagerService.this.mContext.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump autofill from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            Object object = AutoFillManagerService.this.mLock;
            synchronized (object) {
                int size = AutoFillManagerService.this.mServicesCache.size();
                pw.print("Cached services: ");
                if (size == 0) {
                    pw.println("none");
                } else {
                    pw.println(size);
                    for (int i = 0; i < size; ++i) {
                        pw.print("\nService at index ");
                        pw.println(i);
                        AutoFillManagerServiceImpl impl = (AutoFillManagerServiceImpl)AutoFillManagerService.this.mServicesCache.valueAt(i);
                        impl.dumpLocked("  ", pw);
                    }
                }
                AutoFillManagerService.this.mUi.dump(pw);
            }
            pw.println("Requests history:");
            AutoFillManagerService.this.mRequestsHistory.reverseDump(fd, pw, args);
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new AutoFillManagerServiceShellCommand(AutoFillManagerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }
    }
}

