/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.assist.AssistStructure;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.service.autofill.AutoFillServiceInfo;
import android.service.autofill.Dataset;
import android.service.autofill.FillResponse;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.LocalLog;
import android.util.Slog;
import android.view.autofill.AutoFillId;
import android.view.autofill.AutoFillValue;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.IResultReceiver;
import com.android.server.autofill.AutoFillManagerServiceImpl$$Lambda$8;
import com.android.server.autofill.AutoFillManagerServiceImpl$Session$$Lambda$1;
import com.android.server.autofill.AutoFillManagerServiceImpl$Session$$Lambda$7;
import com.android.server.autofill.AutoFillUI;
import com.android.server.autofill.Helper;
import com.android.server.autofill.RemoteFillService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;

final class AutoFillManagerServiceImpl {
    private static final String TAG = "AutoFillManagerServiceImpl";
    private static final int MSG_SERVICE_SAVE = 1;
    private final int mUserId;
    private final Context mContext;
    private final Object mLock;
    private final AutoFillUI mUi;
    private RemoteCallbackList<IAutoFillManagerClient> mClients;
    private AutoFillServiceInfo mInfo;
    private final LocalLog mRequestsHistory;
    private final HandlerCaller.Callback mHandlerCallback = AutoFillManagerServiceImpl$$Lambda$8.get$Lambda(this);
    private final HandlerCaller mHandlerCaller = new HandlerCaller(null, Looper.getMainLooper(), this.mHandlerCallback, true);
    @GuardedBy(value="mLock")
    private final ArrayMap<IBinder, Session> mSessions = new ArrayMap();
    private final IResultReceiver mAssistReceiver = new IResultReceiver.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(int resultCode, Bundle resultData) throws RemoteException {
            Session session;
            Slog.d(AutoFillManagerServiceImpl.TAG, "resultCode on mAssistReceiver: " + resultCode);
            AssistStructure structure = (AssistStructure)resultData.getParcelable("structure");
            if (structure == null) {
                Slog.w(AutoFillManagerServiceImpl.TAG, "no assist structure for id " + resultCode);
                return;
            }
            Bundle receiverExtras = resultData.getBundle("receiverExtras");
            if (receiverExtras == null) {
                Slog.wtf(AutoFillManagerServiceImpl.TAG, "No receiverExtras on receiver");
                return;
            }
            IBinder activityToken = receiverExtras.getBinder("android.service.autofill.extra.ACTIVITY_TOKEN");
            Object object = AutoFillManagerServiceImpl.this.mLock;
            synchronized (object) {
                session = (Session)AutoFillManagerServiceImpl.this.mSessions.get(activityToken);
                if (session == null) {
                    Slog.w(AutoFillManagerServiceImpl.TAG, "no server session for activityToken " + activityToken);
                    return;
                }
                session.mStructure = structure;
            }
            structure.ensureData();
            structure.sanitizeForParceling(true);
            session.mRemoteFillService.onFillRequest(structure, null);
        }
    };

    AutoFillManagerServiceImpl(Context context, Object lock, LocalLog requestsHistory, int userId, AutoFillUI ui) {
        this.mContext = context;
        this.mLock = lock;
        this.mRequestsHistory = requestsHistory;
        this.mUserId = userId;
        this.mUi = ui;
        this.updateLocked();
    }

    CharSequence getServiceName() {
        if (this.mInfo == null) {
            return null;
        }
        ComponentName serviceComponent = this.mInfo.getServiceInfo().getComponentName();
        String packageName = serviceComponent.getPackageName();
        try {
            PackageManager pm = this.mContext.getPackageManager();
            ApplicationInfo info = pm.getApplicationInfo(packageName, 0);
            return pm.getApplicationLabel(info);
        }
        catch (Exception e) {
            Slog.w(TAG, "Could not get label for " + packageName + ": " + e);
            return packageName;
        }
    }

    void updateLocked() {
        ComponentName serviceComponent = null;
        ServiceInfo serviceInfo = null;
        String componentName = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "auto_fill_service", this.mUserId);
        if (!TextUtils.isEmpty(componentName)) {
            try {
                serviceComponent = ComponentName.unflattenFromString(componentName);
                serviceInfo = AppGlobals.getPackageManager().getServiceInfo(serviceComponent, 0, this.mUserId);
            }
            catch (RemoteException | RuntimeException e) {
                Slog.e(TAG, "Bad auto-fill service name " + componentName, e);
                return;
            }
        }
        try {
            boolean hadService = this.hasService();
            this.mInfo = serviceInfo != null ? new AutoFillServiceInfo(this.mContext.getPackageManager(), serviceComponent, this.mUserId) : null;
            if (hadService != this.hasService()) {
                if (!this.hasService()) {
                    int sessionCount = this.mSessions.size();
                    for (int i = sessionCount - 1; i >= 0; --i) {
                        Session session = this.mSessions.valueAt(i);
                        session.destroyLocked();
                        this.mSessions.removeAt(i);
                    }
                }
                this.sendStateToClients();
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Bad auto-fill service name " + componentName, e);
        }
    }

    void requestSaveForUserLocked(IBinder activityToken) {
        if (!this.hasService()) {
            return;
        }
        Session session = this.mSessions.get(activityToken);
        if (session == null) {
            Slog.w(TAG, "requestSaveForUserLocked(): no session for " + activityToken);
            return;
        }
        session.callSaveLocked();
    }

    boolean addClientLocked(IAutoFillManagerClient client) {
        if (this.mClients == null) {
            this.mClients = new RemoteCallbackList();
        }
        this.mClients.register(client);
        return this.hasService();
    }

    void setAuthenticationResultLocked(Bundle data, IBinder activityToken) {
        if (!this.hasService()) {
            return;
        }
        Session session = this.mSessions.get(activityToken);
        if (session != null) {
            session.setAuthenticationResultLocked(data);
        }
    }

    void startSessionLocked(IBinder activityToken, IBinder appCallbackToken, AutoFillId autoFillId, Rect bounds, AutoFillValue value) {
        if (!this.hasService()) {
            return;
        }
        String historyItem = "s=" + new ComponentName(this.mInfo.getServiceInfo().packageName, this.mInfo.getServiceInfo().name) + " u=" + this.mUserId + " a=" + activityToken + " i=" + autoFillId + " b=" + bounds + " v=" + value;
        this.mRequestsHistory.log(historyItem);
        Session session = this.mSessions.get(activityToken);
        if (session != null) {
            return;
        }
        Session newSession = this.createSessionByTokenLocked(activityToken, appCallbackToken);
        newSession.updateLocked(autoFillId, bounds, value, 1);
    }

    void finishSessionLocked(IBinder activityToken) {
        if (!this.hasService()) {
            return;
        }
        Session session = this.mSessions.get(activityToken);
        if (session == null) {
            Slog.w(TAG, "finishSessionLocked(): no session for " + activityToken);
            return;
        }
        session.showSaveLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSessionByTokenLocked(IBinder activityToken, IBinder appCallbackToken) {
        Session newSession = new Session(this.mContext, activityToken, appCallbackToken);
        this.mSessions.put(activityToken, newSession);
        try {
            Bundle receiverExtras = new Bundle();
            receiverExtras.putBinder("android.service.autofill.extra.ACTIVITY_TOKEN", activityToken);
            long identity = Binder.clearCallingIdentity();
            try {
                if (!ActivityManager.getService().requestAutoFillData(this.mAssistReceiver, receiverExtras, activityToken)) {
                    Slog.w(TAG, "failed to request auto-fill data for " + activityToken);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return newSession;
    }

    void updateSessionLocked(IBinder activityToken, AutoFillId autoFillId, Rect bounds, AutoFillValue value, int flags) {
        Session session = this.mSessions.get(activityToken);
        if (session == null) {
            Slog.w(TAG, "updateSessionLocked(): session gone for " + activityToken);
            return;
        }
        session.updateLocked(autoFillId, bounds, value, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSessionSave(IBinder activityToken) {
        Object object = this.mLock;
        synchronized (object) {
            Session session = this.mSessions.get(activityToken);
            if (session == null) {
                Slog.w(TAG, "handleSessionSave(): already gone: " + activityToken);
                return;
            }
            session.callSaveLocked();
        }
    }

    void destroyLocked() {
        for (Session session : this.mSessions.values()) {
            session.destroyLocked();
        }
        this.mSessions.clear();
    }

    void dumpLocked(String prefix, PrintWriter pw) {
        String prefix2 = prefix + "  ";
        pw.print(prefix);
        pw.println("Component:");
        pw.println(this.mInfo != null ? this.mInfo.getServiceInfo().getComponentName() : null);
        int size = this.mSessions.size();
        if (size == 0) {
            pw.print(prefix);
            pw.println("No sessions");
        } else {
            pw.print(prefix);
            pw.print(size);
            pw.println(" sessions:");
            for (int i = 0; i < size; ++i) {
                pw.print(prefix);
                pw.print("#");
                pw.println(i + 1);
                this.mSessions.valueAt(i).dumpLocked(prefix2, pw);
            }
        }
    }

    void listSessionsLocked(ArrayList<String> output) {
        for (IBinder activityToken : this.mSessions.keySet()) {
            output.add((this.mInfo != null ? this.mInfo.getServiceInfo().getComponentName() : null) + ":" + activityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateToClients() {
        int userClientCount;
        RemoteCallbackList<IAutoFillManagerClient> clients;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClients == null) {
                return;
            }
            clients = this.mClients;
            userClientCount = clients.beginBroadcast();
        }
        try {
            for (int i = 0; i < userClientCount; ++i) {
                IAutoFillManagerClient client = clients.getBroadcastItem(i);
                try {
                    client.setState(this.hasService());
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            clients.finishBroadcast();
        }
    }

    private boolean hasService() {
        return this.mInfo != null;
    }

    public String toString() {
        return "AutoFillManagerServiceImpl: [userId=" + this.mUserId + ", component=" + (this.mInfo != null ? this.mInfo.getServiceInfo().getComponentName() : null) + "]";
    }

    final /* synthetic */ void lambda$new$0$AutoFillManagerServiceImpl(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleSessionSave((IBinder)msg.obj);
                break;
            }
            default: {
                Slog.d(TAG, "invalid msg: " + msg);
            }
        }
    }

    final class Session
    implements RemoteFillService.FillServiceCallbacks,
    ViewState.Listener,
    AutoFillUI.AutoFillUiCallback {
        private final IBinder mActivityToken;
        @GuardedBy(value="mLock")
        private final Map<AutoFillId, ViewState> mViewStates = new ArrayMap<AutoFillId, ViewState>();
        @GuardedBy(value="mLock")
        private ViewState mCurrentViewState;
        private final IAutoFillManagerClient mClient;
        @GuardedBy(value="mLock")
        RemoteFillService mRemoteFillService;
        @GuardedBy(value="mLock")
        private FillResponse mCurrentResponse;
        @GuardedBy(value="mLock")
        private Dataset mAutoFilledDataset;
        @GuardedBy(value="mLock")
        private AssistStructure mStructure;

        private Session(Context context, IBinder activityToken, IBinder client) {
            this.mRemoteFillService = new RemoteFillService(context, AutoFillManagerServiceImpl.this.mInfo.getServiceInfo().getComponentName(), AutoFillManagerServiceImpl.this.mUserId, this);
            this.mActivityToken = activityToken;
            this.mClient = IAutoFillManagerClient.Stub.asInterface(client);
            try {
                client.linkToDeath(AutoFillManagerServiceImpl$Session$$Lambda$1.get$Lambda(this), 0);
            }
            catch (RemoteException e) {
                Slog.w(AutoFillManagerServiceImpl.TAG, "linkToDeath() on mClient failed: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFillRequestSuccess(FillResponse response) {
            if (response == null) {
                this.removeSelf();
                return;
            }
            Object object = AutoFillManagerServiceImpl.this.mLock;
            synchronized (object) {
                this.processResponseLocked(response);
            }
        }

        @Override
        public void onFillRequestFailure(CharSequence message) {
            this.getUiForShowing().showError(message);
            this.removeSelf();
        }

        @Override
        public void onSaveRequestSuccess() {
            this.removeSelf();
        }

        @Override
        public void onSaveRequestFailure(CharSequence message) {
            this.getUiForShowing().showError(message);
            this.removeSelf();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void authenticate(IntentSender intent) {
            Intent fillInIntent;
            Object object = AutoFillManagerServiceImpl.this.mLock;
            synchronized (object) {
                fillInIntent = this.createAuthFillInIntent(this.mStructure);
            }
            AutoFillManagerServiceImpl.this.mHandlerCaller.getHandler().post(AutoFillManagerServiceImpl$Session$$Lambda$7.get$Lambda(this, intent, fillInIntent));
        }

        @Override
        public void onServiceDied(RemoteFillService service) {
        }

        @Override
        public void fill(Dataset dataset) {
            this.autoFill(dataset);
        }

        @Override
        public void save() {
            AutoFillManagerServiceImpl.this.mHandlerCaller.getHandler().obtainMessage(1, this.mActivityToken).sendToTarget();
        }

        public void setAuthenticationResultLocked(Bundle data) {
            if (this.mCurrentResponse == null || data == null) {
                this.removeSelf();
            } else {
                Object result = data.getParcelable("android.view.autofill.extra.AUTHENTICATION_RESULT");
                if (result instanceof FillResponse) {
                    this.mCurrentResponse = (FillResponse)result;
                    this.processResponseLocked(this.mCurrentResponse);
                } else if (result instanceof Dataset) {
                    Dataset dataset = (Dataset)result;
                    this.mCurrentResponse.getDatasets().remove(this.mAutoFilledDataset);
                    this.mCurrentResponse.getDatasets().add(dataset);
                    this.mAutoFilledDataset = dataset;
                    this.processResponseLocked(this.mCurrentResponse);
                }
            }
        }

        public void showSaveLocked() {
            if (this.mStructure == null) {
                Slog.wtf(AutoFillManagerServiceImpl.TAG, "showSaveLocked(): no mStructure");
                return;
            }
            if (this.mCurrentResponse == null) {
                Slog.d(AutoFillManagerServiceImpl.TAG, "showSaveLocked(): no mCurrentResponse yet");
                return;
            }
            ArraySet<AutoFillId> savableIds = this.mCurrentResponse.getSavableIds();
            if (savableIds.isEmpty()) {
                Slog.d(AutoFillManagerServiceImpl.TAG, "showSaveLocked(): service doesn't want to save");
                return;
            }
            int size = savableIds.size();
            for (int i = 0; i < size; ++i) {
                AutoFillId id2 = savableIds.valueAt(i);
                ViewState state = this.mViewStates.get(id2);
                if (state == null || !state.mValueUpdated) continue;
                AutoFillValue filledValue = Helper.findValue(this.mAutoFilledDataset, id2);
                if (state.mAutoFillValue == null || state.mAutoFillValue.equals(filledValue)) continue;
                Slog.d(AutoFillManagerServiceImpl.TAG, "finishSessionLocked(): found a change on " + id2 + ": " + state.mAutoFillValue);
                this.getUiForShowing().showSaveUi();
                return;
            }
            Slog.d(AutoFillManagerServiceImpl.TAG, "showSaveLocked(): with no changes, comes no responsibilities");
        }

        private void callSaveLocked() {
            Slog.d(AutoFillManagerServiceImpl.TAG, "callSaveLocked(): mViewStates=" + this.mViewStates);
            Bundle extras = this.mCurrentResponse.getExtras();
            for (Map.Entry<AutoFillId, ViewState> entry : this.mViewStates.entrySet()) {
                AutoFillValue value = entry.getValue().mAutoFillValue;
                if (value == null) continue;
                AutoFillId id2 = entry.getKey();
                AssistStructure.ViewNode node = this.findViewNodeByIdLocked(id2);
                if (node == null) {
                    Slog.w(AutoFillManagerServiceImpl.TAG, "callSaveLocked(): did not find node with id " + id2);
                    continue;
                }
                Slog.d(AutoFillManagerServiceImpl.TAG, "callSaveLocked(): updating " + id2 + " to " + value);
                node.updateAutoFillValue(value);
            }
            this.mStructure.sanitizeForParceling(false);
            this.mRemoteFillService.onSaveRequest(this.mStructure, extras);
        }

        void updateLocked(AutoFillId id2, Rect bounds, AutoFillValue value, int flags) {
            Slog.d(AutoFillManagerServiceImpl.TAG, "updateLocked(): id=" + id2 + ", flags=" + flags);
            if (this.mAutoFilledDataset != null && (flags & 8) == 0) {
                Slog.d(AutoFillManagerServiceImpl.TAG, "updateLocked(): ignoring " + flags + " after auto-filled");
                return;
            }
            ViewState viewState = this.mViewStates.get(id2);
            if (viewState == null) {
                viewState = new ViewState(this, id2, this);
                this.mViewStates.put(id2, viewState);
            }
            if ((flags & 1) != 0) {
                this.mCurrentViewState = viewState;
                viewState.update(value, bounds);
                return;
            }
            if ((flags & 8) != 0) {
                if (value != null && !value.equals(viewState.mAutoFillValue)) {
                    AutoFillValue filledValue;
                    viewState.mValueUpdated = true;
                    if (this.mAutoFilledDataset != null && value.equals(filledValue = Helper.findValue(this.mAutoFilledDataset, id2))) {
                        viewState.mAutoFillValue = value;
                        return;
                    }
                    viewState.mAutoFillValue = value;
                    AutoFillManagerServiceImpl.this.mUi.updateFillUi(value.coerceToString());
                }
                return;
            }
            if ((flags & 2) != 0) {
                if (this.mCurrentViewState != viewState) {
                    AutoFillManagerServiceImpl.this.mUi.hideFillUi();
                    this.mCurrentViewState = viewState;
                }
                viewState.update(value, bounds);
                if (this.mCurrentResponse != null) {
                    viewState.setResponse(this.mCurrentResponse);
                }
                return;
            }
            if ((flags & 4) != 0) {
                if (this.mCurrentViewState == viewState) {
                    AutoFillManagerServiceImpl.this.mUi.hideFillUi();
                    this.mCurrentViewState = null;
                }
                return;
            }
            Slog.w(AutoFillManagerServiceImpl.TAG, "unknown flags " + flags);
        }

        @Override
        public void onFillReady(ViewState viewState, FillResponse response, Rect bounds, AutoFillId filledId, AutoFillValue value) {
            CharSequence text;
            String filterText = "";
            if (value != null && (text = value.getTextValue()) != null) {
                filterText = text.toString();
            }
            this.getUiForShowing().showFillUi(filledId, response, bounds, filterText);
        }

        private void processResponseLocked(FillResponse response) {
            Slog.d(AutoFillManagerServiceImpl.TAG, "processResponseLocked(authRequired=" + response.getAuthentication() + "):" + response);
            if (this.mCurrentViewState == null) {
                Slog.w(AutoFillManagerServiceImpl.TAG, "processResponseLocked(): mCurrentResponse is null");
                return;
            }
            this.mCurrentResponse = response;
            if (this.mCurrentResponse.getAuthentication() != null) {
                Intent fillInIntent = this.createAuthFillInIntent(this.mStructure);
                this.mCurrentViewState.setResponse(this.mCurrentResponse, fillInIntent);
                return;
            }
            this.mCurrentViewState.setResponse(this.mCurrentResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void autoFill(Dataset dataset) {
            Object object = AutoFillManagerServiceImpl.this.mLock;
            synchronized (object) {
                this.mAutoFilledDataset = dataset;
                if (dataset.getAuthentication() == null) {
                    this.autoFillApp(dataset);
                    return;
                }
                Intent fillInIntent = this.createAuthFillInIntent(this.mStructure);
                this.startAuthentication(dataset.getAuthentication(), fillInIntent);
            }
        }

        CharSequence getServiceName() {
            return AutoFillManagerServiceImpl.this.getServiceName();
        }

        private Intent createAuthFillInIntent(AssistStructure structure) {
            Intent fillInIntent = new Intent();
            fillInIntent.putExtra("android.view.autofill.extra.ASSIST_STRUCTURE", structure);
            return fillInIntent;
        }

        private void startAuthentication(IntentSender intent, Intent fillInIntent) {
            try {
                this.mClient.authenticate(intent, fillInIntent);
            }
            catch (RemoteException e) {
                Slog.e(AutoFillManagerServiceImpl.TAG, "Error launching auth intent", e);
            }
        }

        void dumpLocked(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("mActivityToken: ");
            pw.println(this.mActivityToken);
            pw.print(prefix);
            pw.print("mCurrentResponse: ");
            pw.println(this.mCurrentResponse);
            pw.print(prefix);
            pw.print("mAutoFilledDataset: ");
            pw.println(this.mAutoFilledDataset);
            pw.print(prefix);
            pw.print("mCurrentViewStates: ");
            pw.println(this.mCurrentViewState);
            pw.print(prefix);
            pw.print("mViewStates: ");
            pw.println(this.mViewStates.size());
            String prefix2 = prefix + "  ";
            for (Map.Entry<AutoFillId, ViewState> entry : this.mViewStates.entrySet()) {
                pw.print(prefix);
                pw.print("State for id ");
                pw.println(entry.getKey());
                entry.getValue().dump(prefix2, pw);
            }
            this.mRemoteFillService.dump(prefix, pw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void autoFillApp(Dataset dataset) {
            Object object = AutoFillManagerServiceImpl.this.mLock;
            synchronized (object) {
                try {
                    Slog.d(AutoFillManagerServiceImpl.TAG, "autoFillApp(): the buck is on the app: " + dataset);
                    this.mClient.autoFill(dataset.getFieldIds(), dataset.getFieldValues());
                }
                catch (RemoteException e) {
                    Slog.w(AutoFillManagerServiceImpl.TAG, "Error auto-filling activity: " + e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AutoFillUI getUiForShowing() {
            Object object = AutoFillManagerServiceImpl.this.mLock;
            synchronized (object) {
                AutoFillManagerServiceImpl.this.mUi.setCallbackLocked(this, this.mActivityToken);
                return AutoFillManagerServiceImpl.this.mUi;
            }
        }

        private AssistStructure.ViewNode findViewNodeByIdLocked(AutoFillId id2) {
            int size = this.mStructure.getWindowNodeCount();
            for (int i = 0; i < size; ++i) {
                AssistStructure.WindowNode window = this.mStructure.getWindowNodeAt(i);
                AssistStructure.ViewNode root = window.getRootViewNode();
                if (id2.equals(root.getAutoFillId())) {
                    return root;
                }
                AssistStructure.ViewNode child = this.findViewNodeByIdLocked(root, id2);
                if (child == null) continue;
                return child;
            }
            return null;
        }

        private AssistStructure.ViewNode findViewNodeByIdLocked(AssistStructure.ViewNode parent, AutoFillId id2) {
            int childrenSize = parent.getChildCount();
            if (childrenSize > 0) {
                for (int i = 0; i < childrenSize; ++i) {
                    AssistStructure.ViewNode child = parent.getChildAt(i);
                    if (id2.equals(child.getAutoFillId())) {
                        return child;
                    }
                    AssistStructure.ViewNode grandChild = this.findViewNodeByIdLocked(child, id2);
                    if (grandChild == null || !id2.equals(grandChild.getAutoFillId())) continue;
                    return grandChild;
                }
            }
            return null;
        }

        private void destroyLocked() {
            this.mRemoteFillService.destroy();
            AutoFillManagerServiceImpl.this.mUi.setCallbackLocked(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeSelf() {
            Object object = AutoFillManagerServiceImpl.this.mLock;
            synchronized (object) {
                this.destroyLocked();
                AutoFillManagerServiceImpl.this.mSessions.remove(this.mActivityToken);
            }
        }

        final /* synthetic */ void lambda$authenticate$2$AutoFillManagerServiceImpl$Session(IntentSender intentSender, Intent intent) {
            this.startAuthentication(intentSender, intent);
        }

        final /* synthetic */ void lambda$new$1$AutoFillManagerServiceImpl$Session() {
            Slog.d(AutoFillManagerServiceImpl.TAG, "app binder died");
            this.removeSelf();
        }
    }

    static final class ViewState {
        final AutoFillId mId;
        private final Listener mListener;
        private final Session mSession;
        FillResponse mResponse;
        Intent mAuthIntent;
        private AutoFillValue mAutoFillValue;
        private Rect mBounds;
        private boolean mValueUpdated;

        ViewState(Session session, AutoFillId id2, Listener listener) {
            this.mSession = session;
            this.mId = id2;
            this.mListener = listener;
        }

        void setResponse(FillResponse response) {
            this.mResponse = response;
            this.maybeCallOnFillReady();
        }

        void setResponse(FillResponse response, Intent authIntent) {
            this.mAuthIntent = authIntent;
            this.setResponse(response);
        }

        CharSequence getServiceName() {
            return this.mSession.getServiceName();
        }

        void update(AutoFillValue autoFillValue, Rect bounds) {
            if (autoFillValue != null) {
                this.mAutoFillValue = autoFillValue;
            }
            if (bounds != null) {
                this.mBounds = bounds;
            }
            this.maybeCallOnFillReady();
        }

        void maybeCallOnFillReady() {
            if (this.mResponse != null && (this.mResponse.getAuthentication() != null || this.mResponse.getDatasets() != null) && this.mBounds != null) {
                this.mListener.onFillReady(this, this.mResponse, this.mBounds, this.mId, this.mAutoFillValue);
            }
        }

        public String toString() {
            return "ViewState: [id=" + this.mId + ", value=" + this.mAutoFillValue + ", bounds=" + this.mBounds + ", updated = " + this.mValueUpdated + "]";
        }

        void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("id:");
            pw.println(this.mId);
            pw.print(prefix);
            pw.print("value:");
            pw.println(this.mAutoFillValue);
            pw.print(prefix);
            pw.print("updated:");
            pw.println(this.mValueUpdated);
            pw.print(prefix);
            pw.print("bounds:");
            pw.println(this.mBounds);
            pw.print(prefix);
            pw.print("authIntent:");
            pw.println(this.mAuthIntent);
        }

        static interface Listener {
            public void onFillReady(ViewState var1, FillResponse var2, Rect var3, AutoFillId var4, AutoFillValue var5);
        }
    }
}

