/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.ActivityManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.os.UserHandle;
import com.android.internal.os.IResultReceiver;
import com.android.server.autofill.AutoFillManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class AutoFillManagerServiceShellCommand
extends ShellCommand {
    private final AutoFillManagerService mService;

    public AutoFillManagerServiceShellCommand(AutoFillManagerService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        switch (cmd) {
            case "save": {
                return this.requestSave();
            }
            case "list": {
                return this.requestList(pw);
            }
            case "reset": {
                return this.requestReset();
            }
        }
        return this.handleDefaultCommands(cmd);
    }

    @Override
    public void onHelp() {
        try (PrintWriter pw = this.getOutPrintWriter();){
            pw.println("AutoFill Service (autofill) commands:");
            pw.println("  help");
            pw.println("    Prints this help text.");
            pw.println("");
            pw.println("  list sessions [--user USER_ID]");
            pw.println("    List all pending sessions.");
            pw.println("");
            pw.println("  save [--user USER_ID]");
            pw.println("    Request provider to save contents of the top activity. ");
            pw.println("");
            pw.println("  reset");
            pw.println("    Reset all pending sessions and cached service connections.");
            pw.println("");
        }
    }

    private int requestSave() {
        int userId = this.getUserIdFromArgsOrCurrentUser();
        this.mService.requestSaveForUser(userId);
        return 0;
    }

    private int requestList(final PrintWriter pw) {
        String type = this.getNextArgRequired();
        if (!type.equals("sessions")) {
            pw.println("Error: invalid list type");
            return -1;
        }
        int userId = this.getUserIdFromArgsOrAllUsers();
        final CountDownLatch latch = new CountDownLatch(1);
        IResultReceiver.Stub receiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) throws RemoteException {
                ArrayList<String> sessions = resultData.getStringArrayList("sessions");
                for (String session : sessions) {
                    pw.println(session);
                }
                latch.countDown();
            }
        };
        this.mService.listSessions(userId, receiver);
        try {
            boolean received = latch.await(5L, TimeUnit.SECONDS);
            if (!received) {
                pw.println("Timed out after 5 seconds");
                return -1;
            }
        }
        catch (InterruptedException e) {
            pw.println("System call interrupted");
            Thread.currentThread().interrupt();
            return -1;
        }
        return 0;
    }

    private int requestReset() {
        this.mService.reset();
        return 0;
    }

    private int getUserIdFromArgsOrCurrentUser() {
        if ("--user".equals(this.getNextArg())) {
            return UserHandle.parseUserArg(this.getNextArgRequired());
        }
        return ActivityManager.getCurrentUser();
    }

    private int getUserIdFromArgsOrAllUsers() {
        if ("--user".equals(this.getNextArg())) {
            return UserHandle.parseUserArg(this.getNextArgRequired());
        }
        return -1;
    }
}

