/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.content.Context;
import android.content.IntentSender;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.service.autofill.Dataset;
import android.service.autofill.FillResponse;
import android.util.Slog;
import android.view.View;
import android.view.WindowManager;
import android.view.autofill.AutoFillId;
import android.widget.Toast;
import com.android.server.UiThread;
import com.android.server.autofill.AnchoredWindow;
import com.android.server.autofill.AutoFillUI$$Lambda$10;
import com.android.server.autofill.AutoFillUI$$Lambda$11;
import com.android.server.autofill.AutoFillUI$$Lambda$12;
import com.android.server.autofill.AutoFillUI$$Lambda$13;
import com.android.server.autofill.AutoFillUI$$Lambda$14;
import com.android.server.autofill.AutoFillUI$$Lambda$15;
import com.android.server.autofill.AutoFillUI$$Lambda$16;
import com.android.server.autofill.AutoFillUI$$Lambda$17;
import com.android.server.autofill.AutoFillUI$$Lambda$9;
import com.android.server.autofill.DatasetPicker;
import com.android.server.autofill.SavePrompt;
import java.io.PrintWriter;

final class AutoFillUI {
    private static final String TAG = "AutoFillUI";
    private static final long SNACK_BAR_LIFETIME_MS = 5000L;
    private static final int MSG_HIDE_SNACK_BAR = 1;
    private final Handler mHandler = UiThread.getHandler();
    private final Context mContext;
    private final WindowManager mWm;
    private AnchoredWindow mFillWindow;
    private DatasetPicker mDatasetPicker;
    private AutoFillUiCallback mCallback;
    private IBinder mActivityToken;
    private View mSnackbar;

    AutoFillUI(Context context) {
        this.mContext = context;
        this.mWm = (WindowManager)context.getSystemService("window");
    }

    void setCallbackLocked(AutoFillUiCallback callback, IBinder activityToken) {
        this.mHandler.post(AutoFillUI$$Lambda$9.get$Lambda(this, callback, activityToken));
    }

    void showError(CharSequence message) {
        UiThread.getHandler().post(AutoFillUI$$Lambda$10.get$Lambda(this, message));
    }

    void hideFillUi() {
        this.mHandler.post(AutoFillUI$$Lambda$11.get$Lambda(this));
    }

    private void hideFillUiUiThread() {
        if (this.mFillWindow != null) {
            Slog.d(TAG, "hideFillUiUiThread(): hide" + this.mFillWindow);
            this.mFillWindow.hide();
        }
        this.mFillWindow = null;
        this.mDatasetPicker = null;
    }

    void updateFillUi(String filterText) {
        this.mHandler.post(AutoFillUI$$Lambda$12.get$Lambda(this, filterText));
    }

    void showFillUi(AutoFillId focusedId, FillResponse response, Rect bounds, String filterText) {
        this.mHandler.post(AutoFillUI$$Lambda$13.get$Lambda(this, response, focusedId, filterText, bounds));
    }

    void showSaveUi() {
        this.mHandler.post(AutoFillUI$$Lambda$14.get$Lambda(this));
    }

    void hideAll() {
        this.mHandler.post(AutoFillUI$$Lambda$15.get$Lambda(this));
    }

    private void hideAllUiThread() {
        this.hideSnackbarUiThread();
        this.hideFillUiUiThread();
    }

    void dump(PrintWriter pw) {
        pw.println("AufoFill UI");
        String prefix = "  ";
        pw.print("  ");
        pw.print("mActivityToken: ");
        pw.println(this.mActivityToken);
        pw.print("  ");
        pw.print("mSnackBar: ");
        pw.println(this.mSnackbar);
    }

    private void showSnackbarUiThread(View snackBar) {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.type = 2002;
        params.flags = 131112;
        params.softInputMode = 32;
        params.gravity = 8388691;
        params.width = -1;
        params.height = -2;
        this.mHandler.post(AutoFillUI$$Lambda$16.get$Lambda(this, snackBar, params));
        Slog.d(TAG, "showSnackbar(): auto dismissing it in 5000 ms");
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), 5000L);
    }

    private void hideSnackbarUiThread() {
        this.mHandler.removeMessages(1);
        if (this.mSnackbar != null) {
            this.mWm.removeView(this.mSnackbar);
            this.mSnackbar = null;
        }
    }

    private boolean hasCallback() {
        return this.mCallback != null;
    }

    final /* synthetic */ void lambda$showSnackbarUiThread$11$AutoFillUI(View view, WindowManager.LayoutParams layoutParams) {
        this.mSnackbar = view;
        this.mWm.addView(this.mSnackbar, layoutParams);
    }

    final /* synthetic */ void lambda$hideAll$10$AutoFillUI() {
        this.hideAllUiThread();
    }

    final /* synthetic */ void lambda$showSaveUi$9$AutoFillUI() {
        if (!this.hasCallback()) {
            return;
        }
        this.hideAllUiThread();
        this.showSnackbarUiThread(new SavePrompt(this.mContext, new SavePrompt.OnSaveListener(){

            @Override
            public void onSaveClick() {
                AutoFillUI.this.hideSnackbarUiThread();
                AutoFillUI.this.mCallback.save();
            }

            @Override
            public void onCancelClick() {
                AutoFillUI.this.hideSnackbarUiThread();
            }
        }));
    }

    final /* synthetic */ void lambda$showFillUi$8$AutoFillUI(FillResponse fillResponse, AutoFillId autoFillId, String string2, Rect rect) {
        View content;
        if (!this.hasCallback()) {
            return;
        }
        this.hideSnackbarUiThread();
        if (fillResponse.getPresentation() != null) {
            content = fillResponse.getPresentation().apply(this.mContext, null);
            content.setOnClickListener(AutoFillUI$$Lambda$17.get$Lambda(this, fillResponse));
        } else {
            this.mDatasetPicker = new DatasetPicker(this.mContext, fillResponse.getDatasets(), autoFillId, new DatasetPicker.Listener(){

                @Override
                public void onDatasetPicked(Dataset dataset) {
                    if (AutoFillUI.this.mCallback != null) {
                        AutoFillUI.this.mCallback.fill(dataset);
                    }
                    AutoFillUI.this.hideFillUiUiThread();
                }

                @Override
                public void onCanceled() {
                    AutoFillUI.this.hideFillUiUiThread();
                }
            });
            this.mDatasetPicker.update(string2);
            content = this.mDatasetPicker;
        }
        this.mFillWindow = new AnchoredWindow(this.mWm, this.mActivityToken, content);
        this.mFillWindow.show(rect);
    }

    final /* synthetic */ void lambda$null$7$AutoFillUI(FillResponse fillResponse, View view) {
        if (this.mCallback != null) {
            this.mCallback.authenticate(fillResponse.getAuthentication());
        }
        this.hideFillUiUiThread();
    }

    final /* synthetic */ void lambda$updateFillUi$6$AutoFillUI(String string2) {
        if (!this.hasCallback()) {
            return;
        }
        this.hideSnackbarUiThread();
        if (this.mDatasetPicker != null) {
            this.mDatasetPicker.update(string2);
        }
    }

    final /* synthetic */ void lambda$hideFillUi$5$AutoFillUI() {
        this.hideFillUiUiThread();
    }

    final /* synthetic */ void lambda$showError$4$AutoFillUI(CharSequence charSequence) {
        if (!this.hasCallback()) {
            return;
        }
        this.hideAllUiThread();
        Toast.makeText(this.mContext, "AutoFill error: " + charSequence, 1).show();
    }

    final /* synthetic */ void lambda$setCallbackLocked$3$AutoFillUI(AutoFillUiCallback autoFillUiCallback, IBinder iBinder) {
        if (autoFillUiCallback != this.mCallback && iBinder != this.mActivityToken) {
            this.hideAllUiThread();
            this.mCallback = autoFillUiCallback;
            this.mActivityToken = iBinder;
        }
    }

    static interface AutoFillUiCallback {
        public void authenticate(IntentSender var1);

        public void fill(Dataset var1);

        public void save();
    }
}

