/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.content.Context;
import android.service.autofill.Dataset;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.autofill.AutoFillId;
import android.view.autofill.AutoFillValue;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.RemoteViews;
import com.android.server.autofill.DatasetPicker$$Lambda$24;
import java.util.ArrayList;

final class DatasetPicker
extends FrameLayout
implements AdapterView.OnItemClickListener {
    private final Listener mListener;
    private final ArrayAdapter<ViewItem> mAdapter;

    DatasetPicker(final Context context, ArrayList<Dataset> datasets, AutoFillId filteredViewId, Listener listener) {
        super(context);
        this.mListener = listener;
        ArrayList<ViewItem> items = new ArrayList<ViewItem>(datasets.size());
        for (Dataset dataset : datasets) {
            int index = dataset.getFieldIds().indexOf(filteredViewId);
            if (index < 0) continue;
            AutoFillValue value = dataset.getFieldValues().get(index);
            items.add(new ViewItem(dataset, value.coerceToString()));
        }
        this.mAdapter = new ArrayAdapter<ViewItem>(context, 0, items){

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                RemoteViews presentation = ((ViewItem)this.getItem(position)).getDataset().getPresentation();
                return presentation.apply(context, parent);
            }
        };
        LayoutInflater inflater = LayoutInflater.from(context);
        ListView content = (ListView)inflater.inflate(17367098, (ViewGroup)this, true).findViewById(16908298);
        content.setAdapter(this.mAdapter);
        content.setOnItemClickListener(this);
    }

    public void update(String prefix) {
        this.mAdapter.getFilter().filter(prefix, DatasetPicker$$Lambda$24.get$Lambda(this));
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int pos, long id2) {
        if (this.mListener != null) {
            ViewItem vi = (ViewItem)adapterView.getItemAtPosition(pos);
            this.mListener.onDatasetPicked(vi.getDataset());
        }
    }

    final /* synthetic */ void lambda$update$16$DatasetPicker(int count) {
        if (count <= 0 && this.mListener != null) {
            this.mListener.onCanceled();
        }
    }

    private static class ViewItem {
        private final String mValue;
        private final Dataset mDataset;

        ViewItem(Dataset dataset, String value) {
            this.mDataset = dataset;
            this.mValue = value;
        }

        public Dataset getDataset() {
            return this.mDataset;
        }

        public String toString() {
            return this.mValue;
        }
    }

    static interface Listener {
        public void onDatasetPicked(Dataset var1);

        public void onCanceled();
    }
}

