/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.app.assist.AssistStructure;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.autofill.FillResponse;
import android.service.autofill.IAutoFillService;
import android.service.autofill.IFillCallback;
import android.service.autofill.ISaveCallback;
import android.util.Slog;
import com.android.internal.os.HandlerCaller;
import com.android.server.FgThread;
import com.android.server.autofill.RemoteFillService$$Lambda$18;
import com.android.server.autofill.RemoteFillService$$Lambda$19;
import com.android.server.autofill.RemoteFillService$$Lambda$20;
import com.android.server.autofill.RemoteFillService$$Lambda$21;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

final class RemoteFillService
implements IBinder.DeathRecipient {
    private static final String LOG_TAG = "RemoteFillService";
    private static final boolean DEBUG = true;
    private static final long TIMEOUT_IDLE_BIND_MILLIS = 300000L;
    private final Context mContext;
    private final ComponentName mComponentName;
    private final Intent mIntent;
    private final FillServiceCallbacks mCallbacks;
    private final int mUserId;
    private final ServiceConnection mServiceConnection = new RemoteServiceConnection();
    private final HandlerCaller mHandler;
    private IAutoFillService mAutoFillService;
    private boolean mBinding;
    private boolean mDestroyed;
    private boolean mServiceDied;
    private boolean mCompleted;
    private PendingRequest mPendingRequest;

    public RemoteFillService(Context context, ComponentName componentName, int userId, FillServiceCallbacks callbacks) {
        this.mContext = context;
        this.mCallbacks = callbacks;
        this.mComponentName = componentName;
        this.mIntent = new Intent("android.service.autofill.AutoFillService").setComponent(this.mComponentName);
        this.mUserId = userId;
        this.mHandler = new MyHandler(context);
    }

    public void destroy() {
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void handleDestroy() {
        if (this.mPendingRequest != null) {
            this.mPendingRequest.cancel();
            this.mPendingRequest = null;
        }
        this.ensureUnbound();
        this.mDestroyed = true;
    }

    @Override
    public void binderDied() {
        this.mHandler.obtainMessage(2).sendToTarget();
    }

    private void handleBinderDied() {
        if (this.mAutoFillService != null) {
            this.mAutoFillService.asBinder().unlinkToDeath(this, 0);
        }
        this.mAutoFillService = null;
        this.mServiceDied = true;
        this.mCallbacks.onServiceDied(this);
    }

    public void onFillRequest(AssistStructure structure, Bundle extras) {
        this.cancelScheduledUnbind();
        PendingFillRequest request = new PendingFillRequest(structure, extras, this);
        this.mHandler.obtainMessageO(4, request).sendToTarget();
    }

    public void onSaveRequest(AssistStructure structure, Bundle extras) {
        this.cancelScheduledUnbind();
        PendingSaveRequest request = new PendingSaveRequest(structure, extras, this);
        this.mHandler.obtainMessageO(4, request).sendToTarget();
    }

    public void dump(String prefix, PrintWriter pw) {
        String tab = "  ";
        pw.append(prefix).append("service:").println();
        pw.append(prefix).append(tab).append("userId=").append(String.valueOf(this.mUserId)).println();
        pw.append(prefix).append(tab).append("componentName=").append(this.mComponentName.flattenToString()).println();
        pw.append(prefix).append(tab).append("destroyed=").append(String.valueOf(this.mDestroyed)).println();
        pw.append(prefix).append(tab).append("bound=").append(String.valueOf(this.isBound())).println();
        pw.append(prefix).append(tab).append("hasPendingRequest=").append(String.valueOf(this.mPendingRequest != null)).println();
        pw.println();
    }

    private void cancelScheduledUnbind() {
        this.mHandler.removeMessages(3);
    }

    private void scheduleUnbind() {
        this.cancelScheduledUnbind();
        Message message = this.mHandler.obtainMessage(3);
        this.mHandler.sendMessageDelayed(message, 300000L);
    }

    private void handleUnbind() {
        this.ensureUnbound();
    }

    private void handlePendingRequest(PendingRequest pendingRequest) {
        if (this.mDestroyed || this.mCompleted) {
            return;
        }
        if (pendingRequest.isFinal()) {
            this.mCompleted = true;
        }
        if (!this.isBound()) {
            if (this.mPendingRequest != null) {
                this.mPendingRequest.cancel();
            }
            this.mPendingRequest = pendingRequest;
            this.ensureBound();
        } else {
            Slog.d(LOG_TAG, "[user: " + this.mUserId + "] handlePendingRequest()");
            pendingRequest.run();
        }
    }

    private boolean isBound() {
        return this.mAutoFillService != null;
    }

    private void ensureBound() {
        if (this.isBound() || this.mBinding) {
            return;
        }
        Slog.d(LOG_TAG, "[user: " + this.mUserId + "] ensureBound()");
        this.mBinding = true;
        boolean willBind = this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, 0x4000001, new UserHandle(this.mUserId));
        if (!willBind) {
            Slog.d(LOG_TAG, "[user: " + this.mUserId + "] could not bind to " + this.mIntent);
            this.mBinding = false;
            if (!this.mServiceDied) {
                this.handleBinderDied();
            }
        }
    }

    private void ensureUnbound() {
        if (!this.isBound() && !this.mBinding) {
            return;
        }
        Slog.d(LOG_TAG, "[user: " + this.mUserId + "] ensureUnbound()");
        this.mBinding = false;
        if (this.isBound()) {
            if (this.mAutoFillService != null) {
                try {
                    this.mAutoFillService.onDisconnected();
                }
                catch (Exception e) {
                    Slog.w(LOG_TAG, "Exception calling onDisconnected(): " + e);
                }
            }
            if (this.mAutoFillService != null) {
                this.mAutoFillService.asBinder().unlinkToDeath(this, 0);
                this.mAutoFillService = null;
            }
        }
        this.mContext.unbindService(this.mServiceConnection);
    }

    private void dispatchOnFillRequestSuccess(PendingRequest pendingRequest, FillResponse response) {
        this.mHandler.getHandler().post(RemoteFillService$$Lambda$18.get$Lambda(this, pendingRequest, response));
    }

    private void dispatchOnFillRequestFailure(PendingRequest pendingRequest, CharSequence message) {
        this.mHandler.getHandler().post(RemoteFillService$$Lambda$19.get$Lambda(this, pendingRequest, message));
    }

    private void dispatchOnSaveRequestSuccess(PendingRequest pendingRequest) {
        this.mHandler.getHandler().post(RemoteFillService$$Lambda$20.get$Lambda(this, pendingRequest));
    }

    private void dispatchOnSaveRequestFailure(PendingRequest pendingRequest, CharSequence message) {
        this.mHandler.getHandler().post(RemoteFillService$$Lambda$21.get$Lambda(this, pendingRequest, message));
    }

    private boolean handleResponseCallbackCommon(PendingRequest pendingRequest) {
        if (this.mDestroyed) {
            return false;
        }
        if (this.mPendingRequest == pendingRequest) {
            this.mPendingRequest = null;
        }
        if (this.mPendingRequest == null) {
            this.scheduleUnbind();
        }
        return true;
    }

    final /* synthetic */ void lambda$dispatchOnSaveRequestFailure$15$RemoteFillService(PendingRequest pendingRequest, CharSequence charSequence) {
        if (this.handleResponseCallbackCommon(pendingRequest)) {
            this.mCallbacks.onSaveRequestFailure(charSequence);
        }
    }

    final /* synthetic */ void lambda$dispatchOnSaveRequestSuccess$14$RemoteFillService(PendingRequest pendingRequest) {
        if (this.handleResponseCallbackCommon(pendingRequest)) {
            this.mCallbacks.onSaveRequestSuccess();
        }
    }

    final /* synthetic */ void lambda$dispatchOnFillRequestFailure$13$RemoteFillService(PendingRequest pendingRequest, CharSequence charSequence) {
        if (this.handleResponseCallbackCommon(pendingRequest)) {
            this.mCallbacks.onFillRequestFailure(charSequence);
        }
    }

    final /* synthetic */ void lambda$dispatchOnFillRequestSuccess$12$RemoteFillService(PendingRequest pendingRequest, FillResponse fillResponse) {
        if (this.handleResponseCallbackCommon(pendingRequest)) {
            this.mCallbacks.onFillRequestSuccess(fillResponse);
        }
    }

    private static final class PendingSaveRequest
    extends PendingRequest {
        private final Object mLock = new Object();
        private final WeakReference<RemoteFillService> mWeakService;
        private AssistStructure mStructure;
        private Bundle mExtras;
        private final ISaveCallback mCallback;

        public PendingSaveRequest(AssistStructure structure, Bundle extras, RemoteFillService service) {
            this.mStructure = structure;
            this.mExtras = extras;
            this.mWeakService = new WeakReference<RemoteFillService>(service);
            this.mCallback = new ISaveCallback.Stub(){

                @Override
                public void onSuccess() {
                    RemoteFillService service = (RemoteFillService)mWeakService.get();
                    if (service != null) {
                        service.dispatchOnSaveRequestSuccess(this);
                    }
                }

                @Override
                public void onFailure(CharSequence message) {
                    RemoteFillService service = (RemoteFillService)mWeakService.get();
                    if (service != null) {
                        service.dispatchOnSaveRequestFailure(this, message);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RemoteFillService service = (RemoteFillService)this.mWeakService.get();
            if (service != null) {
                try {
                    service.mAutoFillService.onSaveRequest(this.mStructure, this.mExtras, this.mCallback);
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mStructure = null;
                        this.mExtras = null;
                    }
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error calling on save request", e);
                }
            }
        }

        @Override
        public boolean isFinal() {
            return true;
        }
    }

    private static final class PendingFillRequest
    extends PendingRequest {
        private final Object mLock = new Object();
        private final WeakReference<RemoteFillService> mWeakService;
        private AssistStructure mStructure;
        private Bundle mExtras;
        private final IFillCallback mCallback;
        private ICancellationSignal mCancellation;
        private boolean mCancelled;

        public PendingFillRequest(AssistStructure structure, Bundle extras, RemoteFillService service) {
            this.mStructure = structure;
            this.mExtras = extras;
            this.mWeakService = new WeakReference<RemoteFillService>(service);
            this.mCallback = new IFillCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellable(ICancellationSignal cancellation) {
                    Object object = mLock;
                    synchronized (object) {
                        boolean cancelled;
                        Object object2 = mLock;
                        synchronized (object2) {
                            mCancellation = cancellation;
                            cancelled = mCancelled;
                        }
                        if (cancelled) {
                            try {
                                cancellation.cancel();
                            }
                            catch (RemoteException e) {
                                Slog.e(RemoteFillService.LOG_TAG, "Error requesting a cancellation", e);
                            }
                        }
                    }
                }

                @Override
                public void onSuccess(FillResponse response) {
                    RemoteFillService remoteService = (RemoteFillService)mWeakService.get();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestSuccess(this, response);
                    }
                }

                @Override
                public void onFailure(CharSequence message) {
                    RemoteFillService remoteService = (RemoteFillService)mWeakService.get();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestFailure(this, message);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RemoteFillService remoteService = (RemoteFillService)this.mWeakService.get();
            if (remoteService != null) {
                try {
                    remoteService.mAutoFillService.onFillRequest(this.mStructure, this.mExtras, this.mCallback);
                    Object object = this.mLock;
                    synchronized (object) {
                        this.mStructure = null;
                        this.mExtras = null;
                    }
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error calling on fill request", e);
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            ICancellationSignal cancellation;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCancelled) {
                    return;
                }
                this.mCancelled = true;
                cancellation = this.mCancellation;
            }
            if (cancellation == null) {
                return;
            }
            try {
                cancellation.cancel();
            }
            catch (RemoteException e) {
                Slog.e(RemoteFillService.LOG_TAG, "Error cancelling a fill request", e);
            }
        }
    }

    private static abstract class PendingRequest
    implements Runnable {
        private PendingRequest() {
        }

        void cancel() {
        }

        boolean isFinal() {
            return false;
        }
    }

    private final class MyHandler
    extends HandlerCaller {
        public static final int MSG_DESTROY = 1;
        public static final int MSG_BINDER_DIED = 2;
        public static final int MSG_UNBIND = 3;
        public static final int MSG_ON_PENDING_REQUEST = 4;

        public MyHandler(Context context) {
            super(context, FgThread.getHandler().getLooper(), new HandlerCaller.Callback(){

                @Override
                public void executeMessage(Message message) {
                    if (RemoteFillService.this.mDestroyed) {
                        Slog.w(RemoteFillService.LOG_TAG, "Not handling " + message + " as service for " + RemoteFillService.this.mComponentName + " is already destroyed");
                        return;
                    }
                    switch (message.what) {
                        case 1: {
                            RemoteFillService.this.handleDestroy();
                            break;
                        }
                        case 2: {
                            RemoteFillService.this.handleBinderDied();
                            break;
                        }
                        case 3: {
                            RemoteFillService.this.handleUnbind();
                            break;
                        }
                        case 4: {
                            RemoteFillService.this.handlePendingRequest((PendingRequest)message.obj);
                        }
                    }
                }
            }, false);
        }
    }

    private class RemoteServiceConnection
    implements ServiceConnection {
        private RemoteServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (RemoteFillService.this.mDestroyed || !RemoteFillService.this.mBinding) {
                RemoteFillService.this.mContext.unbindService(RemoteFillService.this.mServiceConnection);
                return;
            }
            RemoteFillService.this.mBinding = false;
            RemoteFillService.this.mAutoFillService = IAutoFillService.Stub.asInterface(service);
            try {
                service.linkToDeath(RemoteFillService.this, 0);
            }
            catch (RemoteException re) {
                RemoteFillService.this.handleBinderDied();
                return;
            }
            try {
                if (RemoteFillService.this.mAutoFillService != null) {
                    RemoteFillService.this.mAutoFillService.onConnected();
                }
            }
            catch (RemoteException e) {
                Slog.w(RemoteFillService.LOG_TAG, "Exception calling onConnected(): " + e);
            }
            if (RemoteFillService.this.mPendingRequest != null) {
                RemoteFillService.this.handlePendingRequest(RemoteFillService.this.mPendingRequest);
            }
            RemoteFillService.this.mServiceDied = false;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            RemoteFillService.this.mBinding = true;
            RemoteFillService.this.mAutoFillService = null;
        }
    }

    public static interface FillServiceCallbacks {
        public void onFillRequestSuccess(FillResponse var1);

        public void onFillRequestFailure(CharSequence var1);

        public void onSaveRequestSuccess();

        public void onSaveRequestFailure(CharSequence var1);

        public void onServiceDied(RemoteFillService var1);
    }
}

