/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.SelectBackupTransportCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.backup.IBackupTransport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TransportManager {
    private static final String TAG = "BackupTransportManager";
    private static final String SERVICE_ACTION_TRANSPORT_HOST = "android.backup.TRANSPORT_HOST";
    private final Intent mTransportServiceIntent = new Intent("android.backup.TRANSPORT_HOST");
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final Set<ComponentName> mTransportWhitelist;
    private final TransportBoundListener mTransportBoundListener;
    private String mCurrentTransportName;
    private final Object mTransportLock = new Object();
    @GuardedBy(value="mTransportLock")
    private final Map<ComponentName, TransportConnection> mValidTransports = new ArrayMap<ComponentName, TransportConnection>();
    @GuardedBy(value="mTransportLock")
    private final Map<String, ComponentName> mBoundTransports = new ArrayMap<String, ComponentName>();

    TransportManager(Context context, Set<ComponentName> whitelist, String defaultTransport, TransportBoundListener listener) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mTransportWhitelist = whitelist != null ? whitelist : new ArraySet();
        this.mCurrentTransportName = defaultTransport;
        this.mTransportBoundListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageAdded(String packageName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            TransportManager.log_verbose("Package added. Binding to all transports. " + packageName);
            this.bindToAllInternal(packageName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageRemoved(String packageName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            for (ComponentName transport : this.mValidTransports.keySet()) {
                TransportConnection removed;
                if (!transport.getPackageName().equals(packageName) || (removed = this.mValidTransports.remove(transport)) == null) continue;
                this.mContext.unbindService(removed);
                TransportManager.log_verbose("Package removed, Removing transport: " + transport.flattenToShortString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPackageChanged(String packageName, String[] components) {
        Object object = this.mTransportLock;
        synchronized (object) {
            for (String component : components) {
                ComponentName componentName = new ComponentName(packageName, component);
                TransportConnection removed = this.mValidTransports.remove(componentName);
                if (removed == null) continue;
                this.mContext.unbindService(removed);
                TransportManager.log_verbose("Package changed. Removing transport: " + componentName.flattenToShortString());
            }
            this.bindToAllInternal(packageName, components);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBackupTransport getTransportBinder(String transportName) {
        Object object = this.mTransportLock;
        synchronized (object) {
            ComponentName component = this.mBoundTransports.get(transportName);
            if (component == null) {
                Slog.w(TAG, "Transport " + transportName + " not bound.");
                return null;
            }
            TransportConnection conn = this.mValidTransports.get(component);
            if (conn == null) {
                Slog.w(TAG, "Transport " + transportName + " not valid.");
                return null;
            }
            return conn.getBinder();
        }
    }

    IBackupTransport getCurrentTransportBinder() {
        return this.getTransportBinder(this.mCurrentTransportName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTransportName(IBackupTransport binder) {
        Object object = this.mTransportLock;
        synchronized (object) {
            for (TransportConnection conn : this.mValidTransports.values()) {
                if (conn.getBinder() != binder) continue;
                return conn.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getBoundTransportNames() {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.mBoundTransports.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName[] getAllTransportCompenents() {
        Object object = this.mTransportLock;
        synchronized (object) {
            return this.mValidTransports.keySet().toArray(new ComponentName[0]);
        }
    }

    String getCurrentTransportName() {
        return this.mCurrentTransportName;
    }

    Set<ComponentName> getTransportWhitelist() {
        return this.mTransportWhitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String selectTransport(String transport) {
        Object object = this.mTransportLock;
        synchronized (object) {
            String prevTransport = this.mCurrentTransportName;
            this.mCurrentTransportName = transport;
            return prevTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureTransportReady(ComponentName transportComponent, SelectBackupTransportCallback listener) {
        Object object = this.mTransportLock;
        synchronized (object) {
            TransportConnection conn = this.mValidTransports.get(transportComponent);
            if (conn == null) {
                listener.onFailure(-1);
                return;
            }
            conn.bindIfUnbound();
            conn.addListener(listener);
        }
    }

    void registerAllTransports() {
        this.bindToAllInternal(null, null);
    }

    private void bindToAllInternal(String packageName, String[] components) {
        List<ResolveInfo> hosts;
        PackageInfo pkgInfo = null;
        if (packageName != null) {
            try {
                pkgInfo = this.mPackageManager.getPackageInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(TAG, "Package not found: " + packageName);
                return;
            }
        }
        Intent intent = new Intent(this.mTransportServiceIntent);
        if (packageName != null) {
            intent.setPackage(packageName);
        }
        if ((hosts = this.mPackageManager.queryIntentServicesAsUser(intent, 0, 0)) != null) {
            for (ResolveInfo host : hosts) {
                ServiceInfo info = host.serviceInfo;
                boolean shouldBind = false;
                if (components != null && packageName != null) {
                    for (String component : components) {
                        ComponentName cn = new ComponentName(pkgInfo.packageName, component);
                        if (!info.getComponentName().equals(cn)) continue;
                        shouldBind = true;
                        break;
                    }
                } else {
                    shouldBind = true;
                }
                if (!shouldBind || !this.isTransportTrusted(info.getComponentName())) continue;
                this.tryBindTransport(info);
            }
        }
    }

    private boolean isTransportTrusted(ComponentName transport) {
        if (!this.mTransportWhitelist.contains(transport)) {
            Slog.w(TAG, "BackupTransport " + transport.flattenToShortString() + " not whitelisted.");
            return false;
        }
        try {
            PackageInfo packInfo = this.mPackageManager.getPackageInfo(transport.getPackageName(), 0);
            if ((packInfo.applicationInfo.privateFlags & 8) == 0) {
                Slog.w(TAG, "Transport package " + transport.getPackageName() + " not privileged");
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Package not found.", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBindTransport(ServiceInfo transport) {
        Slog.d(TAG, "Binding to transport: " + transport.getComponentName().flattenToShortString());
        TransportConnection connection = new TransportConnection(transport.getComponentName());
        if (this.bindToTransport(transport.getComponentName(), connection)) {
            Object object = this.mTransportLock;
            synchronized (object) {
                this.mValidTransports.put(transport.getComponentName(), connection);
            }
        } else {
            Slog.w(TAG, "Couldn't bind to transport " + transport.getComponentName());
        }
    }

    private boolean bindToTransport(ComponentName componentName, ServiceConnection connection) {
        Intent intent = new Intent(this.mTransportServiceIntent).setComponent(componentName);
        return this.mContext.bindServiceAsUser(intent, connection, 1, UserHandle.SYSTEM);
    }

    private static void log_verbose(String message) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, message);
        }
    }

    static interface TransportBoundListener {
        public boolean onTransportBound(IBackupTransport var1);
    }

    private class TransportConnection
    implements ServiceConnection {
        private IBackupTransport mBinder;
        private final List<SelectBackupTransportCallback> mListeners = new ArrayList<SelectBackupTransportCallback>();
        private String mTransportName;
        private final ComponentName mTransportComponent;

        private TransportConnection(ComponentName transportComponent) {
            this.mTransportComponent = transportComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName component, IBinder binder) {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                block17: {
                    block15: {
                        this.mBinder = IBackupTransport.Stub.asInterface(binder);
                        boolean success = false;
                        EventLog.writeEvent(2850, component.flattenToShortString(), 1);
                        try {
                            this.mTransportName = this.mBinder.name();
                            success = TransportManager.this.mTransportBoundListener.onTransportBound(this.mBinder);
                            if (!success) break block15;
                        }
                        catch (RemoteException e) {
                            block19: {
                                block16: {
                                    try {
                                        success = false;
                                        Slog.e(TransportManager.TAG, "Couldn't get transport name.", e);
                                        if (!success) break block16;
                                    }
                                    catch (Throwable throwable) {
                                        if (success) {
                                            Slog.d(TransportManager.TAG, "Bound to transport: " + component.flattenToShortString());
                                            TransportManager.this.mBoundTransports.put(this.mTransportName, component);
                                            for (SelectBackupTransportCallback listener : this.mListeners) {
                                                listener.onSuccess(this.mTransportName);
                                            }
                                        } else {
                                            Slog.w(TransportManager.TAG, "Bound to transport " + component.flattenToShortString() + " but it is invalid");
                                            EventLog.writeEvent(2850, component.flattenToShortString(), 0);
                                            TransportManager.this.mContext.unbindService(this);
                                            TransportManager.this.mValidTransports.remove(component);
                                            this.mBinder = null;
                                            for (SelectBackupTransportCallback listener : this.mListeners) {
                                                listener.onFailure(-2);
                                            }
                                        }
                                        this.mListeners.clear();
                                        throw throwable;
                                    }
                                    Slog.d(TransportManager.TAG, "Bound to transport: " + component.flattenToShortString());
                                    TransportManager.this.mBoundTransports.put(this.mTransportName, component);
                                    for (SelectBackupTransportCallback listener : this.mListeners) {
                                        listener.onSuccess(this.mTransportName);
                                    }
                                    break block19;
                                }
                                Slog.w(TransportManager.TAG, "Bound to transport " + component.flattenToShortString() + " but it is invalid");
                                EventLog.writeEvent(2850, component.flattenToShortString(), 0);
                                TransportManager.this.mContext.unbindService(this);
                                TransportManager.this.mValidTransports.remove(component);
                                this.mBinder = null;
                                for (SelectBackupTransportCallback listener : this.mListeners) {
                                    listener.onFailure(-2);
                                }
                            }
                            this.mListeners.clear();
                        }
                        Slog.d(TransportManager.TAG, "Bound to transport: " + component.flattenToShortString());
                        TransportManager.this.mBoundTransports.put(this.mTransportName, component);
                        for (SelectBackupTransportCallback listener : this.mListeners) {
                            listener.onSuccess(this.mTransportName);
                        }
                        break block17;
                    }
                    Slog.w(TransportManager.TAG, "Bound to transport " + component.flattenToShortString() + " but it is invalid");
                    EventLog.writeEvent(2850, component.flattenToShortString(), 0);
                    TransportManager.this.mContext.unbindService(this);
                    TransportManager.this.mValidTransports.remove(component);
                    this.mBinder = null;
                    for (SelectBackupTransportCallback listener : this.mListeners) {
                        listener.onFailure(-2);
                    }
                }
                this.mListeners.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName component) {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                this.mBinder = null;
                TransportManager.this.mBoundTransports.remove(this.mTransportName);
            }
            EventLog.writeEvent(2850, component.flattenToShortString(), 0);
            Slog.w(TransportManager.TAG, "Disconnected from transport " + component.flattenToShortString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IBackupTransport getBinder() {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                return this.mBinder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getName() {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                return this.mTransportName;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bindIfUnbound() {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                if (this.mBinder == null) {
                    Slog.d(TransportManager.TAG, "Rebinding to transport " + this.mTransportComponent.flattenToShortString());
                    TransportManager.this.bindToTransport(this.mTransportComponent, this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(SelectBackupTransportCallback listener) {
            Object object = TransportManager.this.mTransportLock;
            synchronized (object) {
                if (this.mBinder == null) {
                    this.mListeners.add(listener);
                } else {
                    listener.onSuccess(this.mTransportName);
                }
            }
        }
    }
}

