/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetdEventCallback;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.metrics.ConnectStats;
import android.net.metrics.DnsEvent;
import android.net.metrics.INetdEventListener;
import android.net.metrics.IpConnectivityLog;
import android.os.RemoteException;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.TokenBucket;
import com.android.server.connectivity.metrics.nano.IpConnectivityLogClass;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class NetdEventListenerService
extends INetdEventListener.Stub {
    public static final String SERVICE_NAME = "netd_listener";
    private static final String TAG = NetdEventListenerService.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final int MAX_LOOKUPS_PER_DNS_EVENT = 100;
    private static final int CONNECT_LATENCY_BURST_LIMIT = 5000;
    private static final int CONNECT_LATENCY_FILL_RATE = 15000;
    private static final int CONNECT_LATENCY_MAXIMUM_RECORDS = 20000;
    @GuardedBy(value="this")
    private final SortedMap<Integer, DnsEventBatch> mEventBatches = new TreeMap<Integer, DnsEventBatch>();
    private final ConnectivityManager mCm;
    private final IpConnectivityLog mMetricsLog;
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLost(Network network) {
            NetdEventListenerService netdEventListenerService = NetdEventListenerService.this;
            synchronized (netdEventListenerService) {
                DnsEventBatch batch = (DnsEventBatch)NetdEventListenerService.this.mEventBatches.remove(network.netId);
                if (batch != null) {
                    batch.logAndClear();
                }
            }
        }
    };
    @GuardedBy(value="this")
    private final TokenBucket mConnectTb = new TokenBucket(15000, 5000);
    @GuardedBy(value="this")
    private ConnectStats mConnectStats = this.makeConnectStats();
    @GuardedBy(value="this")
    private INetdEventCallback mNetdEventCallback;

    public synchronized boolean registerNetdEventCallback(INetdEventCallback callback) {
        this.mNetdEventCallback = callback;
        return true;
    }

    public synchronized boolean unregisterNetdEventCallback() {
        this.mNetdEventCallback = null;
        return true;
    }

    public NetdEventListenerService(Context context) {
        this(context.getSystemService(ConnectivityManager.class), new IpConnectivityLog());
    }

    public NetdEventListenerService(ConnectivityManager cm, IpConnectivityLog log) {
        this.mCm = cm;
        this.mMetricsLog = log;
        NetworkRequest request = new NetworkRequest.Builder().clearCapabilities().build();
        this.mCm.registerNetworkCallback(request, this.mNetworkCallback);
    }

    @Override
    public synchronized void onDnsEvent(int netId, int eventType, int returnCode, int latencyMs, String hostname, String[] ipAddresses, int ipAddressesCount, int uid) throws RemoteException {
        NetdEventListenerService.maybeVerboseLog("onDnsEvent(%d, %d, %d, %dms)", netId, eventType, returnCode, latencyMs);
        DnsEventBatch batch = (DnsEventBatch)this.mEventBatches.get(netId);
        if (batch == null) {
            batch = new DnsEventBatch(netId);
            this.mEventBatches.put(netId, batch);
        }
        batch.addResult((byte)eventType, (byte)returnCode, latencyMs);
        if (this.mNetdEventCallback != null) {
            this.mNetdEventCallback.onDnsEvent(hostname, ipAddresses, ipAddressesCount, System.currentTimeMillis(), uid);
        }
    }

    @Override
    public synchronized void onConnectEvent(int netId, int error, int latencyMs, String ipAddr, int port, int uid) throws RemoteException {
        NetdEventListenerService.maybeVerboseLog("onConnectEvent(%d, %d, %dms)", netId, error, latencyMs);
        this.mConnectStats.addEvent(error, latencyMs, ipAddr);
        if (this.mNetdEventCallback != null) {
            this.mNetdEventCallback.onConnectEvent(ipAddr, port, System.currentTimeMillis(), uid);
        }
    }

    public synchronized void flushStatistics(List<IpConnectivityLogClass.IpConnectivityEvent> events) {
        events.add(this.flushConnectStats());
    }

    private IpConnectivityLogClass.IpConnectivityEvent flushConnectStats() {
        IpConnectivityLogClass.IpConnectivityEvent ev = new IpConnectivityLogClass.IpConnectivityEvent();
        ev.setConnectStatistics(this.mConnectStats.toProto());
        this.mConnectStats = this.makeConnectStats();
        return ev;
    }

    public synchronized void dump(PrintWriter writer) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(TAG + ":");
        pw.increaseIndent();
        for (DnsEventBatch batch : this.mEventBatches.values()) {
            pw.println(batch.toString());
        }
        pw.decreaseIndent();
    }

    private ConnectStats makeConnectStats() {
        return new ConnectStats(this.mConnectTb, 20000);
    }

    private static void maybeLog(String s, Object ... args) {
    }

    private static void maybeVerboseLog(String s, Object ... args) {
    }

    private class DnsEventBatch {
        private final int mNetId;
        private final byte[] mEventTypes = new byte[100];
        private final byte[] mReturnCodes = new byte[100];
        private final int[] mLatenciesMs = new int[100];
        private int mEventCount;

        public DnsEventBatch(int netId) {
            this.mNetId = netId;
        }

        public void addResult(byte eventType, byte returnCode, int latencyMs) {
            this.mEventTypes[this.mEventCount] = eventType;
            this.mReturnCodes[this.mEventCount] = returnCode;
            this.mLatenciesMs[this.mEventCount] = latencyMs;
            ++this.mEventCount;
            if (this.mEventCount == 100) {
                this.logAndClear();
            }
        }

        public void logAndClear() {
            if (this.mEventCount == 0) {
                return;
            }
            byte[] eventTypes = Arrays.copyOf(this.mEventTypes, this.mEventCount);
            byte[] returnCodes = Arrays.copyOf(this.mReturnCodes, this.mEventCount);
            int[] latenciesMs = Arrays.copyOf(this.mLatenciesMs, this.mEventCount);
            NetdEventListenerService.this.mMetricsLog.log(new DnsEvent(this.mNetId, eventTypes, returnCodes, latenciesMs));
            NetdEventListenerService.maybeLog("Logging %d results for netId %d", new Object[]{this.mEventCount, this.mNetId});
            this.mEventCount = 0;
        }

        public String toString() {
            return String.format("%s %d %d", this.getClass().getSimpleName(), this.mNetId, this.mEventCount);
        }
    }
}

