/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.CaptivePortal;
import android.net.ICaptivePortal;
import android.net.NetworkRequest;
import android.net.ProxyInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.NetworkEvent;
import android.net.metrics.ValidationProbeEvent;
import android.net.util.Stopwatch;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.NetworkAgentInfo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class NetworkMonitor
extends StateMachine {
    private static final String TAG = NetworkMonitor.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String DEFAULT_HTTPS_URL = "https://www.google.com/generate_204";
    private static final String DEFAULT_HTTP_URL = "http://connectivitycheck.gstatic.com/generate_204";
    private static final String DEFAULT_FALLBACK_URL = "http://www.google.com/gen_204";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.82 Safari/537.36";
    private static final int SOCKET_TIMEOUT_MS = 10000;
    private static final int PROBE_TIMEOUT_MS = 3000;
    public static final String ACTION_NETWORK_CONDITIONS_MEASURED = "android.net.conn.NETWORK_CONDITIONS_MEASURED";
    public static final String EXTRA_CONNECTIVITY_TYPE = "extra_connectivity_type";
    public static final String EXTRA_NETWORK_TYPE = "extra_network_type";
    public static final String EXTRA_RESPONSE_RECEIVED = "extra_response_received";
    public static final String EXTRA_IS_CAPTIVE_PORTAL = "extra_is_captive_portal";
    public static final String EXTRA_CELL_ID = "extra_cellid";
    public static final String EXTRA_SSID = "extra_ssid";
    public static final String EXTRA_BSSID = "extra_bssid";
    public static final String EXTRA_REQUEST_TIMESTAMP_MS = "extra_request_timestamp_ms";
    public static final String EXTRA_RESPONSE_TIMESTAMP_MS = "extra_response_timestamp_ms";
    private static final String PERMISSION_ACCESS_NETWORK_CONDITIONS = "android.permission.ACCESS_NETWORK_CONDITIONS";
    public static final int NETWORK_TEST_RESULT_VALID = 0;
    public static final int NETWORK_TEST_RESULT_INVALID = 1;
    private static final int BASE = 532480;
    public static final int CMD_NETWORK_CONNECTED = 532481;
    public static final int EVENT_NETWORK_TESTED = 532482;
    private static final int CMD_REEVALUATE = 532486;
    public static final int CMD_NETWORK_DISCONNECTED = 532487;
    public static final int CMD_FORCE_REEVALUATION = 532488;
    private static final int CMD_CAPTIVE_PORTAL_APP_FINISHED = 532489;
    public static final int EVENT_PROVISIONING_NOTIFICATION = 532490;
    private static final int CMD_LAUNCH_CAPTIVE_PORTAL_APP = 532491;
    private static final int CMD_CAPTIVE_PORTAL_RECHECK = 532492;
    private static final int INITIAL_REEVALUATE_DELAY_MS = 1000;
    private static final int MAX_REEVALUATE_DELAY_MS = 600000;
    private static final int IGNORE_REEVALUATE_ATTEMPTS = 5;
    private int mReevaluateToken = 0;
    private static final int INVALID_UID = -1;
    private int mUidResponsibleForReeval = -1;
    private static final int BLAME_FOR_EVALUATION_ATTEMPTS = 5;
    private static final int CAPTIVE_PORTAL_REEVALUATE_DELAY_MS = 600000;
    private final Context mContext;
    private final Handler mConnectivityServiceHandler;
    private final NetworkAgentInfo mNetworkAgentInfo;
    private final int mNetId;
    private final TelephonyManager mTelephonyManager;
    private final WifiManager mWifiManager;
    private final AlarmManager mAlarmManager;
    private final NetworkRequest mDefaultRequest;
    private final IpConnectivityLog mMetricsLog;
    protected boolean mIsCaptivePortalCheckEnabled;
    private boolean mUseHttps;
    private int mValidations = 0;
    private boolean mUserDoesNotWant = false;
    private boolean mDontDisplaySigninNotification = false;
    public boolean systemReady = false;
    private final State mDefaultState = new DefaultState();
    private final State mValidatedState = new ValidatedState();
    private final State mMaybeNotifyState = new MaybeNotifyState();
    private final State mEvaluatingState = new EvaluatingState();
    private final State mCaptivePortalState = new CaptivePortalState();
    private CustomIntentReceiver mLaunchCaptivePortalAppBroadcastReceiver = null;
    private final LocalLog validationLogs = new LocalLog(20);
    private final Stopwatch mEvaluationTimer = new Stopwatch();
    private CaptivePortalProbeResult mLastPortalProbeResult = CaptivePortalProbeResult.FAILED;

    public NetworkMonitor(Context context, Handler handler, NetworkAgentInfo networkAgentInfo, NetworkRequest defaultRequest) {
        this(context, handler, networkAgentInfo, defaultRequest, new IpConnectivityLog());
    }

    protected NetworkMonitor(Context context, Handler handler, NetworkAgentInfo networkAgentInfo, NetworkRequest defaultRequest, IpConnectivityLog logger) {
        super(TAG + networkAgentInfo.name());
        this.mContext = context;
        this.mMetricsLog = logger;
        this.mConnectivityServiceHandler = handler;
        this.mNetworkAgentInfo = networkAgentInfo;
        this.mNetId = this.mNetworkAgentInfo.network.netId;
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        this.mDefaultRequest = defaultRequest;
        this.addState(this.mDefaultState);
        this.addState(this.mValidatedState, this.mDefaultState);
        this.addState(this.mMaybeNotifyState, this.mDefaultState);
        this.addState(this.mEvaluatingState, this.mMaybeNotifyState);
        this.addState(this.mCaptivePortalState, this.mMaybeNotifyState);
        this.setInitialState(this.mDefaultState);
        this.mIsCaptivePortalCheckEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "captive_portal_mode", 1) != 0;
        this.mUseHttps = Settings.Global.getInt(this.mContext.getContentResolver(), "captive_portal_use_https", 1) == 1;
        this.start();
    }

    @Override
    protected void log(String s) {
        Log.d(TAG + "/" + this.mNetworkAgentInfo.name(), s);
    }

    private void validationLog(String s) {
        this.log(s);
        this.validationLogs.log(s);
    }

    public LocalLog.ReadOnlyLocalLog getValidationLogs() {
        return this.validationLogs.readOnlyLocalLog();
    }

    private ValidationStage validationStage() {
        return 0 == this.mValidations ? ValidationStage.FIRST_VALIDATION : ValidationStage.REVALIDATION;
    }

    private static String getCaptivePortalServerHttpsUrl(Context context) {
        return NetworkMonitor.getSetting(context, "captive_portal_https_url", DEFAULT_HTTPS_URL);
    }

    public static String getCaptivePortalServerHttpUrl(Context context) {
        return NetworkMonitor.getSetting(context, "captive_portal_http_url", DEFAULT_HTTP_URL);
    }

    private static String getCaptivePortalFallbackUrl(Context context) {
        return NetworkMonitor.getSetting(context, "captive_portal_fallback_url", DEFAULT_FALLBACK_URL);
    }

    private static String getCaptivePortalUserAgent(Context context) {
        return NetworkMonitor.getSetting(context, "captive_portal_user_agent", DEFAULT_USER_AGENT);
    }

    private static String getSetting(Context context, String symbol, String defaultValue) {
        String value = Settings.Global.getString(context.getContentResolver(), symbol);
        return value != null ? value : defaultValue;
    }

    protected CaptivePortalProbeResult isCaptivePortal() {
        if (!this.mIsCaptivePortalCheckEnabled) {
            this.validationLog("Validation disabled.");
            return new CaptivePortalProbeResult(204);
        }
        URL pacUrl = null;
        URL httpsUrl = null;
        URL httpUrl = null;
        URL fallbackUrl = null;
        ProxyInfo proxyInfo = this.mNetworkAgentInfo.linkProperties.getHttpProxy();
        if (proxyInfo != null && !Uri.EMPTY.equals(proxyInfo.getPacFileUrl()) && (pacUrl = this.makeURL(proxyInfo.getPacFileUrl().toString())) == null) {
            return CaptivePortalProbeResult.FAILED;
        }
        if (pacUrl == null) {
            httpsUrl = this.makeURL(NetworkMonitor.getCaptivePortalServerHttpsUrl(this.mContext));
            httpUrl = this.makeURL(NetworkMonitor.getCaptivePortalServerHttpUrl(this.mContext));
            fallbackUrl = this.makeURL(NetworkMonitor.getCaptivePortalFallbackUrl(this.mContext));
            if (httpUrl == null || httpsUrl == null) {
                return CaptivePortalProbeResult.FAILED;
            }
        }
        long startTime = SystemClock.elapsedRealtime();
        CaptivePortalProbeResult result = pacUrl != null ? this.sendDnsAndHttpProbes(null, pacUrl, 3) : (this.mUseHttps ? this.sendParallelHttpProbes(proxyInfo, httpsUrl, httpUrl, fallbackUrl) : this.sendDnsAndHttpProbes(proxyInfo, httpUrl, 1));
        long endTime = SystemClock.elapsedRealtime();
        this.sendNetworkConditionsBroadcast(true, result.isPortal(), startTime, endTime);
        return result;
    }

    private CaptivePortalProbeResult sendDnsAndHttpProbes(ProxyInfo proxy, URL url, int probeType) {
        String host = proxy != null ? proxy.getHost() : url.getHost();
        this.sendDnsProbe(host);
        return this.sendHttpProbe(url, probeType);
    }

    private void sendDnsProbe(String host) {
        String connectInfo;
        int result;
        if (TextUtils.isEmpty(host)) {
            return;
        }
        String name = ValidationProbeEvent.getProbeName(0);
        Stopwatch watch = new Stopwatch().start();
        try {
            InetAddress[] addresses = this.mNetworkAgentInfo.network.getAllByName(host);
            result = 1;
            StringBuffer buffer = new StringBuffer(host).append("=");
            for (InetAddress address : addresses) {
                buffer.append(address.getHostAddress());
                if (address == addresses[addresses.length - 1]) continue;
                buffer.append(",");
            }
            connectInfo = buffer.toString();
        }
        catch (UnknownHostException e) {
            result = 0;
            connectInfo = host;
        }
        long latency = watch.stop();
        String resultString = 1 == result ? "OK" : "FAIL";
        this.validationLog(String.format("%s %s %dms, %s", name, resultString, latency, connectInfo));
        this.logValidationProbe(latency, 0, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CaptivePortalProbeResult sendHttpProbe(URL url, int probeType) {
        HttpURLConnection urlConnection = null;
        int httpResponseCode = 599;
        String redirectUrl = null;
        Stopwatch probeTimer = new Stopwatch().start();
        int oldTag = TrafficStats.getAndSetThreadStatsTag(-249);
        try {
            urlConnection = (HttpURLConnection)this.mNetworkAgentInfo.network.openConnection(url);
            urlConnection.setInstanceFollowRedirects(probeType == 3);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setUseCaches(false);
            String userAgent = NetworkMonitor.getCaptivePortalUserAgent(this.mContext);
            if (userAgent != null) {
                urlConnection.setRequestProperty("User-Agent", userAgent);
            }
            long requestTimestamp = SystemClock.elapsedRealtime();
            httpResponseCode = urlConnection.getResponseCode();
            redirectUrl = urlConnection.getHeaderField("location");
            long responseTimestamp = SystemClock.elapsedRealtime();
            this.validationLog(ValidationProbeEvent.getProbeName(probeType) + " " + url + " time=" + (responseTimestamp - requestTimestamp) + "ms" + " ret=" + httpResponseCode + " headers=" + urlConnection.getHeaderFields());
            if (httpResponseCode == 200) {
                if (probeType == 3) {
                    this.validationLog("PAC fetch 200 response interpreted as 204 response.");
                    httpResponseCode = 204;
                } else if (urlConnection.getContentLengthLong() == 0L) {
                    this.validationLog("200 response with Content-length=0 interpreted as 204 response.");
                    httpResponseCode = 204;
                } else if (urlConnection.getContentLengthLong() == -1L && urlConnection.getInputStream().read() == -1) {
                    this.validationLog("Empty 200 response interpreted as 204 response.");
                    httpResponseCode = 204;
                }
            }
        }
        catch (IOException e) {
            this.validationLog("Probably not a portal: exception " + e);
            if (httpResponseCode == 599) {
                // empty if block
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            TrafficStats.setThreadStatsTag(oldTag);
        }
        this.logValidationProbe(probeTimer.stop(), probeType, httpResponseCode);
        return new CaptivePortalProbeResult(httpResponseCode, redirectUrl, url.toString());
    }

    private CaptivePortalProbeResult sendParallelHttpProbes(final ProxyInfo proxy, final URL httpsUrl, final URL httpUrl, URL fallbackUrl) {
        CaptivePortalProbeResult result;
        final CountDownLatch latch = new CountDownLatch(2);
        final class ProbeThread
        extends Thread {
            private final boolean mIsHttps;
            private volatile CaptivePortalProbeResult mResult = CaptivePortalProbeResult.FAILED;

            public ProbeThread(boolean isHttps) {
                this.mIsHttps = isHttps;
            }

            public CaptivePortalProbeResult result() {
                return this.mResult;
            }

            @Override
            public void run() {
                this.mResult = this.mIsHttps ? NetworkMonitor.this.sendDnsAndHttpProbes(proxy, httpsUrl, 2) : NetworkMonitor.this.sendDnsAndHttpProbes(proxy, httpUrl, 1);
                if (this.mIsHttps && this.mResult.isSuccessful() || !this.mIsHttps && this.mResult.isPortal()) {
                    while (latch.getCount() > 0L) {
                        latch.countDown();
                    }
                }
                latch.countDown();
            }
        }
        ProbeThread httpsProbe = new ProbeThread(true);
        ProbeThread httpProbe = new ProbeThread(false);
        try {
            httpsProbe.start();
            httpProbe.start();
            latch.await(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.validationLog("Error: probes wait interrupted!");
            return CaptivePortalProbeResult.FAILED;
        }
        CaptivePortalProbeResult httpsResult = httpsProbe.result();
        CaptivePortalProbeResult httpResult = httpProbe.result();
        if (httpResult.isPortal()) {
            return httpResult;
        }
        if (httpsResult.isPortal() || httpsResult.isSuccessful()) {
            return httpsResult;
        }
        if (fallbackUrl != null && (result = this.sendHttpProbe(fallbackUrl, 4)).isPortal()) {
            return result;
        }
        try {
            httpsProbe.join();
        }
        catch (InterruptedException e) {
            this.validationLog("Error: https probe wait interrupted!");
            return CaptivePortalProbeResult.FAILED;
        }
        return httpsProbe.result();
    }

    private URL makeURL(String url) {
        if (url != null) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                this.validationLog("Bad URL: " + url);
            }
        }
        return null;
    }

    private void sendNetworkConditionsBroadcast(boolean responseReceived, boolean isCaptivePortal, long requestTimestampMs, long responseTimestampMs) {
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_scan_always_enabled", 0) == 0) {
            return;
        }
        if (!this.systemReady) {
            return;
        }
        Intent latencyBroadcast = new Intent(ACTION_NETWORK_CONDITIONS_MEASURED);
        switch (this.mNetworkAgentInfo.networkInfo.getType()) {
            case 1: {
                WifiInfo currentWifiInfo = this.mWifiManager.getConnectionInfo();
                if (currentWifiInfo != null) {
                    latencyBroadcast.putExtra(EXTRA_SSID, currentWifiInfo.getSSID());
                    latencyBroadcast.putExtra(EXTRA_BSSID, currentWifiInfo.getBSSID());
                    break;
                }
                return;
            }
            case 0: {
                latencyBroadcast.putExtra(EXTRA_NETWORK_TYPE, this.mTelephonyManager.getNetworkType());
                List<CellInfo> info = this.mTelephonyManager.getAllCellInfo();
                if (info == null) {
                    return;
                }
                int numRegisteredCellInfo = 0;
                for (CellInfo cellInfo : info) {
                    Parcelable cellId;
                    if (!cellInfo.isRegistered()) continue;
                    if (++numRegisteredCellInfo > 1) {
                        return;
                    }
                    if (cellInfo instanceof CellInfoCdma) {
                        cellId = ((CellInfoCdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoGsm) {
                        cellId = ((CellInfoGsm)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoLte) {
                        cellId = ((CellInfoLte)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoWcdma) {
                        cellId = ((CellInfoWcdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    return;
                }
                break;
            }
            default: {
                return;
            }
        }
        latencyBroadcast.putExtra(EXTRA_CONNECTIVITY_TYPE, this.mNetworkAgentInfo.networkInfo.getType());
        latencyBroadcast.putExtra(EXTRA_RESPONSE_RECEIVED, responseReceived);
        latencyBroadcast.putExtra(EXTRA_REQUEST_TIMESTAMP_MS, requestTimestampMs);
        if (responseReceived) {
            latencyBroadcast.putExtra(EXTRA_IS_CAPTIVE_PORTAL, isCaptivePortal);
            latencyBroadcast.putExtra(EXTRA_RESPONSE_TIMESTAMP_MS, responseTimestampMs);
        }
        this.mContext.sendBroadcastAsUser(latencyBroadcast, UserHandle.CURRENT, PERMISSION_ACCESS_NETWORK_CONDITIONS);
    }

    private void logNetworkEvent(int evtype) {
        this.mMetricsLog.log(new NetworkEvent(this.mNetId, evtype));
    }

    private int networkEventType(ValidationStage s, EvaluationResult r) {
        if (s.isFirstValidation) {
            if (r.isValidated) {
                return 8;
            }
            return 10;
        }
        if (r.isValidated) {
            return 9;
        }
        return 11;
    }

    private void maybeLogEvaluationResult(int evtype) {
        if (this.mEvaluationTimer.isRunning()) {
            this.mMetricsLog.log(new NetworkEvent(this.mNetId, evtype, this.mEvaluationTimer.stop()));
            this.mEvaluationTimer.reset();
        }
    }

    private void logValidationProbe(long durationMs, int probeType, int probeResult) {
        probeType = ValidationProbeEvent.makeProbeType(probeType, this.validationStage().isFirstValidation);
        this.mMetricsLog.log(new ValidationProbeEvent(this.mNetId, durationMs, probeType, probeResult));
    }

    private class CaptivePortalState
    extends State {
        private static final String ACTION_LAUNCH_CAPTIVE_PORTAL_APP = "android.net.netmon.launchCaptivePortalApp";

        private CaptivePortalState() {
        }

        @Override
        public void enter() {
            NetworkMonitor.this.maybeLogEvaluationResult(NetworkMonitor.this.networkEventType(NetworkMonitor.this.validationStage(), EvaluationResult.CAPTIVE_PORTAL));
            if (NetworkMonitor.this.mDontDisplaySigninNotification) {
                return;
            }
            if (NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver == null) {
                NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver = new CustomIntentReceiver(ACTION_LAUNCH_CAPTIVE_PORTAL_APP, new Random().nextInt(), 532491);
            }
            Message message = NetworkMonitor.this.obtainMessage(532490, 1, ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId, NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver.getPendingIntent());
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(message);
            NetworkMonitor.this.sendMessageDelayed(532492, 0, 600000L);
            NetworkMonitor.this.mValidations++;
        }

        @Override
        public void exit() {
            NetworkMonitor.this.removeMessages(532492);
        }
    }

    private class CustomIntentReceiver
    extends BroadcastReceiver {
        private final int mToken;
        private final int mWhat;
        private final String mAction;

        CustomIntentReceiver(String action, int token, int what) {
            this.mToken = token;
            this.mWhat = what;
            this.mAction = action + "_" + ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId + "_" + token;
            NetworkMonitor.this.mContext.registerReceiver(this, new IntentFilter(this.mAction));
        }

        public PendingIntent getPendingIntent() {
            Intent intent = new Intent(this.mAction);
            intent.setPackage(NetworkMonitor.this.mContext.getPackageName());
            return PendingIntent.getBroadcast(NetworkMonitor.this.mContext, 0, intent, 0);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(this.mAction)) {
                NetworkMonitor.this.sendMessage(NetworkMonitor.this.obtainMessage(this.mWhat, this.mToken));
            }
        }
    }

    private class EvaluatingState
    extends State {
        private int mReevaluateDelayMs;
        private int mAttempts;

        private EvaluatingState() {
        }

        @Override
        public void enter() {
            if (!NetworkMonitor.this.mEvaluationTimer.isStarted()) {
                NetworkMonitor.this.mEvaluationTimer.start();
            }
            NetworkMonitor.this.sendMessage(532486, ++NetworkMonitor.this.mReevaluateToken, 0);
            if (NetworkMonitor.this.mUidResponsibleForReeval != -1) {
                TrafficStats.setThreadStatsUid(NetworkMonitor.this.mUidResponsibleForReeval);
                NetworkMonitor.this.mUidResponsibleForReeval = -1;
            }
            this.mReevaluateDelayMs = 1000;
            this.mAttempts = 0;
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532486: {
                    if (message.arg1 != NetworkMonitor.this.mReevaluateToken || NetworkMonitor.this.mUserDoesNotWant) {
                        return true;
                    }
                    if (!((NetworkMonitor)NetworkMonitor.this).mDefaultRequest.networkCapabilities.satisfiedByNetworkCapabilities(((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.networkCapabilities)) {
                        NetworkMonitor.this.validationLog("Network would not satisfy default request, not validating");
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                        return true;
                    }
                    ++this.mAttempts;
                    CaptivePortalProbeResult probeResult = NetworkMonitor.this.isCaptivePortal();
                    if (probeResult.isSuccessful()) {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    } else if (probeResult.isPortal()) {
                        NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 1, NetworkMonitor.this.mNetId, probeResult.redirectUrl));
                        NetworkMonitor.this.mLastPortalProbeResult = probeResult;
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mCaptivePortalState);
                    } else {
                        Message msg = NetworkMonitor.this.obtainMessage(532486, ++NetworkMonitor.this.mReevaluateToken, 0);
                        NetworkMonitor.this.sendMessageDelayed(msg, (long)this.mReevaluateDelayMs);
                        NetworkMonitor.this.logNetworkEvent(3);
                        NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 1, NetworkMonitor.this.mNetId, probeResult.redirectUrl));
                        if (this.mAttempts >= 5) {
                            TrafficStats.clearThreadStatsUid();
                        }
                        this.mReevaluateDelayMs *= 2;
                        if (this.mReevaluateDelayMs > 600000) {
                            this.mReevaluateDelayMs = 600000;
                        }
                    }
                    return true;
                }
                case 532488: {
                    return this.mAttempts < 5;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            TrafficStats.clearThreadStatsUid();
        }
    }

    public static final class CaptivePortalProbeResult {
        static final CaptivePortalProbeResult FAILED = new CaptivePortalProbeResult(599);
        private final int mHttpResponseCode;
        final String redirectUrl;
        final String detectUrl;

        public CaptivePortalProbeResult(int httpResponseCode, String redirectUrl, String detectUrl) {
            this.mHttpResponseCode = httpResponseCode;
            this.redirectUrl = redirectUrl;
            this.detectUrl = detectUrl;
        }

        public CaptivePortalProbeResult(int httpResponseCode) {
            this(httpResponseCode, null, null);
        }

        boolean isSuccessful() {
            return this.mHttpResponseCode == 204;
        }

        boolean isPortal() {
            return !this.isSuccessful() && this.mHttpResponseCode >= 200 && this.mHttpResponseCode <= 399;
        }
    }

    private class MaybeNotifyState
    extends State {
        private MaybeNotifyState() {
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532491: {
                    Intent intent = new Intent("android.net.conn.CAPTIVE_PORTAL");
                    intent.putExtra("android.net.extra.NETWORK", ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network);
                    intent.putExtra("android.net.extra.CAPTIVE_PORTAL", new CaptivePortal(new ICaptivePortal.Stub(){

                        @Override
                        public void appResponse(int response) {
                            if (response == 2) {
                                NetworkMonitor.this.mContext.enforceCallingPermission("android.permission.CONNECTIVITY_INTERNAL", "CaptivePortal");
                            }
                            NetworkMonitor.this.sendMessage(532489, response);
                        }
                    }));
                    intent.putExtra("android.net.extra.CAPTIVE_PORTAL_URL", ((NetworkMonitor)NetworkMonitor.this).mLastPortalProbeResult.detectUrl);
                    intent.putExtra("android.net.extra.CAPTIVE_PORTAL_USER_AGENT", NetworkMonitor.getCaptivePortalUserAgent(NetworkMonitor.this.mContext));
                    intent.setFlags(0x10400000);
                    NetworkMonitor.this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            Message message = NetworkMonitor.this.obtainMessage(532490, 0, ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId, null);
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(message);
        }
    }

    private class ValidatedState
    extends State {
        private ValidatedState() {
        }

        @Override
        public void enter() {
            NetworkMonitor.this.maybeLogEvaluationResult(NetworkMonitor.this.networkEventType(NetworkMonitor.this.validationStage(), EvaluationResult.VALIDATED));
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 0, ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId, null));
            NetworkMonitor.this.mValidations++;
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532481: {
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    return true;
                }
            }
            return false;
        }
    }

    private class DefaultState
    extends State {
        private DefaultState() {
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 532481: {
                    NetworkMonitor.this.logNetworkEvent(1);
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                    return true;
                }
                case 532487: {
                    NetworkMonitor.this.logNetworkEvent(7);
                    if (NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver != null) {
                        NetworkMonitor.this.mContext.unregisterReceiver(NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver);
                        NetworkMonitor.this.mLaunchCaptivePortalAppBroadcastReceiver = null;
                    }
                    NetworkMonitor.this.quit();
                    return true;
                }
                case 532488: 
                case 532492: {
                    NetworkMonitor.this.log("Forcing reevaluation for UID " + message.arg1);
                    NetworkMonitor.this.mUidResponsibleForReeval = message.arg1;
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                    return true;
                }
                case 532489: {
                    NetworkMonitor.this.log("CaptivePortal App responded with " + message.arg1);
                    NetworkMonitor.this.mUseHttps = false;
                    switch (message.arg1) {
                        case 0: {
                            NetworkMonitor.this.sendMessage(532488, 0, 0);
                            break;
                        }
                        case 2: {
                            NetworkMonitor.this.mDontDisplaySigninNotification = true;
                            NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                            break;
                        }
                        case 1: {
                            NetworkMonitor.this.mDontDisplaySigninNotification = true;
                            NetworkMonitor.this.mUserDoesNotWant = true;
                            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 1, NetworkMonitor.this.mNetId, null));
                            NetworkMonitor.this.mUidResponsibleForReeval = 0;
                            NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                        }
                    }
                    return true;
                }
            }
            return true;
        }
    }

    static enum ValidationStage {
        FIRST_VALIDATION(true),
        REVALIDATION(false);

        final boolean isFirstValidation;

        private ValidationStage(boolean isFirstValidation) {
            this.isFirstValidation = isFirstValidation;
        }
    }

    static enum EvaluationResult {
        VALIDATED(true),
        CAPTIVE_PORTAL(false);

        final boolean isValidated;

        private EvaluationResult(boolean isValidated) {
            this.isValidated = isValidated;
        }
    }
}

