/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.hardware.usb.UsbManager;
import android.net.ConnectivityManager;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkState;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.MockableSystemProperties;
import com.android.server.connectivity.tethering.IControlsTethering;
import com.android.server.connectivity.tethering.IPv6TetheringCoordinator;
import com.android.server.connectivity.tethering.IPv6TetheringInterfaceServices;
import com.android.server.connectivity.tethering.TetherInterfaceStateMachine;
import com.android.server.connectivity.tethering.TetheringConfiguration;
import com.android.server.connectivity.tethering.UpstreamNetworkMonitor;
import com.android.server.net.BaseNetworkObserver;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Tethering
extends BaseNetworkObserver
implements IControlsTethering {
    private final Context mContext;
    private static final String TAG = "Tethering";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    protected static final String DISABLE_PROVISIONING_SYSPROP_KEY = "net.tethering.noprovisioning";
    private static final Class[] messageClasses = new Class[]{Tethering.class, TetherMasterSM.class, TetherInterfaceStateMachine.class};
    private static final SparseArray<String> sMagicDecoderRing = MessageUtils.findMessageNames(messageClasses);
    private volatile TetheringConfiguration mConfig;
    private final Object mPublicSync;
    private final INetworkManagementService mNMService;
    private final INetworkStatsService mStatsService;
    private final INetworkPolicyManager mPolicyManager;
    private final Looper mLooper;
    private final MockableSystemProperties mSystemProperties;
    private final ArrayMap<String, TetherState> mTetherStates;
    private final BroadcastReceiver mStateReceiver;
    private static final ComponentName TETHER_SERVICE = ComponentName.unflattenFromString(Resources.getSystem().getString(17039666));
    private final StateMachine mTetherMasterSM;
    private final UpstreamNetworkMonitor mUpstreamNetworkMonitor;
    private String mCurrentUpstreamIface;
    private Notification.Builder mTetheredNotificationBuilder;
    private int mLastNotificationId;
    private boolean mRndisEnabled;
    private boolean mUsbTetherRequested;
    private boolean mWifiTetherRequested;

    public Tethering(Context context, INetworkManagementService nmService, INetworkStatsService statsService, INetworkPolicyManager policyManager, Looper looper, MockableSystemProperties systemProperties) {
        this.mContext = context;
        this.mNMService = nmService;
        this.mStatsService = statsService;
        this.mPolicyManager = policyManager;
        this.mLooper = looper;
        this.mSystemProperties = systemProperties;
        this.mPublicSync = new Object();
        this.mTetherStates = new ArrayMap();
        this.mTetherMasterSM = new TetherMasterSM("TetherMaster", this.mLooper);
        this.mTetherMasterSM.start();
        this.mUpstreamNetworkMonitor = new UpstreamNetworkMonitor(this.mContext, this.mTetherMasterSM, 327685);
        this.mStateReceiver = new StateReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_STATE");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.net.wifi.WIFI_AP_STATE_CHANGED");
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mContext.registerReceiver(this.mStateReceiver, filter, null, this.mTetherMasterSM.getHandler());
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_SHARED");
        filter.addAction("android.intent.action.MEDIA_UNSHARED");
        filter.addDataScheme("file");
        this.mContext.registerReceiver(this.mStateReceiver, filter, null, this.mTetherMasterSM.getHandler());
        this.updateConfiguration();
    }

    private ConnectivityManager getConnectivityManager() {
        return (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    private void updateConfiguration() {
        this.mConfig = new TetheringConfiguration(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceStatusChanged(String iface, boolean up) {
        Object object = this.mPublicSync;
        synchronized (object) {
            int interfaceType = this.ifaceNameToType(iface);
            if (interfaceType == -1) {
                return;
            }
            TetherState tetherState = this.mTetherStates.get(iface);
            if (up) {
                if (tetherState == null) {
                    this.trackNewTetherableInterface(iface, interfaceType);
                }
            } else if (interfaceType == 2) {
                tetherState.mStateMachine.sendMessage(327784);
                this.mTetherStates.remove(iface);
            }
        }
    }

    @Override
    public void interfaceLinkStateChanged(String iface, boolean up) {
        this.interfaceStatusChanged(iface, up);
    }

    private int ifaceNameToType(String iface) {
        TetheringConfiguration cfg = this.mConfig;
        if (cfg.isWifi(iface)) {
            return 0;
        }
        if (cfg.isUsb(iface)) {
            return 1;
        }
        if (cfg.isBluetooth(iface)) {
            return 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceAdded(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            int interfaceType = this.ifaceNameToType(iface);
            if (interfaceType == -1) {
                return;
            }
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                this.trackNewTetherableInterface(iface, interfaceType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interfaceRemoved(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                return;
            }
            tetherState.mStateMachine.sendMessage(327784);
            this.mTetherStates.remove(iface);
        }
    }

    public void startTethering(int type, ResultReceiver receiver, boolean showProvisioningUi) {
        if (!this.isTetherProvisioningRequired()) {
            this.enableTetheringInternal(type, true, receiver);
            return;
        }
        if (showProvisioningUi) {
            this.runUiTetherProvisioningAndEnable(type, receiver);
        } else {
            this.runSilentTetherProvisioningAndEnable(type, receiver);
        }
    }

    public void stopTethering(int type) {
        this.enableTetheringInternal(type, false, null);
        if (this.isTetherProvisioningRequired()) {
            this.cancelTetherProvisioningRechecks(type);
        }
    }

    protected boolean isTetherProvisioningRequired() {
        boolean isEntitlementCheckRequired;
        String[] provisionApp = this.mContext.getResources().getStringArray(17236007);
        if (this.mSystemProperties.getBoolean(DISABLE_PROVISIONING_SYSPROP_KEY, false) || provisionApp == null) {
            return false;
        }
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configManager != null && configManager.getConfig() != null && !(isEntitlementCheckRequired = configManager.getConfig().getBoolean("require_entitlement_checks_bool"))) {
            return false;
        }
        return provisionApp.length == 2;
    }

    private void enableTetheringInternal(int type, boolean enable, ResultReceiver receiver) {
        boolean isProvisioningRequired = enable && this.isTetherProvisioningRequired();
        switch (type) {
            case 0: {
                int result = this.setWifiTethering(enable);
                if (isProvisioningRequired && result == 0) {
                    this.scheduleProvisioningRechecks(type);
                }
                this.sendTetherResult(receiver, result);
                break;
            }
            case 1: {
                int result = this.setUsbTethering(enable);
                if (isProvisioningRequired && result == 0) {
                    this.scheduleProvisioningRechecks(type);
                }
                this.sendTetherResult(receiver, result);
                break;
            }
            case 2: {
                this.setBluetoothTethering(enable, receiver);
                break;
            }
            default: {
                Log.w(TAG, "Invalid tether type.");
                this.sendTetherResult(receiver, 1);
            }
        }
    }

    private void sendTetherResult(ResultReceiver receiver, int result) {
        if (receiver != null) {
            receiver.send(result, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setWifiTethering(boolean enable) {
        Object object = this.mPublicSync;
        synchronized (object) {
            this.mWifiTetherRequested = enable;
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            if (wifiManager.setWifiApEnabled(null, enable)) {
                return 0;
            }
            return 5;
        }
    }

    private void setBluetoothTethering(final boolean enable, final ResultReceiver receiver) {
        final BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || !adapter.isEnabled()) {
            Log.w(TAG, "Tried to enable bluetooth tethering with null or disabled adapter. null: " + (adapter == null));
            this.sendTetherResult(receiver, 2);
            return;
        }
        adapter.getProfileProxy(this.mContext, new BluetoothProfile.ServiceListener(){

            @Override
            public void onServiceDisconnected(int profile) {
            }

            @Override
            public void onServiceConnected(int profile, BluetoothProfile proxy) {
                ((BluetoothPan)proxy).setBluetoothTethering(enable);
                int result = ((BluetoothPan)proxy).isTetheringOn() == enable ? 0 : 5;
                Tethering.this.sendTetherResult(receiver, result);
                if (enable && Tethering.this.isTetherProvisioningRequired()) {
                    Tethering.this.scheduleProvisioningRechecks(2);
                }
                adapter.closeProfileProxy(5, proxy);
            }
        }, 5);
    }

    private void runUiTetherProvisioningAndEnable(int type, ResultReceiver receiver) {
        ResultReceiver proxyReceiver = this.getProxyReceiver(type, receiver);
        this.sendUiTetherProvisionIntent(type, proxyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUiTetherProvisionIntent(int type, ResultReceiver receiver) {
        Intent intent = new Intent("android.settings.TETHER_PROVISIONING_UI");
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraProvisionCallback", receiver);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private ResultReceiver getProxyReceiver(final int type, final ResultReceiver receiver) {
        ResultReceiver rr = new ResultReceiver(null){

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 0) {
                    Tethering.this.enableTetheringInternal(type, true, receiver);
                } else {
                    Tethering.this.sendTetherResult(receiver, resultCode);
                }
            }
        };
        Parcel parcel = Parcel.obtain();
        rr.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        ResultReceiver receiverForSending = ResultReceiver.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return receiverForSending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProvisioningRechecks(int type) {
        Intent intent = new Intent();
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraSetAlarm", true);
        intent.setComponent(TETHER_SERVICE);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void runSilentTetherProvisioningAndEnable(int type, ResultReceiver receiver) {
        ResultReceiver proxyReceiver = this.getProxyReceiver(type, receiver);
        this.sendSilentTetherProvisionIntent(type, proxyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSilentTetherProvisionIntent(int type, ResultReceiver receiver) {
        Intent intent = new Intent();
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraRunProvision", true);
        intent.putExtra("extraProvisionCallback", receiver);
        intent.setComponent(TETHER_SERVICE);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTetherProvisioningRechecks(int type) {
        if (this.getConnectivityManager().isTetheringSupported()) {
            Intent intent = new Intent();
            intent.putExtra("extraRemTetherType", type);
            intent.setComponent(TETHER_SERVICE);
            long ident = Binder.clearCallingIdentity();
            try {
                this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tether(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                Log.e(TAG, "Tried to Tether an unknown iface: " + iface + ", ignoring");
                return 1;
            }
            if (tetherState.mLastState != 1) {
                Log.e(TAG, "Tried to Tether an unavailable iface: " + iface + ", ignoring");
                return 4;
            }
            tetherState.mStateMachine.sendMessage(327782);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int untether(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                Log.e(TAG, "Tried to Untether an unknown iface :" + iface + ", ignoring");
                return 1;
            }
            if (tetherState.mLastState != 2) {
                Log.e(TAG, "Tried to untether an untethered iface :" + iface + ", ignoring");
                return 4;
            }
            tetherState.mStateMachine.sendMessage(327783);
            return 0;
        }
    }

    public void untetherAll() {
        this.stopTethering(0);
        this.stopTethering(1);
        this.stopTethering(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastTetherError(String iface) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState == null) {
                Log.e(TAG, "Tried to getLastTetherError on an unknown iface :" + iface + ", ignoring");
                return 1;
            }
            return tetherState.mLastError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTetherStateChangedBroadcast() {
        if (!this.getConnectivityManager().isTetheringSupported()) {
            return;
        }
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> activeList = new ArrayList<String>();
        ArrayList<String> erroredList = new ArrayList<String>();
        boolean wifiTethered = false;
        boolean usbTethered = false;
        boolean bluetoothTethered = false;
        TetheringConfiguration cfg = this.mConfig;
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                String iface = this.mTetherStates.keyAt(i);
                if (tetherState.mLastError != 0) {
                    erroredList.add(iface);
                    continue;
                }
                if (tetherState.mLastState == 1) {
                    availableList.add(iface);
                    continue;
                }
                if (tetherState.mLastState != 2) continue;
                if (cfg.isUsb(iface)) {
                    usbTethered = true;
                } else if (cfg.isWifi(iface)) {
                    wifiTethered = true;
                } else if (cfg.isBluetooth(iface)) {
                    bluetoothTethered = true;
                }
                activeList.add(iface);
            }
        }
        Intent broadcast = new Intent("android.net.conn.TETHER_STATE_CHANGED");
        broadcast.addFlags(0x24000000);
        broadcast.putStringArrayListExtra("availableArray", availableList);
        broadcast.putStringArrayListExtra("activeArray", activeList);
        broadcast.putStringArrayListExtra("erroredArray", erroredList);
        this.mContext.sendStickyBroadcastAsUser(broadcast, UserHandle.ALL);
        if (usbTethered) {
            if (wifiTethered || bluetoothTethered) {
                this.showTetheredNotification(17303359);
            } else {
                this.showTetheredNotification(17303360);
            }
        } else if (wifiTethered) {
            if (bluetoothTethered) {
                this.showTetheredNotification(17303359);
            } else {
                this.clearTetheredNotification();
            }
        } else if (bluetoothTethered) {
            this.showTetheredNotification(17303358);
        } else {
            this.clearTetheredNotification();
        }
    }

    private void showTetheredNotification(int icon) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        if (this.mLastNotificationId != 0) {
            if (this.mLastNotificationId == icon) {
                return;
            }
            notificationManager.cancelAsUser(null, this.mLastNotificationId, UserHandle.ALL);
            this.mLastNotificationId = 0;
        }
        Intent intent = new Intent();
        intent.setClassName("com.android.settings", "com.android.settings.TetherSettings");
        intent.setFlags(0x40000000);
        PendingIntent pi = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
        Resources r = Resources.getSystem();
        CharSequence title = r.getText(17040810);
        CharSequence message = r.getText(17040809);
        if (this.mTetheredNotificationBuilder == null) {
            this.mTetheredNotificationBuilder = new Notification.Builder(this.mContext);
            this.mTetheredNotificationBuilder.setWhen(0L).setOngoing(true).setColor(this.mContext.getColor(17170762)).setVisibility(1).setCategory("status");
        }
        this.mTetheredNotificationBuilder.setSmallIcon(icon).setContentTitle(title).setContentText(message).setContentIntent(pi);
        this.mLastNotificationId = icon;
        notificationManager.notifyAsUser(null, this.mLastNotificationId, this.mTetheredNotificationBuilder.build(), UserHandle.ALL);
    }

    private void clearTetheredNotification() {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager != null && this.mLastNotificationId != 0) {
            notificationManager.cancelAsUser(null, this.mLastNotificationId, UserHandle.ALL);
            this.mLastNotificationId = 0;
        }
    }

    private void tetherMatchingInterfaces(boolean enable, int interfaceType) {
        int result;
        String[] ifaces = null;
        try {
            ifaces = this.mNMService.listInterfaces();
        }
        catch (Exception e) {
            Log.e(TAG, "Error listing Interfaces", e);
            return;
        }
        String chosenIface = null;
        if (ifaces != null) {
            for (String iface : ifaces) {
                if (this.ifaceNameToType(iface) != interfaceType) continue;
                chosenIface = iface;
                break;
            }
        }
        if (chosenIface == null) {
            Log.e(TAG, "could not find iface of type " + interfaceType);
            return;
        }
        int n = result = enable ? this.tether(chosenIface) : this.untether(chosenIface);
        if (result != 0) {
            Log.e(TAG, "unable start or stop tethering on iface " + chosenIface);
            return;
        }
    }

    public TetheringConfiguration getTetheringConfiguration() {
        return this.mConfig;
    }

    public boolean hasTetherableConfiguration() {
        TetheringConfiguration cfg = this.mConfig;
        boolean hasDownstreamConfiguration = cfg.tetherableUsbRegexs.length != 0 || cfg.tetherableWifiRegexs.length != 0 || cfg.tetherableBluetoothRegexs.length != 0;
        boolean hasUpstreamConfiguration = !cfg.preferredUpstreamIfaceTypes.isEmpty();
        return hasDownstreamConfiguration && hasUpstreamConfiguration;
    }

    public String[] getTetherableUsbRegexs() {
        return Tethering.copy(this.mConfig.tetherableUsbRegexs);
    }

    public String[] getTetherableWifiRegexs() {
        return Tethering.copy(this.mConfig.tetherableWifiRegexs);
    }

    public String[] getTetherableBluetoothRegexs() {
        return Tethering.copy(this.mConfig.tetherableBluetoothRegexs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setUsbTethering(boolean enable) {
        UsbManager usbManager = this.mContext.getSystemService(UsbManager.class);
        Object object = this.mPublicSync;
        synchronized (object) {
            if (enable) {
                if (this.mRndisEnabled) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.tetherMatchingInterfaces(true, 1);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                } else {
                    this.mUsbTetherRequested = true;
                    usbManager.setCurrentFunction("rndis", false);
                }
            } else {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.tetherMatchingInterfaces(false, 1);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                if (this.mRndisEnabled) {
                    usbManager.setCurrentFunction(null, false);
                }
                this.mUsbTetherRequested = false;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetheredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                if (tetherState.mLastState != 2) continue;
                list.add(this.mTetherStates.keyAt(i));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTetherableIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                if (tetherState.mLastState != 1) continue;
                list.add(this.mTetherStates.keyAt(i));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getTetheredDhcpRanges() {
        return this.mConfig.dhcpRanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getErroredIfaces() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.mPublicSync;
        synchronized (object) {
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                TetherState tetherState = this.mTetherStates.valueAt(i);
                if (tetherState.mLastError == 0) continue;
                list.add(this.mTetherStates.keyAt(i));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void maybeLogMessage(State state, int what) {
    }

    boolean pertainsToCurrentUpstream(NetworkState ns) {
        if (ns != null && ns.linkProperties != null && this.mCurrentUpstreamIface != null) {
            for (String ifname : ns.linkProperties.getAllInterfaceNames()) {
                if (!this.mCurrentUpstreamIface.equals(ifname)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ConnectivityService.Tether from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Tethering:");
        pw.increaseIndent();
        TetheringConfiguration cfg = this.mConfig;
        pw.print("preferredUpstreamIfaceTypes:");
        Object object = this.mPublicSync;
        synchronized (object) {
            for (Integer netType : cfg.preferredUpstreamIfaceTypes) {
                pw.print(" " + ConnectivityManager.getNetworkTypeName(netType));
            }
            pw.println();
            pw.println("Tether state:");
            pw.increaseIndent();
            for (int i = 0; i < this.mTetherStates.size(); ++i) {
                String iface = this.mTetherStates.keyAt(i);
                TetherState tetherState = this.mTetherStates.valueAt(i);
                pw.print(iface + " - ");
                switch (tetherState.mLastState) {
                    case 0: {
                        pw.print("UnavailableState");
                        break;
                    }
                    case 1: {
                        pw.print("AvailableState");
                        break;
                    }
                    case 2: {
                        pw.print("TetheredState");
                        break;
                    }
                    default: {
                        pw.print("UnknownState");
                    }
                }
                pw.println(" - lastError = " + tetherState.mLastError);
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyInterfaceStateChange(String iface, TetherInterfaceStateMachine who, int state, int error) {
        Object object = this.mPublicSync;
        synchronized (object) {
            TetherState tetherState = this.mTetherStates.get(iface);
            if (tetherState != null && tetherState.mStateMachine.equals(who)) {
                tetherState.mLastState = state;
                tetherState.mLastError = error;
            }
        }
        try {
            this.mPolicyManager.onTetheringChanged(iface, state == 2);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        switch (state) {
            case 0: 
            case 1: {
                this.mTetherMasterSM.sendMessage(327682, who);
                break;
            }
            case 2: {
                this.mTetherMasterSM.sendMessage(327681, who);
            }
        }
        this.sendTetherStateChangedBroadcast();
    }

    private void trackNewTetherableInterface(String iface, int interfaceType) {
        TetherState tetherState = new TetherState(new TetherInterfaceStateMachine(iface, this.mLooper, interfaceType, this.mNMService, this.mStatsService, this, new IPv6TetheringInterfaceServices(iface, this.mNMService)));
        this.mTetherStates.put(iface, tetherState);
        tetherState.mStateMachine.start();
    }

    private static String[] copy(String[] strarray) {
        return Arrays.copyOf(strarray, strarray.length);
    }

    class TetherMasterSM
    extends StateMachine {
        private static final int BASE_MASTER = 327680;
        static final int CMD_TETHER_MODE_REQUESTED = 327681;
        static final int CMD_TETHER_MODE_UNREQUESTED = 327682;
        static final int CMD_UPSTREAM_CHANGED = 327683;
        static final int CMD_RETRY_UPSTREAM = 327684;
        static final int EVENT_UPSTREAM_CALLBACK = 327685;
        private State mInitialState;
        private State mTetherModeAliveState;
        private State mSetIpForwardingEnabledErrorState;
        private State mSetIpForwardingDisabledErrorState;
        private State mStartTetheringErrorState;
        private State mStopTetheringErrorState;
        private State mSetDnsForwardersErrorState;
        private final ArrayList<TetherInterfaceStateMachine> mNotifyList;
        private final IPv6TetheringCoordinator mIPv6TetheringCoordinator;
        private static final int UPSTREAM_SETTLE_TIME_MS = 10000;

        TetherMasterSM(String name, Looper looper) {
            super(name, looper);
            this.mInitialState = new InitialState();
            this.addState(this.mInitialState);
            this.mTetherModeAliveState = new TetherModeAliveState();
            this.addState(this.mTetherModeAliveState);
            this.mSetIpForwardingEnabledErrorState = new SetIpForwardingEnabledErrorState();
            this.addState(this.mSetIpForwardingEnabledErrorState);
            this.mSetIpForwardingDisabledErrorState = new SetIpForwardingDisabledErrorState();
            this.addState(this.mSetIpForwardingDisabledErrorState);
            this.mStartTetheringErrorState = new StartTetheringErrorState();
            this.addState(this.mStartTetheringErrorState);
            this.mStopTetheringErrorState = new StopTetheringErrorState();
            this.addState(this.mStopTetheringErrorState);
            this.mSetDnsForwardersErrorState = new SetDnsForwardersErrorState();
            this.addState(this.mSetDnsForwardersErrorState);
            this.mNotifyList = new ArrayList();
            this.mIPv6TetheringCoordinator = new IPv6TetheringCoordinator(this.mNotifyList);
            this.setInitialState(this.mInitialState);
        }

        class SetDnsForwardersErrorState
        extends ErrorState {
            SetDnsForwardersErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in setDnsForwarders");
                this.notify(327791);
                try {
                    Tethering.this.mNMService.stopTethering();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StopTetheringErrorState
        extends ErrorState {
            StopTetheringErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in stopTethering");
                this.notify(327790);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class StartTetheringErrorState
        extends ErrorState {
            StartTetheringErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in startTethering");
                this.notify(327789);
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class SetIpForwardingDisabledErrorState
        extends ErrorState {
            SetIpForwardingDisabledErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in setIpForwardingDisabled");
                this.notify(327788);
            }
        }

        class SetIpForwardingEnabledErrorState
        extends ErrorState {
            SetIpForwardingEnabledErrorState() {
            }

            @Override
            public void enter() {
                Log.e(Tethering.TAG, "Error in setIpForwardingEnabled");
                this.notify(327787);
            }
        }

        class ErrorState
        extends State {
            int mErrorNotification;

            ErrorState() {
            }

            @Override
            public boolean processMessage(Message message) {
                boolean retValue = true;
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        who.sendMessage(this.mErrorNotification);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }

            void notify(int msgType) {
                this.mErrorNotification = msgType;
                for (TetherInterfaceStateMachine sm : TetherMasterSM.this.mNotifyList) {
                    sm.sendMessage(msgType);
                }
            }
        }

        class TetherModeAliveState
        extends TetherMasterUtilState {
            final SimChangeListener simChange;
            boolean mTryCell;

            TetherModeAliveState() {
                this.simChange = new SimChangeListener(Tethering.this.mContext);
                this.mTryCell = true;
            }

            @Override
            public void enter() {
                this.turnOnMasterTetherSettings();
                this.simChange.startListening();
                Tethering.this.mUpstreamNetworkMonitor.start();
                this.chooseUpstreamType(true);
                this.mTryCell = false;
            }

            @Override
            public void exit() {
                this.unrequestUpstreamMobileConnection();
                Tethering.this.mUpstreamNetworkMonitor.stop();
                this.simChange.stopListening();
                this.notifyTetheredOfNewUpstreamIface(null);
                this.handleNewUpstreamNetworkState(null);
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.maybeLogMessage(this, message.what);
                boolean retValue = true;
                block0 : switch (message.what) {
                    case 327681: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        if (TetherMasterSM.this.mNotifyList.indexOf(who) < 0) {
                            TetherMasterSM.this.mNotifyList.add(who);
                            TetherMasterSM.this.mIPv6TetheringCoordinator.addActiveDownstream(who);
                        }
                        who.sendMessage(327792, Tethering.this.mCurrentUpstreamIface);
                        break;
                    }
                    case 327682: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        if (TetherMasterSM.this.mNotifyList.remove(who)) {
                            if (TetherMasterSM.this.mNotifyList.isEmpty()) {
                                this.turnOffMasterTetherSettings();
                            }
                        } else {
                            Log.e(Tethering.TAG, "TetherModeAliveState UNREQUESTED has unknown who: " + who);
                        }
                        TetherMasterSM.this.mIPv6TetheringCoordinator.removeActiveDownstream(who);
                        break;
                    }
                    case 327683: {
                        this.chooseUpstreamType(true);
                        this.mTryCell = false;
                        break;
                    }
                    case 327684: {
                        this.chooseUpstreamType(this.mTryCell);
                        this.mTryCell = !this.mTryCell;
                        break;
                    }
                    case 327685: {
                        NetworkState ns = (NetworkState)message.obj;
                        if (ns == null || !Tethering.this.pertainsToCurrentUpstream(ns)) {
                            if (Tethering.this.mCurrentUpstreamIface != null) break;
                            this.chooseUpstreamType(false);
                            break;
                        }
                        switch (message.arg1) {
                            case 1: {
                                break block0;
                            }
                            case 2: {
                                this.handleNewUpstreamNetworkState(ns);
                                break block0;
                            }
                            case 3: {
                                this.setDnsForwarders(ns.network, ns.linkProperties);
                                this.handleNewUpstreamNetworkState(ns);
                                break block0;
                            }
                            case 4: {
                                this.handleNewUpstreamNetworkState(null);
                                break block0;
                            }
                        }
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        class InitialState
        extends TetherMasterUtilState {
            InitialState() {
            }

            @Override
            public boolean processMessage(Message message) {
                Tethering.this.maybeLogMessage(this, message.what);
                boolean retValue = true;
                switch (message.what) {
                    case 327681: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        if (TetherMasterSM.this.mNotifyList.indexOf(who) < 0) {
                            TetherMasterSM.this.mNotifyList.add(who);
                            TetherMasterSM.this.mIPv6TetheringCoordinator.addActiveDownstream(who);
                        }
                        TetherMasterSM.this.transitionTo(TetherMasterSM.this.mTetherModeAliveState);
                        break;
                    }
                    case 327682: {
                        TetherInterfaceStateMachine who = (TetherInterfaceStateMachine)message.obj;
                        TetherMasterSM.this.mNotifyList.remove(who);
                        TetherMasterSM.this.mIPv6TetheringCoordinator.removeActiveDownstream(who);
                        break;
                    }
                    default: {
                        retValue = false;
                    }
                }
                return retValue;
            }
        }

        private class SimChangeListener {
            private final Context mContext;
            private final AtomicInteger mSimBcastGenerationNumber;
            private BroadcastReceiver mBroadcastReceiver;

            SimChangeListener(Context ctx) {
                this.mContext = ctx;
                this.mSimBcastGenerationNumber = new AtomicInteger(0);
            }

            public int generationNumber() {
                return this.mSimBcastGenerationNumber.get();
            }

            public void startListening() {
                if (this.mBroadcastReceiver != null) {
                    return;
                }
                this.mBroadcastReceiver = new SimChangeBroadcastReceiver(this.mSimBcastGenerationNumber.incrementAndGet());
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.SIM_STATE_CHANGED");
                this.mContext.registerReceiver(this.mBroadcastReceiver, filter, null, Tethering.this.mTetherMasterSM.getHandler());
            }

            public void stopListening() {
                if (this.mBroadcastReceiver == null) {
                    return;
                }
                this.mSimBcastGenerationNumber.incrementAndGet();
                this.mContext.unregisterReceiver(this.mBroadcastReceiver);
                this.mBroadcastReceiver = null;
            }

            public boolean hasMobileHotspotProvisionApp() {
                try {
                    if (!this.mContext.getResources().getString(17039650).isEmpty()) {
                        Log.d(Tethering.TAG, "re-evaluate provisioning");
                        return true;
                    }
                }
                catch (Resources.NotFoundException notFoundException) {
                    // empty catch block
                }
                Log.d(Tethering.TAG, "no prov-check needed for new SIM");
                return false;
            }

            private boolean isSimCardLoaded(String state) {
                return "LOADED".equals(state);
            }

            private void startProvisionIntent(int tetherType) {
                Intent startProvIntent = new Intent();
                startProvIntent.putExtra("extraAddTetherType", tetherType);
                startProvIntent.putExtra("extraRunProvision", true);
                startProvIntent.setComponent(TETHER_SERVICE);
                this.mContext.startServiceAsUser(startProvIntent, UserHandle.CURRENT);
            }

            private class SimChangeBroadcastReceiver
            extends BroadcastReceiver {
                private final int mGenerationNumber;
                private boolean mSimNotLoadedSeen = false;

                public SimChangeBroadcastReceiver(int generationNumber) {
                    this.mGenerationNumber = generationNumber;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onReceive(Context context, Intent intent) {
                    int currentGenerationNumber = SimChangeListener.this.mSimBcastGenerationNumber.get();
                    if (this.mGenerationNumber != currentGenerationNumber) {
                        return;
                    }
                    String state = intent.getStringExtra("ss");
                    Log.d(Tethering.TAG, "got Sim changed to state " + state + ", mSimNotLoadedSeen=" + this.mSimNotLoadedSeen);
                    if (!SimChangeListener.this.isSimCardLoaded(state)) {
                        if (!this.mSimNotLoadedSeen) {
                            this.mSimNotLoadedSeen = true;
                        }
                        return;
                    }
                    if (SimChangeListener.this.isSimCardLoaded(state) && this.mSimNotLoadedSeen) {
                        this.mSimNotLoadedSeen = false;
                        if (!SimChangeListener.this.hasMobileHotspotProvisionApp()) {
                            return;
                        }
                        ArrayList<Integer> tethered = new ArrayList<Integer>();
                        Iterator iterator = Tethering.this.mPublicSync;
                        synchronized (iterator) {
                            for (int i = 0; i < Tethering.this.mTetherStates.size(); ++i) {
                                String iface;
                                int interfaceType;
                                TetherState tetherState = (TetherState)Tethering.this.mTetherStates.valueAt(i);
                                if (tetherState.mLastState != 2 || (interfaceType = Tethering.this.ifaceNameToType(iface = (String)Tethering.this.mTetherStates.keyAt(i))) == -1) continue;
                                tethered.add(new Integer(interfaceType));
                            }
                        }
                        iterator = tethered.iterator();
                        while (iterator.hasNext()) {
                            int tetherType = (Integer)iterator.next();
                            SimChangeListener.this.startProvisionIntent(tetherType);
                        }
                    }
                }
            }
        }

        class TetherMasterUtilState
        extends State {
            TetherMasterUtilState() {
            }

            @Override
            public boolean processMessage(Message m) {
                return false;
            }

            protected void requestUpstreamMobileConnection() {
                Tethering.this.mUpstreamNetworkMonitor.updateMobileRequiresDun(((Tethering)Tethering.this).mConfig.isDunRequired);
                Tethering.this.mUpstreamNetworkMonitor.registerMobileNetworkRequest();
            }

            protected void unrequestUpstreamMobileConnection() {
                Tethering.this.mUpstreamNetworkMonitor.releaseMobileNetworkRequest();
            }

            protected boolean turnOnMasterTetherSettings() {
                TetheringConfiguration cfg = Tethering.this.mConfig;
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(true);
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mSetIpForwardingEnabledErrorState);
                    return false;
                }
                try {
                    Tethering.this.mNMService.startTethering(cfg.dhcpRanges);
                }
                catch (Exception e) {
                    try {
                        Tethering.this.mNMService.stopTethering();
                        Tethering.this.mNMService.startTethering(cfg.dhcpRanges);
                    }
                    catch (Exception ee) {
                        TetherMasterSM.this.transitionTo(TetherMasterSM.this.mStartTetheringErrorState);
                        return false;
                    }
                }
                return true;
            }

            protected boolean turnOffMasterTetherSettings() {
                try {
                    Tethering.this.mNMService.stopTethering();
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mStopTetheringErrorState);
                    return false;
                }
                try {
                    Tethering.this.mNMService.setIpForwardingEnabled(false);
                }
                catch (Exception e) {
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mSetIpForwardingDisabledErrorState);
                    return false;
                }
                TetherMasterSM.this.transitionTo(TetherMasterSM.this.mInitialState);
                return true;
            }

            protected void chooseUpstreamType(boolean tryCell) {
                int upstreamType = this.findPreferredUpstreamType(tryCell);
                this.setUpstreamByType(upstreamType);
            }

            protected int findPreferredUpstreamType(boolean tryCell) {
                ConnectivityManager cm = Tethering.this.getConnectivityManager();
                int upType = -1;
                Tethering.this.updateConfiguration();
                TetheringConfiguration cfg = Tethering.this.mConfig;
                for (Integer netType : cfg.preferredUpstreamIfaceTypes) {
                    NetworkInfo info = cm.getNetworkInfo(netType);
                    if (info == null || !info.isConnected()) continue;
                    upType = netType;
                    break;
                }
                int preferredUpstreamMobileApn = cfg.isDunRequired ? 4 : 5;
                switch (upType) {
                    case 4: 
                    case 5: {
                        this.requestUpstreamMobileConnection();
                        break;
                    }
                    case -1: {
                        if (tryCell) {
                            this.requestUpstreamMobileConnection();
                            break;
                        }
                        TetherMasterSM.this.sendMessageDelayed(327684, 10000L);
                        break;
                    }
                    default: {
                        this.unrequestUpstreamMobileConnection();
                    }
                }
                return upType;
            }

            protected void setUpstreamByType(int upType) {
                ConnectivityManager cm = Tethering.this.getConnectivityManager();
                Network network = null;
                String iface = null;
                if (upType != -1) {
                    LinkProperties linkProperties = cm.getLinkProperties(upType);
                    if (linkProperties != null) {
                        Log.i(Tethering.TAG, "Finding IPv4 upstream interface on: " + linkProperties);
                        RouteInfo ipv4Default = RouteInfo.selectBestRoute(linkProperties.getAllRoutes(), Inet4Address.ANY);
                        if (ipv4Default != null) {
                            iface = ipv4Default.getInterface();
                            Log.i(Tethering.TAG, "Found interface " + ipv4Default.getInterface());
                        } else {
                            Log.i(Tethering.TAG, "No IPv4 upstream interface, giving up.");
                        }
                    }
                    if (iface != null) {
                        network = cm.getNetworkForType(upType);
                        if (network == null) {
                            Log.e(Tethering.TAG, "No Network for upstream type " + upType + "!");
                        }
                        this.setDnsForwarders(network, linkProperties);
                    }
                }
                this.notifyTetheredOfNewUpstreamIface(iface);
                NetworkState ns = Tethering.this.mUpstreamNetworkMonitor.lookup(network);
                if (ns != null && Tethering.this.pertainsToCurrentUpstream(ns)) {
                    this.handleNewUpstreamNetworkState(ns);
                } else if (Tethering.this.mCurrentUpstreamIface == null) {
                    this.handleNewUpstreamNetworkState(null);
                }
            }

            protected void setDnsForwarders(Network network, LinkProperties lp) {
                String[] dnsServers = ((Tethering)Tethering.this).mConfig.defaultIPv4DNS;
                List<InetAddress> dnses = lp.getDnsServers();
                if (dnses != null && !dnses.isEmpty()) {
                    dnsServers = NetworkUtils.makeStrings(dnses);
                }
                try {
                    Tethering.this.mNMService.setDnsForwarders(network, dnsServers);
                }
                catch (Exception e) {
                    Log.e(Tethering.TAG, "Setting DNS forwarders failed!");
                    TetherMasterSM.this.transitionTo(TetherMasterSM.this.mSetDnsForwardersErrorState);
                }
            }

            protected void notifyTetheredOfNewUpstreamIface(String ifaceName) {
                Tethering.this.mCurrentUpstreamIface = ifaceName;
                for (TetherInterfaceStateMachine sm : TetherMasterSM.this.mNotifyList) {
                    sm.sendMessage(327792, ifaceName);
                }
            }

            protected void handleNewUpstreamNetworkState(NetworkState ns) {
                TetherMasterSM.this.mIPv6TetheringCoordinator.updateUpstreamNetworkState(ns);
            }
        }
    }

    private class StateReceiver
    extends BroadcastReceiver {
        private StateReceiver() {
        }

        @Override
        public void onReceive(Context content, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.hardware.usb.action.USB_STATE")) {
                this.handleUsbAction(intent);
            } else if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                this.handleConnectivityAction(intent);
            } else if (action.equals("android.net.wifi.WIFI_AP_STATE_CHANGED")) {
                this.handleWifiApAction(intent);
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                Tethering.this.updateConfiguration();
            }
        }

        private void handleConnectivityAction(Intent intent) {
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (networkInfo == null || networkInfo.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
                return;
            }
            Tethering.this.mTetherMasterSM.sendMessage(327683);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleUsbAction(Intent intent) {
            boolean usbConnected = intent.getBooleanExtra("connected", false);
            boolean rndisEnabled = intent.getBooleanExtra("rndis", false);
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                Tethering.this.mRndisEnabled = rndisEnabled;
                if (usbConnected && Tethering.this.mRndisEnabled && Tethering.this.mUsbTetherRequested) {
                    Tethering.this.tetherMatchingInterfaces(true, 1);
                }
                Tethering.this.mUsbTetherRequested = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWifiApAction(Intent intent) {
            int curState = intent.getIntExtra("wifi_state", 11);
            Object object = Tethering.this.mPublicSync;
            synchronized (object) {
                switch (curState) {
                    case 12: {
                        break;
                    }
                    case 13: {
                        if (!Tethering.this.mWifiTetherRequested) break;
                        Tethering.this.tetherMatchingInterfaces(true, 0);
                        break;
                    }
                    default: {
                        for (int i = 0; i < Tethering.this.mTetherStates.size(); ++i) {
                            TetherInterfaceStateMachine tism = ((TetherState)((Tethering)Tethering.this).mTetherStates.valueAt((int)i)).mStateMachine;
                            if (tism.interfaceType() != 0) continue;
                            tism.sendMessage(327783);
                            break;
                        }
                        Tethering.this.mWifiTetherRequested = false;
                    }
                }
            }
        }
    }

    private static class TetherState {
        public final TetherInterfaceStateMachine mStateMachine;
        public int mLastState;
        public int mLastError;

        public TetherState(TetherInterfaceStateMachine sm) {
            this.mStateMachine = sm;
            this.mLastState = 1;
            this.mLastError = 0;
        }
    }
}

