/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.net.INetworkStatsService;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.tethering.IControlsTethering;
import com.android.server.connectivity.tethering.IPv6TetheringInterfaceServices;
import java.net.InetAddress;

public class TetherInterfaceStateMachine
extends StateMachine {
    private static final String USB_NEAR_IFACE_ADDR = "192.168.42.129";
    private static final int USB_PREFIX_LENGTH = 24;
    private static final String WIFI_HOST_IFACE_ADDR = "192.168.43.1";
    private static final int WIFI_HOST_IFACE_PREFIX_LENGTH = 24;
    private static final String TAG = "TetherInterfaceSM";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final Class[] messageClasses = new Class[]{TetherInterfaceStateMachine.class};
    private static final SparseArray<String> sMagicDecoderRing = MessageUtils.findMessageNames(messageClasses);
    private static final int BASE_IFACE = 327780;
    public static final int CMD_TETHER_REQUESTED = 327782;
    public static final int CMD_TETHER_UNREQUESTED = 327783;
    public static final int CMD_INTERFACE_DOWN = 327784;
    public static final int CMD_IP_FORWARDING_ENABLE_ERROR = 327787;
    public static final int CMD_IP_FORWARDING_DISABLE_ERROR = 327788;
    public static final int CMD_START_TETHERING_ERROR = 327789;
    public static final int CMD_STOP_TETHERING_ERROR = 327790;
    public static final int CMD_SET_DNS_FORWARDERS_ERROR = 327791;
    public static final int CMD_TETHER_CONNECTION_CHANGED = 327792;
    public static final int CMD_IPV6_TETHER_UPDATE = 327793;
    private final State mInitialState;
    private final State mTetheredState;
    private final State mUnavailableState;
    private final INetworkManagementService mNMService;
    private final INetworkStatsService mStatsService;
    private final IControlsTethering mTetherController;
    private final String mIfaceName;
    private final int mInterfaceType;
    private final IPv6TetheringInterfaceServices mIPv6TetherSvc;
    private int mLastError;
    private String mMyUpstreamIfaceName;

    public TetherInterfaceStateMachine(String ifaceName, Looper looper, int interfaceType, INetworkManagementService nMService, INetworkStatsService statsService, IControlsTethering tetherController, IPv6TetheringInterfaceServices ipv6Svc) {
        super(ifaceName, looper);
        this.mNMService = nMService;
        this.mStatsService = statsService;
        this.mTetherController = tetherController;
        this.mIfaceName = ifaceName;
        this.mInterfaceType = interfaceType;
        this.mIPv6TetherSvc = ipv6Svc;
        this.mLastError = 0;
        this.mInitialState = new InitialState();
        this.addState(this.mInitialState);
        this.mTetheredState = new TetheredState();
        this.addState(this.mTetheredState);
        this.mUnavailableState = new UnavailableState();
        this.addState(this.mUnavailableState);
        this.setInitialState(this.mInitialState);
    }

    public int interfaceType() {
        return this.mInterfaceType;
    }

    private boolean configureIfaceIp(boolean enabled) {
        String ipAsString = null;
        int prefixLen = 0;
        if (this.mInterfaceType == 1) {
            ipAsString = USB_NEAR_IFACE_ADDR;
            prefixLen = 24;
        } else if (this.mInterfaceType == 0) {
            ipAsString = WIFI_HOST_IFACE_ADDR;
            prefixLen = 24;
        } else {
            return true;
        }
        InterfaceConfiguration ifcg = null;
        try {
            ifcg = this.mNMService.getInterfaceConfig(this.mIfaceName);
            if (ifcg != null) {
                InetAddress addr = NetworkUtils.numericToInetAddress(ipAsString);
                ifcg.setLinkAddress(new LinkAddress(addr, prefixLen));
                if (this.mInterfaceType == 0) {
                    ifcg.ignoreInterfaceUpDownStatus();
                } else if (enabled) {
                    ifcg.setInterfaceUp();
                } else {
                    ifcg.setInterfaceDown();
                }
                ifcg.clearFlag("running");
                this.mNMService.setInterfaceConfig(this.mIfaceName, ifcg);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Error configuring interface " + this.mIfaceName, e);
            return false;
        }
        return true;
    }

    private void maybeLogMessage(State state, int what) {
    }

    class UnavailableState
    extends State {
        UnavailableState() {
        }

        @Override
        public void enter() {
            TetherInterfaceStateMachine.this.mLastError = 0;
            TetherInterfaceStateMachine.this.mTetherController.notifyInterfaceStateChange(TetherInterfaceStateMachine.this.mIfaceName, TetherInterfaceStateMachine.this, 0, TetherInterfaceStateMachine.this.mLastError);
        }
    }

    class TetheredState
    extends State {
        TetheredState() {
        }

        @Override
        public void enter() {
            if (!TetherInterfaceStateMachine.this.configureIfaceIp(true)) {
                TetherInterfaceStateMachine.this.mLastError = 10;
                TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                return;
            }
            try {
                TetherInterfaceStateMachine.this.mNMService.tetherInterface(TetherInterfaceStateMachine.this.mIfaceName);
            }
            catch (Exception e) {
                Log.e(TetherInterfaceStateMachine.TAG, "Error Tethering: " + e.toString());
                TetherInterfaceStateMachine.this.mLastError = 6;
                TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                return;
            }
            if (!TetherInterfaceStateMachine.this.mIPv6TetherSvc.start()) {
                Log.e(TetherInterfaceStateMachine.TAG, "Failed to start IPv6TetheringInterfaceServices");
            }
            TetherInterfaceStateMachine.this.mTetherController.notifyInterfaceStateChange(TetherInterfaceStateMachine.this.mIfaceName, TetherInterfaceStateMachine.this, 2, TetherInterfaceStateMachine.this.mLastError);
        }

        @Override
        public void exit() {
            TetherInterfaceStateMachine.this.mIPv6TetherSvc.stop();
            this.cleanupUpstream();
            try {
                TetherInterfaceStateMachine.this.mNMService.untetherInterface(TetherInterfaceStateMachine.this.mIfaceName);
            }
            catch (Exception ee) {
                TetherInterfaceStateMachine.this.mLastError = 7;
                Log.e(TetherInterfaceStateMachine.TAG, "Failed to untether interface: " + ee.toString());
            }
            TetherInterfaceStateMachine.this.configureIfaceIp(false);
        }

        private void cleanupUpstream() {
            if (TetherInterfaceStateMachine.this.mMyUpstreamIfaceName == null) {
                return;
            }
            this.cleanupUpstreamInterface(TetherInterfaceStateMachine.this.mMyUpstreamIfaceName);
            TetherInterfaceStateMachine.this.mMyUpstreamIfaceName = null;
        }

        private void cleanupUpstreamInterface(String upstreamIface) {
            try {
                TetherInterfaceStateMachine.this.mStatsService.forceUpdate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                TetherInterfaceStateMachine.this.mNMService.stopInterfaceForwarding(TetherInterfaceStateMachine.this.mIfaceName, upstreamIface);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                TetherInterfaceStateMachine.this.mNMService.disableNat(TetherInterfaceStateMachine.this.mIfaceName, upstreamIface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean processMessage(Message message) {
            TetherInterfaceStateMachine.this.maybeLogMessage(this, message.what);
            boolean retValue = true;
            switch (message.what) {
                case 327783: {
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                    break;
                }
                case 327784: {
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mUnavailableState);
                    break;
                }
                case 327792: {
                    String newUpstreamIfaceName = (String)message.obj;
                    if (TetherInterfaceStateMachine.this.mMyUpstreamIfaceName == null && newUpstreamIfaceName == null || TetherInterfaceStateMachine.this.mMyUpstreamIfaceName != null && TetherInterfaceStateMachine.this.mMyUpstreamIfaceName.equals(newUpstreamIfaceName)) break;
                    this.cleanupUpstream();
                    if (newUpstreamIfaceName != null) {
                        try {
                            TetherInterfaceStateMachine.this.mNMService.enableNat(TetherInterfaceStateMachine.this.mIfaceName, newUpstreamIfaceName);
                            TetherInterfaceStateMachine.this.mNMService.startInterfaceForwarding(TetherInterfaceStateMachine.this.mIfaceName, newUpstreamIfaceName);
                        }
                        catch (Exception e) {
                            Log.e(TetherInterfaceStateMachine.TAG, "Exception enabling Nat: " + e.toString());
                            this.cleanupUpstreamInterface(newUpstreamIfaceName);
                            TetherInterfaceStateMachine.this.mLastError = 8;
                            TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                            return true;
                        }
                    }
                    TetherInterfaceStateMachine.this.mMyUpstreamIfaceName = newUpstreamIfaceName;
                    break;
                }
                case 327793: {
                    TetherInterfaceStateMachine.this.mIPv6TetherSvc.updateUpstreamIPv6LinkProperties((LinkProperties)message.obj);
                    break;
                }
                case 327787: 
                case 327788: 
                case 327789: 
                case 327790: 
                case 327791: {
                    TetherInterfaceStateMachine.this.mLastError = 5;
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }
    }

    class InitialState
    extends State {
        InitialState() {
        }

        @Override
        public void enter() {
            TetherInterfaceStateMachine.this.mTetherController.notifyInterfaceStateChange(TetherInterfaceStateMachine.this.mIfaceName, TetherInterfaceStateMachine.this, 1, TetherInterfaceStateMachine.this.mLastError);
        }

        @Override
        public boolean processMessage(Message message) {
            TetherInterfaceStateMachine.this.maybeLogMessage(this, message.what);
            boolean retValue = true;
            switch (message.what) {
                case 327782: {
                    TetherInterfaceStateMachine.this.mLastError = 0;
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mTetheredState);
                    break;
                }
                case 327784: {
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mUnavailableState);
                    break;
                }
                case 327793: {
                    TetherInterfaceStateMachine.this.mIPv6TetherSvc.updateUpstreamIPv6LinkProperties((LinkProperties)message.obj);
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }
    }
}

