/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.net.NetworkState;
import android.util.Log;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.tethering.UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$1;
import com.android.server.connectivity.tethering.UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$7;
import com.android.server.connectivity.tethering.UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$8;
import com.android.server.connectivity.tethering.UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$9;
import java.util.HashMap;

public class UpstreamNetworkMonitor {
    private static final String TAG = UpstreamNetworkMonitor.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final int EVENT_ON_AVAILABLE = 1;
    public static final int EVENT_ON_CAPABILITIES = 2;
    public static final int EVENT_ON_LINKPROPERTIES = 3;
    public static final int EVENT_ON_LOST = 4;
    private static final int CALLBACK_LISTEN_ALL = 1;
    private static final int CALLBACK_TRACK_DEFAULT = 2;
    private static final int CALLBACK_MOBILE_REQUEST = 3;
    private final Context mContext;
    private final StateMachine mTarget;
    private final int mWhat;
    private final HashMap<Network, NetworkState> mNetworkMap = new HashMap();
    private ConnectivityManager mCM;
    private ConnectivityManager.NetworkCallback mListenAllCallback;
    private ConnectivityManager.NetworkCallback mDefaultNetworkCallback;
    private ConnectivityManager.NetworkCallback mMobileNetworkCallback;
    private boolean mDunRequired;
    private Network mCurrentDefault;

    public UpstreamNetworkMonitor(Context ctx, StateMachine tgt, int what) {
        this.mContext = ctx;
        this.mTarget = tgt;
        this.mWhat = what;
    }

    public UpstreamNetworkMonitor(StateMachine tgt, int what, ConnectivityManager cm) {
        this(null, tgt, what);
        this.mCM = cm;
    }

    public void start() {
        this.stop();
        NetworkRequest listenAllRequest = new NetworkRequest.Builder().clearCapabilities().build();
        this.mListenAllCallback = new UpstreamNetworkCallback(1);
        this.cm().registerNetworkCallback(listenAllRequest, this.mListenAllCallback);
        this.mDefaultNetworkCallback = new UpstreamNetworkCallback(2);
        this.cm().registerDefaultNetworkCallback(this.mDefaultNetworkCallback);
    }

    public void stop() {
        this.releaseMobileNetworkRequest();
        this.releaseCallback(this.mDefaultNetworkCallback);
        this.mDefaultNetworkCallback = null;
        this.releaseCallback(this.mListenAllCallback);
        this.mListenAllCallback = null;
        this.mNetworkMap.clear();
    }

    public void updateMobileRequiresDun(boolean dunRequired) {
        boolean valueChanged = this.mDunRequired != dunRequired;
        this.mDunRequired = dunRequired;
        if (valueChanged && this.mobileNetworkRequested()) {
            this.releaseMobileNetworkRequest();
            this.registerMobileNetworkRequest();
        }
    }

    public boolean mobileNetworkRequested() {
        return this.mMobileNetworkCallback != null;
    }

    public void registerMobileNetworkRequest() {
        if (this.mMobileNetworkCallback != null) {
            Log.e(TAG, "registerMobileNetworkRequest() already registered");
            return;
        }
        int legacyType = this.mDunRequired ? 4 : 5;
        NetworkRequest mobileUpstreamRequest = new NetworkRequest.Builder().setCapabilities(ConnectivityManager.networkCapabilitiesForType(legacyType)).build();
        this.mMobileNetworkCallback = new UpstreamNetworkCallback(3);
        Log.d(TAG, "requesting mobile upstream network: " + mobileUpstreamRequest);
        this.cm().requestNetwork(mobileUpstreamRequest, this.mMobileNetworkCallback, 0, legacyType);
    }

    public void releaseMobileNetworkRequest() {
        if (this.mMobileNetworkCallback == null) {
            return;
        }
        this.cm().unregisterNetworkCallback(this.mMobileNetworkCallback);
        this.mMobileNetworkCallback = null;
    }

    public NetworkState lookup(Network network) {
        return network != null ? this.mNetworkMap.get(network) : null;
    }

    private void handleAvailable(int callbackType, Network network) {
        if (!this.mNetworkMap.containsKey(network)) {
            this.mNetworkMap.put(network, new NetworkState(null, null, null, network, null, null));
        }
        switch (callbackType) {
            case 1: {
                break;
            }
            case 2: {
                if (this.mDefaultNetworkCallback == null) {
                    return;
                }
                this.cm().requestNetworkCapabilities(this.mDefaultNetworkCallback);
                this.cm().requestLinkProperties(this.mDefaultNetworkCallback);
                this.mCurrentDefault = network;
                break;
            }
            case 3: {
                if (this.mMobileNetworkCallback == null) {
                    return;
                }
                this.cm().requestNetworkCapabilities(this.mMobileNetworkCallback);
                this.cm().requestLinkProperties(this.mMobileNetworkCallback);
            }
        }
        this.notifyTarget(1, network);
    }

    private void handleNetCap(Network network, NetworkCapabilities newNc) {
        NetworkState prev = this.mNetworkMap.get(network);
        if (prev == null || newNc.equals(prev.networkCapabilities)) {
            return;
        }
        this.mNetworkMap.put(network, new NetworkState(null, prev.linkProperties, newNc, network, null, null));
        this.notifyTarget(2, network);
    }

    private void handleLinkProp(Network network, LinkProperties newLp) {
        NetworkState prev = this.mNetworkMap.get(network);
        if (prev == null || newLp.equals(prev.linkProperties)) {
            return;
        }
        this.mNetworkMap.put(network, new NetworkState(null, newLp, prev.networkCapabilities, network, null, null));
        this.notifyTarget(3, network);
    }

    private void handleLost(int callbackType, Network network) {
        if (callbackType == 2) {
            this.mCurrentDefault = null;
            return;
        }
        if (!this.mNetworkMap.containsKey(network)) {
            return;
        }
        this.notifyTarget(4, this.mNetworkMap.remove(network));
    }

    private ConnectivityManager cm() {
        if (this.mCM == null) {
            this.mCM = this.mContext.getSystemService(ConnectivityManager.class);
        }
        return this.mCM;
    }

    private void releaseCallback(ConnectivityManager.NetworkCallback cb) {
        if (cb != null) {
            this.cm().unregisterNetworkCallback(cb);
        }
    }

    private void notifyTarget(int which, Network network) {
        this.notifyTarget(which, this.mNetworkMap.get(network));
    }

    private void notifyTarget(int which, NetworkState netstate) {
        this.mTarget.sendMessage(this.mWhat, which, 0, netstate);
    }

    private class UpstreamNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private final int mCallbackType;

        UpstreamNetworkCallback(int callbackType) {
            this.mCallbackType = callbackType;
        }

        @Override
        public void onAvailable(Network network) {
            UpstreamNetworkMonitor.this.mTarget.getHandler().post(UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$1.get$Lambda(this, network));
        }

        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities newNc) {
            UpstreamNetworkMonitor.this.mTarget.getHandler().post(UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$7.get$Lambda(this, network, newNc));
        }

        @Override
        public void onLinkPropertiesChanged(Network network, LinkProperties newLp) {
            UpstreamNetworkMonitor.this.mTarget.getHandler().post(UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$8.get$Lambda(this, network, newLp));
        }

        @Override
        public void onLost(Network network) {
            UpstreamNetworkMonitor.this.mTarget.getHandler().post(UpstreamNetworkMonitor$UpstreamNetworkCallback$$Lambda$9.get$Lambda(this, network));
        }

        final /* synthetic */ void lambda$onLost$8$UpstreamNetworkMonitor$UpstreamNetworkCallback(Network network) {
            UpstreamNetworkMonitor.this.handleLost(this.mCallbackType, network);
        }

        final /* synthetic */ void lambda$onLinkPropertiesChanged$7$UpstreamNetworkMonitor$UpstreamNetworkCallback(Network network, LinkProperties linkProperties) {
            UpstreamNetworkMonitor.this.handleLinkProp(network, linkProperties);
        }

        final /* synthetic */ void lambda$onCapabilitiesChanged$6$UpstreamNetworkMonitor$UpstreamNetworkCallback(Network network, NetworkCapabilities networkCapabilities) {
            UpstreamNetworkMonitor.this.handleNetCap(network, networkCapabilities);
        }

        final /* synthetic */ void lambda$onAvailable$5$UpstreamNetworkMonitor$UpstreamNetworkCallback(Network network) {
            UpstreamNetworkMonitor.this.handleAvailable(this.mCallbackType, network);
        }
    }
}

