/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.RemoteException;
import android.os.UserHandle;
import android.security.KeyChain;
import android.util.Log;
import com.android.internal.util.ParcelableString;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.util.ArrayList;
import java.util.List;

public class MonitoringCertNotificationTask
extends AsyncTask<Integer, Void, Void> {
    protected static final String LOG_TAG = "DevicePolicyManager";
    protected static final int MONITORING_CERT_NOTIFICATION_ID = 18153494;
    private final DevicePolicyManagerService mService;
    private final DevicePolicyManagerService.Injector mInjector;

    public MonitoringCertNotificationTask(DevicePolicyManagerService service, DevicePolicyManagerService.Injector injector) {
        this.mService = service;
        this.mInjector = injector;
    }

    protected Void doInBackground(Integer ... params) {
        int userHandle = params[0];
        if (userHandle == -1) {
            for (UserInfo userInfo : this.mInjector.getUserManager().getUsers(true)) {
                this.repostOrClearNotification(userInfo.getUserHandle());
            }
        } else {
            this.repostOrClearNotification(UserHandle.of(userHandle));
        }
        return null;
    }

    private void repostOrClearNotification(UserHandle userHandle) {
        int pendingCertificateCount;
        if (!this.mInjector.getUserManager().isUserUnlocked(userHandle.getIdentifier())) {
            return;
        }
        try {
            pendingCertificateCount = this.mService.retainAcceptedCertificates(userHandle, this.getInstalledCaCertificates(userHandle));
        }
        catch (RemoteException | RuntimeException e) {
            Log.e(LOG_TAG, "Could not retrieve certificates from KeyChain service", e);
            return;
        }
        if (pendingCertificateCount != 0) {
            this.showNotification(userHandle, pendingCertificateCount);
        } else {
            this.mInjector.getNotificationManager().cancelAsUser(LOG_TAG, 18153494, userHandle);
        }
    }

    private void showNotification(UserHandle userHandle, int pendingCertificateCount) {
        int smallIconId;
        String contentText;
        Context userContext;
        try {
            userContext = this.mInjector.createContextAsUser(userHandle);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOG_TAG, "Create context as " + userHandle + " failed", e);
            return;
        }
        int parentUserId = userHandle.getIdentifier();
        Resources resources = this.mInjector.getResources();
        if (this.mService.getProfileOwner(userHandle.getIdentifier()) != null) {
            contentText = resources.getString(17040755, this.mService.getProfileOwnerName(userHandle.getIdentifier()));
            smallIconId = 17303326;
            parentUserId = this.mService.getProfileParentId(userHandle.getIdentifier());
        } else if (this.mService.getDeviceOwnerUserId() == userHandle.getIdentifier()) {
            contentText = resources.getString(17040755, this.mService.getDeviceOwnerName());
            smallIconId = 17303326;
        } else {
            contentText = resources.getString(17040754);
            smallIconId = 17301642;
        }
        Intent dialogIntent = new Intent("com.android.settings.MONITORING_CERT_INFO");
        dialogIntent.setFlags(0x10008000);
        dialogIntent.setPackage("com.android.settings");
        dialogIntent.putExtra("android.settings.extra.number_of_certificates", pendingCertificateCount);
        dialogIntent.putExtra("android.intent.extra.USER_ID", userHandle.getIdentifier());
        PendingIntent notifyIntent = PendingIntent.getActivityAsUser(userContext, 0, dialogIntent, 0x8000000, null, UserHandle.of(parentUserId));
        Notification noti = new Notification.Builder(userContext).setSmallIcon(smallIconId).setContentTitle(resources.getQuantityText(18153494, pendingCertificateCount)).setContentText(contentText).setContentIntent(notifyIntent).setPriority(1).setShowWhen(false).setColor(17170762).build();
        this.mInjector.getNotificationManager().notifyAsUser(LOG_TAG, 18153494, noti, userHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getInstalledCaCertificates(UserHandle userHandle) throws RemoteException, RuntimeException {
        try (KeyChain.KeyChainConnection conn = this.mInjector.keyChainBindAsUser(userHandle);){
            List aliases = conn.getService().getUserCaAliases().getList();
            ArrayList<String> result = new ArrayList<String>(aliases.size());
            for (int i = 0; i < aliases.size(); ++i) {
                result.add(((ParcelableString)aliases.get((int)i)).string);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (AssertionError e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }
}

