/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.AlarmManager;
import android.app.admin.NetworkEvent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class NetworkLoggingHandler
extends Handler {
    private static final String TAG = NetworkLoggingHandler.class.getSimpleName();
    static final String NETWORK_EVENT_KEY = "network_event";
    private static final int MAX_EVENTS_PER_BATCH = 1200;
    private static final long BATCH_FINALIZATION_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(90L);
    private static final long BATCH_FINALIZATION_TIMEOUT_ALARM_INTERVAL_MS = TimeUnit.MINUTES.toMillis(30L);
    private static final String NETWORK_LOGGING_TIMEOUT_ALARM_TAG = "NetworkLogging.batchTimeout";
    private final DevicePolicyManagerService mDpm;
    private final AlarmManager mAlarmManager;
    private final AlarmManager.OnAlarmListener mBatchTimeoutAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            Log.d(TAG, "Received a batch finalization timeout alarm, finalizing " + NetworkLoggingHandler.this.mNetworkEvents.size() + " pending events.");
            NetworkLoggingHandler networkLoggingHandler = NetworkLoggingHandler.this;
            synchronized (networkLoggingHandler) {
                NetworkLoggingHandler.this.finalizeBatchAndNotifyDeviceOwnerLocked();
            }
        }
    };
    static final int LOG_NETWORK_EVENT_MSG = 1;
    @GuardedBy(value="this")
    private ArrayList<NetworkEvent> mNetworkEvents = new ArrayList();
    @GuardedBy(value="this")
    private ArrayList<NetworkEvent> mFullBatch;
    @GuardedBy(value="this")
    private boolean mPaused = false;
    @GuardedBy(value="this")
    private long mCurrentFullBatchToken;
    @GuardedBy(value="this")
    private long mLastRetrievedFullBatchToken;

    NetworkLoggingHandler(Looper looper, DevicePolicyManagerService dpm) {
        super(looper);
        this.mDpm = dpm;
        this.mAlarmManager = this.mDpm.mInjector.getAlarmManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                NetworkEvent networkEvent = (NetworkEvent)msg.getData().getParcelable(NETWORK_EVENT_KEY);
                if (networkEvent == null) break;
                NetworkLoggingHandler networkLoggingHandler = this;
                synchronized (networkLoggingHandler) {
                    this.mNetworkEvents.add(networkEvent);
                    if (this.mNetworkEvents.size() >= 1200) {
                        this.finalizeBatchAndNotifyDeviceOwnerLocked();
                    }
                    break;
                }
            }
            default: {
                Log.d(TAG, "NetworkLoggingHandler received an unknown of message.");
            }
        }
    }

    void scheduleBatchFinalization() {
        long when = SystemClock.elapsedRealtime() + BATCH_FINALIZATION_TIMEOUT_MS;
        this.mAlarmManager.setWindow(2, when, BATCH_FINALIZATION_TIMEOUT_ALARM_INTERVAL_MS, NETWORK_LOGGING_TIMEOUT_ALARM_TAG, this.mBatchTimeoutAlarmListener, this);
        Log.d(TAG, "Scheduled a new batch finalization alarm " + BATCH_FINALIZATION_TIMEOUT_MS + "ms from now.");
    }

    synchronized void pause() {
        Log.d(TAG, "Paused network logging");
        this.mPaused = true;
    }

    synchronized void resume() {
        if (!this.mPaused) {
            Log.d(TAG, "Attempted to resume network logging, but logging is not paused.");
            return;
        }
        Log.d(TAG, "Resumed network logging. Current batch=" + this.mCurrentFullBatchToken + ", LastRetrievedBatch=" + this.mLastRetrievedFullBatchToken);
        this.mPaused = false;
        if (this.mFullBatch != null && this.mFullBatch.size() > 0 && this.mLastRetrievedFullBatchToken != this.mCurrentFullBatchToken) {
            this.scheduleBatchFinalization();
            this.notifyDeviceOwnerLocked();
        }
    }

    synchronized void discardLogs() {
        this.mFullBatch = null;
        this.mNetworkEvents = new ArrayList();
        Log.d(TAG, "Discarded all network logs");
    }

    @GuardedBy(value="this")
    private void finalizeBatchAndNotifyDeviceOwnerLocked() {
        if (this.mNetworkEvents.size() > 0) {
            this.mFullBatch = this.mNetworkEvents;
            ++this.mCurrentFullBatchToken;
            this.mNetworkEvents = new ArrayList();
            if (!this.mPaused) {
                this.notifyDeviceOwnerLocked();
            }
        } else {
            Log.d(TAG, "Was about to finalize the batch, but there were no events to send to the DPC, the batchToken of last available batch: " + this.mCurrentFullBatchToken);
        }
        this.scheduleBatchFinalization();
    }

    @GuardedBy(value="this")
    private void notifyDeviceOwnerLocked() {
        Bundle extras = new Bundle();
        extras.putLong("android.app.extra.EXTRA_NETWORK_LOGS_TOKEN", this.mCurrentFullBatchToken);
        extras.putInt("android.app.extra.EXTRA_NETWORK_LOGS_COUNT", this.mFullBatch.size());
        Log.d(TAG, "Sending network logging batch broadcast to device owner, batchToken: " + this.mCurrentFullBatchToken);
        this.mDpm.sendDeviceOwnerCommand("android.app.action.NETWORK_LOGS_AVAILABLE", extras);
    }

    synchronized List<NetworkEvent> retrieveFullLogBatch(long batchToken) {
        if (batchToken != this.mCurrentFullBatchToken) {
            return null;
        }
        this.mLastRetrievedFullBatchToken = this.mCurrentFullBatchToken;
        return this.mFullBatch;
    }
}

