/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.admin.SecurityLog;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class SecurityLogMonitor
implements Runnable {
    private final DevicePolicyManagerService mService;
    private final Lock mLock = new ReentrantLock();
    private static final boolean DEBUG = false;
    private static final String TAG = "SecurityLogMonitor";
    private static final int BUFFER_ENTRIES_NOTIFICATION_LEVEL = 1024;
    private static final int BUFFER_ENTRIES_MAXIMUM_LEVEL = 10240;
    private static final long RATE_LIMIT_INTERVAL_MILLISECONDS = TimeUnit.HOURS.toMillis(2L);
    private static final long POLLING_INTERVAL_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    @GuardedBy(value="mLock")
    private Thread mMonitorThread = null;
    @GuardedBy(value="mLock")
    private ArrayList<SecurityLog.SecurityEvent> mPendingLogs = new ArrayList();
    @GuardedBy(value="mLock")
    private boolean mAllowedToRetrieve = false;
    @GuardedBy(value="mLock")
    private long mNextAllowedRetrievalTimeMillis = -1L;
    @GuardedBy(value="mLock")
    private boolean mPaused = false;

    SecurityLogMonitor(DevicePolicyManagerService service) {
        this.mService = service;
    }

    void start() {
        Slog.i(TAG, "Starting security logging.");
        this.mLock.lock();
        try {
            if (this.mMonitorThread == null) {
                this.mPendingLogs = new ArrayList();
                this.mAllowedToRetrieve = false;
                this.mNextAllowedRetrievalTimeMillis = -1L;
                this.mPaused = false;
                this.mMonitorThread = new Thread(this);
                this.mMonitorThread.start();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    void stop() {
        block5: {
            Slog.i(TAG, "Stopping security logging.");
            this.mLock.lock();
            try {
                if (this.mMonitorThread == null) break block5;
                this.mMonitorThread.interrupt();
                try {
                    this.mMonitorThread.join(TimeUnit.SECONDS.toMillis(5L));
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting for thread to stop", e);
                }
                this.mPendingLogs = new ArrayList();
                this.mAllowedToRetrieve = false;
                this.mNextAllowedRetrievalTimeMillis = -1L;
                this.mPaused = false;
                this.mMonitorThread = null;
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    void pause() {
        Slog.i(TAG, "Paused.");
        this.mLock.lock();
        this.mPaused = true;
        this.mAllowedToRetrieve = false;
        this.mLock.unlock();
    }

    void resume() {
        this.mLock.lock();
        try {
            if (!this.mPaused) {
                Log.d(TAG, "Attempted to resume, but logging is not paused.");
                return;
            }
            this.mPaused = false;
            this.mAllowedToRetrieve = false;
        }
        finally {
            this.mLock.unlock();
        }
        Slog.i(TAG, "Resumed.");
        try {
            this.notifyDeviceOwnerIfNeeded();
        }
        catch (InterruptedException e) {
            Log.w(TAG, "Thread interrupted.", e);
        }
    }

    void discardLogs() {
        this.mLock.lock();
        this.mAllowedToRetrieve = false;
        this.mPendingLogs = new ArrayList();
        this.mLock.unlock();
        Slog.i(TAG, "Discarded all logs.");
    }

    List<SecurityLog.SecurityEvent> retrieveLogs() {
        this.mLock.lock();
        try {
            if (this.mAllowedToRetrieve) {
                this.mAllowedToRetrieve = false;
                this.mNextAllowedRetrievalTimeMillis = SystemClock.elapsedRealtime() + RATE_LIMIT_INTERVAL_MILLISECONDS;
                ArrayList<SecurityLog.SecurityEvent> result = this.mPendingLogs;
                this.mPendingLogs = new ArrayList();
                ArrayList<SecurityLog.SecurityEvent> arrayList = result;
                return arrayList;
            }
            List<SecurityLog.SecurityEvent> list = null;
            return list;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority(10);
        ArrayList<SecurityLog.SecurityEvent> logs = new ArrayList<SecurityLog.SecurityEvent>();
        long lastLogTimestampNanos = -1L;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(POLLING_INTERVAL_MILLISECONDS);
                if (lastLogTimestampNanos < 0L) {
                    SecurityLog.readEvents(logs);
                } else {
                    SecurityLog.readEventsSince(lastLogTimestampNanos + 1L, logs);
                }
                if (!logs.isEmpty()) {
                    this.mLock.lockInterruptibly();
                    try {
                        this.mPendingLogs.addAll(logs);
                        if (this.mPendingLogs.size() > 10240) {
                            this.mPendingLogs = new ArrayList<SecurityLog.SecurityEvent>(this.mPendingLogs.subList(this.mPendingLogs.size() - 5120, this.mPendingLogs.size()));
                            Slog.i(TAG, "Pending logs buffer full. Discarding old logs.");
                        }
                    }
                    finally {
                        this.mLock.unlock();
                    }
                    lastLogTimestampNanos = logs.get(logs.size() - 1).getTimeNanos();
                    logs.clear();
                }
                this.notifyDeviceOwnerIfNeeded();
            }
            catch (IOException e) {
                Log.e(TAG, "Failed to read security log", e);
            }
            catch (InterruptedException e) {
                Log.i(TAG, "Thread interrupted, exiting.", e);
                break;
            }
        }
        Slog.i(TAG, "MonitorThread exit.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeviceOwnerIfNeeded() throws InterruptedException {
        boolean shouldNotifyDO = false;
        boolean allowToRetrieveNow = false;
        this.mLock.lockInterruptibly();
        try {
            if (this.mPaused) {
                return;
            }
            int logSize = this.mPendingLogs.size();
            if (logSize >= 1024) {
                allowToRetrieveNow = true;
            } else if (logSize > 0 && SystemClock.elapsedRealtime() >= this.mNextAllowedRetrievalTimeMillis) {
                allowToRetrieveNow = true;
            }
            shouldNotifyDO = !this.mAllowedToRetrieve && allowToRetrieveNow;
            this.mAllowedToRetrieve = allowToRetrieveNow;
        }
        finally {
            this.mLock.unlock();
        }
        if (shouldNotifyDO) {
            Slog.i(TAG, "notify DO");
            this.mService.sendDeviceOwnerCommand("android.app.action.SECURITY_LOGS_AVAILABLE", null);
        }
    }
}

