/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.provider.Settings;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.MathUtils;
import android.util.Slog;
import android.view.animation.AnimationUtils;
import com.android.internal.app.NightDisplayController;
import com.android.server.SystemService;
import com.android.server.display.DisplayTransformManager;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NightDisplayService
extends SystemService
implements NightDisplayController.Callback {
    private static final String TAG = "NightDisplayService";
    private static final boolean DEBUG = false;
    private static final float[] MATRIX_NIGHT = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.754f, 0.0f, 0.0f, 0.0f, 0.0f, 0.516f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final long TRANSITION_DURATION = 3000L;
    private static final float[] MATRIX_IDENTITY = new float[16];
    private static final ColorMatrixEvaluator COLOR_MATRIX_EVALUATOR;
    private final Handler mHandler;
    private final AtomicBoolean mIgnoreAllColorMatrixChanges = new AtomicBoolean();
    private final IVrStateCallbacks mVrStateCallbacks = new IVrStateCallbacks.Stub(){

        @Override
        public void onVrStateChanged(final boolean enabled) {
            NightDisplayService.this.mIgnoreAllColorMatrixChanges.set(enabled);
            NightDisplayService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (NightDisplayService.this.mColorMatrixAnimator != null) {
                        NightDisplayService.this.mColorMatrixAnimator.cancel();
                    }
                    DisplayTransformManager dtm = (DisplayTransformManager)NightDisplayService.this.getLocalService(DisplayTransformManager.class);
                    if (enabled) {
                        dtm.setColorMatrix(100, MATRIX_IDENTITY);
                    } else if (NightDisplayService.this.mController != null && NightDisplayService.this.mController.isActivated()) {
                        dtm.setColorMatrix(100, MATRIX_NIGHT);
                    }
                }
            });
        }
    };
    private int mCurrentUser = -10000;
    private ContentObserver mUserSetupObserver;
    private boolean mBootCompleted;
    private NightDisplayController mController;
    private ValueAnimator mColorMatrixAnimator;
    private Boolean mIsActivated;
    private AutoMode mAutoMode;

    public NightDisplayService(Context context) {
        super(context);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            IVrManager vrManager = (IVrManager)((Object)this.getBinderService("vrmanager"));
            if (vrManager != null) {
                try {
                    vrManager.registerListener(this.mVrStateCallbacks);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Failed to register VR mode state listener: " + e);
                }
            }
        } else if (phase == 1000) {
            this.mBootCompleted = true;
            if (this.mCurrentUser != -10000 && this.mUserSetupObserver == null) {
                this.setUp();
            }
        }
    }

    @Override
    public void onStartUser(int userHandle) {
        super.onStartUser(userHandle);
        if (this.mCurrentUser == -10000) {
            this.onUserChanged(userHandle);
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        super.onSwitchUser(userHandle);
        this.onUserChanged(userHandle);
    }

    @Override
    public void onStopUser(int userHandle) {
        super.onStopUser(userHandle);
        if (this.mCurrentUser == userHandle) {
            this.onUserChanged(-10000);
        }
    }

    private void onUserChanged(int userHandle) {
        final ContentResolver cr = this.getContext().getContentResolver();
        if (this.mCurrentUser != -10000) {
            if (this.mUserSetupObserver != null) {
                cr.unregisterContentObserver(this.mUserSetupObserver);
                this.mUserSetupObserver = null;
            } else if (this.mBootCompleted) {
                this.tearDown();
            }
        }
        this.mCurrentUser = userHandle;
        if (this.mCurrentUser != -10000) {
            if (!NightDisplayService.isUserSetupCompleted(cr, this.mCurrentUser)) {
                this.mUserSetupObserver = new ContentObserver(this.mHandler){

                    @Override
                    public void onChange(boolean selfChange, Uri uri) {
                        if (NightDisplayService.isUserSetupCompleted(cr, NightDisplayService.this.mCurrentUser)) {
                            cr.unregisterContentObserver(this);
                            NightDisplayService.this.mUserSetupObserver = null;
                            if (NightDisplayService.this.mBootCompleted) {
                                NightDisplayService.this.setUp();
                            }
                        }
                    }
                };
                cr.registerContentObserver(Settings.Secure.getUriFor("user_setup_complete"), false, this.mUserSetupObserver, this.mCurrentUser);
            } else if (this.mBootCompleted) {
                this.setUp();
            }
        }
    }

    private static boolean isUserSetupCompleted(ContentResolver cr, int userHandle) {
        return Settings.Secure.getIntForUser(cr, "user_setup_complete", 0, userHandle) == 1;
    }

    private void setUp() {
        Slog.d(TAG, "setUp: currentUser=" + this.mCurrentUser);
        this.mController = new NightDisplayController(this.getContext(), this.mCurrentUser);
        this.mController.setListener(this);
        this.onAutoModeChanged(this.mController.getAutoMode());
        if (this.mIsActivated == null) {
            this.onActivated(this.mController.isActivated());
        }
    }

    private void tearDown() {
        Slog.d(TAG, "tearDown: currentUser=" + this.mCurrentUser);
        if (this.mController != null) {
            this.mController.setListener(null);
            this.mController = null;
        }
        if (this.mAutoMode != null) {
            this.mAutoMode.onStop();
            this.mAutoMode = null;
        }
        if (this.mColorMatrixAnimator != null) {
            this.mColorMatrixAnimator.end();
            this.mColorMatrixAnimator = null;
        }
        this.mIsActivated = null;
    }

    @Override
    public void onActivated(boolean activated) {
        if (this.mIsActivated == null || this.mIsActivated != activated) {
            Slog.i(TAG, activated ? "Turning on night display" : "Turning off night display");
            if (this.mAutoMode != null) {
                this.mAutoMode.onActivated(activated);
            }
            this.mIsActivated = activated;
            if (this.mColorMatrixAnimator != null) {
                this.mColorMatrixAnimator.cancel();
            }
            if (this.mIgnoreAllColorMatrixChanges.get()) {
                return;
            }
            final DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
            float[] from = dtm.getColorMatrix(100);
            final float[] to = (float[])(this.mIsActivated != false ? MATRIX_NIGHT : null);
            this.mColorMatrixAnimator = ValueAnimator.ofObject(COLOR_MATRIX_EVALUATOR, from == null ? MATRIX_IDENTITY : from, to == null ? MATRIX_IDENTITY : to);
            this.mColorMatrixAnimator.setDuration(3000L);
            this.mColorMatrixAnimator.setInterpolator(AnimationUtils.loadInterpolator(this.getContext(), 17563661));
            this.mColorMatrixAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                @Override
                public void onAnimationUpdate(ValueAnimator animator2) {
                    float[] value = (float[])animator2.getAnimatedValue();
                    dtm.setColorMatrix(100, value);
                }
            });
            this.mColorMatrixAnimator.addListener(new AnimatorListenerAdapter(){
                private boolean mIsCancelled;

                @Override
                public void onAnimationCancel(Animator animator2) {
                    this.mIsCancelled = true;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    if (!this.mIsCancelled) {
                        dtm.setColorMatrix(100, to);
                    }
                    NightDisplayService.this.mColorMatrixAnimator = null;
                }
            });
            this.mColorMatrixAnimator.start();
        }
    }

    @Override
    public void onAutoModeChanged(int autoMode) {
        Slog.d(TAG, "onAutoModeChanged: autoMode=" + autoMode);
        if (this.mAutoMode != null) {
            this.mAutoMode.onStop();
            this.mAutoMode = null;
        }
        if (autoMode == 1) {
            this.mAutoMode = new CustomAutoMode();
        } else if (autoMode == 2) {
            this.mAutoMode = new TwilightAutoMode();
        }
        if (this.mAutoMode != null) {
            this.mAutoMode.onStart();
        }
    }

    @Override
    public void onCustomStartTimeChanged(NightDisplayController.LocalTime startTime) {
        Slog.d(TAG, "onCustomStartTimeChanged: startTime=" + startTime);
        if (this.mAutoMode != null) {
            this.mAutoMode.onCustomStartTimeChanged(startTime);
        }
    }

    @Override
    public void onCustomEndTimeChanged(NightDisplayController.LocalTime endTime) {
        Slog.d(TAG, "onCustomEndTimeChanged: endTime=" + endTime);
        if (this.mAutoMode != null) {
            this.mAutoMode.onCustomEndTimeChanged(endTime);
        }
    }

    static {
        Matrix.setIdentityM(MATRIX_IDENTITY, 0);
        COLOR_MATRIX_EVALUATOR = new ColorMatrixEvaluator();
    }

    private static class ColorMatrixEvaluator
    implements TypeEvaluator<float[]> {
        private final float[] mResultMatrix = new float[16];

        private ColorMatrixEvaluator() {
        }

        @Override
        public float[] evaluate(float fraction2, float[] startValue, float[] endValue) {
            for (int i = 0; i < this.mResultMatrix.length; ++i) {
                this.mResultMatrix[i] = MathUtils.lerp(startValue[i], endValue[i], fraction2);
            }
            return this.mResultMatrix;
        }
    }

    private class TwilightAutoMode
    extends AutoMode
    implements TwilightListener {
        private final TwilightManager mTwilightManager;
        private Calendar mLastActivatedTime;

        public TwilightAutoMode() {
            this.mTwilightManager = (TwilightManager)NightDisplayService.this.getLocalService(TwilightManager.class);
        }

        private void updateActivated(TwilightState state) {
            boolean setActivated;
            boolean isNight = state != null && state.isNight();
            boolean bl = setActivated = NightDisplayService.this.mIsActivated == null || NightDisplayService.this.mIsActivated != isNight;
            if (setActivated && state != null && this.mLastActivatedTime != null) {
                Calendar sunset;
                Calendar sunrise = state.sunrise();
                if (sunrise.before(sunset = state.sunset())) {
                    setActivated = this.mLastActivatedTime.before(sunrise) || this.mLastActivatedTime.after(sunset);
                } else {
                    boolean bl2 = setActivated = this.mLastActivatedTime.before(sunset) || this.mLastActivatedTime.after(sunrise);
                }
            }
            if (setActivated) {
                NightDisplayService.this.mController.setActivated(isNight);
            }
        }

        @Override
        public void onStart() {
            this.mTwilightManager.registerListener(this, NightDisplayService.this.mHandler);
            this.updateActivated(this.mTwilightManager.getLastTwilightState());
        }

        @Override
        public void onStop() {
            this.mTwilightManager.unregisterListener(this);
            this.mLastActivatedTime = null;
        }

        @Override
        public void onActivated(boolean activated) {
            if (NightDisplayService.this.mIsActivated != null) {
                this.mLastActivatedTime = Calendar.getInstance();
            }
        }

        @Override
        public void onTwilightStateChanged(TwilightState state) {
            Slog.d(NightDisplayService.TAG, "onTwilightStateChanged: isNight=" + (state == null ? null : Boolean.valueOf(state.isNight())));
            this.updateActivated(state);
        }
    }

    private class CustomAutoMode
    extends AutoMode
    implements AlarmManager.OnAlarmListener {
        private final AlarmManager mAlarmManager;
        private final BroadcastReceiver mTimeChangedReceiver;
        private NightDisplayController.LocalTime mStartTime;
        private NightDisplayController.LocalTime mEndTime;
        private Calendar mLastActivatedTime;

        public CustomAutoMode() {
            this.mAlarmManager = (AlarmManager)NightDisplayService.this.getContext().getSystemService("alarm");
            this.mTimeChangedReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    CustomAutoMode.this.updateActivated();
                }
            };
        }

        private void updateActivated() {
            boolean setActivated;
            Calendar now = Calendar.getInstance();
            Calendar startTime = this.mStartTime.getDateTimeBefore(now);
            Calendar endTime = this.mEndTime.getDateTimeAfter(startTime);
            boolean activated = now.before(endTime);
            boolean bl = setActivated = NightDisplayService.this.mIsActivated == null || this.mLastActivatedTime == null;
            if (!setActivated && NightDisplayService.this.mIsActivated != activated) {
                TimeZone currentTimeZone = now.getTimeZone();
                if (!currentTimeZone.equals(this.mLastActivatedTime.getTimeZone())) {
                    int year = this.mLastActivatedTime.get(1);
                    int dayOfYear = this.mLastActivatedTime.get(6);
                    int hourOfDay = this.mLastActivatedTime.get(11);
                    int minute = this.mLastActivatedTime.get(12);
                    this.mLastActivatedTime.setTimeZone(currentTimeZone);
                    this.mLastActivatedTime.set(1, year);
                    this.mLastActivatedTime.set(6, dayOfYear);
                    this.mLastActivatedTime.set(11, hourOfDay);
                    this.mLastActivatedTime.set(12, minute);
                }
                if (NightDisplayService.this.mIsActivated.booleanValue()) {
                    setActivated = now.before(this.mStartTime.getDateTimeBefore(this.mLastActivatedTime)) || now.after(this.mEndTime.getDateTimeAfter(this.mLastActivatedTime));
                } else {
                    boolean bl2 = setActivated = now.before(this.mEndTime.getDateTimeBefore(this.mLastActivatedTime)) || now.after(this.mStartTime.getDateTimeAfter(this.mLastActivatedTime));
                }
            }
            if (setActivated) {
                NightDisplayService.this.mController.setActivated(activated);
            }
            this.updateNextAlarm(NightDisplayService.this.mIsActivated, now);
        }

        private void updateNextAlarm(Boolean activated, Calendar now) {
            if (activated != null) {
                Calendar next = activated != false ? this.mEndTime.getDateTimeAfter(now) : this.mStartTime.getDateTimeAfter(now);
                this.mAlarmManager.setExact(1, next.getTimeInMillis(), NightDisplayService.TAG, this, null);
            }
        }

        @Override
        public void onStart() {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            NightDisplayService.this.getContext().registerReceiver(this.mTimeChangedReceiver, intentFilter);
            this.mStartTime = NightDisplayService.this.mController.getCustomStartTime();
            this.mEndTime = NightDisplayService.this.mController.getCustomEndTime();
            this.updateActivated();
        }

        @Override
        public void onStop() {
            NightDisplayService.this.getContext().unregisterReceiver(this.mTimeChangedReceiver);
            this.mAlarmManager.cancel(this);
            this.mLastActivatedTime = null;
        }

        @Override
        public void onActivated(boolean activated) {
            Calendar now = Calendar.getInstance();
            if (NightDisplayService.this.mIsActivated != null) {
                this.mLastActivatedTime = now;
            }
            this.updateNextAlarm(activated, now);
        }

        @Override
        public void onCustomStartTimeChanged(NightDisplayController.LocalTime startTime) {
            this.mStartTime = startTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onCustomEndTimeChanged(NightDisplayController.LocalTime endTime) {
            this.mEndTime = endTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onAlarm() {
            Slog.d(NightDisplayService.TAG, "onAlarm");
            this.updateActivated();
        }
    }

    private abstract class AutoMode
    implements NightDisplayController.Callback {
        private AutoMode() {
        }

        public abstract void onStart();

        public abstract void onStop();
    }
}

