/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprint;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import java.util.NoSuchElementException;

public abstract class ClientMonitor
implements IBinder.DeathRecipient {
    protected static final String TAG = "FingerprintService";
    protected static final int ERROR_ESRCH = 3;
    protected static final boolean DEBUG = true;
    private IBinder mToken;
    private IFingerprintServiceReceiver mReceiver;
    private int mTargetUserId;
    private int mGroupId;
    private boolean mIsRestricted;
    private String mOwner;
    private Context mContext;
    private long mHalDeviceId;

    public ClientMonitor(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int userId, int groupId, boolean restricted, String owner) {
        this.mContext = context;
        this.mHalDeviceId = halDeviceId;
        this.mToken = token;
        this.mReceiver = receiver;
        this.mTargetUserId = userId;
        this.mGroupId = groupId;
        this.mIsRestricted = restricted;
        this.mOwner = owner;
        try {
            token.linkToDeath(this, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "caught remote exception in linkToDeath: ", e);
        }
    }

    public abstract int start();

    public abstract int stop(boolean var1);

    public abstract void notifyUserActivity();

    public abstract IBiometricsFingerprint getFingerprintDaemon();

    public abstract boolean onEnrollResult(int var1, int var2, int var3);

    public abstract boolean onAuthenticated(int var1, int var2);

    public abstract boolean onRemoved(int var1, int var2, int var3);

    public abstract boolean onEnumerationResult(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAcquired(int acquiredInfo, int vendorCode) {
        if (this.mReceiver == null) {
            return true;
        }
        try {
            this.mReceiver.onAcquired(this.getHalDeviceId(), acquiredInfo, vendorCode);
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to invoke sendAcquired:", e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (acquiredInfo == 0) {
                this.notifyUserActivity();
            }
        }
    }

    public boolean onError(int error, int vendorCode) {
        if (this.mReceiver != null) {
            try {
                this.mReceiver.onError(this.getHalDeviceId(), error, vendorCode);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to invoke sendError:", e);
            }
        }
        return true;
    }

    public void destroy() {
        if (this.mToken != null) {
            try {
                this.mToken.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Slog.e(TAG, "destroy(): " + this + ":", new Exception("here"));
            }
            this.mToken = null;
        }
        this.mReceiver = null;
    }

    @Override
    public void binderDied() {
        this.mToken = null;
        this.mReceiver = null;
        this.onError(1, 0);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mToken != null) {
                Slog.w(TAG, "removing leaked reference: " + this.mToken);
                this.onError(1, 0);
            }
        }
        finally {
            super.finalize();
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final long getHalDeviceId() {
        return this.mHalDeviceId;
    }

    public final String getOwnerString() {
        return this.mOwner;
    }

    public final IFingerprintServiceReceiver getReceiver() {
        return this.mReceiver;
    }

    public final boolean getIsRestricted() {
        return this.mIsRestricted;
    }

    public final int getTargetUserId() {
        return this.mTargetUserId;
    }

    public final int getGroupId() {
        return this.mGroupId;
    }

    public final IBinder getToken() {
        return this.mToken;
    }
}

