/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.Fingerprint;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class FingerprintsUserState {
    private static final String TAG = "FingerprintState";
    private static final String FINGERPRINT_FILE = "settings_fingerprint.xml";
    private static final String TAG_FINGERPRINTS = "fingerprints";
    private static final String TAG_FINGERPRINT = "fingerprint";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_GROUP_ID = "groupId";
    private static final String ATTR_FINGER_ID = "fingerId";
    private static final String ATTR_DEVICE_ID = "deviceId";
    private final File mFile;
    @GuardedBy(value="this")
    private final ArrayList<Fingerprint> mFingerprints = new ArrayList();
    private final Context mCtx;
    private final Runnable mWriteStateRunnable = new Runnable(){

        @Override
        public void run() {
            FingerprintsUserState.this.doWriteState();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FingerprintsUserState(Context ctx, int userId) {
        this.mFile = FingerprintsUserState.getFileForUser(userId);
        this.mCtx = ctx;
        FingerprintsUserState fingerprintsUserState = this;
        synchronized (fingerprintsUserState) {
            this.readStateSyncLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFingerprint(int fingerId, int groupId) {
        FingerprintsUserState fingerprintsUserState = this;
        synchronized (fingerprintsUserState) {
            this.mFingerprints.add(new Fingerprint(this.getUniqueName(), groupId, fingerId, 0L));
            this.scheduleWriteStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFingerprint(int fingerId) {
        FingerprintsUserState fingerprintsUserState = this;
        synchronized (fingerprintsUserState) {
            for (int i = 0; i < this.mFingerprints.size(); ++i) {
                if (this.mFingerprints.get(i).getFingerId() != fingerId) continue;
                this.mFingerprints.remove(i);
                this.scheduleWriteStateLocked();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFingerprint(int fingerId, CharSequence name) {
        FingerprintsUserState fingerprintsUserState = this;
        synchronized (fingerprintsUserState) {
            for (int i = 0; i < this.mFingerprints.size(); ++i) {
                if (this.mFingerprints.get(i).getFingerId() != fingerId) continue;
                Fingerprint old = this.mFingerprints.get(i);
                this.mFingerprints.set(i, new Fingerprint(name, old.getGroupId(), old.getFingerId(), old.getDeviceId()));
                this.scheduleWriteStateLocked();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Fingerprint> getFingerprints() {
        FingerprintsUserState fingerprintsUserState = this;
        synchronized (fingerprintsUserState) {
            return this.getCopy(this.mFingerprints);
        }
    }

    private String getUniqueName() {
        int guess = 1;
        String name;
        while (!this.isUnique(name = this.mCtx.getString(17039854, guess))) {
            ++guess;
        }
        return name;
    }

    private boolean isUnique(String name) {
        for (Fingerprint fp : this.mFingerprints) {
            if (!fp.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private static File getFileForUser(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), FINGERPRINT_FILE);
    }

    private void scheduleWriteStateLocked() {
        AsyncTask.execute(this.mWriteStateRunnable);
    }

    private ArrayList<Fingerprint> getCopy(ArrayList<Fingerprint> array2) {
        ArrayList<Fingerprint> result = new ArrayList<Fingerprint>(array2.size());
        for (int i = 0; i < array2.size(); ++i) {
            Fingerprint fp = array2.get(i);
            result.add(new Fingerprint(fp.getName(), fp.getGroupId(), fp.getFingerId(), fp.getDeviceId()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteState() {
        ArrayList<Fingerprint> fingerprints;
        AtomicFile destination = new AtomicFile(this.mFile);
        FingerprintsUserState fingerprintsUserState = this;
        synchronized (fingerprintsUserState) {
            fingerprints = this.getCopy(this.mFingerprints);
        }
        FileOutputStream out = null;
        try {
            out = destination.startWrite();
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(out, "utf-8");
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_FINGERPRINTS);
            int count = fingerprints.size();
            for (int i = 0; i < count; ++i) {
                Fingerprint fp = fingerprints.get(i);
                serializer.startTag(null, TAG_FINGERPRINT);
                serializer.attribute(null, ATTR_FINGER_ID, Integer.toString(fp.getFingerId()));
                serializer.attribute(null, ATTR_NAME, fp.getName().toString());
                serializer.attribute(null, ATTR_GROUP_ID, Integer.toString(fp.getGroupId()));
                serializer.attribute(null, ATTR_DEVICE_ID, Long.toString(fp.getDeviceId()));
                serializer.endTag(null, TAG_FINGERPRINT);
            }
            serializer.endTag(null, TAG_FINGERPRINTS);
            serializer.endDocument();
            destination.finishWrite(out);
        }
        catch (Throwable t) {
            Slog.wtf(TAG, "Failed to write settings, restoring backup", t);
            destination.failWrite(out);
            throw new IllegalStateException("Failed to write fingerprints", t);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    private void readStateSyncLocked() {
        FileInputStream in;
        if (!this.mFile.exists()) {
            return;
        }
        try {
            in = new FileInputStream(this.mFile);
        }
        catch (FileNotFoundException fnfe) {
            Slog.i(TAG, "No fingerprint state");
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, null);
            this.parseStateLocked(parser);
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("Failed parsing settings file: " + this.mFile, e);
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    private void parseStateLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(TAG_FINGERPRINTS)) continue;
            this.parseFingerprintsLocked(parser);
        }
    }

    private void parseFingerprintsLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(TAG_FINGERPRINT)) continue;
            String name = parser.getAttributeValue(null, ATTR_NAME);
            String groupId = parser.getAttributeValue(null, ATTR_GROUP_ID);
            String fingerId = parser.getAttributeValue(null, ATTR_FINGER_ID);
            String deviceId = parser.getAttributeValue(null, ATTR_DEVICE_ID);
            this.mFingerprints.add(new Fingerprint(name, Integer.parseInt(groupId), Integer.parseInt(fingerId), Integer.parseInt(deviceId)));
        }
    }
}

