/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.RoutingControlAction;
import com.android.server.hdmi.SystemAudioActionFromAvr;
import com.android.server.hdmi.SystemAudioActionFromTv;
import com.android.server.hdmi.SystemAudioStatusAction;
import java.util.List;

abstract class SystemAudioAction
extends HdmiCecFeatureAction {
    private static final String TAG = "SystemAudioAction";
    private static final int STATE_CHECK_ROUTING_IN_PRGRESS = 1;
    private static final int STATE_WAIT_FOR_SET_SYSTEM_AUDIO_MODE = 2;
    private static final int MAX_SEND_RETRY_COUNT = 2;
    private static final int ON_TIMEOUT_MS = 5000;
    private static final int OFF_TIMEOUT_MS = 2000;
    protected final int mAvrLogicalAddress;
    protected boolean mTargetAudioStatus;
    private final IHdmiControlCallback mCallback;
    private int mSendRetryCount = 0;

    SystemAudioAction(HdmiCecLocalDevice source, int avrAddress, boolean targetStatus, IHdmiControlCallback callback) {
        super(source);
        HdmiUtils.verifyAddressType(avrAddress, 5);
        this.mAvrLogicalAddress = avrAddress;
        this.mTargetAudioStatus = targetStatus;
        this.mCallback = callback;
    }

    protected void sendSystemAudioModeRequest() {
        List<RoutingControlAction> routingActions = this.getActions(RoutingControlAction.class);
        if (!routingActions.isEmpty()) {
            this.mState = 1;
            RoutingControlAction routingAction = routingActions.get(0);
            routingAction.addOnFinishedCallback(this, new Runnable(){

                @Override
                public void run() {
                    SystemAudioAction.this.sendSystemAudioModeRequestInternal();
                }
            });
            return;
        }
        this.sendSystemAudioModeRequestInternal();
    }

    private void sendSystemAudioModeRequestInternal() {
        HdmiCecMessage command = HdmiCecMessageBuilder.buildSystemAudioModeRequest(this.getSourceAddress(), this.mAvrLogicalAddress, this.getSystemAudioModeRequestParam(), this.mTargetAudioStatus);
        this.sendCommand(command, new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    HdmiLogger.debug("Failed to send <System Audio Mode Request>:" + error, new Object[0]);
                    SystemAudioAction.this.setSystemAudioMode(false);
                    SystemAudioAction.this.finishWithCallback(7);
                }
            }
        });
        this.mState = 2;
        this.addTimer(this.mState, this.mTargetAudioStatus ? 5000 : 2000);
    }

    private int getSystemAudioModeRequestParam() {
        if (this.tv().getActiveSource().isValid()) {
            return this.tv().getActiveSource().physicalAddress;
        }
        int param = this.tv().getActivePath();
        return param != 65535 ? param : 0;
    }

    private void handleSendSystemAudioModeRequestTimeout() {
        if (!this.mTargetAudioStatus || this.mSendRetryCount++ >= 2) {
            HdmiLogger.debug("[T]:wait for <Set System Audio Mode>.", new Object[0]);
            this.setSystemAudioMode(false);
            this.finishWithCallback(1);
            return;
        }
        this.sendSystemAudioModeRequest();
    }

    protected void setSystemAudioMode(boolean mode) {
        this.tv().setSystemAudioMode(mode, true);
    }

    @Override
    final boolean processCommand(HdmiCecMessage cmd) {
        if (cmd.getSource() != this.mAvrLogicalAddress) {
            return false;
        }
        switch (this.mState) {
            case 2: {
                if (cmd.getOpcode() == 0 && (cmd.getParams()[0] & 0xFF) == 112) {
                    HdmiLogger.debug("Failed to start system audio mode request.", new Object[0]);
                    this.setSystemAudioMode(false);
                    this.finishWithCallback(5);
                    return true;
                }
                if (cmd.getOpcode() != 114 || !HdmiUtils.checkCommandSource(cmd, this.mAvrLogicalAddress, TAG)) {
                    return false;
                }
                boolean receivedStatus = HdmiUtils.parseCommandParamSystemAudioStatus(cmd);
                if (receivedStatus == this.mTargetAudioStatus) {
                    this.setSystemAudioMode(receivedStatus);
                    this.startAudioStatusAction();
                    return true;
                }
                HdmiLogger.debug("Unexpected system audio mode request:" + receivedStatus, new Object[0]);
                this.finishWithCallback(5);
                return false;
            }
        }
        return false;
    }

    protected void startAudioStatusAction() {
        this.addAndStartAction(new SystemAudioStatusAction(this.tv(), this.mAvrLogicalAddress, this.mCallback));
        this.finish();
    }

    protected void removeSystemAudioActionInProgress() {
        this.removeActionExcept(SystemAudioActionFromTv.class, this);
        this.removeActionExcept(SystemAudioActionFromAvr.class, this);
    }

    @Override
    final void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        switch (this.mState) {
            case 2: {
                this.handleSendSystemAudioModeRequestTimeout();
                return;
            }
        }
    }

    protected void finishWithCallback(int returnCode) {
        if (this.mCallback != null) {
            try {
                this.mCallback.onComplete(returnCode);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to invoke callback.", e);
            }
        }
        this.finish();
    }
}

