/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.INetworkPolicyListener;
import android.net.NetworkInfo;
import android.net.NetworkPolicyManager;
import android.os.UserHandle;
import com.android.internal.annotations.GuardedBy;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ConnectivityController
extends StateController
implements ConnectivityManager.OnNetworkActiveListener {
    private static final String TAG = "JobScheduler.Conn";
    private final ConnectivityManager mConnManager;
    private final NetworkPolicyManager mNetPolicyManager;
    @GuardedBy(value="mLock")
    private final ArrayList<JobStatus> mTrackedJobs = new ArrayList();
    private static ConnectivityController mSingleton;
    private static Object sCreationLock;
    private BroadcastReceiver mConnectivityReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            ConnectivityController.this.updateTrackedJobs(-1);
        }
    };
    private INetworkPolicyListener mNetPolicyListener = new INetworkPolicyListener.Stub(){

        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            ConnectivityController.this.updateTrackedJobs(uid);
        }

        @Override
        public void onMeteredIfacesChanged(String[] meteredIfaces) {
            ConnectivityController.this.updateTrackedJobs(-1);
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            ConnectivityController.this.updateTrackedJobs(-1);
        }

        @Override
        public void onUidPoliciesChanged(int uid, int uidPolicies) {
            ConnectivityController.this.updateTrackedJobs(uid);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectivityController get(JobSchedulerService jms) {
        Object object = sCreationLock;
        synchronized (object) {
            if (mSingleton == null) {
                mSingleton = new ConnectivityController(jms, jms.getContext(), jms.getLock());
            }
            return mSingleton;
        }
    }

    private ConnectivityController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.mConnManager = this.mContext.getSystemService(ConnectivityManager.class);
        this.mNetPolicyManager = this.mContext.getSystemService(NetworkPolicyManager.class);
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiverAsUser(this.mConnectivityReceiver, UserHandle.SYSTEM, intentFilter, null, null);
        this.mNetPolicyManager.registerListener(this.mNetPolicyListener);
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        if (jobStatus.hasConnectivityConstraint() || jobStatus.hasUnmeteredConstraint() || jobStatus.hasNotRoamingConstraint()) {
            this.updateConstraintsSatisfied(jobStatus);
            this.mTrackedJobs.add(jobStatus);
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
        if (jobStatus.hasConnectivityConstraint() || jobStatus.hasUnmeteredConstraint() || jobStatus.hasNotRoamingConstraint()) {
            this.mTrackedJobs.remove(jobStatus);
        }
    }

    private boolean updateConstraintsSatisfied(JobStatus jobStatus) {
        boolean ignoreBlocked = (jobStatus.getFlags() & 1) != 0;
        NetworkInfo info = this.mConnManager.getActiveNetworkInfoForUid(jobStatus.getSourceUid(), ignoreBlocked);
        boolean connected = info != null && info.isConnected();
        boolean unmetered = connected && !info.isMetered();
        boolean notRoaming = connected && !info.isRoaming();
        boolean changed = false;
        changed |= jobStatus.setConnectivityConstraintSatisfied(connected);
        changed |= jobStatus.setUnmeteredConstraintSatisfied(unmetered);
        return changed |= jobStatus.setNotRoamingConstraintSatisfied(notRoaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTrackedJobs(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
                JobStatus js = this.mTrackedJobs.get(i);
                if (uid != -1 && uid != js.getSourceUid()) continue;
                changed |= this.updateConstraintsSatisfied(js);
            }
            if (changed) {
                this.mStateChangedListener.onControllerStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onNetworkActive() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
                JobStatus js = this.mTrackedJobs.get(i);
                if (!js.isReady()) continue;
                this.mStateChangedListener.onRunJobNow(js);
            }
        }
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.println("Connectivity.");
        pw.print("Tracking ");
        pw.print(this.mTrackedJobs.size());
        pw.println(":");
        for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
            JobStatus js = this.mTrackedJobs.get(i);
            if (!js.shouldDump(filterUid)) continue;
            pw.print("  #");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.print(": C=");
            pw.print(js.hasConnectivityConstraint());
            pw.print(": UM=");
            pw.print(js.hasUnmeteredConstraint());
            pw.print(": NR=");
            pw.println(js.hasNotRoamingConstraint());
        }
    }

    static {
        sCreationLock = new Object();
    }
}

