/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;
import android.os.UserHandle;
import com.android.internal.util.ArrayUtils;
import com.android.server.DeviceIdleController;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.JobStore;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;

public class DeviceIdleJobsController
extends StateController {
    private static final String LOG_TAG = "DeviceIdleJobsController";
    private static final boolean LOG_DEBUG = false;
    private static Object sCreationLock = new Object();
    private static DeviceIdleJobsController sController;
    private final JobSchedulerService mJobSchedulerService;
    private final PowerManager mPowerManager;
    private final DeviceIdleController.LocalService mLocalDeviceIdleController;
    private boolean mDeviceIdleMode;
    private int[] mDeviceIdleWhitelistAppIds;
    final JobStore.JobStatusFunctor mUpdateFunctor = new JobStore.JobStatusFunctor(){

        @Override
        public void process(JobStatus jobStatus) {
            DeviceIdleJobsController.this.updateTaskStateLocked(jobStatus);
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED".equals(action) || "android.os.action.DEVICE_IDLE_MODE_CHANGED".equals(action)) {
                DeviceIdleJobsController.this.updateIdleMode(DeviceIdleJobsController.this.mPowerManager != null ? DeviceIdleJobsController.this.mPowerManager.isDeviceIdleMode() || DeviceIdleJobsController.this.mPowerManager.isLightDeviceIdleMode() : false);
            } else if ("android.os.action.POWER_SAVE_WHITELIST_CHANGED".equals(action)) {
                DeviceIdleJobsController.this.updateWhitelist();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceIdleJobsController get(JobSchedulerService service) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new DeviceIdleJobsController(service, service.getContext(), service.getLock());
            }
            return sController;
        }
    }

    private DeviceIdleJobsController(JobSchedulerService jobSchedulerService, Context context, Object lock) {
        super(jobSchedulerService, context, lock);
        this.mJobSchedulerService = jobSchedulerService;
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mLocalDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        filter.addAction("android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED");
        filter.addAction("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateIdleMode(boolean enabled) {
        boolean changed = false;
        if (this.mDeviceIdleWhitelistAppIds == null) {
            this.updateWhitelist();
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDeviceIdleMode != enabled) {
                changed = true;
            }
            this.mDeviceIdleMode = enabled;
            this.mJobSchedulerService.getJobStore().forEachJob(this.mUpdateFunctor);
        }
        if (changed) {
            this.mStateChangedListener.onDeviceIdleStateChanged(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWhitelist() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLocalDeviceIdleController != null) {
                this.mDeviceIdleWhitelistAppIds = this.mLocalDeviceIdleController.getPowerSaveWhitelistUserAppIds();
            }
        }
    }

    boolean isWhitelistedLocked(JobStatus job) {
        return this.mDeviceIdleWhitelistAppIds != null && ArrayUtils.contains(this.mDeviceIdleWhitelistAppIds, UserHandle.getAppId(job.getSourceUid()));
    }

    private void updateTaskStateLocked(JobStatus task) {
        boolean whitelisted = this.isWhitelistedLocked(task);
        boolean enableTask = !this.mDeviceIdleMode || whitelisted;
        task.setDeviceNotDozingConstraintSatisfied(enableTask, whitelisted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateTaskStateLocked(jobStatus);
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
    }

    @Override
    public void dumpControllerStateLocked(final PrintWriter pw, final int filterUid) {
        pw.println(LOG_TAG);
        this.mJobSchedulerService.getJobStore().forEachJob(new JobStore.JobStatusFunctor(){

            @Override
            public void process(JobStatus jobStatus) {
                if (!jobStatus.shouldDump(filterUid)) {
                    return;
                }
                pw.print("  #");
                jobStatus.printUniqueId(pw);
                pw.print(" from ");
                UserHandle.formatUid(pw, jobStatus.getSourceUid());
                pw.print(": ");
                pw.print(jobStatus.getSourcePackageName());
                pw.print((jobStatus.satisfiedConstraints & 0x100) != 0 ? " RUNNABLE" : " WAITING");
                if (jobStatus.dozeWhitelisted) {
                    pw.print(" WHITELISTED");
                }
                pw.println();
            }
        });
    }
}

