/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.HashMap;
import java.util.Map;

abstract class RemoteListenerHelper<TListener extends IInterface> {
    protected static final int RESULT_SUCCESS = 0;
    protected static final int RESULT_NOT_AVAILABLE = 1;
    protected static final int RESULT_NOT_SUPPORTED = 2;
    protected static final int RESULT_GPS_LOCATION_DISABLED = 3;
    protected static final int RESULT_INTERNAL_ERROR = 4;
    protected static final int RESULT_UNKNOWN = 5;
    private final Handler mHandler;
    private final String mTag;
    private final Map<IBinder, LinkedListener> mListenerMap = new HashMap<IBinder, LinkedListener>();
    private boolean mIsRegistered;
    private boolean mHasIsSupported;
    private boolean mIsSupported;
    private int mLastReportedResult = 5;

    protected RemoteListenerHelper(Handler handler, String name) {
        Preconditions.checkNotNull(name);
        this.mHandler = handler;
        this.mTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(TListener listener) {
        Preconditions.checkNotNull(listener, "Attempted to register a 'null' listener.");
        IBinder binder = listener.asBinder();
        LinkedListener deathListener = new LinkedListener(this, listener);
        Map<IBinder, LinkedListener> map = this.mListenerMap;
        synchronized (map) {
            int result;
            if (this.mListenerMap.containsKey(binder)) {
                return true;
            }
            try {
                binder.linkToDeath(deathListener, 0);
            }
            catch (RemoteException e) {
                Log.v(this.mTag, "Remote listener already died.", e);
                return false;
            }
            this.mListenerMap.put(binder, deathListener);
            if (!this.isAvailableInPlatform()) {
                result = 1;
            } else if (this.mHasIsSupported && !this.mIsSupported) {
                result = 2;
            } else if (!this.isGpsEnabled()) {
                result = 3;
            } else if (!this.tryRegister()) {
                result = 4;
            } else if (this.mHasIsSupported && this.mIsSupported) {
                result = 0;
            } else {
                return true;
            }
            this.post(listener, this.getHandlerOperation(result));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TListener listener) {
        LinkedListener linkedListener;
        Preconditions.checkNotNull(listener, "Attempted to remove a 'null' listener.");
        IBinder binder = listener.asBinder();
        Map<IBinder, LinkedListener> map = this.mListenerMap;
        synchronized (map) {
            linkedListener = this.mListenerMap.remove(binder);
            if (this.mListenerMap.isEmpty()) {
                this.tryUnregister();
            }
        }
        if (linkedListener != null) {
            binder.unlinkToDeath(linkedListener, 0);
        }
    }

    protected abstract boolean isAvailableInPlatform();

    protected abstract boolean isGpsEnabled();

    protected abstract boolean registerWithService();

    protected abstract void unregisterFromService();

    protected abstract ListenerOperation<TListener> getHandlerOperation(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foreach(ListenerOperation<TListener> operation) {
        Map<IBinder, LinkedListener> map = this.mListenerMap;
        synchronized (map) {
            this.foreachUnsafe(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSupported(boolean value) {
        Map<IBinder, LinkedListener> map = this.mListenerMap;
        synchronized (map) {
            this.mHasIsSupported = true;
            this.mIsSupported = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryUpdateRegistrationWithService() {
        Map<IBinder, LinkedListener> map = this.mListenerMap;
        synchronized (map) {
            if (!this.isGpsEnabled()) {
                this.tryUnregister();
                return true;
            }
            if (this.mListenerMap.isEmpty()) {
                return true;
            }
            if (this.tryRegister()) {
                return true;
            }
            ListenerOperation<TListener> operation = this.getHandlerOperation(4);
            this.foreachUnsafe(operation);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResult() {
        Map<IBinder, LinkedListener> map = this.mListenerMap;
        synchronized (map) {
            int newResult = this.calculateCurrentResultUnsafe();
            if (this.mLastReportedResult == newResult) {
                return;
            }
            this.foreachUnsafe(this.getHandlerOperation(newResult));
            this.mLastReportedResult = newResult;
        }
    }

    private void foreachUnsafe(ListenerOperation<TListener> operation) {
        for (LinkedListener linkedListener : this.mListenerMap.values()) {
            this.post(linkedListener.getUnderlyingListener(), operation);
        }
    }

    private void post(TListener listener, ListenerOperation<TListener> operation) {
        if (operation != null) {
            this.mHandler.post(new HandlerRunnable(this, listener, operation));
        }
    }

    private boolean tryRegister() {
        if (!this.mIsRegistered) {
            this.mIsRegistered = this.registerWithService();
        }
        return this.mIsRegistered;
    }

    private void tryUnregister() {
        if (!this.mIsRegistered) {
            return;
        }
        this.unregisterFromService();
        this.mIsRegistered = false;
    }

    private int calculateCurrentResultUnsafe() {
        if (!this.isAvailableInPlatform()) {
            return 1;
        }
        if (!this.mHasIsSupported || this.mListenerMap.isEmpty()) {
            return 5;
        }
        if (!this.mIsSupported) {
            return 2;
        }
        if (!this.isGpsEnabled()) {
            return 3;
        }
        return 0;
    }

    private static class HandlerRunnable
    implements Runnable {
        private final TListener mListener;
        private final ListenerOperation<TListener> mOperation;
        final /* synthetic */ RemoteListenerHelper this$0;

        public HandlerRunnable(TListener listener, ListenerOperation<TListener> operation) {
            this.this$0 = var1_1;
            this.mListener = listener;
            this.mOperation = operation;
        }

        @Override
        public void run() {
            try {
                this.mOperation.execute(this.mListener);
            }
            catch (RemoteException e) {
                Log.v(this.this$0.mTag, "Error in monitored listener.", e);
            }
        }
    }

    private static class LinkedListener
    implements IBinder.DeathRecipient {
        private final TListener mListener;
        final /* synthetic */ RemoteListenerHelper this$0;

        public LinkedListener(TListener listener) {
            this.this$0 = var1_1;
            this.mListener = listener;
        }

        public TListener getUnderlyingListener() {
            return this.mListener;
        }

        @Override
        public void binderDied() {
            Log.d(this.this$0.mTag, "Remote Listener died: " + this.mListener);
            this.this$0.removeListener(this.mListener);
        }
    }

    protected static interface ListenerOperation<TListener extends IInterface> {
        public void execute(TListener var1) throws RemoteException;
    }
}

