/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.NetworkIdentity;
import android.util.proto.ProtoOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;

public class NetworkIdentitySet
extends HashSet<NetworkIdentity>
implements Comparable<NetworkIdentitySet> {
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADD_ROAMING = 2;
    private static final int VERSION_ADD_NETWORK_ID = 3;
    private static final int VERSION_ADD_METERED = 4;

    public NetworkIdentitySet() {
    }

    public NetworkIdentitySet(DataInputStream in) throws IOException {
        int version = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            if (version <= 1) {
                int n = in.readInt();
            }
            int type = in.readInt();
            int subType = in.readInt();
            String subscriberId = NetworkIdentitySet.readOptionalString(in);
            String networkId = version >= 3 ? NetworkIdentitySet.readOptionalString(in) : null;
            boolean roaming = version >= 2 ? in.readBoolean() : false;
            boolean metered = version >= 4 ? in.readBoolean() : type == 0;
            this.add(new NetworkIdentity(type, subType, subscriberId, networkId, roaming, metered));
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeInt(this.size());
        for (NetworkIdentity ident : this) {
            out.writeInt(ident.getType());
            out.writeInt(ident.getSubType());
            NetworkIdentitySet.writeOptionalString(out, ident.getSubscriberId());
            NetworkIdentitySet.writeOptionalString(out, ident.getNetworkId());
            out.writeBoolean(ident.getRoaming());
            out.writeBoolean(ident.getMetered());
        }
    }

    public boolean isAnyMemberMetered() {
        if (this.isEmpty()) {
            return false;
        }
        for (NetworkIdentity ident : this) {
            if (!ident.getMetered()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyMemberRoaming() {
        if (this.isEmpty()) {
            return false;
        }
        for (NetworkIdentity ident : this) {
            if (!ident.getRoaming()) continue;
            return true;
        }
        return false;
    }

    private static void writeOptionalString(DataOutputStream out, String value) throws IOException {
        if (value != null) {
            out.writeByte(1);
            out.writeUTF(value);
        } else {
            out.writeByte(0);
        }
    }

    private static String readOptionalString(DataInputStream in) throws IOException {
        if (in.readByte() != 0) {
            return in.readUTF();
        }
        return null;
    }

    @Override
    public int compareTo(NetworkIdentitySet another) {
        if (this.isEmpty()) {
            return -1;
        }
        if (another.isEmpty()) {
            return 1;
        }
        NetworkIdentity ident = (NetworkIdentity)this.iterator().next();
        NetworkIdentity anotherIdent = (NetworkIdentity)another.iterator().next();
        return ident.compareTo(anotherIdent);
    }

    public void writeToProto(ProtoOutputStream proto, long tag) {
        long start = proto.start(tag);
        for (NetworkIdentity ident : this) {
            ident.writeToProto(proto, 0x21100000001L);
        }
        proto.end(start);
    }
}

