/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.notification.GlobalSortKeyComparator;
import com.android.server.notification.NotificationComparator;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.RankingReconsideration;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RankingHelper
implements RankingConfig {
    private static final String TAG = "RankingHelper";
    private static final int XML_VERSION = 1;
    private static final String TAG_RANKING = "ranking";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_CHANNEL = "channel";
    private static final String TAG_GROUP = "channelGroup";
    private static final String ATT_VERSION = "version";
    private static final String ATT_NAME = "name";
    private static final String ATT_UID = "uid";
    private static final String ATT_ID = "id";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private static final String ATT_IMPORTANCE = "importance";
    private static final String ATT_SHOW_BADGE = "show_badge";
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_VISIBILITY = -1000;
    private static final int DEFAULT_IMPORTANCE = -1000;
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private final NotificationSignalExtractor[] mSignalExtractors;
    private final NotificationComparator mPreliminaryComparator;
    private final GlobalSortKeyComparator mFinalComparator = new GlobalSortKeyComparator();
    private final ArrayMap<String, Record> mRecords = new ArrayMap();
    private final ArrayMap<String, NotificationRecord> mProxyByGroupTmp = new ArrayMap();
    private final ArrayMap<String, Record> mRestoredWithoutUids = new ArrayMap();
    private final Context mContext;
    private final RankingHandler mRankingHandler;
    private final PackageManager mPm;

    public RankingHelper(Context context, PackageManager pm, RankingHandler rankingHandler, NotificationUsageStats usageStats, String[] extractorNames) {
        this.mContext = context;
        this.mRankingHandler = rankingHandler;
        this.mPm = pm;
        this.mPreliminaryComparator = new NotificationComparator(this.mContext);
        int N = extractorNames.length;
        this.mSignalExtractors = new NotificationSignalExtractor[N];
        for (int i = 0; i < N; ++i) {
            try {
                Class<?> extractorClass = this.mContext.getClassLoader().loadClass(extractorNames[i]);
                NotificationSignalExtractor extractor = (NotificationSignalExtractor)extractorClass.newInstance();
                extractor.initialize(this.mContext, usageStats);
                extractor.setConfig(this);
                this.mSignalExtractors[i] = extractor;
                continue;
            }
            catch (ClassNotFoundException e) {
                Slog.w(TAG, "Couldn't find extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (InstantiationException e) {
                Slog.w(TAG, "Couldn't instantiate extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Slog.w(TAG, "Problem accessing extractor " + extractorNames[i] + ".", e);
            }
        }
    }

    public <T extends NotificationSignalExtractor> T findExtractor(Class<T> extractorClass) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            if (!extractorClass.equals(extractor.getClass())) continue;
            return (T)extractor;
        }
        return null;
    }

    public void extractSignals(NotificationRecord r) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            try {
                RankingReconsideration recon = extractor.process(r);
                if (recon == null) continue;
                this.mRankingHandler.requestReconsideration(recon);
            }
            catch (Throwable t) {
                Slog.w(TAG, "NotificationSignalExtractor failed.", t);
            }
        }
    }

    public void readXml(XmlPullParser parser, boolean forRestore) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return;
        }
        String tag = parser.getName();
        if (!TAG_RANKING.equals(tag)) {
            return;
        }
        this.mRecords.clear();
        this.mRestoredWithoutUids.clear();
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && TAG_RANKING.equals(tag)) {
                return;
            }
            if (type != 2 || !TAG_PACKAGE.equals(tag)) continue;
            int uid = RankingHelper.safeInt(parser, ATT_UID, Record.UNKNOWN_UID);
            String name = parser.getAttributeValue(null, ATT_NAME);
            if (TextUtils.isEmpty(name)) continue;
            if (forRestore) {
                try {
                    uid = this.mPm.getPackageUidAsUser(name, 0);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            Record r = this.getOrCreateRecord(name, uid, RankingHelper.safeInt(parser, ATT_IMPORTANCE, -1000), RankingHelper.safeInt(parser, ATT_PRIORITY, 0), RankingHelper.safeInt(parser, ATT_VISIBILITY, -1000), RankingHelper.safeBool(parser, ATT_SHOW_BADGE, true));
            int innerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                String id2;
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (TAG_GROUP.equals(tagName)) {
                    id2 = parser.getAttributeValue(null, ATT_ID);
                    String groupName = parser.getAttributeValue(null, ATT_NAME);
                    if (!TextUtils.isEmpty(id2)) {
                        NotificationChannelGroup group = new NotificationChannelGroup(id2, groupName);
                        r.groups.put(id2, group);
                    }
                }
                if (!TAG_CHANNEL.equals(tagName)) continue;
                id2 = parser.getAttributeValue(null, ATT_ID);
                String channelName = parser.getAttributeValue(null, ATT_NAME);
                int channelImportance = RankingHelper.safeInt(parser, ATT_IMPORTANCE, -1000);
                if (TextUtils.isEmpty(id2)) continue;
                NotificationChannel channel = new NotificationChannel(id2, channelName, channelImportance);
                channel.populateFromXml(parser);
                r.channels.put(id2, channel);
            }
            this.clampDefaultChannel(r);
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    private static String recordKey(String pkg, int uid) {
        return pkg + "|" + uid;
    }

    private Record getRecord(String pkg, int uid) {
        String key = RankingHelper.recordKey(pkg, uid);
        return this.mRecords.get(key);
    }

    private Record getOrCreateRecord(String pkg, int uid) {
        return this.getOrCreateRecord(pkg, uid, -1000, 0, -1000, true);
    }

    private Record getOrCreateRecord(String pkg, int uid, int importance, int priority, int visibility, boolean showBadge) {
        Record r;
        String key = RankingHelper.recordKey(pkg, uid);
        Record record = r = uid == Record.UNKNOWN_UID ? this.mRestoredWithoutUids.get(pkg) : this.mRecords.get(key);
        if (r == null) {
            r = new Record();
            r.pkg = pkg;
            r.uid = uid;
            r.importance = importance;
            r.priority = priority;
            r.visibility = visibility;
            r.showBadge = showBadge;
            this.createDefaultChannelIfMissing(r);
            if (r.uid == Record.UNKNOWN_UID) {
                this.mRestoredWithoutUids.put(pkg, r);
            } else {
                this.mRecords.put(key, r);
            }
            this.clampDefaultChannel(r);
        }
        return r;
    }

    private void clampDefaultChannel(Record r) {
        try {
            if (r.uid != Record.UNKNOWN_UID) {
                NotificationChannel defaultChannel;
                int userId = UserHandle.getUserId(r.uid);
                ApplicationInfo applicationInfo = this.mPm.getApplicationInfoAsUser(r.pkg, 0, userId);
                if (applicationInfo.targetSdkVersion > 25 && ((defaultChannel = r.channels.get("miscellaneous")).getUserLockedFields() & 4) == 0) {
                    defaultChannel.setImportance(2);
                    this.updateConfig();
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private void createDefaultChannelIfMissing(Record r) {
        if (!r.channels.containsKey("miscellaneous")) {
            NotificationChannel channel = new NotificationChannel("miscellaneous", this.mContext.getString(17039725), r.importance);
            channel.setBypassDnd(r.priority == 2);
            channel.setLockscreenVisibility(r.visibility);
            if (r.importance != -1000) {
                channel.lockFields(4);
            }
            if (r.priority != 0) {
                channel.lockFields(1);
            }
            if (r.visibility != -1000) {
                channel.lockFields(2);
            }
            r.channels.put(channel.getId(), channel);
        }
    }

    public void writeXml(XmlSerializer out, boolean forBackup) throws IOException {
        out.startTag(null, TAG_RANKING);
        out.attribute(null, ATT_VERSION, Integer.toString(1));
        int N = this.mRecords.size();
        for (int i = 0; i < N; ++i) {
            boolean hasNonDefaultSettings;
            Record r = this.mRecords.valueAt(i);
            if (forBackup && UserHandle.getUserId(r.uid) != 0) continue;
            boolean bl = hasNonDefaultSettings = r.importance != -1000 || r.priority != 0 || r.visibility != -1000 || !r.showBadge || r.channels.size() > 0 || r.groups.size() > 0;
            if (!hasNonDefaultSettings) continue;
            out.startTag(null, TAG_PACKAGE);
            out.attribute(null, ATT_NAME, r.pkg);
            if (r.importance != -1000) {
                out.attribute(null, ATT_IMPORTANCE, Integer.toString(r.importance));
            }
            if (r.priority != 0) {
                out.attribute(null, ATT_PRIORITY, Integer.toString(r.priority));
            }
            if (r.visibility != -1000) {
                out.attribute(null, ATT_VISIBILITY, Integer.toString(r.visibility));
            }
            out.attribute(null, ATT_SHOW_BADGE, Boolean.toString(r.showBadge));
            if (!forBackup) {
                out.attribute(null, ATT_UID, Integer.toString(r.uid));
            }
            for (NotificationChannelGroup group : r.groups.values()) {
                group.writeXml(out);
            }
            for (NotificationChannel channel : r.channels.values()) {
                channel.writeXml(out);
            }
            out.endTag(null, TAG_PACKAGE);
        }
        out.endTag(null, TAG_RANKING);
    }

    private void updateConfig() {
        int N = this.mSignalExtractors.length;
        for (int i = 0; i < N; ++i) {
            this.mSignalExtractors[i].setConfig(this);
        }
        this.mRankingHandler.requestSort(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(ArrayList<NotificationRecord> notificationList) {
        int N = notificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            notificationList.get(i).setGlobalSortKey(null);
        }
        Collections.sort(notificationList, this.mPreliminaryComparator);
        ArrayMap<String, NotificationRecord> arrayMap = this.mProxyByGroupTmp;
        synchronized (arrayMap) {
            NotificationRecord record;
            int i;
            for (i = N - 1; i >= 0; --i) {
                record = notificationList.get(i);
                record.setAuthoritativeRank(i);
                String groupKey = record.getGroupKey();
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                if (!isGroupSummary && this.mProxyByGroupTmp.containsKey(groupKey)) continue;
                this.mProxyByGroupTmp.put(groupKey, record);
            }
            for (i = 0; i < N; ++i) {
                record = notificationList.get(i);
                NotificationRecord groupProxy = this.mProxyByGroupTmp.get(record.getGroupKey());
                String groupSortKey = record.getNotification().getSortKey();
                String groupSortKeyPortion = groupSortKey == null ? "nsk" : (groupSortKey.equals("") ? "esk" : "gsk=" + groupSortKey);
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                record.setGlobalSortKey(String.format("intrsv=%c:grnk=0x%04x:gsmry=%c:%s:rnk=0x%04x", Character.valueOf(record.isRecentlyIntrusive() ? (char)'0' : '1'), groupProxy.getAuthoritativeRank(), Character.valueOf(isGroupSummary ? (char)'0' : '1'), groupSortKeyPortion, record.getAuthoritativeRank()));
            }
            this.mProxyByGroupTmp.clear();
        }
        Collections.sort(notificationList, this.mFinalComparator);
    }

    public int indexOf(ArrayList<NotificationRecord> notificationList, NotificationRecord target) {
        return Collections.binarySearch(notificationList, target, this.mFinalComparator);
    }

    private static boolean safeBool(XmlPullParser parser, String att, boolean defValue) {
        String value = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static int safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return RankingHelper.tryParseInt(val, defValue);
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    @Override
    public int getImportance(String packageName, int uid) {
        return this.getOrCreateRecord((String)packageName, (int)uid).importance;
    }

    @Override
    public boolean canShowBadge(String packageName, int uid) {
        return this.getOrCreateRecord((String)packageName, (int)uid).showBadge;
    }

    @Override
    public void setShowBadge(String packageName, int uid, boolean showBadge) {
        this.getOrCreateRecord((String)packageName, (int)uid).showBadge = showBadge;
        this.updateConfig();
    }

    @Override
    public void createNotificationChannelGroup(String pkg, int uid, NotificationChannelGroup group, boolean fromTargetApp) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(group);
        Preconditions.checkNotNull(group.getId());
        Preconditions.checkNotNull(group.getName());
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            throw new IllegalArgumentException("Invalid package");
        }
        r.groups.put(group.getId(), group);
        this.updateConfig();
    }

    @Override
    public void createNotificationChannel(String pkg, int uid, NotificationChannel channel, boolean fromTargetApp) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(channel);
        Preconditions.checkNotNull(channel.getId());
        Preconditions.checkNotNull(channel.getName());
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            throw new IllegalArgumentException("Invalid package");
        }
        if (0 == r.importance) {
            throw new IllegalArgumentException("Package blocked");
        }
        if (channel.getGroup() != null && !r.groups.containsKey(channel.getGroup())) {
            throw new IllegalArgumentException("NotificationChannelGroup doesn't exist");
        }
        NotificationChannel existing = r.channels.get(channel.getId());
        if (existing != null) {
            if (existing.isDeleted()) {
                existing.setDeleted(false);
                this.updateConfig();
            }
            return;
        }
        if (channel.getImportance() < 0 || channel.getImportance() > 5) {
            throw new IllegalArgumentException("Invalid importance level");
        }
        if (fromTargetApp) {
            channel.setBypassDnd(r.priority == 2);
            channel.setLockscreenVisibility(r.visibility);
        }
        this.clearLockedFields(channel);
        if (channel.getLockscreenVisibility() == 1) {
            channel.setLockscreenVisibility(-1000);
        }
        if (!r.showBadge) {
            channel.setShowBadge(false);
        }
        if (channel.getSound() == null) {
            channel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        }
        r.channels.put(channel.getId(), channel);
        this.updateConfig();
    }

    private void clearLockedFields(NotificationChannel channel) {
        int clearMask = 0;
        for (int i = 0; i < NotificationChannel.LOCKABLE_FIELDS.length; ++i) {
            clearMask |= NotificationChannel.LOCKABLE_FIELDS[i];
        }
        channel.lockFields(~clearMask);
    }

    @Override
    public void updateNotificationChannel(String pkg, int uid, NotificationChannel updatedChannel) {
        Preconditions.checkNotNull(updatedChannel);
        Preconditions.checkNotNull(updatedChannel.getId());
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            throw new IllegalArgumentException("Invalid package");
        }
        NotificationChannel channel = r.channels.get(updatedChannel.getId());
        if (channel == null || channel.isDeleted()) {
            throw new IllegalArgumentException("Channel does not exist");
        }
        if (updatedChannel.getLockscreenVisibility() == 1) {
            updatedChannel.setLockscreenVisibility(-1000);
        }
        r.channels.put(updatedChannel.getId(), updatedChannel);
        this.updateConfig();
    }

    @Override
    public void updateNotificationChannelFromAssistant(String pkg, int uid, NotificationChannel updatedChannel) {
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            throw new IllegalArgumentException("Invalid package");
        }
        NotificationChannel channel = r.channels.get(updatedChannel.getId());
        if (channel == null || channel.isDeleted()) {
            throw new IllegalArgumentException("Channel does not exist");
        }
        if ((channel.getUserLockedFields() & 4) == 0) {
            channel.setImportance(updatedChannel.getImportance());
        }
        if ((channel.getUserLockedFields() & 8) == 0) {
            channel.enableLights(updatedChannel.shouldShowLights());
            channel.setLightColor(updatedChannel.getLightColor());
        }
        if ((channel.getUserLockedFields() & 1) == 0) {
            channel.setBypassDnd(updatedChannel.canBypassDnd());
        }
        if ((channel.getUserLockedFields() & 0x20) == 0) {
            channel.setSound(updatedChannel.getSound(), updatedChannel.getAudioAttributes());
        }
        if ((channel.getUserLockedFields() & 0x10) == 0) {
            channel.enableVibration(updatedChannel.shouldVibrate());
            channel.setVibrationPattern(updatedChannel.getVibrationPattern());
        }
        if ((channel.getUserLockedFields() & 2) == 0) {
            if (updatedChannel.getLockscreenVisibility() == 1) {
                channel.setLockscreenVisibility(-1000);
            } else {
                channel.setLockscreenVisibility(updatedChannel.getLockscreenVisibility());
            }
        }
        if ((channel.getUserLockedFields() & 0x80) == 0) {
            channel.setShowBadge(updatedChannel.canShowBadge());
        }
        if (updatedChannel.isDeleted()) {
            channel.setDeleted(true);
        }
        r.channels.put(channel.getId(), channel);
        this.updateConfig();
    }

    @Override
    public NotificationChannel getNotificationChannelWithFallback(String pkg, int uid, String channelId, boolean includeDeleted) {
        NotificationChannel channel;
        Record r = this.getOrCreateRecord(pkg, uid);
        if (channelId == null) {
            channelId = "miscellaneous";
        }
        if ((channel = r.channels.get(channelId)) != null && (includeDeleted || !channel.isDeleted())) {
            return channel;
        }
        return r.channels.get("miscellaneous");
    }

    @Override
    public NotificationChannel getNotificationChannel(String pkg, int uid, String channelId, boolean includeDeleted) {
        NotificationChannel nc;
        Preconditions.checkNotNull(pkg);
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            return null;
        }
        if (channelId == null) {
            channelId = "miscellaneous";
        }
        if ((nc = r.channels.get(channelId)) != null && (includeDeleted || !nc.isDeleted())) {
            return nc;
        }
        return null;
    }

    @Override
    public void deleteNotificationChannel(String pkg, int uid, String channelId) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(channelId);
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return;
        }
        NotificationChannel channel = r.channels.get(channelId);
        if (channel != null) {
            channel.setDeleted(true);
        }
    }

    @Override
    public void permanentlyDeleteNotificationChannel(String pkg, int uid, String channelId) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(channelId);
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return;
        }
        r.channels.remove(channelId);
    }

    @Override
    public void permanentlyDeleteNotificationChannels(String pkg, int uid) {
        int N;
        Preconditions.checkNotNull(pkg);
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return;
        }
        for (int i = N = r.channels.size() - 1; i >= 0; --i) {
            String key = r.channels.keyAt(i);
            if ("miscellaneous".equals(key)) continue;
            r.channels.remove(key);
        }
    }

    public NotificationChannelGroup getNotificationChannelGroup(String groupId, String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        Record r = this.getRecord(pkg, uid);
        return r.groups.get(groupId);
    }

    @Override
    public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroups(String pkg, int uid, boolean includeDeleted) {
        Preconditions.checkNotNull(pkg);
        ArrayMap<String, NotificationChannelGroup> groups = new ArrayMap<String, NotificationChannelGroup>();
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return ParceledListSlice.emptyList();
        }
        NotificationChannelGroup nonGrouped = new NotificationChannelGroup(null, null);
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (!includeDeleted && nc.isDeleted()) continue;
            if (nc.getGroup() != null) {
                NotificationChannelGroup ncg = (NotificationChannelGroup)groups.get(nc.getGroup());
                if (ncg == null) {
                    ncg = r.groups.get(nc.getGroup()).clone();
                    groups.put(nc.getGroup(), ncg);
                }
                ncg.addChannel(nc);
                continue;
            }
            nonGrouped.addChannel(nc);
        }
        if (nonGrouped.getChannels().size() > 0) {
            groups.put(null, nonGrouped);
        }
        return new ParceledListSlice<NotificationChannelGroup>(new ArrayList(groups.values()));
    }

    @Override
    public Collection<NotificationChannelGroup> getNotificationChannelGroups(String pkg, int uid) {
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return new ArrayList<NotificationChannelGroup>();
        }
        return r.groups.values();
    }

    @Override
    public ParceledListSlice<NotificationChannel> getNotificationChannels(String pkg, int uid, boolean includeDeleted) {
        Preconditions.checkNotNull(pkg);
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>();
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return ParceledListSlice.emptyList();
        }
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (!includeDeleted && nc.isDeleted()) continue;
            channels.add(nc);
        }
        return new ParceledListSlice<NotificationChannel>(channels);
    }

    @Override
    public void setImportance(String pkgName, int uid, int importance) {
        this.getOrCreateRecord((String)pkgName, (int)uid).importance = importance;
        this.updateConfig();
    }

    public void setEnabled(String packageName, int uid, boolean enabled) {
        boolean wasEnabled;
        boolean bl = wasEnabled = this.getImportance(packageName, uid) != 0;
        if (wasEnabled == enabled) {
            return;
        }
        this.setImportance(packageName, uid, enabled ? -1000 : 0);
    }

    public void dump(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter) {
        if (filter == null) {
            int N = this.mSignalExtractors.length;
            pw.print(prefix);
            pw.print("mSignalExtractors.length = ");
            pw.println(N);
            for (int i = 0; i < N; ++i) {
                pw.print(prefix);
                pw.print("  ");
                pw.println(this.mSignalExtractors[i]);
            }
        }
        if (filter == null) {
            pw.print(prefix);
            pw.println("per-package config:");
        }
        pw.println("Records:");
        RankingHelper.dumpRecords(pw, prefix, filter, this.mRecords);
        pw.println("Restored without uid:");
        RankingHelper.dumpRecords(pw, prefix, filter, this.mRestoredWithoutUids);
    }

    private static void dumpRecords(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter, ArrayMap<String, Record> records) {
        int N = records.size();
        for (int i = 0; i < N; ++i) {
            Record r = records.valueAt(i);
            if (filter != null && !filter.matches(r.pkg)) continue;
            pw.print(prefix);
            pw.print("  AppSettings: ");
            pw.print(r.pkg);
            pw.print(" (");
            pw.print(r.uid == Record.UNKNOWN_UID ? "UNKNOWN_UID" : Integer.toString(r.uid));
            pw.print(')');
            if (r.importance != -1000) {
                pw.print(" importance=");
                pw.print(NotificationListenerService.Ranking.importanceToString(r.importance));
            }
            if (r.priority != 0) {
                pw.print(" priority=");
                pw.print(Notification.priorityToString(r.priority));
            }
            if (r.visibility != -1000) {
                pw.print(" visibility=");
                pw.print(Notification.visibilityToString(r.visibility));
            }
            pw.print(" showBadge=");
            pw.print(Boolean.toString(r.showBadge));
            pw.println();
            for (NotificationChannel channel : r.channels.values()) {
                pw.print(prefix);
                pw.print("  ");
                pw.print("  ");
                pw.println(channel);
            }
            for (NotificationChannelGroup group : r.groups.values()) {
                pw.print(prefix);
                pw.print("  ");
                pw.print("  ");
                pw.println(group);
            }
        }
    }

    public JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
        JSONObject ranking = new JSONObject();
        JSONArray records = new JSONArray();
        try {
            ranking.put("noUid", this.mRestoredWithoutUids.size());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        int N = this.mRecords.size();
        for (int i = 0; i < N; ++i) {
            Record r = this.mRecords.valueAt(i);
            if (filter != null && !filter.matches(r.pkg)) continue;
            JSONObject record = new JSONObject();
            try {
                record.put("userId", UserHandle.getUserId(r.uid));
                record.put("packageName", r.pkg);
                if (r.importance != -1000) {
                    record.put(ATT_IMPORTANCE, NotificationListenerService.Ranking.importanceToString(r.importance));
                }
                if (r.priority != 0) {
                    record.put(ATT_PRIORITY, Notification.priorityToString(r.priority));
                }
                if (r.visibility != -1000) {
                    record.put(ATT_VISIBILITY, Notification.visibilityToString(r.visibility));
                }
                if (!r.showBadge) {
                    record.put("showBadge", (Object)r.showBadge);
                }
                for (NotificationChannel channel : r.channels.values()) {
                    record.put(TAG_CHANNEL, channel.toJson());
                }
                for (NotificationChannelGroup group : r.groups.values()) {
                    record.put("group", group.toJson());
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            records.put(record);
        }
        try {
            ranking.put("records", records);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ranking;
    }

    public JSONArray dumpBansJson(NotificationManagerService.DumpFilter filter) {
        JSONArray bans = new JSONArray();
        Map<Integer, String> packageBans = this.getPackageBans();
        for (Map.Entry<Integer, String> ban : packageBans.entrySet()) {
            int userId = UserHandle.getUserId(ban.getKey());
            String packageName = ban.getValue();
            if (filter != null && !filter.matches(packageName)) continue;
            JSONObject banJson = new JSONObject();
            try {
                banJson.put("userId", userId);
                banJson.put("packageName", packageName);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            bans.put(banJson);
        }
        return bans;
    }

    public Map<Integer, String> getPackageBans() {
        int N = this.mRecords.size();
        ArrayMap<Integer, String> packageBans = new ArrayMap<Integer, String>(N);
        for (int i = 0; i < N; ++i) {
            Record r = this.mRecords.valueAt(i);
            if (r.importance != 0) continue;
            packageBans.put(r.uid, r.pkg);
        }
        return packageBans;
    }

    public void onPackagesChanged(boolean removingPackage, int changeUserId, String[] pkgList, int[] uidList) {
        if (pkgList == null || pkgList.length == 0) {
            return;
        }
        boolean updated = false;
        if (removingPackage) {
            int size = Math.min(pkgList.length, uidList.length);
            for (int i = 0; i < size; ++i) {
                String pkg = pkgList[i];
                int uid = uidList[i];
                this.mRecords.remove(RankingHelper.recordKey(pkg, uid));
                this.mRestoredWithoutUids.remove(pkg);
                updated = true;
            }
        } else {
            for (String pkg : pkgList) {
                Record r = this.mRestoredWithoutUids.get(pkg);
                if (r != null) {
                    try {
                        r.uid = this.mPm.getPackageUidAsUser(r.pkg, changeUserId);
                        this.mRestoredWithoutUids.remove(pkg);
                        this.mRecords.put(RankingHelper.recordKey(r.pkg, r.uid), r);
                        updated = true;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    Record fullRecord = this.getRecord(pkg, this.mPm.getPackageUidAsUser(pkg, changeUserId));
                    if (fullRecord == null) continue;
                    this.clampDefaultChannel(fullRecord);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (updated) {
            this.updateConfig();
        }
    }

    private static class Record {
        static int UNKNOWN_UID = -10000;
        String pkg;
        int uid = UNKNOWN_UID;
        int importance = -1000;
        int priority = 0;
        int visibility = -1000;
        boolean showBadge = true;
        ArrayMap<String, NotificationChannel> channels = new ArrayMap();
        ArrayMap<String, NotificationChannelGroup> groups = new ArrayMap();

        private Record() {
        }
    }
}

