/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Binder;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class SnoozeHelper {
    private static final String TAG = "SnoozeHelper";
    private static final boolean DEBUG = Log.isLoggable("SnoozeHelper", 3);
    private static final String INDENT = "    ";
    private static final String REPOST_ACTION = SnoozeHelper.class.getSimpleName() + ".EVALUATE";
    private static final int REQUEST_CODE_REPOST = 1;
    private static final String REPOST_SCHEME = "repost";
    private static final String EXTRA_PKG = "pkg";
    private static final String EXTRA_KEY = "key";
    private static final String EXTRA_USER_ID = "userId";
    private final Context mContext;
    private AlarmManager mAm;
    private final ManagedServices.UserProfiles mUserProfiles;
    private ArrayMap<Integer, ArrayMap<String, ArrayMap<String, NotificationRecord>>> mSnoozedNotifications = new ArrayMap();
    private ArrayMap<String, String> mPackages = new ArrayMap();
    private ArrayMap<String, Integer> mUsers = new ArrayMap();
    private Callback mCallback;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (DEBUG) {
                Slog.d(SnoozeHelper.TAG, "Reposting notification");
            }
            if (REPOST_ACTION.equals(intent.getAction())) {
                SnoozeHelper.this.repost(intent.getStringExtra(SnoozeHelper.EXTRA_KEY), intent.getIntExtra(SnoozeHelper.EXTRA_USER_ID, 0));
            }
        }
    };

    public SnoozeHelper(Context context, Callback callback, ManagedServices.UserProfiles userProfiles) {
        this.mContext = context;
        IntentFilter filter = new IntentFilter(REPOST_ACTION);
        filter.addDataScheme(REPOST_SCHEME);
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mAm = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mCallback = callback;
        this.mUserProfiles = userProfiles;
    }

    protected boolean isSnoozed(int userId, String pkg, String key) {
        return this.mSnoozedNotifications.containsKey(userId) && this.mSnoozedNotifications.get(userId).containsKey(pkg) && this.mSnoozedNotifications.get(userId).get(pkg).containsKey(key);
    }

    protected Collection<NotificationRecord> getSnoozed(int userId, String pkg) {
        if (this.mSnoozedNotifications.containsKey(userId) && this.mSnoozedNotifications.get(userId).containsKey(pkg)) {
            this.mSnoozedNotifications.get(userId).get(pkg).values();
        }
        return Collections.EMPTY_LIST;
    }

    protected List<NotificationRecord> getSnoozed() {
        ArrayList<NotificationRecord> snoozedForUser = new ArrayList<NotificationRecord>();
        int[] userIds = this.mUserProfiles.getCurrentProfileIds();
        int N = userIds.length;
        for (int i = 0; i < N; ++i) {
            ArrayMap<String, ArrayMap<String, NotificationRecord>> snoozedPkgs = this.mSnoozedNotifications.get(userIds[i]);
            if (snoozedPkgs == null) continue;
            int M = snoozedPkgs.size();
            for (int j = 0; j < M; ++j) {
                ArrayMap<String, NotificationRecord> records = snoozedPkgs.valueAt(j);
                if (records == null) continue;
                snoozedForUser.addAll(records.values());
            }
        }
        return snoozedForUser;
    }

    protected void snooze(NotificationRecord record, long until) {
        this.snooze(record);
        this.scheduleRepost(record.sbn.getPackageName(), record.getKey(), record.getUserId(), until);
    }

    protected void snooze(NotificationRecord record) {
        ArrayMap<String, NotificationRecord> pkgRecords;
        ArrayMap<String, ArrayMap<String, NotificationRecord>> records;
        int userId = record.getUser().getIdentifier();
        if (DEBUG) {
            Slog.d(TAG, "Snoozing " + record.getKey());
        }
        if ((records = this.mSnoozedNotifications.get(userId)) == null) {
            records = new ArrayMap();
        }
        if ((pkgRecords = records.get(record.sbn.getPackageName())) == null) {
            pkgRecords = new ArrayMap();
        }
        pkgRecords.put(record.getKey(), record);
        records.put(record.sbn.getPackageName(), pkgRecords);
        this.mSnoozedNotifications.put(userId, records);
        this.mPackages.put(record.getKey(), record.sbn.getPackageName());
        this.mUsers.put(record.getKey(), userId);
    }

    protected boolean cancel(int userId, String pkg, String tag, int id2) {
        ArrayMap<String, NotificationRecord> recordsForPkg;
        if (this.mSnoozedNotifications.containsKey(userId) && (recordsForPkg = this.mSnoozedNotifications.get(userId).get(pkg)) != null) {
            Set<Map.Entry<String, NotificationRecord>> records = recordsForPkg.entrySet();
            String key = null;
            for (Map.Entry<String, NotificationRecord> record : records) {
                StatusBarNotification sbn = record.getValue().sbn;
                if (!Objects.equals(sbn.getTag(), tag) || sbn.getId() != id2) continue;
                key = record.getKey();
            }
            if (key != null) {
                recordsForPkg.remove(key);
                this.cancelAlarm(userId, pkg, key);
                this.mPackages.remove(key);
                this.mUsers.remove(key);
                return true;
            }
        }
        return false;
    }

    protected boolean cancel(int userId, boolean includeCurrentProfiles) {
        int[] userIds = new int[]{userId};
        if (includeCurrentProfiles) {
            userIds = this.mUserProfiles.getCurrentProfileIds();
        }
        int N = userIds.length;
        for (int i = 0; i < N; ++i) {
            ArrayMap<String, ArrayMap<String, NotificationRecord>> snoozedPkgs = this.mSnoozedNotifications.remove(userIds[i]);
            if (snoozedPkgs == null) continue;
            int M = snoozedPkgs.size();
            for (int j = 0; j < M; ++j) {
                ArrayMap<String, NotificationRecord> records = snoozedPkgs.valueAt(j);
                if (records == null) continue;
                int P = records.size();
                for (int k = 0; k < P; ++k) {
                    String key = records.keyAt(k);
                    this.cancelAlarm(userId, snoozedPkgs.keyAt(j), key);
                    this.mPackages.remove(key);
                    this.mUsers.remove(key);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean cancel(int userId, String pkg) {
        if (this.mSnoozedNotifications.containsKey(userId) && this.mSnoozedNotifications.get(userId).containsKey(pkg)) {
            ArrayMap<String, NotificationRecord> records = this.mSnoozedNotifications.get(userId).remove(pkg);
            int N = records.size();
            for (int i = 0; i < N; ++i) {
                String key = records.keyAt(i);
                this.cancelAlarm(userId, pkg, key);
                this.mPackages.remove(key);
                this.mUsers.remove(key);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAlarm(int userId, String pkg, String key) {
        long identity = Binder.clearCallingIdentity();
        try {
            PendingIntent pi = this.createPendingIntent(pkg, key, userId);
            this.mAm.cancel(pi);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    protected void update(int userId, NotificationRecord record) {
        ArrayMap<String, ArrayMap<String, NotificationRecord>> records = this.mSnoozedNotifications.get(userId);
        if (records == null) {
            return;
        }
        ArrayMap<String, NotificationRecord> pkgRecords = records.get(record.sbn.getPackageName());
        if (pkgRecords == null) {
            return;
        }
        pkgRecords.put(record.getKey(), record);
    }

    protected void repost(String key) {
        Integer userId = this.mUsers.get(key);
        if (userId != null) {
            this.repost(key, userId);
        }
    }

    protected void repost(String key, int userId) {
        String pkg = this.mPackages.remove(key);
        ArrayMap<String, ArrayMap<String, NotificationRecord>> records = this.mSnoozedNotifications.get(userId);
        if (records == null) {
            return;
        }
        ArrayMap<String, NotificationRecord> pkgRecords = records.get(pkg);
        if (pkgRecords == null) {
            return;
        }
        NotificationRecord record = pkgRecords.remove(key);
        if (record != null) {
            MetricsLogger.action(record.getLogMaker().setCategory(831).setType(1));
            this.mCallback.repost(userId, record);
        }
    }

    private PendingIntent createPendingIntent(String pkg, String key, int userId) {
        return PendingIntent.getBroadcast(this.mContext, 1, new Intent(REPOST_ACTION).setData(new Uri.Builder().scheme(REPOST_SCHEME).appendPath(key).build()).addFlags(0x10000000).putExtra(EXTRA_KEY, key).putExtra(EXTRA_USER_ID, userId), 0x8000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRepost(String pkg, String key, int userId, long time) {
        long identity = Binder.clearCallingIdentity();
        try {
            PendingIntent pi = this.createPendingIntent(pkg, key, userId);
            this.mAm.cancel(pi);
            if (DEBUG) {
                Slog.d(TAG, "Scheduling evaluate for " + new Date(time));
            }
            this.mAm.setExactAndAllowWhileIdle(0, time, pi);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.println("\n  Snoozed notifications:");
        for (int userId : this.mSnoozedNotifications.keySet()) {
            pw.print(INDENT);
            pw.println("user: " + userId);
            ArrayMap<String, ArrayMap<String, NotificationRecord>> snoozedPkgs = this.mSnoozedNotifications.get(userId);
            for (String pkg : snoozedPkgs.keySet()) {
                pw.print(INDENT);
                pw.print(INDENT);
                pw.println("package: " + pkg);
                Set<String> snoozedKeys = snoozedPkgs.get(pkg).keySet();
                for (String key : snoozedKeys) {
                    pw.print(INDENT);
                    pw.print(INDENT);
                    pw.print(INDENT);
                    pw.println(key);
                }
            }
        }
    }

    protected void writeXml(XmlSerializer out, boolean forBackup) throws IOException {
    }

    public void readXml(XmlPullParser parser, boolean forRestore) throws XmlPullParserException, IOException {
    }

    void setAlarmManager(AlarmManager am) {
        this.mAm = am;
    }

    protected static interface Callback {
        public void repost(int var1, NotificationRecord var2);
    }
}

