/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.OverlayInfo;
import android.content.pm.PackageInfo;
import android.os.UserHandle;
import android.util.Slog;
import com.android.server.pm.Installer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class IdmapManager {
    private final Installer mInstaller;

    IdmapManager(Installer installer) {
        this.mInstaller = installer;
    }

    boolean createIdmap(PackageInfo targetPackage, PackageInfo overlayPackage, int userId) {
        int sharedGid = UserHandle.getSharedAppGid(targetPackage.applicationInfo.uid);
        String targetPath = targetPackage.applicationInfo.getBaseCodePath();
        String overlayPath = overlayPackage.applicationInfo.getBaseCodePath();
        try {
            this.mInstaller.idmap(targetPath, overlayPath, sharedGid);
        }
        catch (Installer.InstallerException e) {
            Slog.w("OverlayManager", "failed to generate idmap for " + targetPath + " and " + overlayPath + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    boolean removeIdmap(OverlayInfo oi, int userId) {
        try {
            this.mInstaller.removeIdmap(oi.baseCodePath);
        }
        catch (Installer.InstallerException e) {
            Slog.w("OverlayManager", "failed to remove idmap for " + oi.baseCodePath + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    boolean idmapExists(OverlayInfo oi) {
        return new File(this.getIdmapPath(oi.baseCodePath)).isFile();
    }

    boolean idmapExists(PackageInfo overlayPackage, int userId) {
        return new File(this.getIdmapPath(overlayPackage.applicationInfo.getBaseCodePath())).isFile();
    }

    boolean isDangerous(PackageInfo overlayPackage, int userId) {
        return this.isDangerous(this.getIdmapPath(overlayPackage.applicationInfo.getBaseCodePath()));
    }

    private String getIdmapPath(String baseCodePath) {
        StringBuilder sb = new StringBuilder("/data/resource-cache/");
        sb.append(baseCodePath.substring(1).replace('/', '@'));
        sb.append("@idmap");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDangerous(String idmapPath) {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(idmapPath));){
            int magic = dis.readInt();
            int version = dis.readInt();
            int dangerous = dis.readInt();
            boolean bl = dangerous != 0;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }
}

