/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.om.IOverlayManager;
import android.content.om.OverlayInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManagerInternal;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.FgThread;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.om.IdmapManager;
import com.android.server.om.OverlayManagerServiceImpl;
import com.android.server.om.OverlayManagerSettings;
import com.android.server.om.OverlayManagerShellCommand;
import com.android.server.pm.Installer;
import com.android.server.pm.UserManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xmlpull.v1.XmlPullParserException;

public final class OverlayManagerService
extends SystemService {
    static final String TAG = "OverlayManager";
    static final boolean DEBUG = false;
    static final String PERMISSION_DENIED = "Operation not permitted for user shell";
    private final Object mLock = new Object();
    private final AtomicFile mSettingsFile;
    private final PackageManagerHelper mPackageManager;
    private final UserManagerService mUserManager;
    private final OverlayManagerSettings mSettings;
    private final OverlayManagerServiceImpl mImpl;
    private final AtomicBoolean mPersistSettingsScheduled = new AtomicBoolean(false);
    private final IBinder mService = new IOverlayManager.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, List<OverlayInfo>> getAllOverlays(int userId) throws RemoteException {
            userId = this.handleIncomingUser(userId, "getAllOverlays");
            Object object = OverlayManagerService.this.mLock;
            synchronized (object) {
                return OverlayManagerService.this.mImpl.getOverlaysForUser(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<OverlayInfo> getOverlayInfosForTarget(String targetPackageName, int userId) throws RemoteException {
            userId = this.handleIncomingUser(userId, "getOverlayInfosForTarget");
            if (targetPackageName == null) {
                return Collections.emptyList();
            }
            Object object = OverlayManagerService.this.mLock;
            synchronized (object) {
                return OverlayManagerService.this.mImpl.getOverlayInfosForTarget(targetPackageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OverlayInfo getOverlayInfo(String packageName, int userId) throws RemoteException {
            userId = this.handleIncomingUser(userId, "getOverlayInfo");
            if (packageName == null) {
                return null;
            }
            Object object = OverlayManagerService.this.mLock;
            synchronized (object) {
                return OverlayManagerService.this.mImpl.getOverlayInfo(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setEnabled(String packageName, boolean enable, int userId) throws RemoteException {
            this.enforceChangeOverlayPackagesPermission("setEnabled");
            userId = this.handleIncomingUser(userId, "setEnabled");
            if (packageName == null) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    boolean bl = OverlayManagerService.this.mImpl.setEnabled(packageName, enable, userId);
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPriority(String packageName, String parentPackageName, int userId) throws RemoteException {
            this.enforceChangeOverlayPackagesPermission("setPriority");
            userId = this.handleIncomingUser(userId, "setPriority");
            if (packageName == null || parentPackageName == null) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    boolean bl = OverlayManagerService.this.mImpl.setPriority(packageName, parentPackageName, userId);
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setHighestPriority(String packageName, int userId) throws RemoteException {
            this.enforceChangeOverlayPackagesPermission("setHighestPriority");
            userId = this.handleIncomingUser(userId, "setHighestPriority");
            if (packageName == null) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    boolean bl = OverlayManagerService.this.mImpl.setHighestPriority(packageName, userId);
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setLowestPriority(String packageName, int userId) throws RemoteException {
            this.enforceChangeOverlayPackagesPermission("setLowestPriority");
            userId = this.handleIncomingUser(userId, "setLowestPriority");
            if (packageName == null) {
                return false;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    boolean bl = OverlayManagerService.this.mImpl.setLowestPriority(packageName, userId);
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new OverlayManagerShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] argv) {
            this.enforceDumpPermission("dump");
            boolean verbose = argv.length > 0 && "--verbose".equals(argv[0]);
            Object object = OverlayManagerService.this.mLock;
            synchronized (object) {
                OverlayManagerService.this.mImpl.onDump(pw);
                OverlayManagerService.this.mPackageManager.dump(pw, verbose);
            }
        }

        private int handleIncomingUser(int userId, String message) {
            return ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, message, null);
        }

        private void enforceChangeOverlayPackagesPermission(String message) {
            OverlayManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.CHANGE_OVERLAY_PACKAGES", message);
        }

        private void enforceDumpPermission(String message) {
            OverlayManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DUMP", message);
        }
    };

    public OverlayManagerService(Context context, Installer installer) {
        super(context);
        this.mSettingsFile = new AtomicFile(new File(Environment.getDataSystemDirectory(), "overlays.xml"));
        this.mPackageManager = new PackageManagerHelper();
        this.mUserManager = UserManagerService.getInstance();
        IdmapManager im = new IdmapManager(installer);
        this.mSettings = new OverlayManagerSettings();
        this.mImpl = new OverlayManagerServiceImpl(this.mPackageManager, im, this.mSettings);
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        packageFilter.addDataScheme("package");
        this.getContext().registerReceiverAsUser(new PackageReceiver(), UserHandle.ALL, packageFilter, null, null);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.getContext().registerReceiverAsUser(new UserReceiver(), UserHandle.ALL, userFilter, null, null);
        this.restoreSettings();
        this.onSwitchUser(0);
        this.schedulePersistSettings();
        this.mSettings.addChangeListener(new OverlayChangeListener());
        this.publishBinderService("overlay", this.mService);
        this.publishLocalService(OverlayManagerService.class, this);
    }

    @Override
    public void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int newUserId) {
        List<String> targets;
        Object object = this.mLock;
        synchronized (object) {
            targets = this.mImpl.onSwitchUser(newUserId);
        }
        this.updateAssets(newUserId, targets);
    }

    private boolean isOverlayPackage(PackageInfo pi) {
        return pi != null && pi.overlayTarget != null;
    }

    private void updateAssets(int userId, String targetPackageName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(targetPackageName);
        this.updateAssets(userId, list);
    }

    private void updateAssets(int userId, List<String> targetPackageNames) {
    }

    private void schedulePersistSettings() {
        if (this.mPersistSettingsScheduled.getAndSet(true)) {
            return;
        }
        IoThread.getHandler().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OverlayManagerService.this.mPersistSettingsScheduled.set(false);
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    FileOutputStream stream = null;
                    try {
                        stream = OverlayManagerService.this.mSettingsFile.startWrite();
                        OverlayManagerService.this.mSettings.persist(stream);
                        OverlayManagerService.this.mSettingsFile.finishWrite(stream);
                    }
                    catch (IOException | XmlPullParserException e) {
                        OverlayManagerService.this.mSettingsFile.failWrite(stream);
                        Slog.e(OverlayManagerService.TAG, "failed to persist overlay state", e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSettings() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSettingsFile.getBaseFile().exists()) {
                return;
            }
            try (FileInputStream stream = this.mSettingsFile.openRead();){
                this.mSettings.restore(stream);
                List<UserInfo> deadUsers = this.getDeadUsers();
                int N = deadUsers.size();
                for (int i = 0; i < N; ++i) {
                    UserInfo deadUser = deadUsers.get(i);
                    int userId = deadUser.getUserHandle().getIdentifier();
                    this.mSettings.removeUser(userId);
                }
            }
            catch (IOException | XmlPullParserException e) {
                Slog.e(TAG, "failed to restore overlay state", e);
            }
        }
    }

    private List<UserInfo> getDeadUsers() {
        List<UserInfo> users = this.mUserManager.getUsers(false);
        List<UserInfo> onlyLiveUsers = this.mUserManager.getUsers(true);
        users.removeAll(onlyLiveUsers);
        return users;
    }

    private static final class PackageManagerHelper
    implements OverlayManagerServiceImpl.PackageManagerHelper {
        private final IPackageManager mPackageManager;
        private final PackageManagerInternal mPackageManagerInternal;
        private final SparseArray<HashMap<String, PackageInfo>> mCache = new SparseArray();
        private static final String TAB1 = "    ";
        private static final String TAB2 = "        ";

        PackageManagerHelper() {
            this.mPackageManager = AppGlobals.getPackageManager();
            this.mPackageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        }

        public PackageInfo getPackageInfo(String packageName, int userId, boolean useCache) {
            PackageInfo cachedPi;
            if (useCache && (cachedPi = this.getCachedPackageInfo(packageName, userId)) != null) {
                return cachedPi;
            }
            try {
                PackageInfo pi = this.mPackageManager.getPackageInfo(packageName, 0, userId);
                if (useCache && pi != null) {
                    this.cachePackageInfo(packageName, userId, pi);
                }
                return pi;
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        @Override
        public PackageInfo getPackageInfo(String packageName, int userId) {
            return this.getPackageInfo(packageName, userId, true);
        }

        @Override
        public boolean signaturesMatching(String packageName1, String packageName2, int userId) {
            try {
                return this.mPackageManager.checkSignatures(packageName1, packageName2) == 0;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }

        @Override
        public List<PackageInfo> getOverlayPackages(int userId) {
            return this.mPackageManagerInternal.getOverlayPackages(userId);
        }

        public PackageInfo getCachedPackageInfo(String packageName, int userId) {
            HashMap<String, PackageInfo> map = this.mCache.get(userId);
            return map == null ? null : map.get(packageName);
        }

        public void cachePackageInfo(String packageName, int userId, PackageInfo pi) {
            HashMap<String, PackageInfo> map = this.mCache.get(userId);
            if (map == null) {
                map = new HashMap();
                this.mCache.put(userId, map);
            }
            map.put(packageName, pi);
        }

        public void forgetPackageInfo(String packageName, int userId) {
            HashMap<String, PackageInfo> map = this.mCache.get(userId);
            if (map == null) {
                return;
            }
            map.remove(packageName);
            if (map.isEmpty()) {
                this.mCache.delete(userId);
            }
        }

        public void forgetAllPackageInfos(int userId) {
            this.mCache.delete(userId);
        }

        public void dump(PrintWriter pw, boolean verbose) {
            pw.println("PackageInfo cache");
            if (!verbose) {
                int count = 0;
                int N = this.mCache.size();
                for (int i = 0; i < N; ++i) {
                    int userId = this.mCache.keyAt(i);
                    count += this.mCache.get(userId).size();
                }
                pw.println(TAB1 + count + " package(s)");
                return;
            }
            if (this.mCache.size() == 0) {
                pw.println("    <empty>");
                return;
            }
            int N = this.mCache.size();
            for (int i = 0; i < N; ++i) {
                int userId = this.mCache.keyAt(i);
                pw.println("    User " + userId);
                HashMap<String, PackageInfo> map = this.mCache.get(userId);
                for (Map.Entry<String, PackageInfo> entry : map.entrySet()) {
                    pw.println(TAB2 + entry.getKey() + ": " + entry.getValue());
                }
            }
        }
    }

    private final class OverlayChangeListener
    implements OverlayManagerSettings.ChangeListener {
        private OverlayChangeListener() {
        }

        @Override
        public void onSettingsChanged() {
            OverlayManagerService.this.schedulePersistSettings();
        }

        @Override
        public void onOverlayAdded(OverlayInfo oi) {
            this.scheduleBroadcast("android.intent.action.OVERLAY_ADDED", oi, oi.isEnabled());
        }

        @Override
        public void onOverlayRemoved(OverlayInfo oi) {
            this.scheduleBroadcast("android.intent.action.OVERLAY_REMOVED", oi, oi.isEnabled());
        }

        @Override
        public void onOverlayChanged(OverlayInfo oi, OverlayInfo oldOi) {
            this.scheduleBroadcast("android.intent.action.OVERLAY_CHANGED", oi, oi.isEnabled() != oldOi.isEnabled());
        }

        @Override
        public void onOverlayPriorityChanged(OverlayInfo oi) {
            this.scheduleBroadcast("android.intent.action.OVERLAY_PRIORITY_CHANGED", oi, oi.isEnabled());
        }

        private void scheduleBroadcast(String action, OverlayInfo oi, boolean doUpdate) {
            FgThread.getHandler().post(new BroadcastRunnable(action, oi, doUpdate));
        }

        private final class BroadcastRunnable
        implements Runnable {
            private final String mAction;
            private final OverlayInfo mOverlayInfo;
            private final boolean mDoUpdate;

            BroadcastRunnable(String action, OverlayInfo oi, boolean doUpdate) {
                this.mAction = action;
                this.mOverlayInfo = oi;
                this.mDoUpdate = doUpdate;
            }

            @Override
            public void run() {
                if (this.mDoUpdate) {
                    OverlayManagerService.this.updateAssets(this.mOverlayInfo.userId, this.mOverlayInfo.targetPackageName);
                }
                this.sendBroadcast(this.mAction, this.mOverlayInfo.targetPackageName, this.mOverlayInfo.packageName, this.mOverlayInfo.userId);
            }

            private void sendBroadcast(String action, String targetPackageName, String packageName, int userId) {
                Intent intent = new Intent(action, Uri.fromParts("package", String.format("%s/%s", targetPackageName, packageName), null));
                intent.setFlags(0x4000000);
                try {
                    ActivityManagerNative.getDefault().broadcastIntent(null, intent, null, null, 0, null, null, null, -1, null, false, false, userId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    private final class UserReceiver
    extends BroadcastReceiver {
        private UserReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.intent.action.USER_REMOVED": {
                    int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                    if (userId == -10000) break;
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        OverlayManagerService.this.mImpl.onUserRemoved(userId);
                        OverlayManagerService.this.mPackageManager.forgetAllPackageInfos(userId);
                        break;
                    }
                }
            }
        }
    }

    private final class PackageReceiver
    extends BroadcastReceiver {
        private PackageReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            Uri data = intent.getData();
            if (data == null) {
                Slog.e(OverlayManagerService.TAG, "Cannot handle package broadcast with null data");
                return;
            }
            String packageName = data.getSchemeSpecificPart();
            boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
            int extraUid = intent.getIntExtra("android.intent.extra.UID", -10000);
            int[] userIds = extraUid == -10000 ? OverlayManagerService.this.mUserManager.getUserIds() : new int[]{UserHandle.getUserId(extraUid)};
            switch (intent.getAction()) {
                case "android.intent.action.PACKAGE_ADDED": {
                    if (replacing) {
                        this.onPackageUpgraded(packageName, userIds);
                        break;
                    }
                    this.onPackageAdded(packageName, userIds);
                    break;
                }
                case "android.intent.action.PACKAGE_CHANGED": {
                    this.onPackageChanged(packageName, userIds);
                    break;
                }
                case "android.intent.action.PACKAGE_REMOVED": {
                    if (replacing) {
                        this.onPackageUpgrading(packageName, userIds);
                        break;
                    }
                    this.onPackageRemoved(packageName, userIds);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageAdded(String packageName, int[] userIds) {
            for (int userId : userIds) {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    PackageInfo pi = OverlayManagerService.this.mPackageManager.getPackageInfo(packageName, userId, false);
                    if (pi != null) {
                        OverlayManagerService.this.mPackageManager.cachePackageInfo(packageName, userId, pi);
                        if (!OverlayManagerService.this.isOverlayPackage(pi)) {
                            OverlayManagerService.this.mImpl.onTargetPackageAdded(packageName, userId);
                        } else {
                            OverlayManagerService.this.mImpl.onOverlayPackageAdded(packageName, userId);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageChanged(String packageName, int[] userIds) {
            for (int userId : userIds) {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    PackageInfo pi = OverlayManagerService.this.mPackageManager.getPackageInfo(packageName, userId, false);
                    if (pi != null) {
                        OverlayManagerService.this.mPackageManager.cachePackageInfo(packageName, userId, pi);
                        if (!OverlayManagerService.this.isOverlayPackage(pi)) {
                            OverlayManagerService.this.mImpl.onTargetPackageChanged(packageName, userId);
                        } else {
                            OverlayManagerService.this.mImpl.onOverlayPackageChanged(packageName, userId);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageUpgrading(String packageName, int[] userIds) {
            for (int userId : userIds) {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    OverlayManagerService.this.mPackageManager.forgetPackageInfo(packageName, userId);
                    OverlayInfo oi = OverlayManagerService.this.mImpl.getOverlayInfo(packageName, userId);
                    if (oi == null) {
                        OverlayManagerService.this.mImpl.onTargetPackageUpgrading(packageName, userId);
                    } else {
                        OverlayManagerService.this.mImpl.onOverlayPackageUpgrading(packageName, userId);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageUpgraded(String packageName, int[] userIds) {
            for (int userId : userIds) {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    PackageInfo pi = OverlayManagerService.this.mPackageManager.getPackageInfo(packageName, userId, false);
                    if (pi != null) {
                        OverlayManagerService.this.mPackageManager.cachePackageInfo(packageName, userId, pi);
                        if (!OverlayManagerService.this.isOverlayPackage(pi)) {
                            OverlayManagerService.this.mImpl.onTargetPackageUpgraded(packageName, userId);
                        } else {
                            OverlayManagerService.this.mImpl.onOverlayPackageUpgraded(packageName, userId);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageRemoved(String packageName, int[] userIds) {
            for (int userId : userIds) {
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    OverlayManagerService.this.mPackageManager.forgetPackageInfo(packageName, userId);
                    OverlayInfo oi = OverlayManagerService.this.mImpl.getOverlayInfo(packageName, userId);
                    if (oi == null) {
                        OverlayManagerService.this.mImpl.onTargetPackageRemoved(packageName, userId);
                    } else {
                        OverlayManagerService.this.mImpl.onOverlayPackageRemoved(packageName, userId);
                    }
                }
            }
        }
    }
}

