/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.OverlayInfo;
import android.content.pm.PackageInfo;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.om.IdmapManager;
import com.android.server.om.OverlayManagerSettings;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class OverlayManagerServiceImpl {
    private final PackageManagerHelper mPackageManager;
    private final IdmapManager mIdmapManager;
    private final OverlayManagerSettings mSettings;

    OverlayManagerServiceImpl(PackageManagerHelper packageManager, IdmapManager idmapManager, OverlayManagerSettings settings) {
        this.mPackageManager = packageManager;
        this.mIdmapManager = idmapManager;
        this.mSettings = settings;
    }

    List<String> onSwitchUser(int newUserId) {
        OverlayInfo oi;
        ArraySet<String> packagesToUpdateAssets = new ArraySet<String>();
        ArrayMap<String, List<OverlayInfo>> tmp = this.mSettings.getOverlaysForUser(newUserId);
        int tmpSize = tmp.size();
        ArrayMap<String, OverlayInfo> storedOverlayInfos = new ArrayMap<String, OverlayInfo>(tmpSize);
        for (int i = 0; i < tmpSize; ++i) {
            List<OverlayInfo> chunk = tmp.valueAt(i);
            int chunkSize = chunk.size();
            for (int j = 0; j < chunkSize; ++j) {
                oi = chunk.get(j);
                storedOverlayInfos.put(oi.packageName, oi);
            }
        }
        List<PackageInfo> overlayPackages = this.mPackageManager.getOverlayPackages(newUserId);
        int overlayPackagesSize = overlayPackages.size();
        for (int i = 0; i < overlayPackagesSize; ++i) {
            PackageInfo overlayPackage = overlayPackages.get(i);
            oi = (OverlayInfo)storedOverlayInfos.get(overlayPackage.packageName);
            if (oi == null || !oi.targetPackageName.equals(overlayPackage.overlayTarget)) {
                if (oi != null) {
                    packagesToUpdateAssets.add(oi.targetPackageName);
                }
                this.mSettings.init(overlayPackage.packageName, newUserId, overlayPackage.overlayTarget, overlayPackage.applicationInfo.getBaseCodePath());
            }
            try {
                PackageInfo targetPackage = this.mPackageManager.getPackageInfo(overlayPackage.overlayTarget, newUserId);
                this.updateState(targetPackage, overlayPackage, newUserId);
            }
            catch (OverlayManagerSettings.BadKeyException e) {
                Slog.e("OverlayManager", "failed to update settings", e);
                this.mSettings.remove(overlayPackage.packageName, newUserId);
            }
            packagesToUpdateAssets.add(overlayPackage.overlayTarget);
            storedOverlayInfos.remove(overlayPackage.packageName);
        }
        int storedOverlayInfosSize = storedOverlayInfos.size();
        for (int i = 0; i < storedOverlayInfosSize; ++i) {
            oi = (OverlayInfo)storedOverlayInfos.get(i);
            this.mSettings.remove(oi.packageName, oi.userId);
            this.removeIdmapIfPossible(oi);
            packagesToUpdateAssets.add(oi.targetPackageName);
        }
        Iterator iter = packagesToUpdateAssets.iterator();
        while (iter.hasNext()) {
            String targetPackageName = (String)iter.next();
            if (this.mPackageManager.getPackageInfo(targetPackageName, newUserId) != null) continue;
            iter.remove();
        }
        return new ArrayList<String>(packagesToUpdateAssets);
    }

    void onUserRemoved(int userId) {
        this.mSettings.removeUser(userId);
    }

    void onTargetPackageAdded(String packageName, int userId) {
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        this.updateAllOverlaysForTarget(packageName, userId, targetPackage);
    }

    void onTargetPackageChanged(String packageName, int userId) {
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        this.updateAllOverlaysForTarget(packageName, userId, targetPackage);
    }

    void onTargetPackageUpgrading(String packageName, int userId) {
        this.updateAllOverlaysForTarget(packageName, userId, null);
    }

    void onTargetPackageUpgraded(String packageName, int userId) {
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        this.updateAllOverlaysForTarget(packageName, userId, targetPackage);
    }

    void onTargetPackageRemoved(String packageName, int userId) {
        this.updateAllOverlaysForTarget(packageName, userId, null);
    }

    private void updateAllOverlaysForTarget(String packageName, int userId, PackageInfo targetPackage) {
        List<OverlayInfo> ois = this.mSettings.getOverlaysForTarget(packageName, userId);
        int N = ois.size();
        for (int i = 0; i < N; ++i) {
            OverlayInfo oi = ois.get(i);
            PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(oi.packageName, userId);
            if (overlayPackage == null) {
                this.mSettings.remove(oi.packageName, oi.userId);
                this.removeIdmapIfPossible(oi);
                continue;
            }
            try {
                this.updateState(targetPackage, overlayPackage, userId);
                continue;
            }
            catch (OverlayManagerSettings.BadKeyException e) {
                Slog.e("OverlayManager", "failed to update settings", e);
                this.mSettings.remove(oi.packageName, userId);
            }
        }
    }

    void onOverlayPackageAdded(String packageName, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            Slog.w("OverlayManager", "overlay package " + packageName + " was added, but couldn't be found");
            this.onOverlayPackageRemoved(packageName, userId);
            return;
        }
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(overlayPackage.overlayTarget, userId);
        this.mSettings.init(packageName, userId, overlayPackage.overlayTarget, overlayPackage.applicationInfo.getBaseCodePath());
        try {
            this.updateState(targetPackage, overlayPackage, userId);
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            Slog.e("OverlayManager", "failed to update settings", e);
            this.mSettings.remove(packageName, userId);
        }
    }

    void onOverlayPackageChanged(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageChanged called, but only pre-installed overlays supported");
    }

    void onOverlayPackageUpgrading(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageUpgrading called, but only pre-installed overlays supported");
    }

    void onOverlayPackageUpgraded(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageUpgraded called, but only pre-installed overlays supported");
    }

    void onOverlayPackageRemoved(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageRemoved called, but only pre-installed overlays supported");
    }

    OverlayInfo getOverlayInfo(String packageName, int userId) {
        try {
            return this.mSettings.getOverlayInfo(packageName, userId);
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return null;
        }
    }

    List<OverlayInfo> getOverlayInfosForTarget(String targetPackageName, int userId) {
        return this.mSettings.getOverlaysForTarget(targetPackageName, userId);
    }

    Map<String, List<OverlayInfo>> getOverlaysForUser(int userId) {
        return this.mSettings.getOverlaysForUser(userId);
    }

    boolean setEnabled(String packageName, boolean enable, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        try {
            OverlayInfo oi = this.mSettings.getOverlayInfo(packageName, userId);
            PackageInfo targetPackage = this.mPackageManager.getPackageInfo(oi.targetPackageName, userId);
            this.mSettings.setEnabled(packageName, userId, enable);
            this.updateState(targetPackage, overlayPackage, userId);
            return true;
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return false;
        }
    }

    boolean setPriority(String packageName, String newParentPackageName, int userId) {
        return this.mSettings.setPriority(packageName, newParentPackageName, userId);
    }

    boolean setHighestPriority(String packageName, int userId) {
        return this.mSettings.setHighestPriority(packageName, userId);
    }

    boolean setLowestPriority(String packageName, int userId) {
        return this.mSettings.setLowestPriority(packageName, userId);
    }

    void onDump(PrintWriter pw) {
        this.mSettings.dump(pw);
    }

    List<String> getEnabledOverlayPackageNames(String targetPackageName, int userId) {
        List<OverlayInfo> overlays = this.mSettings.getOverlaysForTarget(targetPackageName, userId);
        ArrayList<String> paths = new ArrayList<String>(overlays.size());
        int N = overlays.size();
        for (int i = 0; i < N; ++i) {
            OverlayInfo oi = overlays.get(i);
            if (!oi.isEnabled()) continue;
            paths.add(oi.packageName);
        }
        return paths;
    }

    private void updateState(PackageInfo targetPackage, PackageInfo overlayPackage, int userId) throws OverlayManagerSettings.BadKeyException {
        if (targetPackage != null) {
            this.mIdmapManager.createIdmap(targetPackage, overlayPackage, userId);
        }
        this.mSettings.setBaseCodePath(overlayPackage.packageName, userId, overlayPackage.applicationInfo.getBaseCodePath());
        int currentState = this.mSettings.getState(overlayPackage.packageName, userId);
        int newState = this.calculateNewState(targetPackage, overlayPackage, userId);
        if (currentState != newState) {
            this.mSettings.setState(overlayPackage.packageName, userId, newState);
        }
    }

    private int calculateNewState(PackageInfo targetPackage, PackageInfo overlayPackage, int userId) throws OverlayManagerSettings.BadKeyException {
        if (targetPackage == null) {
            return 0;
        }
        if (!this.mIdmapManager.idmapExists(overlayPackage, userId)) {
            return 1;
        }
        boolean enabled = this.mSettings.getEnabled(overlayPackage.packageName, userId);
        return enabled ? 3 : 2;
    }

    private void removeIdmapIfPossible(OverlayInfo oi) {
        if (!this.mIdmapManager.idmapExists(oi)) {
            return;
        }
        List<Integer> userIds = this.mSettings.getUsers();
        int N = userIds.size();
        for (int i = 0; i < N; ++i) {
            int userId = userIds.get(i);
            try {
                OverlayInfo tmp = this.mSettings.getOverlayInfo(oi.packageName, userId);
                if (tmp == null || !tmp.isEnabled()) continue;
                return;
            }
            catch (OverlayManagerSettings.BadKeyException badKeyException) {
                // empty catch block
            }
        }
        this.mIdmapManager.removeIdmap(oi, oi.userId);
    }

    static interface PackageManagerHelper {
        public PackageInfo getPackageInfo(String var1, int var2);

        public boolean signaturesMatching(String var1, String var2, int var3);

        public List<PackageInfo> getOverlayPackages(int var1);
    }
}

