/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.OverlayInfo;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

final class OverlayManagerSettings {
    private final List<ChangeListener> mListeners = new ArrayList<ChangeListener>();
    private final ArrayList<SettingsItem> mItems = new ArrayList();
    private static final String TAB1 = "    ";
    private static final String TAB2 = "        ";
    private static final String TAB3 = "            ";

    OverlayManagerSettings() {
    }

    void init(String packageName, int userId, String targetPackageName, String baseCodePath) {
        this.remove(packageName, userId);
        SettingsItem item = new SettingsItem(packageName, userId, targetPackageName, baseCodePath);
        this.mItems.add(item);
    }

    void remove(String packageName, int userId) {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            return;
        }
        OverlayInfo oi = item.getOverlayInfo();
        this.mItems.remove(item);
        if (oi != null) {
            this.notifyOverlayRemoved(oi);
        }
    }

    boolean contains(String packageName, int userId) {
        return this.select(packageName, userId) != null;
    }

    OverlayInfo getOverlayInfo(String packageName, int userId) throws BadKeyException {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            throw new BadKeyException(packageName, userId);
        }
        return item.getOverlayInfo();
    }

    String getTargetPackageName(String packageName, int userId) throws BadKeyException {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            throw new BadKeyException(packageName, userId);
        }
        return item.getTargetPackageName();
    }

    void setBaseCodePath(String packageName, int userId, String path) throws BadKeyException {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            throw new BadKeyException(packageName, userId);
        }
        item.setBaseCodePath(path);
        this.notifySettingsChanged();
    }

    boolean getEnabled(String packageName, int userId) throws BadKeyException {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            throw new BadKeyException(packageName, userId);
        }
        return item.isEnabled();
    }

    void setEnabled(String packageName, int userId, boolean enable) throws BadKeyException {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            throw new BadKeyException(packageName, userId);
        }
        if (enable == item.isEnabled()) {
            return;
        }
        item.setEnabled(enable);
        this.notifySettingsChanged();
    }

    int getState(String packageName, int userId) throws BadKeyException {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            throw new BadKeyException(packageName, userId);
        }
        return item.getState();
    }

    void setState(String packageName, int userId, int state) throws BadKeyException {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            throw new BadKeyException(packageName, userId);
        }
        OverlayInfo previous = item.getOverlayInfo();
        item.setState(state);
        OverlayInfo current = item.getOverlayInfo();
        if (previous.state == -1) {
            this.notifyOverlayAdded(current);
            this.notifySettingsChanged();
        } else if (current.state != previous.state) {
            this.notifyOverlayChanged(current, previous);
            this.notifySettingsChanged();
        }
    }

    List<OverlayInfo> getOverlaysForTarget(String targetPackageName, int userId) {
        List<SettingsItem> items = this.selectWhereTarget(targetPackageName, userId);
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OverlayInfo> out = new ArrayList<OverlayInfo>(items.size());
        int N = items.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = items.get(i);
            out.add(item.getOverlayInfo());
        }
        return out;
    }

    ArrayMap<String, List<OverlayInfo>> getOverlaysForUser(int userId) {
        List<SettingsItem> items = this.selectWhereUser(userId);
        if (items.isEmpty()) {
            return ArrayMap.EMPTY;
        }
        ArrayMap<String, List<OverlayInfo>> out = new ArrayMap<String, List<OverlayInfo>>(items.size());
        int N = items.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = items.get(i);
            String targetPackageName = item.getTargetPackageName();
            if (!out.containsKey(targetPackageName)) {
                out.put(targetPackageName, new ArrayList());
            }
            List<OverlayInfo> overlays = out.get(targetPackageName);
            overlays.add(item.getOverlayInfo());
        }
        return out;
    }

    List<String> getTargetPackageNamesForUser(int userId) {
        List<SettingsItem> items = this.selectWhereUser(userId);
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> out = new ArrayList<String>();
        int N = items.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = items.get(i);
            String targetPackageName = item.getTargetPackageName();
            if (out.contains(targetPackageName)) continue;
            out.add(targetPackageName);
        }
        return out;
    }

    List<Integer> getUsers() {
        ArrayList<Integer> users = new ArrayList<Integer>();
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = this.mItems.get(i);
            if (users.contains(item.userId)) continue;
            users.add(item.userId);
        }
        return users;
    }

    void removeUser(int userId) {
        Iterator<SettingsItem> iter = this.mItems.iterator();
        while (iter.hasNext()) {
            SettingsItem item = iter.next();
            if (item.userId != userId) continue;
            iter.remove();
        }
    }

    boolean setPriority(String packageName, String newParentPackageName, int userId) {
        if (packageName.equals(newParentPackageName)) {
            return false;
        }
        SettingsItem rowToMove = this.select(packageName, userId);
        if (rowToMove == null) {
            return false;
        }
        SettingsItem newParentRow = this.select(newParentPackageName, userId);
        if (newParentRow == null) {
            return false;
        }
        if (!rowToMove.getTargetPackageName().equals(newParentRow.getTargetPackageName())) {
            return false;
        }
        this.mItems.remove(rowToMove);
        ListIterator<SettingsItem> iter = this.mItems.listIterator();
        while (iter.hasNext()) {
            SettingsItem item = iter.next();
            if (item.userId != userId || !item.packageName.equals(newParentPackageName)) continue;
            iter.add(rowToMove);
            this.notifyOverlayPriorityChanged(rowToMove.getOverlayInfo());
            this.notifySettingsChanged();
            return true;
        }
        Slog.wtf("OverlayManager", "failed to find the parent item a second time");
        return false;
    }

    boolean setLowestPriority(String packageName, int userId) {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            return false;
        }
        this.mItems.remove(item);
        this.mItems.add(0, item);
        this.notifyOverlayPriorityChanged(item.getOverlayInfo());
        this.notifySettingsChanged();
        return true;
    }

    boolean setHighestPriority(String packageName, int userId) {
        SettingsItem item = this.select(packageName, userId);
        if (item == null) {
            return false;
        }
        this.mItems.remove(item);
        this.mItems.add(item);
        this.notifyOverlayPriorityChanged(item.getOverlayInfo());
        this.notifySettingsChanged();
        return true;
    }

    void dump(PrintWriter pw) {
        pw.println("Settings");
        this.dumpItems(pw);
        this.dumpListeners(pw);
    }

    private void dumpItems(PrintWriter pw) {
        pw.println("    Items");
        if (this.mItems.isEmpty()) {
            pw.println("        <none>");
            return;
        }
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = this.mItems.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append(TAB2 + item.packageName + ":" + item.userId + " {\n");
            sb.append("            packageName.......: " + item.packageName + "\n");
            sb.append("            userId............: " + item.userId + "\n");
            sb.append("            targetPackageName.: " + item.getTargetPackageName() + "\n");
            sb.append("            baseCodePath......: " + item.getBaseCodePath() + "\n");
            sb.append("            state.............: " + OverlayInfo.stateToString(item.getState()) + "\n");
            sb.append("            isEnabled.........: " + item.isEnabled() + "\n");
            sb.append("        }");
            pw.println(sb.toString());
        }
    }

    private void dumpListeners(PrintWriter pw) {
        pw.println("    Change listeners");
        if (this.mListeners.isEmpty()) {
            pw.println("        <none>");
            return;
        }
        int N = this.mListeners.size();
        for (int i = 0; i < N; ++i) {
            ChangeListener ch = this.mListeners.get(i);
            pw.println(TAB2 + ch);
        }
    }

    void restore(InputStream is) throws IOException, XmlPullParserException {
        Serializer.restore(this.mItems, is);
    }

    void persist(OutputStream os) throws IOException, XmlPullParserException {
        Serializer.persist(this.mItems, os);
    }

    private SettingsItem select(String packageName, int userId) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = this.mItems.get(i);
            if (item.userId != userId || !item.packageName.equals(packageName)) continue;
            return item;
        }
        return null;
    }

    private List<SettingsItem> selectWhereUser(int userId) {
        ArrayList<SettingsItem> items = new ArrayList<SettingsItem>();
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = this.mItems.get(i);
            if (item.userId != userId) continue;
            items.add(item);
        }
        return items;
    }

    private List<SettingsItem> selectWhereTarget(String targetPackageName, int userId) {
        ArrayList<SettingsItem> items = new ArrayList<SettingsItem>();
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            SettingsItem item = this.mItems.get(i);
            if (item.userId != userId || !item.getTargetPackageName().equals(targetPackageName)) continue;
            items.add(item);
        }
        return items;
    }

    private void assertNotNull(Object o) {
        if (o == null) {
            throw new AndroidRuntimeException("object must not be null");
        }
    }

    void addChangeListener(ChangeListener listener) {
        this.mListeners.add(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.mListeners.remove(listener);
    }

    private void notifySettingsChanged() {
        int N = this.mListeners.size();
        for (int i = 0; i < N; ++i) {
            ChangeListener listener = this.mListeners.get(i);
            listener.onSettingsChanged();
        }
    }

    private void notifyOverlayAdded(OverlayInfo oi) {
        int N = this.mListeners.size();
        for (int i = 0; i < N; ++i) {
            ChangeListener listener = this.mListeners.get(i);
            listener.onOverlayAdded(oi);
        }
    }

    private void notifyOverlayRemoved(OverlayInfo oi) {
        int N = this.mListeners.size();
        for (int i = 0; i < N; ++i) {
            ChangeListener listener = this.mListeners.get(i);
            listener.onOverlayRemoved(oi);
        }
    }

    private void notifyOverlayChanged(OverlayInfo oi, OverlayInfo oldOi) {
        int N = this.mListeners.size();
        for (int i = 0; i < N; ++i) {
            ChangeListener listener = this.mListeners.get(i);
            listener.onOverlayChanged(oi, oldOi);
        }
    }

    private void notifyOverlayPriorityChanged(OverlayInfo oi) {
        int N = this.mListeners.size();
        for (int i = 0; i < N; ++i) {
            ChangeListener listener = this.mListeners.get(i);
            listener.onOverlayPriorityChanged(oi);
        }
    }

    static final class BadKeyException
    extends RuntimeException {
        BadKeyException(String packageName, int userId) {
            super("Bad key packageName=" + packageName + " userId=" + userId);
        }
    }

    static interface ChangeListener {
        public void onSettingsChanged();

        public void onOverlayAdded(OverlayInfo var1);

        public void onOverlayRemoved(OverlayInfo var1);

        public void onOverlayChanged(OverlayInfo var1, OverlayInfo var2);

        public void onOverlayPriorityChanged(OverlayInfo var1);
    }

    private static final class SettingsItem {
        private final int userId;
        private final String packageName;
        private final String targetPackageName;
        private String baseCodePath;
        private int state;
        private boolean isEnabled;
        private OverlayInfo cache;

        SettingsItem(String packageName, int userId, String targetPackageName, String baseCodePath, int state, boolean isEnabled) {
            this.packageName = packageName;
            this.userId = userId;
            this.targetPackageName = targetPackageName;
            this.baseCodePath = baseCodePath;
            this.state = state;
            this.isEnabled = isEnabled;
            this.cache = null;
        }

        SettingsItem(String packageName, int userId, String targetPackageName, String baseCodePath) {
            this(packageName, userId, targetPackageName, baseCodePath, -1, false);
        }

        private String getTargetPackageName() {
            return this.targetPackageName;
        }

        private String getBaseCodePath() {
            return this.baseCodePath;
        }

        private void setBaseCodePath(String path) {
            if (!this.baseCodePath.equals(path)) {
                this.baseCodePath = path;
                this.invalidateCache();
            }
        }

        private int getState() {
            return this.state;
        }

        private void setState(int state) {
            if (this.state != state) {
                this.state = state;
                this.invalidateCache();
            }
        }

        private boolean isEnabled() {
            return this.isEnabled;
        }

        private void setEnabled(boolean enable) {
            if (this.isEnabled != enable) {
                this.isEnabled = enable;
                this.invalidateCache();
            }
        }

        private OverlayInfo getOverlayInfo() {
            if (this.cache == null) {
                this.cache = new OverlayInfo(this.packageName, this.targetPackageName, this.baseCodePath, this.state, this.userId);
            }
            return this.cache;
        }

        private void invalidateCache() {
            this.cache = null;
        }
    }

    private static final class Serializer {
        private static final String TAG_OVERLAYS = "overlays";
        private static final String TAG_ITEM = "item";
        private static final String ATTR_BASE_CODE_PATH = "baseCodePath";
        private static final String ATTR_IS_ENABLED = "isEnabled";
        private static final String ATTR_PACKAGE_NAME = "packageName";
        private static final String ATTR_STATE = "state";
        private static final String ATTR_TARGET_PACKAGE_NAME = "targetPackageName";
        private static final String ATTR_USER_ID = "userId";
        private static final String ATTR_VERSION = "version";
        private static final int CURRENT_VERSION = 1;

        private Serializer() {
        }

        public static void restore(ArrayList<SettingsItem> table, InputStream is) throws IOException, XmlPullParserException {
            try (InputStreamReader reader = new InputStreamReader(is);){
                table.clear();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(reader);
                XmlUtils.beginDocument(parser, TAG_OVERLAYS);
                int version = XmlUtils.readIntAttribute(parser, ATTR_VERSION);
                if (version != 1) {
                    throw new XmlPullParserException("unrecognized version " + version);
                }
                int depth = parser.getDepth();
                while (XmlUtils.nextElementWithin(parser, depth)) {
                    switch (parser.getName()) {
                        case "item": {
                            SettingsItem item = Serializer.restoreRow(parser, depth + 1);
                            table.add(item);
                        }
                    }
                }
            }
        }

        private static SettingsItem restoreRow(XmlPullParser parser, int depth) throws IOException {
            String packageName = XmlUtils.readStringAttribute(parser, ATTR_PACKAGE_NAME);
            int userId = XmlUtils.readIntAttribute(parser, ATTR_USER_ID);
            String targetPackageName = XmlUtils.readStringAttribute(parser, ATTR_TARGET_PACKAGE_NAME);
            String baseCodePath = XmlUtils.readStringAttribute(parser, ATTR_BASE_CODE_PATH);
            int state = XmlUtils.readIntAttribute(parser, ATTR_STATE);
            boolean isEnabled = XmlUtils.readBooleanAttribute(parser, ATTR_IS_ENABLED);
            return new SettingsItem(packageName, userId, targetPackageName, baseCodePath, state, isEnabled);
        }

        public static void persist(ArrayList<SettingsItem> table, OutputStream os) throws IOException, XmlPullParserException {
            FastXmlSerializer xml2 = new FastXmlSerializer();
            xml2.setOutput(os, "utf-8");
            xml2.startDocument(null, true);
            xml2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            xml2.startTag(null, TAG_OVERLAYS);
            XmlUtils.writeIntAttribute(xml2, ATTR_VERSION, 1);
            int N = table.size();
            for (int i = 0; i < N; ++i) {
                SettingsItem item = table.get(i);
                Serializer.persistRow(xml2, item);
            }
            xml2.endTag(null, TAG_OVERLAYS);
            xml2.endDocument();
        }

        private static void persistRow(FastXmlSerializer xml2, SettingsItem item) throws IOException {
            xml2.startTag(null, TAG_ITEM);
            XmlUtils.writeStringAttribute(xml2, ATTR_PACKAGE_NAME, item.packageName);
            XmlUtils.writeIntAttribute(xml2, ATTR_USER_ID, item.userId);
            XmlUtils.writeStringAttribute(xml2, ATTR_TARGET_PACKAGE_NAME, item.targetPackageName);
            XmlUtils.writeStringAttribute(xml2, ATTR_BASE_CODE_PATH, item.baseCodePath);
            XmlUtils.writeIntAttribute(xml2, ATTR_STATE, item.state);
            XmlUtils.writeBooleanAttribute(xml2, ATTR_IS_ENABLED, item.isEnabled);
            xml2.endTag(null, TAG_ITEM);
        }
    }
}

