/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.os;

import android.os.Binder;
import android.os.ISchedulingPolicyService;
import android.os.Process;

public class SchedulingPolicyService
extends ISchedulingPolicyService.Stub {
    private static final String TAG = "SchedulingPolicyService";
    private static final int PRIORITY_MIN = 1;
    private static final int PRIORITY_MAX = 3;

    @Override
    public int requestPriority(int pid, int tid, int prio, boolean isForApp) {
        if (!this.isPermittedCallingUid() || prio < 1 || prio > 3 || Process.getThreadGroupLeader(tid) != pid) {
            return -1;
        }
        try {
            Process.setThreadGroup(tid, !isForApp ? 4 : 3);
            Process.setThreadScheduler(tid, 0x40000001, prio);
        }
        catch (RuntimeException e) {
            return -1;
        }
        return 0;
    }

    private boolean isPermittedCallingUid() {
        int callingUid = Binder.getCallingUid();
        switch (callingUid) {
            case 1041: 
            case 1047: {
                return true;
            }
        }
        return false;
    }
}

