/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManagerNative;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.EphemeralIntentFilter;
import android.content.pm.EphemeralRequest;
import android.content.pm.EphemeralResolveInfo;
import android.content.pm.EphemeralResponse;
import android.os.Handler;
import android.os.RemoteException;
import com.android.server.pm.EphemeralResolverConnection;
import com.android.server.pm.PackageManagerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public abstract class EphemeralResolver {
    public static EphemeralResponse doEphemeralResolutionPhaseOne(Context context, EphemeralResolverConnection connection, EphemeralRequest requestObj) {
        Intent intent = requestObj.origIntent;
        EphemeralResolveInfo.EphemeralDigest digest = new EphemeralResolveInfo.EphemeralDigest(intent.getData().getHost(), 5);
        int[] shaPrefix = digest.getDigestPrefix();
        List<EphemeralResolveInfo> ephemeralResolveInfoList = connection.getEphemeralResolveInfoList(shaPrefix);
        if (ephemeralResolveInfoList == null || ephemeralResolveInfoList.size() == 0) {
            return null;
        }
        String token = UUID.randomUUID().toString();
        return EphemeralResolver.filterEphemeralIntent(ephemeralResolveInfoList, intent, requestObj.resolvedType, requestObj.userId, intent.getPackage(), digest, token);
    }

    public static void doEphemeralResolutionPhaseTwo(final Context context, EphemeralResolverConnection connection, final EphemeralRequest requestObj, final ActivityInfo ephemeralInstaller, Handler callbackHandler) {
        final Intent intent = requestObj.origIntent;
        String hostName = intent.getData().getHost();
        final EphemeralResolveInfo.EphemeralDigest digest = new EphemeralResolveInfo.EphemeralDigest(hostName, 5);
        EphemeralResolverConnection.PhaseTwoCallback callback = new EphemeralResolverConnection.PhaseTwoCallback(){

            @Override
            void onPhaseTwoResolved(EphemeralResolveInfo ephemeralResolveInfo, int sequence) {
                int versionCode;
                String splitName;
                String packageName;
                if (ephemeralResolveInfo != null) {
                    ArrayList<EphemeralResolveInfo> ephemeralResolveInfoList = new ArrayList<EphemeralResolveInfo>(1);
                    ephemeralResolveInfoList.add(ephemeralResolveInfo);
                    EphemeralResponse ephemeralIntentInfo = EphemeralResolver.filterEphemeralIntent(ephemeralResolveInfoList, intent, null, 0, intent.getPackage(), digest, requestObj.responseObj.token);
                    if (ephemeralIntentInfo != null && ephemeralIntentInfo.resolveInfo != null) {
                        packageName = ephemeralIntentInfo.resolveInfo.getPackageName();
                        splitName = ephemeralIntentInfo.splitName;
                        versionCode = ephemeralIntentInfo.resolveInfo.getVersionCode();
                    } else {
                        packageName = null;
                        splitName = null;
                        versionCode = -1;
                    }
                } else {
                    packageName = null;
                    splitName = null;
                    versionCode = -1;
                }
                Intent installerIntent = EphemeralResolver.buildEphemeralInstallerIntent(requestObj.launchIntent, requestObj.origIntent, requestObj.callingPackage, requestObj.resolvedType, requestObj.userId, packageName, splitName, versionCode, requestObj.responseObj.token, false);
                installerIntent.setComponent(new ComponentName(ephemeralInstaller.packageName, ephemeralInstaller.name));
                context.startActivity(installerIntent);
            }
        };
        connection.getEphemeralIntentFilterList(hostName, callback, callbackHandler, 0);
    }

    public static Intent buildEphemeralInstallerIntent(Intent launchIntent, Intent origIntent, String callingPackage, String resolvedType, int userId, String ephemeralPackageName, String ephemeralSplitName, int versionCode, String token, boolean needsPhaseTwo) {
        int flags = launchIntent.getFlags();
        Intent intent = new Intent();
        intent.setFlags(flags | 0x10000000 | 0x8000 | 0x40000000 | 0x800000);
        intent.setData(origIntent.getData().buildUpon().clearQuery().build());
        intent.putExtra("android.intent.extra.EPHEMERAL_TOKEN", token);
        intent.putExtra("android.intent.extra.EPHEMERAL_HOSTNAME", origIntent.getData().getHost());
        if (!needsPhaseTwo) {
            Intent nonEphemeralIntent = new Intent(origIntent);
            nonEphemeralIntent.setFlags(nonEphemeralIntent.getFlags() | 0x200);
            try {
                IIntentSender failureIntentTarget = ActivityManagerNative.getDefault().getIntentSender(2, callingPackage, null, null, 1, new Intent[]{nonEphemeralIntent}, new String[]{resolvedType}, 0x54000000, null, userId);
                intent.putExtra("android.intent.extra.EPHEMERAL_FAILURE", new IntentSender(failureIntentTarget));
            }
            catch (RemoteException failureIntentTarget) {
                // empty catch block
            }
            Intent ephemeralIntent = new Intent(launchIntent).setComponent(null).setPackage(ephemeralPackageName);
            try {
                IIntentSender successIntentTarget = ActivityManagerNative.getDefault().getIntentSender(2, callingPackage, null, null, 0, new Intent[]{ephemeralIntent}, new String[]{resolvedType}, 0x54000000, null, userId);
                intent.putExtra("android.intent.extra.EPHEMERAL_SUCCESS", new IntentSender(successIntentTarget));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            intent.putExtra("android.intent.extra.PACKAGE_NAME", ephemeralPackageName);
            intent.putExtra("android.intent.extra.SPLIT_NAME", ephemeralSplitName);
            intent.putExtra("android.intent.extra.VERSION_CODE", versionCode);
        }
        return intent;
    }

    private static EphemeralResponse filterEphemeralIntent(List<EphemeralResolveInfo> ephemeralResolveInfoList, Intent intent, String resolvedType, int userId, String packageName, EphemeralResolveInfo.EphemeralDigest digest, String token) {
        int[] shaPrefix = digest.getDigestPrefix();
        byte[][] digestBytes = digest.getDigestBytes();
        for (int i = shaPrefix.length - 1; i >= 0; --i) {
            for (EphemeralResolveInfo ephemeralInfo : ephemeralResolveInfoList) {
                if (!Arrays.equals(digestBytes[i], ephemeralInfo.getDigestBytes()) || packageName != null && !packageName.equals(ephemeralInfo.getPackageName())) continue;
                List<EphemeralIntentFilter> ephemeralFilters = ephemeralInfo.getIntentFilters();
                if (ephemeralFilters == null || ephemeralFilters.isEmpty()) {
                    return new EphemeralResponse(ephemeralInfo, new IntentFilter("android.intent.action.VIEW"), null, token, true);
                }
                PackageManagerService.EphemeralIntentResolver ephemeralResolver = new PackageManagerService.EphemeralIntentResolver();
                for (int j = ephemeralFilters.size() - 1; j >= 0; --j) {
                    EphemeralIntentFilter ephemeralFilter = ephemeralFilters.get(j);
                    List<IntentFilter> splitFilters = ephemeralFilter.getFilters();
                    if (splitFilters == null || splitFilters.isEmpty()) continue;
                    for (int k = splitFilters.size() - 1; k >= 0; --k) {
                        EphemeralResponse intentInfo = new EphemeralResponse(ephemeralInfo, splitFilters.get(k), ephemeralFilter.getSplitName(), token, false);
                        ephemeralResolver.addFilter(intentInfo);
                    }
                }
                List matchedResolveInfoList = ephemeralResolver.queryIntent(intent, resolvedType, false, userId);
                if (matchedResolveInfoList.isEmpty()) continue;
                return (EphemeralResponse)matchedResolveInfoList.get(0);
            }
        }
        return null;
    }
}

