/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.IOtaDexopt;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.OtaDexoptShellCommand;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.PackageManagerServiceUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OtaDexoptService
extends IOtaDexopt.Stub {
    private static final String TAG = "OTADexopt";
    private static final boolean DEBUG_DEXOPT = true;
    private static final String[] NO_LIBRARIES = new String[]{"&"};
    private static final long BULK_DELETE_THRESHOLD = 0x40000000L;
    private final Context mContext;
    private final PackageManagerService mPackageManagerService;
    private List<String> mDexoptCommands;
    private int completeSize;
    private long availableSpaceBefore;
    private long availableSpaceAfterBulkDelete;
    private long availableSpaceAfterDexopt;
    private int importantPackageCount;
    private int otherPackageCount;
    private int dexoptCommandCountTotal;
    private int dexoptCommandCountExecuted;
    private long otaDexoptTimeStart;

    public OtaDexoptService(Context context, PackageManagerService packageManagerService) {
        this.mContext = context;
        this.mPackageManagerService = packageManagerService;
        this.moveAbArtifacts(packageManagerService.mInstaller);
    }

    public static OtaDexoptService main(Context context, PackageManagerService packageManagerService) {
        OtaDexoptService ota = new OtaDexoptService(context, packageManagerService);
        ServiceManager.addService("otadexopt", ota);
        return ota;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new OtaDexoptShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void prepare() throws RemoteException {
        ArrayList<PackageParser.Package> others;
        List<PackageParser.Package> important;
        if (this.mDexoptCommands != null) {
            throw new IllegalStateException("already called prepare()");
        }
        Iterator iterator = this.mPackageManagerService.mPackages;
        synchronized (iterator) {
            important = PackageManagerServiceUtils.getPackagesForDexopt(this.mPackageManagerService.mPackages.values(), this.mPackageManagerService);
            others = new ArrayList<PackageParser.Package>(this.mPackageManagerService.mPackages.values());
            others.removeAll(important);
            this.mDexoptCommands = new ArrayList<String>(3 * this.mPackageManagerService.mPackages.size() / 2);
        }
        for (PackageParser.Package p : important) {
            int compilationReason = p.coreApp ? 8 : 4;
            this.mDexoptCommands.addAll(this.generatePackageDexopts(p, compilationReason));
        }
        for (PackageParser.Package p : others) {
            if (p.coreApp) {
                throw new IllegalStateException("Found a core app that's not important");
            }
            this.mDexoptCommands.addAll(this.generatePackageDexopts(p, 0));
        }
        this.completeSize = this.mDexoptCommands.size();
        long spaceAvailable = this.getAvailableSpace();
        if (spaceAvailable < 0x40000000L) {
            Log.i(TAG, "Low on space, deleting oat files in an attempt to free up space: " + PackageManagerServiceUtils.packagesToString(others));
            for (PackageParser.Package pkg : others) {
                this.deleteOatArtifactsOfPackage(pkg);
            }
        }
        long spaceAvailableNow = this.getAvailableSpace();
        this.prepareMetricsLogging(important.size(), others.size(), spaceAvailable, spaceAvailableNow);
    }

    @Override
    public synchronized void cleanup() throws RemoteException {
        Log.i(TAG, "Cleaning up OTA Dexopt state.");
        this.mDexoptCommands = null;
        this.availableSpaceAfterDexopt = this.getAvailableSpace();
        this.performMetricsLogging();
    }

    @Override
    public synchronized boolean isDone() throws RemoteException {
        if (this.mDexoptCommands == null) {
            throw new IllegalStateException("done() called before prepare()");
        }
        return this.mDexoptCommands.isEmpty();
    }

    @Override
    public synchronized float getProgress() throws RemoteException {
        if (this.completeSize == 0) {
            return 1.0f;
        }
        int commandsLeft = this.mDexoptCommands.size();
        return (float)(this.completeSize - commandsLeft) / (float)this.completeSize;
    }

    @Override
    public synchronized String nextDexoptCommand() throws RemoteException {
        if (this.mDexoptCommands == null) {
            throw new IllegalStateException("dexoptNextPackage() called before prepare()");
        }
        if (this.mDexoptCommands.isEmpty()) {
            return "(all done)";
        }
        String next = this.mDexoptCommands.remove(0);
        if (this.getAvailableSpace() > 0L) {
            ++this.dexoptCommandCountExecuted;
            return next;
        }
        Log.w(TAG, "Not enough space for OTA dexopt, stopping with " + (this.mDexoptCommands.size() + 1) + " commands left.");
        this.mDexoptCommands.clear();
        return "(no free space)";
    }

    private long getMainLowSpaceThreshold() {
        File dataDir = Environment.getDataDirectory();
        long lowThreshold = StorageManager.from(this.mContext).getStorageLowBytes(dataDir);
        if (lowThreshold == 0L) {
            throw new IllegalStateException("Invalid low memory threshold");
        }
        return lowThreshold;
    }

    private long getAvailableSpace() {
        long lowThreshold = this.getMainLowSpaceThreshold();
        File dataDir = Environment.getDataDirectory();
        long usableSpace = dataDir.getUsableSpace();
        return usableSpace - lowThreshold;
    }

    private static String getOatDir(PackageParser.Package pkg) {
        if (!pkg.canHaveOatDir()) {
            return null;
        }
        File codePath = new File(pkg.codePath);
        if (codePath.isDirectory()) {
            return PackageDexOptimizer.getOatDir(codePath).getAbsolutePath();
        }
        return null;
    }

    private void deleteOatArtifactsOfPackage(PackageParser.Package pkg) {
        String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        for (String codePath : pkg.getAllCodePaths()) {
            for (String isa : instructionSets) {
                try {
                    this.mPackageManagerService.mInstaller.deleteOdex(codePath, isa, OtaDexoptService.getOatDir(pkg));
                }
                catch (Installer.InstallerException e) {
                    Log.e(TAG, "Failed deleting oat files for " + codePath, e);
                }
            }
        }
    }

    private synchronized List<String> generatePackageDexopts(PackageParser.Package pkg, int compilationReason) {
        final ArrayList<String> commands = new ArrayList<String>();
        Installer collectingInstaller = new Installer(this.mContext, true){

            @Override
            public void dexopt(String apkPath, int uid, String pkgName, String instructionSet, int dexoptNeeded, String outputPath, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries) throws Installer.InstallerException {
                commands.add(OtaDexoptService.buildCommand(new Object[]{"dexopt", apkPath, uid, pkgName, instructionSet, dexoptNeeded, outputPath, dexFlags, compilerFilter, volumeUuid, sharedLibraries}));
            }
        };
        OTADexoptPackageDexOptimizer optimizer = new OTADexoptPackageDexOptimizer(collectingInstaller, this.mPackageManagerService.mInstallLock, this.mContext);
        String[] libraryDependencies = pkg.usesLibraryFiles;
        if (pkg.isSystemApp()) {
            libraryDependencies = NO_LIBRARIES;
        }
        optimizer.performDexOpt(pkg, libraryDependencies, null, false, PackageManagerServiceCompilerMapping.getCompilerFilterForReason(compilationReason), null);
        return commands;
    }

    @Override
    public synchronized void dexoptNextPackage() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    private void moveAbArtifacts(Installer installer) {
        if (this.mDexoptCommands != null) {
            throw new IllegalStateException("Should not be ota-dexopting when trying to move.");
        }
        Collection<PackageParser.Package> pkgs = this.mPackageManagerService.getPackages();
        for (PackageParser.Package pkg : pkgs) {
            String[] dexCodeInstructionSets;
            if (pkg == null || !PackageDexOptimizer.canOptimizePackage(pkg)) continue;
            if (pkg.codePath == null) {
                Slog.w(TAG, "Package " + pkg + " can be optimized but has null codePath");
                continue;
            }
            if (pkg.codePath.startsWith("/system") || pkg.codePath.startsWith("/vendor")) continue;
            String[] instructionSets = InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
            List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
            for (String dexCodeInstructionSet : dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets)) {
                for (String path : paths) {
                    String oatDir = PackageDexOptimizer.getOatDir(new File(pkg.codePath)).getAbsolutePath();
                    try {
                        installer.moveAb(path, dexCodeInstructionSet, oatDir);
                    }
                    catch (Installer.InstallerException installerException) {}
                }
            }
        }
    }

    private void prepareMetricsLogging(int important, int others, long spaceBegin, long spaceBulk) {
        this.availableSpaceBefore = spaceBegin;
        this.availableSpaceAfterBulkDelete = spaceBulk;
        this.availableSpaceAfterDexopt = 0L;
        this.importantPackageCount = important;
        this.otherPackageCount = others;
        this.dexoptCommandCountTotal = this.mDexoptCommands.size();
        this.dexoptCommandCountExecuted = 0;
        this.otaDexoptTimeStart = System.nanoTime();
    }

    private static int inMegabytes(long value) {
        long in_mega_bytes = value / 0x100000L;
        if (in_mega_bytes > Integer.MAX_VALUE) {
            Log.w(TAG, "Recording " + in_mega_bytes + "MB of free space, overflowing range");
            return Integer.MAX_VALUE;
        }
        return (int)in_mega_bytes;
    }

    private void performMetricsLogging() {
        long finalTime = System.nanoTime();
        MetricsLogger.histogram(this.mContext, "ota_dexopt_available_space_before_mb", OtaDexoptService.inMegabytes(this.availableSpaceBefore));
        MetricsLogger.histogram(this.mContext, "ota_dexopt_available_space_after_bulk_delete_mb", OtaDexoptService.inMegabytes(this.availableSpaceAfterBulkDelete));
        MetricsLogger.histogram(this.mContext, "ota_dexopt_available_space_after_dexopt_mb", OtaDexoptService.inMegabytes(this.availableSpaceAfterDexopt));
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_important_packages", this.importantPackageCount);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_other_packages", this.otherPackageCount);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_commands", this.dexoptCommandCountTotal);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_num_commands_executed", this.dexoptCommandCountExecuted);
        int elapsedTimeSeconds = (int)TimeUnit.NANOSECONDS.toSeconds(finalTime - this.otaDexoptTimeStart);
        MetricsLogger.histogram(this.mContext, "ota_dexopt_time_s", elapsedTimeSeconds);
    }

    private static String buildCommand(Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            String escaped = arg == null ? "" : String.valueOf(arg);
            if (escaped.indexOf(0) != -1 || escaped.indexOf(32) != -1 || "!".equals(escaped)) {
                throw new IllegalArgumentException("Invalid argument while executing " + Arrays.toString(args));
            }
            if (TextUtils.isEmpty(escaped)) {
                escaped = "!";
            }
            builder.append(' ').append(escaped);
        }
        return builder.toString();
    }

    private static class OTADexoptPackageDexOptimizer
    extends PackageDexOptimizer.ForcedUpdatePackageDexOptimizer {
        public OTADexoptPackageDexOptimizer(Installer installer, Object installLock, Context context) {
            super(installer, installLock, context, "*otadexopt*");
        }
    }
}

