/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.AppGlobals;
import android.content.Intent;
import android.content.pm.PackageParser;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.util.ArraySet;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$143;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$144;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$145;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$146;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$147;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$148;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$149;
import com.android.server.pm.PackageManagerServiceUtils$$Lambda$150;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import libcore.io.Libcore;

public class PackageManagerServiceUtils {
    private static final long SEVEN_DAYS_IN_MILLISECONDS = 604800000L;

    private static ArraySet<String> getPackageNamesForIntent(Intent intent, int userId) {
        List ris = null;
        try {
            ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, userId).getList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        ArraySet<String> pkgNames = new ArraySet<String>();
        if (ris != null) {
            for (ResolveInfo ri : ris) {
                pkgNames.add(ri.activityInfo.packageName);
            }
        }
        return pkgNames;
    }

    public static void sortPackagesByUsageDate(List<PackageParser.Package> pkgs, PackageManagerService packageManagerService) {
        if (!packageManagerService.isHistoricalPackageUsageAvailable()) {
            return;
        }
        Collections.sort(pkgs, PackageManagerServiceUtils$$Lambda$143.get$Lambda());
    }

    private static void applyPackageFilter(Predicate<PackageParser.Package> filter, Collection<PackageParser.Package> result, Collection<PackageParser.Package> packages, List<PackageParser.Package> sortTemp, PackageManagerService packageManagerService) {
        for (PackageParser.Package pkg : packages) {
            if (!filter.test(pkg)) continue;
            sortTemp.add(pkg);
        }
        PackageManagerServiceUtils.sortPackagesByUsageDate(sortTemp, packageManagerService);
        packages.removeAll(sortTemp);
        for (PackageParser.Package pkg : sortTemp) {
            result.add(pkg);
            List<PackageParser.Package> deps = packageManagerService.findSharedNonSystemLibraries(pkg);
            if (deps.isEmpty()) continue;
            deps.removeAll(result);
            result.addAll(deps);
            packages.removeAll(deps);
        }
        sortTemp.clear();
    }

    public static List<PackageParser.Package> getPackagesForDexopt(Collection<PackageParser.Package> packages, PackageManagerService packageManagerService) {
        Predicate remainingPredicate;
        ArrayList<PackageParser.Package> remainingPkgs = new ArrayList<PackageParser.Package>(packages);
        LinkedList<PackageParser.Package> result = new LinkedList<PackageParser.Package>();
        ArrayList<PackageParser.Package> sortTemp = new ArrayList<PackageParser.Package>(remainingPkgs.size());
        PackageManagerServiceUtils.applyPackageFilter(PackageManagerServiceUtils$$Lambda$144.get$Lambda(), result, remainingPkgs, sortTemp, packageManagerService);
        Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
        ArraySet<String> pkgNames = PackageManagerServiceUtils.getPackageNamesForIntent(intent, 0);
        PackageManagerServiceUtils.applyPackageFilter(PackageManagerServiceUtils$$Lambda$145.get$Lambda(pkgNames), result, remainingPkgs, sortTemp, packageManagerService);
        PackageManagerServiceUtils.applyPackageFilter(PackageManagerServiceUtils$$Lambda$146.get$Lambda(), result, remainingPkgs, sortTemp, packageManagerService);
        if (!remainingPkgs.isEmpty() && packageManagerService.isHistoricalPackageUsageAvailable()) {
            PackageParser.Package lastUsed = Collections.max(remainingPkgs, PackageManagerServiceUtils$$Lambda$147.get$Lambda());
            long estimatedPreviousSystemUseTime = lastUsed.getLatestForegroundPackageUseTimeInMills();
            if (estimatedPreviousSystemUseTime != 0L) {
                long cutoffTime = estimatedPreviousSystemUseTime - 604800000L;
                remainingPredicate = PackageManagerServiceUtils$$Lambda$148.get$Lambda(cutoffTime);
            } else {
                remainingPredicate = PackageManagerServiceUtils$$Lambda$149.get$Lambda();
            }
            PackageManagerServiceUtils.sortPackagesByUsageDate(remainingPkgs, packageManagerService);
        } else {
            remainingPredicate = PackageManagerServiceUtils$$Lambda$150.get$Lambda();
        }
        PackageManagerServiceUtils.applyPackageFilter(remainingPredicate, result, remainingPkgs, sortTemp, packageManagerService);
        return result;
    }

    public static String realpath(File path) throws IOException {
        try {
            return Libcore.os.realpath(path.getAbsolutePath());
        }
        catch (ErrnoException ee) {
            throw ee.rethrowAsIOException();
        }
    }

    public static String packagesToString(Collection<PackageParser.Package> c) {
        StringBuilder sb = new StringBuilder();
        for (PackageParser.Package pkg : c) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(pkg.packageName);
        }
        return sb.toString();
    }

    public static boolean checkISA(String isa) {
        for (String abi : Build.SUPPORTED_ABIS) {
            if (!VMRuntime.getInstructionSet(abi).equals(isa)) continue;
            return true;
        }
        return false;
    }

    static final /* synthetic */ boolean lambda$getPackagesForDexopt$142$PackageManagerServiceUtils(PackageParser.Package pkg) {
        return true;
    }

    static final /* synthetic */ boolean lambda$getPackagesForDexopt$141$PackageManagerServiceUtils(PackageParser.Package pkg) {
        return true;
    }

    static final /* synthetic */ boolean lambda$getPackagesForDexopt$140$PackageManagerServiceUtils(long l, PackageParser.Package pkg) {
        return pkg.getLatestForegroundPackageUseTimeInMills() >= l;
    }

    static final /* synthetic */ int lambda$getPackagesForDexopt$139$PackageManagerServiceUtils(PackageParser.Package pkg1, PackageParser.Package pkg2) {
        return Long.compare(pkg1.getLatestForegroundPackageUseTimeInMills(), pkg2.getLatestForegroundPackageUseTimeInMills());
    }

    static final /* synthetic */ boolean lambda$getPackagesForDexopt$138$PackageManagerServiceUtils(PackageParser.Package pkg) {
        return PackageDexOptimizer.isUsedByOtherApps(pkg);
    }

    static final /* synthetic */ boolean lambda$getPackagesForDexopt$137$PackageManagerServiceUtils(ArraySet arraySet, PackageParser.Package pkg) {
        return arraySet.contains(pkg.packageName);
    }

    static final /* synthetic */ boolean lambda$getPackagesForDexopt$136$PackageManagerServiceUtils(PackageParser.Package pkg) {
        return pkg.coreApp;
    }

    static final /* synthetic */ int lambda$sortPackagesByUsageDate$135$PackageManagerServiceUtils(PackageParser.Package pkg1, PackageParser.Package pkg2) {
        return Long.compare(pkg2.getLatestForegroundPackageUseTimeInMills(), pkg1.getLatestForegroundPackageUseTimeInMills());
    }
}

