/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.os.Trace;
import android.util.DisplayMetrics;
import com.android.internal.util.ConcurrentUtils;
import com.android.server.pm.ParallelPackageParser$$Lambda$151;
import java.io.File;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;

class ParallelPackageParser
implements AutoCloseable {
    private static final int QUEUE_CAPACITY = 10;
    private static final int MAX_THREADS = 4;
    private final String[] mSeparateProcesses;
    private final boolean mOnlyCore;
    private final DisplayMetrics mMetrics;
    private final File mCacheDir;
    private volatile String mInterruptedInThread;
    private final BlockingQueue<ParseResult> mQueue = new ArrayBlockingQueue<ParseResult>(10);
    private final ExecutorService mService = ConcurrentUtils.newFixedThreadPool(4, "package-parsing-thread", -2);

    ParallelPackageParser(String[] separateProcesses, boolean onlyCoreApps, DisplayMetrics metrics, File cacheDir) {
        this.mSeparateProcesses = separateProcesses;
        this.mOnlyCore = onlyCoreApps;
        this.mMetrics = metrics;
        this.mCacheDir = cacheDir;
    }

    public ParseResult take() {
        try {
            if (this.mInterruptedInThread != null) {
                throw new InterruptedException("Interrupted in " + this.mInterruptedInThread);
            }
            return this.mQueue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public void submit(File scanFile, int parseFlags) {
        this.mService.submit(ParallelPackageParser$$Lambda$151.get$Lambda(this, scanFile, parseFlags));
    }

    protected PackageParser.Package parsePackage(PackageParser packageParser, File scanFile, int parseFlags) throws PackageParser.PackageParserException {
        return packageParser.parsePackage(scanFile, parseFlags, true);
    }

    @Override
    public void close() {
        List<Runnable> unfinishedTasks = this.mService.shutdownNow();
        if (!unfinishedTasks.isEmpty()) {
            throw new IllegalStateException("Not all tasks finished before calling close: " + unfinishedTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$submit$143$ParallelPackageParser(File file, int n) {
        ParseResult pr = new ParseResult();
        Trace.traceBegin(262144L, "parallel parsePackage [" + file + "]");
        try {
            PackageParser pp = new PackageParser();
            pp.setSeparateProcesses(this.mSeparateProcesses);
            pp.setOnlyCoreApps(this.mOnlyCore);
            pp.setDisplayMetrics(this.mMetrics);
            pp.setCacheDir(this.mCacheDir);
            pr.scanFile = file;
            pr.pkg = this.parsePackage(pp, file, n);
        }
        catch (Throwable e) {
            pr.throwable = e;
        }
        finally {
            Trace.traceEnd(262144L);
        }
        try {
            this.mQueue.put(pr);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.mInterruptedInThread = Thread.currentThread().getName();
        }
    }

    static class ParseResult {
        PackageParser.Package pkg;
        File scanFile;
        Throwable throwable;

        ParseResult() {
        }

        public String toString() {
            return "ParseResult{pkg=" + this.pkg + ", scanFile=" + this.scanFile + ", throwable=" + this.throwable + '}';
        }
    }
}

