/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.util.ArrayUtils;
import com.android.server.pm.BasePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class PermissionsState {
    public static final int PERMISSION_OPERATION_FAILURE = -1;
    public static final int PERMISSION_OPERATION_SUCCESS = 0;
    public static final int PERMISSION_OPERATION_SUCCESS_GIDS_CHANGED = 1;
    private static final int[] NO_GIDS = new int[0];
    private ArrayMap<String, PermissionData> mPermissions;
    private int[] mGlobalGids = NO_GIDS;
    private SparseBooleanArray mPermissionReviewRequired;

    public PermissionsState() {
    }

    public PermissionsState(PermissionsState prototype) {
        this.copyFrom(prototype);
    }

    public void setGlobalGids(int[] globalGids) {
        if (!ArrayUtils.isEmpty(globalGids)) {
            this.mGlobalGids = Arrays.copyOf(globalGids, globalGids.length);
        }
    }

    public void copyFrom(PermissionsState other) {
        int i;
        if (other == this) {
            return;
        }
        if (this.mPermissions != null) {
            if (other.mPermissions == null) {
                this.mPermissions = null;
            } else {
                this.mPermissions.clear();
            }
        }
        if (other.mPermissions != null) {
            if (this.mPermissions == null) {
                this.mPermissions = new ArrayMap();
            }
            int permissionCount = other.mPermissions.size();
            for (i = 0; i < permissionCount; ++i) {
                String name = other.mPermissions.keyAt(i);
                PermissionData permissionData = other.mPermissions.valueAt(i);
                this.mPermissions.put(name, new PermissionData(permissionData));
            }
        }
        this.mGlobalGids = NO_GIDS;
        if (other.mGlobalGids != NO_GIDS) {
            this.mGlobalGids = Arrays.copyOf(other.mGlobalGids, other.mGlobalGids.length);
        }
        if (this.mPermissionReviewRequired != null) {
            if (other.mPermissionReviewRequired == null) {
                this.mPermissionReviewRequired = null;
            } else {
                this.mPermissionReviewRequired.clear();
            }
        }
        if (other.mPermissionReviewRequired != null) {
            if (this.mPermissionReviewRequired == null) {
                this.mPermissionReviewRequired = new SparseBooleanArray();
            }
            int userCount = other.mPermissionReviewRequired.size();
            for (i = 0; i < userCount; ++i) {
                boolean reviewRequired = other.mPermissionReviewRequired.valueAt(i);
                this.mPermissionReviewRequired.put(i, reviewRequired);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PermissionsState other = (PermissionsState)obj;
        if (this.mPermissions == null ? other.mPermissions != null : !this.mPermissions.equals(other.mPermissions)) {
            return false;
        }
        if (this.mPermissionReviewRequired == null ? other.mPermissionReviewRequired != null : !this.mPermissionReviewRequired.equals(other.mPermissionReviewRequired)) {
            return false;
        }
        return Arrays.equals(this.mGlobalGids, other.mGlobalGids);
    }

    public boolean isPermissionReviewRequired(int userId) {
        return this.mPermissionReviewRequired != null && this.mPermissionReviewRequired.get(userId);
    }

    public int grantInstallPermission(BasePermission permission2) {
        return this.grantPermission(permission2, -1);
    }

    public int revokeInstallPermission(BasePermission permission2) {
        return this.revokePermission(permission2, -1);
    }

    public int grantRuntimePermission(BasePermission permission2, int userId) {
        PermissionsState.enforceValidUserId(userId);
        if (userId == -1) {
            return -1;
        }
        return this.grantPermission(permission2, userId);
    }

    public int revokeRuntimePermission(BasePermission permission2, int userId) {
        PermissionsState.enforceValidUserId(userId);
        if (userId == -1) {
            return -1;
        }
        return this.revokePermission(permission2, userId);
    }

    public boolean hasRuntimePermission(String name, int userId) {
        PermissionsState.enforceValidUserId(userId);
        return !this.hasInstallPermission(name) && this.hasPermission(name, userId);
    }

    public boolean hasInstallPermission(String name) {
        return this.hasPermission(name, -1);
    }

    public boolean hasPermission(String name, int userId) {
        PermissionsState.enforceValidUserId(userId);
        if (this.mPermissions == null) {
            return false;
        }
        PermissionData permissionData = this.mPermissions.get(name);
        return permissionData != null && permissionData.isGranted(userId);
    }

    public boolean hasRequestedPermission(ArraySet<String> names) {
        if (this.mPermissions == null) {
            return false;
        }
        for (int i = names.size() - 1; i >= 0; --i) {
            if (this.mPermissions.get(names.valueAt(i)) == null) continue;
            return true;
        }
        return false;
    }

    public Set<String> getPermissions(int userId) {
        PermissionsState.enforceValidUserId(userId);
        if (this.mPermissions == null) {
            return Collections.emptySet();
        }
        ArraySet<String> permissions = new ArraySet<String>(this.mPermissions.size());
        int permissionCount = this.mPermissions.size();
        for (int i = 0; i < permissionCount; ++i) {
            String permission2 = this.mPermissions.keyAt(i);
            if (this.hasInstallPermission(permission2)) {
                permissions.add(permission2);
                continue;
            }
            if (userId == -1 || !this.hasRuntimePermission(permission2, userId)) continue;
            permissions.add(permission2);
        }
        return permissions;
    }

    public PermissionState getInstallPermissionState(String name) {
        return this.getPermissionState(name, -1);
    }

    public PermissionState getRuntimePermissionState(String name, int userId) {
        PermissionsState.enforceValidUserId(userId);
        return this.getPermissionState(name, userId);
    }

    public List<PermissionState> getInstallPermissionStates() {
        return this.getPermissionStatesInternal(-1);
    }

    public List<PermissionState> getRuntimePermissionStates(int userId) {
        PermissionsState.enforceValidUserId(userId);
        return this.getPermissionStatesInternal(userId);
    }

    public int getPermissionFlags(String name, int userId) {
        PermissionState installPermState = this.getInstallPermissionState(name);
        if (installPermState != null) {
            return installPermState.getFlags();
        }
        PermissionState runtimePermState = this.getRuntimePermissionState(name, userId);
        if (runtimePermState != null) {
            return runtimePermState.getFlags();
        }
        return 0;
    }

    public boolean updatePermissionFlags(BasePermission permission2, int userId, int flagMask, int flagValues) {
        PermissionData permissionData;
        boolean mayChangeFlags;
        PermissionsState.enforceValidUserId(userId);
        boolean bl = mayChangeFlags = flagValues != 0 || flagMask != 0;
        if (this.mPermissions == null) {
            if (!mayChangeFlags) {
                return false;
            }
            this.ensurePermissionData(permission2);
        }
        if ((permissionData = this.mPermissions.get(permission2.name)) == null) {
            if (!mayChangeFlags) {
                return false;
            }
            permissionData = this.ensurePermissionData(permission2);
        }
        int oldFlags = permissionData.getFlags(userId);
        boolean updated = permissionData.updateFlags(userId, flagMask, flagValues);
        if (updated) {
            int newFlags = permissionData.getFlags(userId);
            if ((oldFlags & 0x40) == 0 && (newFlags & 0x40) != 0) {
                if (this.mPermissionReviewRequired == null) {
                    this.mPermissionReviewRequired = new SparseBooleanArray();
                }
                this.mPermissionReviewRequired.put(userId, true);
            } else if ((oldFlags & 0x40) != 0 && (newFlags & 0x40) == 0 && this.mPermissionReviewRequired != null) {
                this.mPermissionReviewRequired.delete(userId);
                if (this.mPermissionReviewRequired.size() <= 0) {
                    this.mPermissionReviewRequired = null;
                }
            }
        }
        return updated;
    }

    public boolean updatePermissionFlagsForAllPermissions(int userId, int flagMask, int flagValues) {
        PermissionsState.enforceValidUserId(userId);
        if (this.mPermissions == null) {
            return false;
        }
        boolean changed = false;
        int permissionCount = this.mPermissions.size();
        for (int i = 0; i < permissionCount; ++i) {
            PermissionData permissionData = this.mPermissions.valueAt(i);
            changed |= permissionData.updateFlags(userId, flagMask, flagValues);
        }
        return changed;
    }

    public int[] computeGids(int userId) {
        PermissionsState.enforceValidUserId(userId);
        int[] gids = this.mGlobalGids;
        if (this.mPermissions != null) {
            int permissionCount = this.mPermissions.size();
            for (int i = 0; i < permissionCount; ++i) {
                PermissionData permissionData;
                int[] permGids;
                String permission2 = this.mPermissions.keyAt(i);
                if (!this.hasPermission(permission2, userId) || (permGids = (permissionData = this.mPermissions.valueAt(i)).computeGids(userId)) == NO_GIDS) continue;
                gids = PermissionsState.appendInts(gids, permGids);
            }
        }
        return gids;
    }

    public int[] computeGids(int[] userIds) {
        int[] gids = this.mGlobalGids;
        for (int userId : userIds) {
            int[] userGids = this.computeGids(userId);
            gids = PermissionsState.appendInts(gids, userGids);
        }
        return gids;
    }

    public void reset() {
        this.mGlobalGids = NO_GIDS;
        this.mPermissions = null;
        this.mPermissionReviewRequired = null;
    }

    private PermissionState getPermissionState(String name, int userId) {
        if (this.mPermissions == null) {
            return null;
        }
        PermissionData permissionData = this.mPermissions.get(name);
        if (permissionData == null) {
            return null;
        }
        return permissionData.getPermissionState(userId);
    }

    private List<PermissionState> getPermissionStatesInternal(int userId) {
        PermissionsState.enforceValidUserId(userId);
        if (this.mPermissions == null) {
            return Collections.emptyList();
        }
        ArrayList<PermissionState> permissionStates = new ArrayList<PermissionState>();
        int permissionCount = this.mPermissions.size();
        for (int i = 0; i < permissionCount; ++i) {
            PermissionData permissionData = this.mPermissions.valueAt(i);
            PermissionState permissionState = permissionData.getPermissionState(userId);
            if (permissionState == null) continue;
            permissionStates.add(permissionState);
        }
        return permissionStates;
    }

    private int grantPermission(BasePermission permission2, int userId) {
        int[] newGids;
        if (this.hasPermission(permission2.name, userId)) {
            return -1;
        }
        boolean hasGids = !ArrayUtils.isEmpty(permission2.computeGids(userId));
        int[] oldGids = hasGids ? this.computeGids(userId) : NO_GIDS;
        PermissionData permissionData = this.ensurePermissionData(permission2);
        if (!permissionData.grant(userId)) {
            return -1;
        }
        if (hasGids && oldGids.length != (newGids = this.computeGids(userId)).length) {
            return 1;
        }
        return 0;
    }

    private int revokePermission(BasePermission permission2, int userId) {
        int[] newGids;
        if (!this.hasPermission(permission2.name, userId)) {
            return -1;
        }
        boolean hasGids = !ArrayUtils.isEmpty(permission2.computeGids(userId));
        int[] oldGids = hasGids ? this.computeGids(userId) : NO_GIDS;
        PermissionData permissionData = this.mPermissions.get(permission2.name);
        if (!permissionData.revoke(userId)) {
            return -1;
        }
        if (permissionData.isDefault()) {
            this.ensureNoPermissionData(permission2.name);
        }
        if (hasGids && oldGids.length != (newGids = this.computeGids(userId)).length) {
            return 1;
        }
        return 0;
    }

    private static int[] appendInts(int[] current, int[] added) {
        if (current != null && added != null) {
            for (int guid : added) {
                current = ArrayUtils.appendInt(current, guid);
            }
        }
        return current;
    }

    private static void enforceValidUserId(int userId) {
        if (userId != -1 && userId < 0) {
            throw new IllegalArgumentException("Invalid userId:" + userId);
        }
    }

    private PermissionData ensurePermissionData(BasePermission permission2) {
        PermissionData permissionData;
        if (this.mPermissions == null) {
            this.mPermissions = new ArrayMap();
        }
        if ((permissionData = this.mPermissions.get(permission2.name)) == null) {
            permissionData = new PermissionData(permission2);
            this.mPermissions.put(permission2.name, permissionData);
        }
        return permissionData;
    }

    private void ensureNoPermissionData(String name) {
        if (this.mPermissions == null) {
            return;
        }
        this.mPermissions.remove(name);
        if (this.mPermissions.isEmpty()) {
            this.mPermissions = null;
        }
    }

    public static final class PermissionState {
        private final String mName;
        private boolean mGranted;
        private int mFlags;

        public PermissionState(String name) {
            this.mName = name;
        }

        public PermissionState(PermissionState other) {
            this.mName = other.mName;
            this.mGranted = other.mGranted;
            this.mFlags = other.mFlags;
        }

        public boolean isDefault() {
            return !this.mGranted && this.mFlags == 0;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isGranted() {
            return this.mGranted;
        }

        public int getFlags() {
            return this.mFlags;
        }
    }

    private static final class PermissionData {
        private final BasePermission mPerm;
        private SparseArray<PermissionState> mUserStates = new SparseArray();

        public PermissionData(BasePermission perm) {
            this.mPerm = perm;
        }

        public PermissionData(PermissionData other) {
            this(other.mPerm);
            int otherStateCount = other.mUserStates.size();
            for (int i = 0; i < otherStateCount; ++i) {
                int otherUserId = other.mUserStates.keyAt(i);
                PermissionState otherState = other.mUserStates.valueAt(i);
                this.mUserStates.put(otherUserId, new PermissionState(otherState));
            }
        }

        public int[] computeGids(int userId) {
            return this.mPerm.computeGids(userId);
        }

        public boolean isGranted(int userId) {
            PermissionState userState;
            if (this.isInstallPermission()) {
                userId = -1;
            }
            if ((userState = this.mUserStates.get(userId)) == null) {
                return false;
            }
            return userState.mGranted;
        }

        public boolean grant(int userId) {
            if (!this.isCompatibleUserId(userId)) {
                return false;
            }
            if (this.isGranted(userId)) {
                return false;
            }
            PermissionState userState = this.mUserStates.get(userId);
            if (userState == null) {
                userState = new PermissionState(this.mPerm.name);
                this.mUserStates.put(userId, userState);
            }
            userState.mGranted = true;
            return true;
        }

        public boolean revoke(int userId) {
            if (!this.isCompatibleUserId(userId)) {
                return false;
            }
            if (!this.isGranted(userId)) {
                return false;
            }
            PermissionState userState = this.mUserStates.get(userId);
            userState.mGranted = false;
            if (userState.isDefault()) {
                this.mUserStates.remove(userId);
            }
            return true;
        }

        public PermissionState getPermissionState(int userId) {
            return this.mUserStates.get(userId);
        }

        public int getFlags(int userId) {
            PermissionState userState = this.mUserStates.get(userId);
            if (userState != null) {
                return userState.mFlags;
            }
            return 0;
        }

        public boolean isDefault() {
            return this.mUserStates.size() <= 0;
        }

        public static boolean isInstallPermissionKey(int userId) {
            return userId == -1;
        }

        public boolean updateFlags(int userId, int flagMask, int flagValues) {
            if (this.isInstallPermission()) {
                userId = -1;
            }
            if (!this.isCompatibleUserId(userId)) {
                return false;
            }
            int newFlags = flagValues & flagMask;
            PermissionState userState = this.mUserStates.get(userId);
            if (userState != null) {
                int oldFlags = userState.mFlags;
                userState.mFlags = userState.mFlags & ~flagMask | newFlags;
                if (userState.isDefault()) {
                    this.mUserStates.remove(userId);
                }
                return userState.mFlags != oldFlags;
            }
            if (newFlags != 0) {
                userState = new PermissionState(this.mPerm.name);
                userState.mFlags = newFlags;
                this.mUserStates.put(userId, userState);
                return true;
            }
            return false;
        }

        private boolean isCompatibleUserId(int userId) {
            return this.isDefault() || !(this.isInstallPermission() ^ PermissionData.isInstallPermissionKey(userId));
        }

        private boolean isInstallPermission() {
            return this.mUserStates.size() == 1 && this.mUserStates.get(-1) != null;
        }
    }
}

