/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.annotation.IntDef;
import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.IUidObserver;
import android.app.usage.UsageStatsManagerInternal;
import android.appwidget.AppWidgetProviderInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.IShortcutService;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutServiceInternal;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.LocaleList;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.KeyValueListParser;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.IWindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.ShortcutLauncher;
import com.android.server.pm.ShortcutPackage;
import com.android.server.pm.ShortcutPackageItem;
import com.android.server.pm.ShortcutRequestPinProcessor;
import com.android.server.pm.ShortcutService$$Lambda$122;
import com.android.server.pm.ShortcutService$$Lambda$123;
import com.android.server.pm.ShortcutService$$Lambda$124;
import com.android.server.pm.ShortcutService$$Lambda$125;
import com.android.server.pm.ShortcutService$$Lambda$126;
import com.android.server.pm.ShortcutService$$Lambda$127;
import com.android.server.pm.ShortcutService$$Lambda$128;
import com.android.server.pm.ShortcutService$$Lambda$129;
import com.android.server.pm.ShortcutService$$Lambda$130;
import com.android.server.pm.ShortcutService$$Lambda$131;
import com.android.server.pm.ShortcutService$$Lambda$132;
import com.android.server.pm.ShortcutService$$Lambda$133;
import com.android.server.pm.ShortcutService$$Lambda$134;
import com.android.server.pm.ShortcutService$$Lambda$135;
import com.android.server.pm.ShortcutService$$Lambda$136;
import com.android.server.pm.ShortcutService$$Lambda$137;
import com.android.server.pm.ShortcutService$LocalService$$Lambda$164;
import com.android.server.pm.ShortcutService$LocalService$$Lambda$165;
import com.android.server.pm.ShortcutService$LocalService$$Lambda$166;
import com.android.server.pm.ShortcutUser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import libcore.io.IoUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ShortcutService
extends IShortcutService.Stub {
    static final String TAG = "ShortcutService";
    static final boolean DEBUG = false;
    static final boolean DEBUG_LOAD = false;
    static final boolean DEBUG_PROCSTATE = false;
    static final long DEFAULT_RESET_INTERVAL_SEC = 86400L;
    static final int DEFAULT_MAX_UPDATES_PER_INTERVAL = 10;
    static final int DEFAULT_MAX_SHORTCUTS_PER_APP = 5;
    static final int DEFAULT_MAX_ICON_DIMENSION_DP = 96;
    static final int DEFAULT_MAX_ICON_DIMENSION_LOWRAM_DP = 48;
    static final String DEFAULT_ICON_PERSIST_FORMAT = Bitmap.CompressFormat.PNG.name();
    static final int DEFAULT_ICON_PERSIST_QUALITY = 100;
    static final int DEFAULT_SAVE_DELAY_MS = 3000;
    static final String FILENAME_BASE_STATE = "shortcut_service.xml";
    static final String DIRECTORY_PER_USER = "shortcut_service";
    static final String FILENAME_USER_PACKAGES = "shortcuts.xml";
    static final String DIRECTORY_BITMAPS = "bitmaps";
    private static final String TAG_ROOT = "root";
    private static final String TAG_LAST_RESET_TIME = "last_reset_time";
    private static final String ATTR_VALUE = "value";
    private static final String LAUNCHER_INTENT_CATEGORY = "android.intent.category.LAUNCHER";
    private static final String KEY_SHORTCUT = "shortcut";
    private static final String KEY_LOW_RAM = "lowRam";
    private static final String KEY_ICON_SIZE = "iconSize";
    private static final String DUMMY_MAIN_ACTIVITY = "android.__dummy__";
    final Context mContext;
    private final Object mLock = new Object();
    private static List<ResolveInfo> EMPTY_RESOLVE_INFO = new ArrayList<ResolveInfo>(0);
    private static Predicate<ResolveInfo> ACTIVITY_NOT_EXPORTED = new Predicate<ResolveInfo>(){

        @Override
        public boolean test(ResolveInfo ri) {
            return !ri.activityInfo.exported;
        }
    };
    private static Predicate<PackageInfo> PACKAGE_NOT_INSTALLED = new Predicate<PackageInfo>(){

        @Override
        public boolean test(PackageInfo pi) {
            return !ShortcutService.isInstalled(pi);
        }
    };
    private final Handler mHandler;
    @GuardedBy(value="mLock")
    private final ArrayList<ShortcutServiceInternal.ShortcutChangeListener> mListeners = new ArrayList(1);
    @GuardedBy(value="mLock")
    private long mRawLastResetTime;
    @GuardedBy(value="mLock")
    private final SparseArray<ShortcutUser> mUsers = new SparseArray();
    private int mMaxShortcuts;
    int mMaxUpdatesPerInterval;
    private long mResetInterval;
    private int mMaxIconDimension;
    private Bitmap.CompressFormat mIconPersistFormat;
    private int mIconPersistQuality;
    private int mSaveDelayMillis;
    private final IPackageManager mIPackageManager;
    private final PackageManagerInternal mPackageManagerInternal;
    private final UserManager mUserManager;
    private final UsageStatsManagerInternal mUsageStatsManagerInternal;
    private final ActivityManagerInternal mActivityManagerInternal;
    private final ShortcutRequestPinProcessor mShortcutRequestPinProcessor;
    @GuardedBy(value="mLock")
    final SparseIntArray mUidState = new SparseIntArray();
    @GuardedBy(value="mLock")
    final SparseLongArray mUidLastForegroundElapsedTime = new SparseLongArray();
    @GuardedBy(value="mLock")
    private List<Integer> mDirtyUserIds = new ArrayList<Integer>();
    private final AtomicBoolean mBootCompleted = new AtomicBoolean();
    private static final int PACKAGE_MATCH_FLAGS = 794624;
    @GuardedBy(value="mLock")
    final SparseBooleanArray mUnlockedUsers = new SparseBooleanArray();
    private static final String[] STAT_LABELS = new String[]{"getHomeActivities()", "Launcher permission check", "getPackageInfo()", "getPackageInfo(SIG)", "getApplicationInfo", "cleanupDanglingBitmaps", "getActivity+metadata", "getInstalledPackages", "checkPackageChanges", "getApplicationResources", "resourceNameLookup", "getLauncherActivity", "checkLauncherActivity", "isActivityEnabled", "packageUpdateCheck", "asyncPreloadUserDelay", "getDefaultLauncher()"};
    final Object mStatLock = new Object();
    @GuardedBy(value="mStatLock")
    private final int[] mCountStats = new int[17];
    @GuardedBy(value="mStatLock")
    private final long[] mDurationStats = new long[17];
    private static final int PROCESS_STATE_FOREGROUND_THRESHOLD = 4;
    static final int OPERATION_SET = 0;
    static final int OPERATION_ADD = 1;
    static final int OPERATION_UPDATE = 2;
    @GuardedBy(value="mLock")
    private int mWtfCount = 0;
    @GuardedBy(value="mLock")
    private Exception mLastWtfStacktrace;
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState) throws RemoteException {
            ShortcutService.this.handleOnUidStateChanged(uid, procState);
        }

        @Override
        public void onUidGone(int uid, boolean disabled) throws RemoteException {
            ShortcutService.this.handleOnUidStateChanged(uid, 17);
        }

        @Override
        public void onUidActive(int uid) throws RemoteException {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) throws RemoteException {
        }
    };
    private final Runnable mSaveDirtyInfoRunner = ShortcutService$$Lambda$122.get$Lambda(this);
    final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (!ShortcutService.this.mBootCompleted.get()) {
                return;
            }
            try {
                if ("android.intent.action.LOCALE_CHANGED".equals(intent.getAction())) {
                    ShortcutService.this.handleLocaleChanged();
                }
            }
            catch (Exception e) {
                ShortcutService.this.wtf("Exception in mReceiver.onReceive", e);
            }
        }
    };
    final BroadcastReceiver mPackageMonitor = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                Slog.w(ShortcutService.TAG, "Intent broadcast does not contain user handle: " + intent);
                return;
            }
            String action = intent.getAction();
            long token = ShortcutService.this.injectClearCallingIdentity();
            try {
                String packageName;
                Object object = ShortcutService.this.mLock;
                // MONITORENTER : object
                if (!ShortcutService.this.isUserUnlockedL(userId)) {
                    // MONITOREXIT : object
                    return;
                }
                ShortcutUser user = ShortcutService.this.getUserShortcutsLocked(userId);
                user.clearLauncher();
                // MONITOREXIT : object
                if ("android.intent.action.ACTION_PREFERRED_ACTIVITY_CHANGED".equals(action)) {
                    return;
                }
                Uri intentUri = intent.getData();
                String string2 = packageName = intentUri != null ? intentUri.getSchemeSpecificPart() : null;
                if (packageName == null) {
                    Slog.w(ShortcutService.TAG, "Intent broadcast does not contain package name: " + intent);
                    return;
                }
                boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                switch (action) {
                    case "android.intent.action.PACKAGE_ADDED": {
                        if (replacing) {
                            ShortcutService.this.handlePackageUpdateFinished(packageName, userId);
                            return;
                        }
                        ShortcutService.this.handlePackageAdded(packageName, userId);
                        return;
                    }
                    case "android.intent.action.PACKAGE_REMOVED": {
                        if (replacing) return;
                        ShortcutService.this.handlePackageRemoved(packageName, userId);
                        return;
                    }
                    case "android.intent.action.PACKAGE_CHANGED": {
                        ShortcutService.this.handlePackageChanged(packageName, userId);
                        return;
                    }
                    case "android.intent.action.PACKAGE_DATA_CLEARED": {
                        ShortcutService.this.handlePackageDataCleared(packageName, userId);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                ShortcutService.this.wtf("Exception in mPackageMonitor.onReceive", e);
                return;
            }
            finally {
                ShortcutService.this.injectRestoreCallingIdentity(token);
            }
        }
    };

    public ShortcutService(Context context) {
        this(context, BackgroundThread.get().getLooper(), false);
    }

    ShortcutService(Context context, Looper looper, boolean onlyForPackageManagerApis) {
        this.mContext = Preconditions.checkNotNull(context);
        LocalServices.addService(ShortcutServiceInternal.class, new LocalService());
        this.mHandler = new Handler(looper);
        this.mIPackageManager = AppGlobals.getPackageManager();
        this.mPackageManagerInternal = Preconditions.checkNotNull(LocalServices.getService(PackageManagerInternal.class));
        this.mUserManager = Preconditions.checkNotNull(context.getSystemService(UserManager.class));
        this.mUsageStatsManagerInternal = Preconditions.checkNotNull(LocalServices.getService(UsageStatsManagerInternal.class));
        this.mActivityManagerInternal = Preconditions.checkNotNull(LocalServices.getService(ActivityManagerInternal.class));
        this.mShortcutRequestPinProcessor = new ShortcutRequestPinProcessor(this, this.mLock);
        if (onlyForPackageManagerApis) {
            return;
        }
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        packageFilter.addAction("android.intent.action.PACKAGE_DATA_CLEARED");
        packageFilter.addDataScheme("package");
        packageFilter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mPackageMonitor, UserHandle.ALL, packageFilter, null, this.mHandler);
        IntentFilter preferedActivityFilter = new IntentFilter();
        preferedActivityFilter.addAction("android.intent.action.ACTION_PREFERRED_ACTIVITY_CHANGED");
        preferedActivityFilter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mPackageMonitor, UserHandle.ALL, preferedActivityFilter, null, this.mHandler);
        IntentFilter localeFilter = new IntentFilter();
        localeFilter.addAction("android.intent.action.LOCALE_CHANGED");
        localeFilter.setPriority(1000);
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, localeFilter, null, this.mHandler);
        this.injectRegisterUidObserver(this.mUidObserver, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logDurationStat(int statId, long start) {
        Object object = this.mStatLock;
        synchronized (object) {
            int n = statId;
            this.mCountStats[n] = this.mCountStats[n] + 1;
            int n2 = statId;
            this.mDurationStats[n2] = this.mDurationStats[n2] + (this.injectElapsedRealtime() - start);
        }
    }

    public String injectGetLocaleTagsForUser(int userId) {
        return LocaleList.getDefault().toLanguageTags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOnUidStateChanged(int uid, int procState) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUidState.put(uid, procState);
            if (this.isProcessStateForeground(procState)) {
                this.mUidLastForegroundElapsedTime.put(uid, this.injectElapsedRealtime());
            }
        }
    }

    private boolean isProcessStateForeground(int processState) {
        return processState <= 4;
    }

    boolean isUidForegroundLocked(int uid) {
        if (uid == 1000) {
            return true;
        }
        if (this.isProcessStateForeground(this.mUidState.get(uid, 17))) {
            return true;
        }
        return this.isProcessStateForeground(this.mActivityManagerInternal.getUidProcessState(uid));
    }

    long getUidLastForegroundElapsedTimeLocked(int uid) {
        return this.mUidLastForegroundElapsedTime.get(uid);
    }

    void onBootPhase(int phase) {
        switch (phase) {
            case 480: {
                this.initialize();
                break;
            }
            case 1000: {
                this.mBootCompleted.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUnlockedUsers.put(userId, true);
        }
        long start = this.injectElapsedRealtime();
        this.injectRunOnNewThread(ShortcutService$$Lambda$123.get$Lambda(this, start, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCleanupUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.unloadUserLocked(userId);
            this.mUnlockedUsers.put(userId, false);
        }
    }

    private void unloadUserLocked(int userId) {
        this.saveDirtyInfo();
        this.mUsers.delete(userId);
    }

    private AtomicFile getBaseStateFile() {
        File path = new File(this.injectSystemDataPath(), FILENAME_BASE_STATE);
        path.mkdirs();
        return new AtomicFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.mLock;
        synchronized (object) {
            this.loadConfigurationLocked();
            this.loadBaseStateLocked();
        }
    }

    private void loadConfigurationLocked() {
        this.updateConfigurationLocked(this.injectShortcutManagerConstants());
    }

    boolean updateConfigurationLocked(String config) {
        boolean result = true;
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(config);
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Bad shortcut manager settings", e);
            result = false;
        }
        this.mSaveDelayMillis = Math.max(0, (int)parser.getLong("save_delay_ms", 3000L));
        this.mResetInterval = Math.max(1L, parser.getLong("reset_interval_sec", 86400L) * 1000L);
        this.mMaxUpdatesPerInterval = Math.max(0, (int)parser.getLong("max_updates_per_interval", 10L));
        this.mMaxShortcuts = Math.max(0, (int)parser.getLong("max_shortcuts", 5L));
        int iconDimensionDp = Math.max(1, this.injectIsLowRamDevice() ? (int)parser.getLong("max_icon_dimension_dp_lowram", 48L) : (int)parser.getLong("max_icon_dimension_dp", 96L));
        this.mMaxIconDimension = this.injectDipToPixel(iconDimensionDp);
        this.mIconPersistFormat = Bitmap.CompressFormat.valueOf(parser.getString("icon_format", DEFAULT_ICON_PERSIST_FORMAT));
        this.mIconPersistQuality = (int)parser.getLong("icon_quality", 100L);
        return result;
    }

    String injectShortcutManagerConstants() {
        return Settings.Global.getString(this.mContext.getContentResolver(), "shortcut_manager_constants");
    }

    int injectDipToPixel(int dip) {
        return (int)TypedValue.applyDimension(1, dip, this.mContext.getResources().getDisplayMetrics());
    }

    static String parseStringAttribute(XmlPullParser parser, String attribute) {
        return parser.getAttributeValue(null, attribute);
    }

    static boolean parseBooleanAttribute(XmlPullParser parser, String attribute) {
        return ShortcutService.parseLongAttribute(parser, attribute) == 1L;
    }

    static int parseIntAttribute(XmlPullParser parser, String attribute) {
        return (int)ShortcutService.parseLongAttribute(parser, attribute);
    }

    static int parseIntAttribute(XmlPullParser parser, String attribute, int def) {
        return (int)ShortcutService.parseLongAttribute(parser, attribute, def);
    }

    static long parseLongAttribute(XmlPullParser parser, String attribute) {
        return ShortcutService.parseLongAttribute(parser, attribute, 0L);
    }

    static long parseLongAttribute(XmlPullParser parser, String attribute, long def) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        if (TextUtils.isEmpty(value)) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Error parsing long " + value);
            return def;
        }
    }

    static ComponentName parseComponentNameAttribute(XmlPullParser parser, String attribute) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        return ComponentName.unflattenFromString(value);
    }

    static Intent parseIntentAttributeNoDefault(XmlPullParser parser, String attribute) {
        String value = ShortcutService.parseStringAttribute(parser, attribute);
        Intent parsed = null;
        if (!TextUtils.isEmpty(value)) {
            try {
                parsed = Intent.parseUri(value, 0);
            }
            catch (URISyntaxException e) {
                Slog.e(TAG, "Error parsing intent", e);
            }
        }
        return parsed;
    }

    static Intent parseIntentAttribute(XmlPullParser parser, String attribute) {
        Intent parsed = ShortcutService.parseIntentAttributeNoDefault(parser, attribute);
        if (parsed == null) {
            parsed = new Intent("android.intent.action.VIEW");
        }
        return parsed;
    }

    static void writeTagValue(XmlSerializer out, String tag, String value) throws IOException {
        if (TextUtils.isEmpty(value)) {
            return;
        }
        out.startTag(null, tag);
        out.attribute(null, ATTR_VALUE, value);
        out.endTag(null, tag);
    }

    static void writeTagValue(XmlSerializer out, String tag, long value) throws IOException {
        ShortcutService.writeTagValue(out, tag, Long.toString(value));
    }

    static void writeTagValue(XmlSerializer out, String tag, ComponentName name) throws IOException {
        if (name == null) {
            return;
        }
        ShortcutService.writeTagValue(out, tag, name.flattenToString());
    }

    static void writeTagExtra(XmlSerializer out, String tag, PersistableBundle bundle) throws IOException, XmlPullParserException {
        if (bundle == null) {
            return;
        }
        out.startTag(null, tag);
        bundle.saveToXml(out);
        out.endTag(null, tag);
    }

    static void writeAttr(XmlSerializer out, String name, CharSequence value) throws IOException {
        if (TextUtils.isEmpty(value)) {
            return;
        }
        out.attribute(null, name, value.toString());
    }

    static void writeAttr(XmlSerializer out, String name, long value) throws IOException {
        ShortcutService.writeAttr(out, name, String.valueOf(value));
    }

    static void writeAttr(XmlSerializer out, String name, boolean value) throws IOException {
        if (value) {
            ShortcutService.writeAttr(out, name, "1");
        }
    }

    static void writeAttr(XmlSerializer out, String name, ComponentName comp) throws IOException {
        if (comp == null) {
            return;
        }
        ShortcutService.writeAttr(out, name, comp.flattenToString());
    }

    static void writeAttr(XmlSerializer out, String name, Intent intent) throws IOException {
        if (intent == null) {
            return;
        }
        ShortcutService.writeAttr(out, name, intent.toUri(0));
    }

    void saveBaseStateLocked() {
        AtomicFile file = this.getBaseStateFile();
        FileOutputStream outs = null;
        try {
            outs = file.startWrite();
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(outs, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, TAG_ROOT);
            ShortcutService.writeTagValue((XmlSerializer)out, TAG_LAST_RESET_TIME, this.mRawLastResetTime);
            out.endTag(null, TAG_ROOT);
            out.endDocument();
            file.finishWrite(outs);
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to write to file " + file.getBaseFile(), e);
            file.failWrite(outs);
        }
    }

    private void loadBaseStateLocked() {
        this.mRawLastResetTime = 0L;
        AtomicFile file = this.getBaseStateFile();
        try (FileInputStream in2 = file.openRead();){
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in2, StandardCharsets.UTF_8.name());
            block21: while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                int depth = parser.getDepth();
                String tag = parser.getName();
                if (depth == 1) {
                    if (TAG_ROOT.equals(tag)) continue;
                    Slog.e(TAG, "Invalid root tag: " + tag);
                    return;
                }
                switch (tag) {
                    case "last_reset_time": {
                        this.mRawLastResetTime = ShortcutService.parseLongAttribute(parser, ATTR_VALUE);
                        continue block21;
                    }
                }
                Slog.e(TAG, "Invalid tag: " + tag);
            }
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to read file " + file.getBaseFile(), e);
            this.mRawLastResetTime = 0L;
        }
        this.getLastResetTimeLocked();
    }

    final File getUserFile(int userId) {
        return new File(this.injectUserDataPath(userId), FILENAME_USER_PACKAGES);
    }

    private void saveUserLocked(int userId) {
        File path = this.getUserFile(userId);
        path.getParentFile().mkdirs();
        AtomicFile file = new AtomicFile(path);
        FileOutputStream os = null;
        try {
            os = file.startWrite();
            this.saveUserInternalLocked(userId, os, false);
            file.finishWrite(os);
            this.cleanupDanglingBitmapDirectoriesLocked(userId);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to write to file " + file.getBaseFile(), e);
            file.failWrite(os);
        }
    }

    private void saveUserInternalLocked(int userId, OutputStream os, boolean forBackup) throws IOException, XmlPullParserException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(bos, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        this.getUserShortcutsLocked(userId).saveToXml(out, forBackup);
        out.endDocument();
        bos.flush();
        os.flush();
    }

    static IOException throwForInvalidTag(int depth, String tag) throws IOException {
        throw new IOException(String.format("Invalid tag '%s' found at depth %d", tag, depth));
    }

    static void warnForInvalidTag(int depth, String tag) throws IOException {
        Slog.w(TAG, String.format("Invalid tag '%s' found at depth %d", tag, depth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortcutUser loadUserLocked(int userId) {
        FileInputStream in;
        File path = this.getUserFile(userId);
        AtomicFile file = new AtomicFile(path);
        try {
            in = file.openRead();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            ShortcutUser ret;
            ShortcutUser shortcutUser = ret = this.loadUserInternal(userId, in, false);
            return shortcutUser;
        }
        catch (InvalidFileFormatException | IOException | XmlPullParserException e) {
            Slog.e(TAG, "Failed to read file " + file.getBaseFile(), e);
            ShortcutUser shortcutUser = null;
            return shortcutUser;
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    private ShortcutUser loadUserInternal(int userId, InputStream is, boolean fromBackup) throws XmlPullParserException, IOException, InvalidFileFormatException {
        int type;
        BufferedInputStream bis = new BufferedInputStream(is);
        ShortcutUser ret = null;
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(bis, StandardCharsets.UTF_8.name());
        while ((type = parser.next()) != 1) {
            if (type != 2) continue;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (depth == 1 && "user".equals(tag)) {
                ret = ShortcutUser.loadFromXml(this, parser, userId, fromBackup);
                continue;
            }
            ShortcutService.throwForInvalidTag(depth, tag);
        }
        return ret;
    }

    private void scheduleSaveBaseState() {
        this.scheduleSaveInner(-10000);
    }

    void scheduleSaveUser(int userId) {
        this.scheduleSaveInner(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSaveInner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDirtyUserIds.contains(userId)) {
                this.mDirtyUserIds.add(userId);
            }
        }
        this.mHandler.removeCallbacks(this.mSaveDirtyInfoRunner);
        this.mHandler.postDelayed(this.mSaveDirtyInfoRunner, this.mSaveDelayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDirtyInfo() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                for (int i = this.mDirtyUserIds.size() - 1; i >= 0; --i) {
                    int userId = this.mDirtyUserIds.get(i);
                    if (userId == -10000) {
                        this.saveBaseStateLocked();
                        continue;
                    }
                    this.saveUserLocked(userId);
                }
                this.mDirtyUserIds.clear();
            }
        }
        catch (Exception e) {
            this.wtf("Exception in saveDirtyInfo", e);
        }
    }

    long getLastResetTimeLocked() {
        this.updateTimesLocked();
        return this.mRawLastResetTime;
    }

    long getNextResetTimeLocked() {
        this.updateTimesLocked();
        return this.mRawLastResetTime + this.mResetInterval;
    }

    static boolean isClockValid(long time) {
        return time >= 1420070400L;
    }

    private void updateTimesLocked() {
        long now = this.injectCurrentTimeMillis();
        long prevLastResetTime = this.mRawLastResetTime;
        if (this.mRawLastResetTime == 0L) {
            this.mRawLastResetTime = now;
        } else if (now < this.mRawLastResetTime) {
            if (ShortcutService.isClockValid(now)) {
                Slog.w(TAG, "Clock rewound");
                this.mRawLastResetTime = now;
            }
        } else if (this.mRawLastResetTime + this.mResetInterval <= now) {
            long offset = this.mRawLastResetTime % this.mResetInterval;
            this.mRawLastResetTime = now / this.mResetInterval * this.mResetInterval + offset;
        }
        if (prevLastResetTime != this.mRawLastResetTime) {
            this.scheduleSaveBaseState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUserUnlockedL(int userId) {
        if (this.mUnlockedUsers.get(userId)) {
            return true;
        }
        long token = this.injectClearCallingIdentity();
        try {
            boolean bl = this.mUserManager.isUserUnlockingOrUnlocked(userId);
            return bl;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    void throwIfUserLockedL(int userId) {
        if (!this.isUserUnlockedL(userId)) {
            throw new IllegalStateException("User " + userId + " is locked or not running");
        }
    }

    @GuardedBy(value="mLock")
    private boolean isUserLoadedLocked(int userId) {
        return this.mUsers.get(userId) != null;
    }

    @GuardedBy(value="mLock")
    ShortcutUser getUserShortcutsLocked(int userId) {
        ShortcutUser userPackages;
        if (!this.isUserUnlockedL(userId)) {
            this.wtf("User still locked");
        }
        if ((userPackages = this.mUsers.get(userId)) == null) {
            userPackages = this.loadUserLocked(userId);
            if (userPackages == null) {
                userPackages = new ShortcutUser(this, userId);
            }
            this.mUsers.put(userId, userPackages);
            this.checkPackageChanges(userId);
        }
        return userPackages;
    }

    void forEachLoadedUserLocked(Consumer<ShortcutUser> c) {
        for (int i = this.mUsers.size() - 1; i >= 0; --i) {
            c.accept(this.mUsers.valueAt(i));
        }
    }

    @GuardedBy(value="mLock")
    ShortcutPackage getPackageShortcutsLocked(String packageName, int userId) {
        return this.getUserShortcutsLocked(userId).getPackageShortcuts(packageName);
    }

    @GuardedBy(value="mLock")
    ShortcutPackage getPackageShortcutsForPublisherLocked(String packageName, int userId) {
        ShortcutPackage ret = this.getUserShortcutsLocked(userId).getPackageShortcuts(packageName);
        ret.getUser().onCalledByPublisher(packageName);
        return ret;
    }

    @GuardedBy(value="mLock")
    ShortcutLauncher getLauncherShortcutsLocked(String packageName, int ownerUserId, int launcherUserId) {
        return this.getUserShortcutsLocked(ownerUserId).getLauncherShortcuts(packageName, launcherUserId);
    }

    void removeIcon(int userId, ShortcutInfo shortcut) {
        shortcut.setIconResourceId(0);
        shortcut.setIconResName(null);
        shortcut.clearFlags(524);
    }

    public void cleanupBitmapsForPackage(int userId, String packageName) {
        File packagePath = new File(this.getUserBitmapFilePath(userId), packageName);
        if (!packagePath.isDirectory()) {
            return;
        }
        if (!FileUtils.deleteContents(packagePath) || !packagePath.delete()) {
            Slog.w(TAG, "Unable to remove directory " + packagePath);
        }
    }

    private void cleanupDanglingBitmapDirectoriesLocked(int userId) {
        long start = this.injectElapsedRealtime();
        ShortcutUser user = this.getUserShortcutsLocked(userId);
        File bitmapDir = this.getUserBitmapFilePath(userId);
        File[] children = bitmapDir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isDirectory()) continue;
            String packageName = child.getName();
            if (!user.hasPackage(packageName)) {
                this.cleanupBitmapsForPackage(userId, packageName);
                continue;
            }
            this.cleanupDanglingBitmapFilesLocked(userId, user, packageName, child);
        }
        this.logDurationStat(5, start);
    }

    private void cleanupDanglingBitmapFilesLocked(int userId, ShortcutUser user, String packageName, File path) {
        ArraySet<String> usedFiles = user.getPackageShortcuts(packageName).getUsedBitmapFiles();
        for (File child : path.listFiles()) {
            String name;
            if (!child.isFile() || usedFiles.contains(name = child.getName())) continue;
            child.delete();
        }
    }

    FileOutputStreamWithPath openIconFileForWrite(int userId, ShortcutInfo shortcut) throws IOException {
        File packagePath = new File(this.getUserBitmapFilePath(userId), shortcut.getPackage());
        if (!packagePath.isDirectory()) {
            packagePath.mkdirs();
            if (!packagePath.isDirectory()) {
                throw new IOException("Unable to create directory " + packagePath);
            }
            SELinux.restorecon(packagePath);
        }
        String baseName = String.valueOf(this.injectCurrentTimeMillis());
        int suffix = 0;
        String filename;
        File file;
        while ((file = new File(packagePath, filename = (suffix == 0 ? baseName : baseName + "_" + suffix) + ".png")).exists()) {
            ++suffix;
        }
        return new FileOutputStreamWithPath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveIconAndFixUpShortcut(int userId, ShortcutInfo shortcut) {
        if (shortcut.hasIconFile()) return;
        if (shortcut.hasIconResource()) {
            return;
        }
        long token = this.injectClearCallingIdentity();
        try {
            this.removeIcon(userId, shortcut);
            Icon icon = shortcut.getIcon();
            if (icon == null) {
                return;
            }
            try {
                Bitmap bitmap;
                switch (icon.getType()) {
                    case 2: {
                        this.injectValidateIconResPackage(shortcut, icon);
                        shortcut.setIconResourceId(icon.getResId());
                        shortcut.addFlags(4);
                        return;
                    }
                    case 1: 
                    case 5: {
                        bitmap = icon.getBitmap();
                        break;
                    }
                    default: {
                        throw ShortcutInfo.getInvalidIconException();
                    }
                }
                if (bitmap == null) {
                    Slog.e(TAG, "Null bitmap detected");
                    return;
                }
                File path = null;
                try {
                    FileOutputStreamWithPath out = this.openIconFileForWrite(userId, shortcut);
                    try {
                        path = out.getFile();
                        Bitmap shrunk = ShortcutService.shrinkBitmap(bitmap, this.mMaxIconDimension);
                        try {
                            shrunk.compress(this.mIconPersistFormat, this.mIconPersistQuality, out);
                        }
                        finally {
                            if (bitmap != shrunk) {
                                shrunk.recycle();
                            }
                        }
                        shortcut.setBitmapPath(out.getFile().getAbsolutePath());
                        shortcut.addFlags(8);
                        if (icon.getType() != 5) return;
                        shortcut.addFlags(512);
                        return;
                    }
                    finally {
                        IoUtils.closeQuietly(out);
                    }
                }
                catch (IOException | RuntimeException e) {
                    Slog.wtf(TAG, "Unable to write bitmap to file", e);
                    if (path == null) return;
                    if (!path.exists()) return;
                    path.delete();
                    return;
                }
            }
            finally {
                shortcut.clearIcon();
            }
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    void injectValidateIconResPackage(ShortcutInfo shortcut, Icon icon) {
        if (!shortcut.getPackage().equals(icon.getResPackage())) {
            throw new IllegalArgumentException("Icon resource must reside in shortcut owner package");
        }
    }

    static Bitmap shrinkBitmap(Bitmap in, int maxSize) {
        int ow = in.getWidth();
        int oh = in.getHeight();
        if (ow <= maxSize && oh <= maxSize) {
            return in;
        }
        int longerDimension = Math.max(ow, oh);
        int nw = ow * maxSize / longerDimension;
        int nh = oh * maxSize / longerDimension;
        Bitmap scaledBitmap = Bitmap.createBitmap(nw, nh, Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(scaledBitmap);
        RectF dst = new RectF(0.0f, 0.0f, nw, nh);
        c.drawBitmap(in, null, dst, null);
        return scaledBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixUpShortcutResourceNamesAndValues(ShortcutInfo si) {
        Resources publisherRes = this.injectGetResourcesForApplicationAsUser(si.getPackage(), si.getUserId());
        if (publisherRes != null) {
            long start = this.injectElapsedRealtime();
            try {
                si.lookupAndFillInResourceNames(publisherRes);
            }
            finally {
                this.logDurationStat(10, start);
            }
            si.resolveResourceStrings(publisherRes);
        }
    }

    private boolean isCallerSystem() {
        int callingUid = this.injectBinderCallingUid();
        return UserHandle.isSameApp(callingUid, 1000);
    }

    private boolean isCallerShell() {
        int callingUid = this.injectBinderCallingUid();
        return callingUid == 2000 || callingUid == 0;
    }

    private void enforceSystemOrShell() {
        if (!this.isCallerSystem() && !this.isCallerShell()) {
            throw new SecurityException("Caller must be system or shell");
        }
    }

    private void enforceShell() {
        if (!this.isCallerShell()) {
            throw new SecurityException("Caller must be shell");
        }
    }

    private void enforceSystem() {
        if (!this.isCallerSystem()) {
            throw new SecurityException("Caller must be system");
        }
    }

    private void enforceResetThrottlingPermission() {
        if (this.isCallerSystem()) {
            return;
        }
        this.enforceCallingOrSelfPermission("android.permission.RESET_SHORTCUT_MANAGER_THROTTLING", null);
    }

    private void enforceCallingOrSelfPermission(String permission2, String message) {
        if (this.isCallerSystem()) {
            return;
        }
        this.injectEnforceCallingPermission(permission2, message);
    }

    void injectEnforceCallingPermission(String permission2, String message) {
        this.mContext.enforceCallingPermission(permission2, message);
    }

    private void verifyCaller(String packageName, int userId) {
        Preconditions.checkStringNotEmpty(packageName, "packageName");
        if (this.isCallerSystem()) {
            return;
        }
        int callingUid = this.injectBinderCallingUid();
        if (UserHandle.getUserId(callingUid) != userId) {
            throw new SecurityException("Invalid user-ID");
        }
        if (this.injectGetPackageUid(packageName, userId) != callingUid) {
            throw new SecurityException("Calling package name mismatch");
        }
        Preconditions.checkState(!this.isEphemeralApp(packageName, userId), "Ephemeral apps can't use ShortcutManager");
    }

    void injectPostToHandler(Runnable r) {
        this.mHandler.post(r);
    }

    void injectRunOnNewThread(Runnable r) {
        new Thread(r).start();
    }

    void enforceMaxActivityShortcuts(int numShortcuts) {
        if (numShortcuts > this.mMaxShortcuts) {
            throw new IllegalArgumentException("Max number of dynamic shortcuts exceeded");
        }
    }

    int getMaxActivityShortcuts() {
        return this.mMaxShortcuts;
    }

    void packageShortcutsChanged(String packageName, int userId) {
        this.notifyListeners(packageName, userId);
        this.scheduleSaveUser(userId);
    }

    private void notifyListeners(String packageName, int userId) {
        this.injectPostToHandler(ShortcutService$$Lambda$124.get$Lambda(this, userId, packageName));
    }

    private void fixUpIncomingShortcutInfo(ShortcutInfo shortcut, boolean forUpdate, boolean forPinRequest) {
        Preconditions.checkNotNull(shortcut, "Null shortcut detected");
        if (shortcut.getActivity() != null) {
            Preconditions.checkState(shortcut.getPackage().equals(shortcut.getActivity().getPackageName()), "Cannot publish shortcut: activity " + shortcut.getActivity() + " does not" + " belong to package " + shortcut.getPackage());
            Preconditions.checkState(this.injectIsMainActivity(shortcut.getActivity(), shortcut.getUserId()), "Cannot publish shortcut: activity " + shortcut.getActivity() + " is not" + " main activity");
        }
        if (!forUpdate) {
            shortcut.enforceMandatoryFields(forPinRequest);
            if (!forPinRequest) {
                Preconditions.checkState(shortcut.getActivity() != null, "Cannot publish shortcut: target activity is not set");
            }
        }
        if (shortcut.getIcon() != null) {
            ShortcutInfo.validateIcon(shortcut.getIcon());
        }
        shortcut.replaceFlags(0);
    }

    private void fixUpIncomingShortcutInfo(ShortcutInfo shortcut, boolean forUpdate) {
        this.fixUpIncomingShortcutInfo(shortcut, forUpdate, false);
    }

    public void validateShortcutForPinRequest(ShortcutInfo shortcut) {
        this.fixUpIncomingShortcutInfo(shortcut, false, true);
    }

    private void fillInDefaultActivity(List<ShortcutInfo> shortcuts) {
        ComponentName defaultActivity = null;
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = shortcuts.get(i);
            if (si.getActivity() != null) continue;
            if (defaultActivity == null) {
                defaultActivity = this.injectGetDefaultMainActivity(si.getPackage(), si.getUserId());
                Preconditions.checkState(defaultActivity != null, "Launcher activity not found for package " + si.getPackage());
            }
            si.setActivity(defaultActivity);
        }
    }

    private void assignImplicitRanks(List<ShortcutInfo> shortcuts) {
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            shortcuts.get(i).setImplicitRank(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List<ShortcutInfo> newShortcuts = shortcutInfoList.getList();
        int size = newShortcuts.size();
        Object object = this.mLock;
        synchronized (object) {
            int i;
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncluded(newShortcuts);
            this.fillInDefaultActivity(newShortcuts);
            ps.enforceShortcutCountsBeforeOperation(newShortcuts, 0);
            if (!ps.tryApiCall()) {
                return false;
            }
            ps.clearAllImplicitRanks();
            this.assignImplicitRanks(newShortcuts);
            for (i = 0; i < size; ++i) {
                this.fixUpIncomingShortcutInfo(newShortcuts.get(i), false);
            }
            ps.deleteAllDynamicShortcuts();
            for (i = 0; i < size; ++i) {
                ShortcutInfo newShortcut = newShortcuts.get(i);
                ps.addOrUpdateDynamicShortcut(newShortcut);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List<ShortcutInfo> newShortcuts = shortcutInfoList.getList();
        int size = newShortcuts.size();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncluded(newShortcuts);
            ps.enforceShortcutCountsBeforeOperation(newShortcuts, 2);
            if (!ps.tryApiCall()) {
                return false;
            }
            ps.clearAllImplicitRanks();
            this.assignImplicitRanks(newShortcuts);
            for (int i = 0; i < size; ++i) {
                boolean replacingIcon;
                ShortcutInfo source = newShortcuts.get(i);
                this.fixUpIncomingShortcutInfo(source, true);
                ShortcutInfo target = ps.findShortcutById(source.getId());
                if (target == null) continue;
                if (target.isEnabled() != source.isEnabled()) {
                    Slog.w(TAG, "ShortcutInfo.enabled cannot be changed with updateShortcuts()");
                }
                if (source.hasRank()) {
                    target.setRankChanged();
                    target.setImplicitRank(source.getImplicitRank());
                }
                boolean bl = replacingIcon = source.getIcon() != null;
                if (replacingIcon) {
                    this.removeIcon(userId, target);
                }
                target.copyNonNullFieldsFrom(source);
                target.setTimestamp(this.injectCurrentTimeMillis());
                if (replacingIcon) {
                    this.saveIconAndFixUpShortcut(userId, target);
                }
                if (!replacingIcon && !source.hasStringResources()) continue;
                this.fixUpShortcutResourceNamesAndValues(target);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDynamicShortcuts(String packageName, ParceledListSlice shortcutInfoList, int userId) {
        this.verifyCaller(packageName, userId);
        List<ShortcutInfo> newShortcuts = shortcutInfoList.getList();
        int size = newShortcuts.size();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncluded(newShortcuts);
            this.fillInDefaultActivity(newShortcuts);
            ps.enforceShortcutCountsBeforeOperation(newShortcuts, 1);
            ps.clearAllImplicitRanks();
            this.assignImplicitRanks(newShortcuts);
            if (!ps.tryApiCall()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                ShortcutInfo newShortcut = newShortcuts.get(i);
                this.fixUpIncomingShortcutInfo(newShortcut, false);
                newShortcut.setRankChanged();
                ps.addOrUpdateDynamicShortcut(newShortcut);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
        return true;
    }

    @Override
    public boolean requestPinShortcut(String packageName, ShortcutInfo shortcut, IntentSender resultIntent, int userId) {
        Preconditions.checkNotNull(shortcut);
        Preconditions.checkArgument(shortcut.isEnabled(), "Shortcut must be enabled");
        return this.requestPinItem(packageName, userId, shortcut, null, resultIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent createShortcutResultIntent(String packageName, ShortcutInfo shortcut, int userId) throws RemoteException {
        Intent ret;
        Preconditions.checkNotNull(shortcut);
        Preconditions.checkArgument(shortcut.isEnabled(), "Shortcut must be enabled");
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ret = this.mShortcutRequestPinProcessor.createShortcutResultIntent(shortcut, userId);
        }
        this.verifyStates();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestPinItem(String packageName, int userId, ShortcutInfo shortcut, AppWidgetProviderInfo appWidget, IntentSender resultIntent) {
        boolean ret;
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            Preconditions.checkState(this.isUidForegroundLocked(this.injectBinderCallingUid()), "Calling application must have a foreground activity or a foreground service");
            ret = this.mShortcutRequestPinProcessor.requestPinItemLocked(shortcut, appWidget, userId, resultIntent);
        }
        this.verifyStates();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableShortcuts(String packageName, List shortcutIds, CharSequence disabledMessage, int disabledMessageResId, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutIds, "shortcutIds must be provided");
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncludedWithIds(shortcutIds);
            String disabledMessageString = disabledMessage == null ? null : disabledMessage.toString();
            for (int i = shortcutIds.size() - 1; i >= 0; --i) {
                ps.disableWithId(Preconditions.checkStringNotEmpty((String)shortcutIds.get(i)), disabledMessageString, disabledMessageResId, false);
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableShortcuts(String packageName, List shortcutIds, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutIds, "shortcutIds must be provided");
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncludedWithIds(shortcutIds);
            for (int i = shortcutIds.size() - 1; i >= 0; --i) {
                ps.enableWithId((String)shortcutIds.get(i));
            }
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDynamicShortcuts(String packageName, List shortcutIds, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutIds, "shortcutIds must be provided");
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.ensureImmutableShortcutsNotIncludedWithIds(shortcutIds);
            for (int i = shortcutIds.size() - 1; i >= 0; --i) {
                ps.deleteDynamicWithId(Preconditions.checkStringNotEmpty((String)shortcutIds.get(i)));
            }
            ps.adjustRanks();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllDynamicShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            ps.deleteAllDynamicShortcuts();
        }
        this.packageShortcutsChanged(packageName, userId);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getDynamicShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getShortcutsWithQueryLocked(packageName, userId, 9, ShortcutService$$Lambda$125.get$Lambda());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getManifestShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getShortcutsWithQueryLocked(packageName, userId, 9, ShortcutService$$Lambda$126.get$Lambda());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ShortcutInfo> getPinnedShortcuts(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getShortcutsWithQueryLocked(packageName, userId, 9, ShortcutService$$Lambda$127.get$Lambda());
        }
    }

    private ParceledListSlice<ShortcutInfo> getShortcutsWithQueryLocked(String packageName, int userId, int cloneFlags, Predicate<ShortcutInfo> query) {
        ArrayList<ShortcutInfo> ret = new ArrayList<ShortcutInfo>();
        ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
        ps.findAll(ret, query, cloneFlags);
        return new ParceledListSlice<ShortcutInfo>(ret);
    }

    @Override
    public int getMaxShortcutCountPerActivity(String packageName, int userId) throws RemoteException {
        this.verifyCaller(packageName, userId);
        return this.mMaxShortcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRemainingCallCount(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            return this.mMaxUpdatesPerInterval - ps.getApiCallCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRateLimitResetTime(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            return this.getNextResetTimeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIconMaxDimensions(String packageName, int userId) {
        this.verifyCaller(packageName, userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.mMaxIconDimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportShortcutUsed(String packageName, String shortcutId, int userId) {
        this.verifyCaller(packageName, userId);
        Preconditions.checkNotNull(shortcutId);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutPackage ps = this.getPackageShortcutsForPublisherLocked(packageName, userId);
            if (ps.findShortcutById(shortcutId) == null) {
                Log.w(TAG, String.format("reportShortcutUsed: package %s doesn't have shortcut %s", packageName, shortcutId));
                return;
            }
        }
        long token = this.injectClearCallingIdentity();
        try {
            this.mUsageStatsManagerInternal.reportShortcutUsage(packageName, shortcutId, userId);
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequestPinItemSupported(int callingUserId, int requestType) {
        long token = this.injectClearCallingIdentity();
        try {
            boolean bl = this.mShortcutRequestPinProcessor.isRequestPinItemSupported(callingUserId, requestType);
            return bl;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    @Override
    public void resetThrottling() {
        this.enforceSystemOrShell();
        this.resetThrottlingInner(this.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetThrottlingInner(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isUserUnlockedL(userId)) {
                Log.w(TAG, "User " + userId + " is locked or not running");
                return;
            }
            this.getUserShortcutsLocked(userId).resetThrottling();
        }
        this.scheduleSaveUser(userId);
        Slog.i(TAG, "ShortcutManager: throttling counter reset for user " + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAllThrottlingInner() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRawLastResetTime = this.injectCurrentTimeMillis();
        }
        this.scheduleSaveBaseState();
        Slog.i(TAG, "ShortcutManager: throttling counter reset for all users");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onApplicationActive(String packageName, int userId) {
        this.enforceResetThrottlingPermission();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isUserUnlockedL(userId)) {
                return;
            }
            this.getPackageShortcutsLocked(packageName, userId).resetRateLimitingForCommandLineNoSaving();
            this.saveUserLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasShortcutHostPermission(String callingPackage, int userId) {
        long start = this.injectElapsedRealtime();
        try {
            boolean bl = this.hasShortcutHostPermissionInner(callingPackage, userId);
            return bl;
        }
        finally {
            this.logDurationStat(4, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasShortcutHostPermissionInner(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfUserLockedL(userId);
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            ComponentName cached = user.getCachedLauncher();
            if (cached != null && cached.getPackageName().equals(packageName)) {
                return true;
            }
            ComponentName detected = this.getDefaultLauncher(userId);
            user.setLauncher(detected);
            if (detected != null) {
                return detected.getPackageName().equals(packageName);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName getDefaultLauncher(int userId) {
        long start = this.injectElapsedRealtime();
        long token = this.injectClearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.throwIfUserLockedL(userId);
                ShortcutUser user = this.getUserShortcutsLocked(userId);
                ArrayList<ResolveInfo> allHomeCandidates = new ArrayList<ResolveInfo>();
                long startGetHomeActivitiesAsUser = this.injectElapsedRealtime();
                ComponentName defaultLauncher = this.mPackageManagerInternal.getHomeActivitiesAsUser(allHomeCandidates, userId);
                this.logDurationStat(0, startGetHomeActivitiesAsUser);
                ComponentName detected = null;
                if (defaultLauncher != null) {
                    detected = defaultLauncher;
                } else {
                    detected = user.getLastKnownLauncher();
                    if (detected != null && !this.injectIsActivityEnabledAndExported(detected, userId)) {
                        Slog.w(TAG, "Cached launcher " + detected + " no longer exists");
                        detected = null;
                        user.clearLauncher();
                    }
                }
                if (detected == null) {
                    int size = allHomeCandidates.size();
                    int lastPriority = Integer.MIN_VALUE;
                    for (int i = 0; i < size; ++i) {
                        ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
                        if (!ri.activityInfo.applicationInfo.isSystemApp() || ri.priority < lastPriority) continue;
                        detected = ri.activityInfo.getComponentName();
                        lastPriority = ri.priority;
                    }
                }
                ComponentName componentName = detected;
                return componentName;
            }
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(16, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpPackageForAllLoadedUsers(String packageName, int packageUserId, boolean appStillExists) {
        Object object = this.mLock;
        synchronized (object) {
            this.forEachLoadedUserLocked(ShortcutService$$Lambda$128.get$Lambda(this, packageName, packageUserId, appStillExists));
        }
    }

    void cleanUpPackageLocked(String packageName, int owningUserId, int packageUserId, boolean appStillExists) {
        boolean wasUserLoaded = this.isUserLoadedLocked(owningUserId);
        ShortcutUser user = this.getUserShortcutsLocked(owningUserId);
        boolean doNotify = false;
        if (packageUserId == owningUserId && user.removePackage(packageName) != null) {
            doNotify = true;
        }
        user.removeLauncher(packageUserId, packageName);
        user.forAllLaunchers(ShortcutService$$Lambda$129.get$Lambda(packageName, packageUserId));
        user.forAllPackages(ShortcutService$$Lambda$130.get$Lambda());
        this.scheduleSaveUser(owningUserId);
        if (doNotify) {
            this.notifyListeners(packageName, owningUserId);
        }
        if (appStillExists && packageUserId == owningUserId) {
            user.rescanPackageIfNeeded(packageName, true);
        }
        if (!wasUserLoaded) {
            this.unloadUserLocked(owningUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleLocaleChanged() {
        this.scheduleSaveBaseState();
        Object object = this.mLock;
        synchronized (object) {
            long token = this.injectClearCallingIdentity();
            try {
                this.forEachLoadedUserLocked(ShortcutService$$Lambda$131.get$Lambda());
            }
            finally {
                this.injectRestoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPackageChanges(int ownerUserId) {
        if (this.injectIsSafeModeEnabled()) {
            Slog.i(TAG, "Safe mode, skipping checkPackageChanges()");
            return;
        }
        long start = this.injectElapsedRealtime();
        try {
            ArrayList gonePackages = new ArrayList();
            Object object = this.mLock;
            synchronized (object) {
                ShortcutUser user = this.getUserShortcutsLocked(ownerUserId);
                user.forAllPackageItems(ShortcutService$$Lambda$132.get$Lambda(this, gonePackages));
                if (gonePackages.size() > 0) {
                    for (int i = gonePackages.size() - 1; i >= 0; --i) {
                        ShortcutUser.PackageWithUser pu = (ShortcutUser.PackageWithUser)gonePackages.get(i);
                        this.cleanUpPackageLocked(pu.packageName, ownerUserId, pu.userId, false);
                    }
                }
                this.rescanUpdatedPackagesLocked(ownerUserId, user.getLastAppScanTime());
            }
        }
        finally {
            this.logDurationStat(8, start);
        }
        this.verifyStates();
    }

    private void rescanUpdatedPackagesLocked(int userId, long lastScanTime) {
        ShortcutUser user = this.getUserShortcutsLocked(userId);
        long now = this.injectCurrentTimeMillis();
        boolean afterOta = !this.injectBuildFingerprint().equals(user.getLastAppScanOsFingerprint());
        this.forUpdatedPackages(userId, lastScanTime, afterOta, ShortcutService$$Lambda$133.get$Lambda(this, user, userId));
        user.setLastAppScanTime(now);
        user.setLastAppScanOsFingerprint(this.injectBuildFingerprint());
        this.scheduleSaveUser(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageAdded(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            user.attemptToRestoreIfNeededAndSave(this, packageName, userId);
            user.rescanPackageIfNeeded(packageName, true);
        }
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageUpdateFinished(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            user.attemptToRestoreIfNeededAndSave(this, packageName, userId);
            if (this.isPackageInstalled(packageName, userId)) {
                user.rescanPackageIfNeeded(packageName, true);
            }
        }
        this.verifyStates();
    }

    private void handlePackageRemoved(String packageName, int packageUserId) {
        this.cleanUpPackageForAllLoadedUsers(packageName, packageUserId, false);
        this.verifyStates();
    }

    private void handlePackageDataCleared(String packageName, int packageUserId) {
        this.cleanUpPackageForAllLoadedUsers(packageName, packageUserId, true);
        this.verifyStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageChanged(String packageName, int packageUserId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.getUserShortcutsLocked(packageUserId);
            user.rescanPackageIfNeeded(packageName, true);
        }
        this.verifyStates();
    }

    final PackageInfo getPackageInfoWithSignatures(String packageName, int userId) {
        return this.getPackageInfo(packageName, userId, true);
    }

    final PackageInfo getPackageInfo(String packageName, int userId) {
        return this.getPackageInfo(packageName, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int injectGetPackageUid(String packageName, int userId) {
        long token = this.injectClearCallingIdentity();
        try {
            int n = this.mIPackageManager.getPackageUid(packageName, 794624, userId);
            return n;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            int n = -1;
            return n;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    final PackageInfo getPackageInfo(String packageName, int userId, boolean getSignatures) {
        return ShortcutService.isInstalledOrNull(this.injectPackageInfoWithUninstalled(packageName, userId, getSignatures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageInfo injectPackageInfoWithUninstalled(String packageName, int userId, boolean getSignatures) {
        long start = this.injectElapsedRealtime();
        long token = this.injectClearCallingIdentity();
        try {
            PackageInfo packageInfo = this.mIPackageManager.getPackageInfo(packageName, 0xC2000 | (getSignatures ? 64 : 0), userId);
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(getSignatures ? 2 : 1, start);
            return packageInfo;
        }
        catch (RemoteException e) {
            try {
                Slog.wtf(TAG, "RemoteException", e);
                PackageInfo packageInfo = null;
                this.injectRestoreCallingIdentity(token);
                this.logDurationStat(getSignatures ? 2 : 1, start);
                return packageInfo;
            }
            catch (Throwable throwable) {
                this.injectRestoreCallingIdentity(token);
                this.logDurationStat(getSignatures ? 2 : 1, start);
                throw throwable;
            }
        }
    }

    final ApplicationInfo getApplicationInfo(String packageName, int userId) {
        return ShortcutService.isInstalledOrNull(this.injectApplicationInfoWithUninstalled(packageName, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationInfo injectApplicationInfoWithUninstalled(String packageName, int userId) {
        long start = this.injectElapsedRealtime();
        long token = this.injectClearCallingIdentity();
        try {
            ApplicationInfo applicationInfo = this.mIPackageManager.getApplicationInfo(packageName, 794624, userId);
            return applicationInfo;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            ApplicationInfo applicationInfo = null;
            return applicationInfo;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(3, start);
        }
    }

    final ActivityInfo getActivityInfoWithMetadata(ComponentName activity, int userId) {
        return ShortcutService.isInstalledOrNull(this.injectGetActivityInfoWithMetadataWithUninstalled(activity, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActivityInfo injectGetActivityInfoWithMetadataWithUninstalled(ComponentName activity, int userId) {
        long start = this.injectElapsedRealtime();
        long token = this.injectClearCallingIdentity();
        try {
            ActivityInfo activityInfo = this.mIPackageManager.getActivityInfo(activity, 794752, userId);
            return activityInfo;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            ActivityInfo activityInfo = null;
            return activityInfo;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(6, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<PackageInfo> getInstalledPackages(int userId) {
        long start = this.injectElapsedRealtime();
        long token = this.injectClearCallingIdentity();
        try {
            List<PackageInfo> all = this.injectGetPackagesWithUninstalled(userId);
            all.removeIf(PACKAGE_NOT_INSTALLED);
            List<PackageInfo> list = all;
            return list;
        }
        catch (RemoteException e) {
            Slog.wtf(TAG, "RemoteException", e);
            List<PackageInfo> list = null;
            return list;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(7, start);
        }
    }

    List<PackageInfo> injectGetPackagesWithUninstalled(int userId) throws RemoteException {
        ParceledListSlice parceledList = this.mIPackageManager.getInstalledPackages(794624, userId);
        if (parceledList == null) {
            return Collections.emptyList();
        }
        return parceledList.getList();
    }

    private void forUpdatedPackages(int userId, long lastScanTime, boolean afterOta, Consumer<ApplicationInfo> callback) {
        List<PackageInfo> list = this.getInstalledPackages(userId);
        for (int i = list.size() - 1; i >= 0; --i) {
            PackageInfo pi = list.get(i);
            if (!afterOta && pi.lastUpdateTime < lastScanTime) continue;
            callback.accept(pi.applicationInfo);
        }
    }

    private boolean isApplicationFlagSet(String packageName, int userId, int flags) {
        ApplicationInfo ai = this.injectApplicationInfoWithUninstalled(packageName, userId);
        return ai != null && (ai.flags & flags) == flags;
    }

    private static boolean isInstalled(ApplicationInfo ai) {
        return ai != null && (ai.flags & 0x800000) != 0;
    }

    private static boolean isEphemeralApp(ApplicationInfo ai) {
        return ai != null && ai.isInstantApp();
    }

    private static boolean isInstalled(PackageInfo pi) {
        return pi != null && ShortcutService.isInstalled(pi.applicationInfo);
    }

    private static boolean isInstalled(ActivityInfo ai) {
        return ai != null && ShortcutService.isInstalled(ai.applicationInfo);
    }

    private static ApplicationInfo isInstalledOrNull(ApplicationInfo ai) {
        return ShortcutService.isInstalled(ai) ? ai : null;
    }

    private static PackageInfo isInstalledOrNull(PackageInfo pi) {
        return ShortcutService.isInstalled(pi) ? pi : null;
    }

    private static ActivityInfo isInstalledOrNull(ActivityInfo ai) {
        return ShortcutService.isInstalled(ai) ? ai : null;
    }

    boolean isPackageInstalled(String packageName, int userId) {
        return this.getApplicationInfo(packageName, userId) != null;
    }

    boolean isEphemeralApp(String packageName, int userId) {
        return ShortcutService.isEphemeralApp(this.getApplicationInfo(packageName, userId));
    }

    XmlResourceParser injectXmlMetaData(ActivityInfo activityInfo, String key) {
        return activityInfo.loadXmlMetaData(this.mContext.getPackageManager(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Resources injectGetResourcesForApplicationAsUser(String packageName, int userId) {
        long start = this.injectElapsedRealtime();
        long token = this.injectClearCallingIdentity();
        try {
            Resources resources = this.mContext.getPackageManager().getResourcesForApplicationAsUser(packageName, userId);
            return resources;
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Resources for package " + packageName + " not found");
            Resources resources = null;
            return resources;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
            this.logDurationStat(9, start);
        }
    }

    private Intent getMainActivityIntent() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory(LAUNCHER_INTENT_CATEGORY);
        return intent;
    }

    List<ResolveInfo> queryActivities(Intent baseIntent, String packageName, ComponentName activity, int userId) {
        baseIntent.setPackage(Preconditions.checkNotNull(packageName));
        if (activity != null) {
            baseIntent.setComponent(activity);
        }
        return this.queryActivities(baseIntent, userId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> queryActivities(Intent intent, int userId, boolean exportedOnly) {
        List<ResolveInfo> resolved;
        long token = this.injectClearCallingIdentity();
        try {
            resolved = this.mContext.getPackageManager().queryIntentActivitiesAsUser(intent, 794624, userId);
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
        if (resolved == null || resolved.size() == 0) {
            return EMPTY_RESOLVE_INFO;
        }
        if (!ShortcutService.isInstalled(resolved.get((int)0).activityInfo)) {
            return EMPTY_RESOLVE_INFO;
        }
        if (exportedOnly) {
            resolved.removeIf(ACTIVITY_NOT_EXPORTED);
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName injectGetDefaultMainActivity(String packageName, int userId) {
        long start = this.injectElapsedRealtime();
        try {
            List<ResolveInfo> resolved = this.queryActivities(this.getMainActivityIntent(), packageName, null, userId);
            ComponentName componentName = resolved.size() == 0 ? null : resolved.get((int)0).activityInfo.getComponentName();
            return componentName;
        }
        finally {
            this.logDurationStat(11, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean injectIsMainActivity(ComponentName activity, int userId) {
        long start = this.injectElapsedRealtime();
        try {
            if (DUMMY_MAIN_ACTIVITY.equals(activity.getClassName())) {
                boolean bl = true;
                return bl;
            }
            List<ResolveInfo> resolved = this.queryActivities(this.getMainActivityIntent(), activity.getPackageName(), activity, userId);
            boolean bl = resolved.size() > 0;
            return bl;
        }
        finally {
            this.logDurationStat(12, start);
        }
    }

    ComponentName getDummyMainActivity(String packageName) {
        return new ComponentName(packageName, DUMMY_MAIN_ACTIVITY);
    }

    boolean isDummyMainActivity(ComponentName name) {
        return name != null && DUMMY_MAIN_ACTIVITY.equals(name.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ResolveInfo> injectGetMainActivities(String packageName, int userId) {
        long start = this.injectElapsedRealtime();
        try {
            List<ResolveInfo> list = this.queryActivities(this.getMainActivityIntent(), packageName, null, userId);
            return list;
        }
        finally {
            this.logDurationStat(12, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean injectIsActivityEnabledAndExported(ComponentName activity, int userId) {
        long start = this.injectElapsedRealtime();
        try {
            boolean bl = this.queryActivities(new Intent(), activity.getPackageName(), activity, userId).size() > 0;
            return bl;
        }
        finally {
            this.logDurationStat(13, start);
        }
    }

    ComponentName injectGetPinConfirmationActivity(String launcherPackageName, int launcherUserId, int requestType) {
        Preconditions.checkNotNull(launcherPackageName);
        String action = requestType == 1 ? "android.content.pm.action.CONFIRM_PIN_SHORTCUT" : "android.content.pm.action.CONFIRM_PIN_APPWIDGET";
        Intent confirmIntent = new Intent(action).setPackage(launcherPackageName);
        List<ResolveInfo> candidates = this.queryActivities(confirmIntent, launcherUserId, false);
        Iterator<ResolveInfo> iterator = candidates.iterator();
        if (iterator.hasNext()) {
            ResolveInfo ri = iterator.next();
            return ri.activityInfo.getComponentName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean injectIsSafeModeEnabled() {
        long token = this.injectClearCallingIdentity();
        try {
            boolean bl = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).isSafeModeEnabled();
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParentOrSelfUserId(int userId) {
        long token = this.injectClearCallingIdentity();
        try {
            UserInfo parent = this.mUserManager.getProfileParent(userId);
            int n = parent != null ? parent.id : userId;
            return n;
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    void injectSendIntentSender(IntentSender intentSender, Intent extras) {
        if (intentSender == null) {
            return;
        }
        try {
            intentSender.sendIntent(this.mContext, 0, extras, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "sendIntent failed().", e);
        }
    }

    boolean shouldBackupApp(String packageName, int userId) {
        return this.isApplicationFlagSet(packageName, userId, 32768);
    }

    boolean shouldBackupApp(PackageInfo pi) {
        return (pi.applicationInfo.flags & 0x8000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBackupPayload(int userId) {
        this.enforceSystem();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isUserUnlockedL(userId)) {
                this.wtf("Can't backup: user " + userId + " is locked or not running");
                return null;
            }
            ShortcutUser user = this.getUserShortcutsLocked(userId);
            if (user == null) {
                this.wtf("Can't backup: user not found: id=" + userId);
                return null;
            }
            user.forAllPackageItems(ShortcutService$$Lambda$134.get$Lambda());
            user.forAllLaunchers(ShortcutService$$Lambda$135.get$Lambda());
            this.scheduleSaveUser(userId);
            this.saveDirtyInfo();
            ByteArrayOutputStream os = new ByteArrayOutputStream(32768);
            try {
                this.saveUserInternalLocked(userId, os, true);
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(TAG, "Backup failed.", e);
                return null;
            }
            return os.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyRestore(byte[] payload, int userId) {
        this.enforceSystem();
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser restored;
            if (!this.isUserUnlockedL(userId)) {
                this.wtf("Can't restore: user " + userId + " is locked or not running");
                return;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(payload);
            try {
                restored = this.loadUserInternal(userId, is, true);
            }
            catch (InvalidFileFormatException | IOException | XmlPullParserException e) {
                Slog.w(TAG, "Restoration failed.", e);
                return;
            }
            this.getUserShortcutsLocked(userId).mergeRestoredFile(restored);
            this.rescanUpdatedPackagesLocked(userId, 0L);
            this.saveUserLocked(userId);
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.enforceCallingOrSelfPermission("android.permission.DUMP", "can't dump by this caller");
        boolean checkin = false;
        boolean clear = false;
        if (args != null) {
            for (String arg : args) {
                if ("-c".equals(arg)) {
                    checkin = true;
                    continue;
                }
                if (!"--checkin".equals(arg)) continue;
                checkin = true;
                clear = true;
            }
        }
        if (checkin) {
            this.dumpCheckin(pw, clear);
        } else {
            this.dumpInner(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInner(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            long now = this.injectCurrentTimeMillis();
            pw.print("Now: [");
            pw.print(now);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(now));
            pw.print("  Raw last reset: [");
            pw.print(this.mRawLastResetTime);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(this.mRawLastResetTime));
            long last = this.getLastResetTimeLocked();
            pw.print("  Last reset: [");
            pw.print(last);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(last));
            long next = this.getNextResetTimeLocked();
            pw.print("  Next reset: [");
            pw.print(next);
            pw.print("] ");
            pw.print(ShortcutService.formatTime(next));
            pw.print("  Config:");
            pw.print("    Max icon dim: ");
            pw.println(this.mMaxIconDimension);
            pw.print("    Icon format: ");
            pw.println((Object)this.mIconPersistFormat);
            pw.print("    Icon quality: ");
            pw.println(this.mIconPersistQuality);
            pw.print("    saveDelayMillis: ");
            pw.println(this.mSaveDelayMillis);
            pw.print("    resetInterval: ");
            pw.println(this.mResetInterval);
            pw.print("    maxUpdatesPerInterval: ");
            pw.println(this.mMaxUpdatesPerInterval);
            pw.print("    maxShortcutsPerActivity: ");
            pw.println(this.mMaxShortcuts);
            pw.println();
            pw.println("  Stats:");
            Object object2 = this.mStatLock;
            synchronized (object2) {
                for (int i2 = 0; i2 < 17; ++i2) {
                    this.dumpStatLS(pw, "    ", i2);
                }
            }
            pw.println();
            pw.print("  #Failures: ");
            pw.println(this.mWtfCount);
            if (this.mLastWtfStacktrace != null) {
                pw.print("  Last failure stack trace: ");
                pw.println(Log.getStackTraceString(this.mLastWtfStacktrace));
            }
            for (i = 0; i < this.mUsers.size(); ++i) {
                pw.println();
                this.mUsers.valueAt(i).dump(pw, "  ");
            }
            pw.println();
            pw.println("  UID state:");
            for (i = 0; i < this.mUidState.size(); ++i) {
                int uid = this.mUidState.keyAt(i);
                int state = this.mUidState.valueAt(i);
                pw.print("    UID=");
                pw.print(uid);
                pw.print(" state=");
                pw.print(state);
                if (this.isProcessStateForeground(state)) {
                    pw.print("  [FG]");
                }
                pw.print("  last FG=");
                pw.print(this.mUidLastForegroundElapsedTime.get(uid));
                pw.println();
            }
        }
    }

    static String formatTime(long time) {
        Time tobj = new Time();
        tobj.set(time);
        return tobj.format("%Y-%m-%d %H:%M:%S");
    }

    private void dumpStatLS(PrintWriter pw, String prefix, int statId) {
        pw.print(prefix);
        int count = this.mCountStats[statId];
        long dur = this.mDurationStats[statId];
        pw.println(String.format("%s: count=%d, total=%dms, avg=%.1fms", STAT_LABELS[statId], count, dur, count == 0 ? 0.0 : (double)dur / (double)count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCheckin(PrintWriter pw, boolean clear) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                JSONArray users = new JSONArray();
                for (int i = 0; i < this.mUsers.size(); ++i) {
                    users.put(this.mUsers.valueAt(i).dumpCheckin(clear));
                }
                JSONObject result = new JSONObject();
                result.put(KEY_SHORTCUT, users);
                result.put(KEY_LOW_RAM, this.injectIsLowRamDevice());
                result.put(KEY_ICON_SIZE, this.mMaxIconDimension);
                pw.println(result.toString(1));
            }
            catch (JSONException e) {
                Slog.e(TAG, "Unable to write in json", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        this.enforceShell();
        long token = this.injectClearCallingIdentity();
        try {
            int status = new MyShellCommand().exec(this, in, out, err, args, callback, resultReceiver);
            resultReceiver.send(status, null);
        }
        finally {
            this.injectRestoreCallingIdentity(token);
        }
    }

    long injectCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    long injectElapsedRealtime() {
        return SystemClock.elapsedRealtime();
    }

    int injectBinderCallingUid() {
        return ShortcutService.getCallingUid();
    }

    private int getCallingUserId() {
        return UserHandle.getUserId(this.injectBinderCallingUid());
    }

    long injectClearCallingIdentity() {
        return Binder.clearCallingIdentity();
    }

    void injectRestoreCallingIdentity(long token) {
        Binder.restoreCallingIdentity(token);
    }

    String injectBuildFingerprint() {
        return Build.FINGERPRINT;
    }

    final void wtf(String message) {
        this.wtf(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wtf(String message, Throwable e) {
        if (e == null) {
            e = new RuntimeException("Stacktrace");
        }
        Object object = this.mLock;
        synchronized (object) {
            ++this.mWtfCount;
            this.mLastWtfStacktrace = new Exception("Last failure was logged here:");
        }
        Slog.wtf(TAG, message, e);
    }

    File injectSystemDataPath() {
        return Environment.getDataSystemDirectory();
    }

    File injectUserDataPath(int userId) {
        return new File(Environment.getDataSystemCeDirectory(userId), DIRECTORY_PER_USER);
    }

    boolean injectIsLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    void injectRegisterUidObserver(IUidObserver observer, int which) {
        try {
            ActivityManager.getService().registerUidObserver(observer, which, -1, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    File getUserBitmapFilePath(int userId) {
        return new File(this.injectUserDataPath(userId), DIRECTORY_BITMAPS);
    }

    SparseArray<ShortcutUser> getShortcutsForTest() {
        return this.mUsers;
    }

    int getMaxShortcutsForTest() {
        return this.mMaxShortcuts;
    }

    int getMaxUpdatesPerIntervalForTest() {
        return this.mMaxUpdatesPerInterval;
    }

    long getResetIntervalForTest() {
        return this.mResetInterval;
    }

    int getMaxIconDimensionForTest() {
        return this.mMaxIconDimension;
    }

    Bitmap.CompressFormat getIconPersistFormatForTest() {
        return this.mIconPersistFormat;
    }

    int getIconPersistQualityForTest() {
        return this.mIconPersistQuality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortcutPackage getPackageShortcutForTest(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.mUsers.get(userId);
            if (user == null) {
                return null;
            }
            return user.getAllPackagesForTest().get(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortcutInfo getPackageShortcutForTest(String packageName, String shortcutId, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutPackage pkg = this.getPackageShortcutForTest(packageName, userId);
            if (pkg == null) {
                return null;
            }
            return pkg.findShortcutById(shortcutId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortcutLauncher getLauncherShortcutForTest(String packageName, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            ShortcutUser user = this.mUsers.get(userId);
            if (user == null) {
                return null;
            }
            return user.getAllLaunchersForTest().get(ShortcutUser.PackageWithUser.of(userId, packageName));
        }
    }

    ShortcutRequestPinProcessor getShortcutRequestPinProcessorForTest() {
        return this.mShortcutRequestPinProcessor;
    }

    boolean injectShouldPerformVerification() {
        return false;
    }

    final void verifyStates() {
        if (this.injectShouldPerformVerification()) {
            this.verifyStatesInner();
        }
    }

    private final void verifyStatesForce() {
        this.verifyStatesInner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyStatesInner() {
        Object object = this.mLock;
        synchronized (object) {
            this.forEachLoadedUserLocked(ShortcutService$$Lambda$136.get$Lambda());
        }
    }

    static final /* synthetic */ void lambda$verifyStatesInner$157$ShortcutService(ShortcutUser u) {
        u.forAllPackageItems(ShortcutService$$Lambda$137.get$Lambda());
    }

    static final /* synthetic */ void lambda$getBackupPayload$156$ShortcutService(ShortcutLauncher launcher) {
        launcher.ensureVersionInfo();
    }

    static final /* synthetic */ void lambda$getBackupPayload$155$ShortcutService(ShortcutPackageItem spi) {
        spi.refreshPackageSignatureAndSave();
    }

    final /* synthetic */ void lambda$rescanUpdatedPackagesLocked$154$ShortcutService(ShortcutUser shortcutUser, int n, ApplicationInfo ai) {
        shortcutUser.attemptToRestoreIfNeededAndSave(this, ai.packageName, n);
        shortcutUser.rescanPackageIfNeeded(ai.packageName, true);
    }

    final /* synthetic */ void lambda$checkPackageChanges$153$ShortcutService(ArrayList arrayList, ShortcutPackageItem spi) {
        if (spi.getPackageInfo().isShadow()) {
            return;
        }
        if (!this.isPackageInstalled(spi.getPackageName(), spi.getPackageUserId())) {
            arrayList.add(ShortcutUser.PackageWithUser.of(spi));
        }
    }

    static final /* synthetic */ void lambda$handleLocaleChanged$152$ShortcutService(ShortcutUser user) {
        user.detectLocaleChange();
    }

    static final /* synthetic */ void lambda$cleanUpPackageLocked$148$ShortcutService(ShortcutPackage p) {
        p.refreshPinnedFlags();
    }

    static final /* synthetic */ void lambda$cleanUpPackageLocked$147$ShortcutService(String string2, int n, ShortcutLauncher l) {
        l.cleanUpPackage(string2, n);
    }

    final /* synthetic */ void lambda$cleanUpPackageForAllLoadedUsers$146$ShortcutService(String string2, int n, boolean bl, ShortcutUser user) {
        this.cleanUpPackageLocked(string2, user.getUserId(), n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$notifyListeners$145$ShortcutService(int n, String string2) {
        try {
            ArrayList<ShortcutServiceInternal.ShortcutChangeListener> copy;
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isUserUnlockedL(n)) {
                    return;
                }
                copy = new ArrayList<ShortcutServiceInternal.ShortcutChangeListener>(this.mListeners);
            }
            for (int i = copy.size() - 1; i >= 0; --i) {
                copy.get(i).onShortcutChanged(string2, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$handleUnlockUser$144$ShortcutService(long l, int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.logDurationStat(15, l);
            this.getUserShortcutsLocked(n);
        }
    }

    private class MyShellCommand
    extends ShellCommand {
        private int mUserId = 0;

        private MyShellCommand() {
        }

        private void parseOptionsLocked(boolean takeUser) throws CommandException {
            String opt;
            block6: while ((opt = this.getNextOption()) != null) {
                switch (opt) {
                    case "--user": {
                        if (!takeUser) break;
                        this.mUserId = UserHandle.parseUserArg(this.getNextArgRequired());
                        if (ShortcutService.this.isUserUnlockedL(this.mUserId)) continue block6;
                        throw new CommandException("User " + this.mUserId + " is not running or locked");
                    }
                }
                throw new CommandException("Unknown option: " + opt);
            }
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter pw = this.getOutPrintWriter();
            try {
                switch (cmd) {
                    case "reset-throttling": {
                        this.handleResetThrottling();
                        break;
                    }
                    case "reset-all-throttling": {
                        this.handleResetAllThrottling();
                        break;
                    }
                    case "override-config": {
                        this.handleOverrideConfig();
                        break;
                    }
                    case "reset-config": {
                        this.handleResetConfig();
                        break;
                    }
                    case "clear-default-launcher": {
                        this.handleClearDefaultLauncher();
                        break;
                    }
                    case "get-default-launcher": {
                        this.handleGetDefaultLauncher();
                        break;
                    }
                    case "unload-user": {
                        this.handleUnloadUser();
                        break;
                    }
                    case "clear-shortcuts": {
                        this.handleClearShortcuts();
                        break;
                    }
                    case "verify-states": {
                        this.handleVerifyStates();
                        break;
                    }
                    default: {
                        return this.handleDefaultCommands(cmd);
                    }
                }
            }
            catch (CommandException e) {
                pw.println("Error: " + e.getMessage());
                return 1;
            }
            pw.println("Success");
            return 0;
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Usage: cmd shortcut COMMAND [options ...]");
            pw.println();
            pw.println("cmd shortcut reset-throttling [--user USER_ID]");
            pw.println("    Reset throttling for all packages and users");
            pw.println();
            pw.println("cmd shortcut reset-all-throttling");
            pw.println("    Reset the throttling state for all users");
            pw.println();
            pw.println("cmd shortcut override-config CONFIG");
            pw.println("    Override the configuration for testing (will last until reboot)");
            pw.println();
            pw.println("cmd shortcut reset-config");
            pw.println("    Reset the configuration set with \"update-config\"");
            pw.println();
            pw.println("cmd shortcut clear-default-launcher [--user USER_ID]");
            pw.println("    Clear the cached default launcher");
            pw.println();
            pw.println("cmd shortcut get-default-launcher [--user USER_ID]");
            pw.println("    Show the default launcher");
            pw.println();
            pw.println("cmd shortcut unload-user [--user USER_ID]");
            pw.println("    Unload a user from the memory");
            pw.println("    (This should not affect any observable behavior)");
            pw.println();
            pw.println("cmd shortcut clear-shortcuts [--user USER_ID] PACKAGE");
            pw.println("    Remove all shortcuts from a package, including pinned shortcuts");
            pw.println();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResetThrottling() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                Slog.i(ShortcutService.TAG, "cmd: handleResetThrottling: user=" + this.mUserId);
                ShortcutService.this.resetThrottlingInner(this.mUserId);
            }
        }

        private void handleResetAllThrottling() {
            Slog.i(ShortcutService.TAG, "cmd: handleResetAllThrottling");
            ShortcutService.this.resetAllThrottlingInner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOverrideConfig() throws CommandException {
            String config = this.getNextArgRequired();
            Slog.i(ShortcutService.TAG, "cmd: handleOverrideConfig: " + config);
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                if (!ShortcutService.this.updateConfigurationLocked(config)) {
                    throw new CommandException("override-config failed.  See logcat for details.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResetConfig() {
            Slog.i(ShortcutService.TAG, "cmd: handleResetConfig");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.loadConfigurationLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearLauncher() {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.getUserShortcutsLocked(this.mUserId).forceClearLauncher();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showLauncher() {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.hasShortcutHostPermissionInner("-", this.mUserId);
                this.getOutPrintWriter().println("Launcher: " + ShortcutService.this.getUserShortcutsLocked(this.mUserId).getLastKnownLauncher());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClearDefaultLauncher() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                this.clearLauncher();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleGetDefaultLauncher() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                this.clearLauncher();
                this.showLauncher();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleUnloadUser() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                Slog.i(ShortcutService.TAG, "cmd: handleUnloadUser: user=" + this.mUserId);
                ShortcutService.this.handleCleanupUser(this.mUserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClearShortcuts() throws CommandException {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                this.parseOptionsLocked(true);
                String packageName = this.getNextArgRequired();
                Slog.i(ShortcutService.TAG, "cmd: handleClearShortcuts: user" + this.mUserId + ", " + packageName);
                ShortcutService.this.cleanUpPackageForAllLoadedUsers(packageName, this.mUserId, true);
            }
        }

        private void handleVerifyStates() throws CommandException {
            try {
                ShortcutService.this.verifyStatesForce();
            }
            catch (Throwable th) {
                throw new CommandException(th.getMessage() + "\n" + Log.getStackTraceString(th));
            }
        }
    }

    static class CommandException
    extends Exception {
        public CommandException(String message) {
            super(message);
        }
    }

    private class LocalService
    extends ShortcutServiceInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ShortcutInfo> getShortcuts(int launcherUserId, String callingPackage, long changedSince, String packageName, List<String> shortcutIds, ComponentName componentName, int queryFlags, int userId) {
            int cloneFlag;
            ArrayList<ShortcutInfo> ret = new ArrayList<ShortcutInfo>();
            boolean cloneKeyFieldOnly = (queryFlags & 4) != 0;
            int n = cloneFlag = cloneKeyFieldOnly ? 4 : 11;
            if (packageName == null) {
                shortcutIds = null;
            }
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                if (packageName != null) {
                    this.getShortcutsInnerLocked(launcherUserId, callingPackage, packageName, shortcutIds, changedSince, componentName, queryFlags, userId, ret, cloneFlag);
                } else {
                    List<String> shortcutIdsF = shortcutIds;
                    ShortcutService.this.getUserShortcutsLocked(userId).forAllPackages(ShortcutService$LocalService$$Lambda$164.get$Lambda(this, launcherUserId, callingPackage, shortcutIdsF, changedSince, componentName, queryFlags, userId, ret, cloneFlag));
                }
            }
            return ret;
        }

        private void getShortcutsInnerLocked(int launcherUserId, String callingPackage, String packageName, List<String> shortcutIds, long changedSince, ComponentName componentName, int queryFlags, int userId, ArrayList<ShortcutInfo> ret, int cloneFlag) {
            ArraySet<String> ids = shortcutIds == null ? null : new ArraySet<String>(shortcutIds);
            ShortcutPackage p = ShortcutService.this.getUserShortcutsLocked(userId).getPackageShortcutsIfExists(packageName);
            if (p == null) {
                return;
            }
            p.findAll(ret, ShortcutService$LocalService$$Lambda$165.get$Lambda(changedSince, ids, componentName, queryFlags), cloneFlag, callingPackage, launcherUserId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPinnedByCaller(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                ShortcutInfo si = this.getShortcutInfoLocked(launcherUserId, callingPackage, packageName, shortcutId, userId);
                return si != null && si.isPinned();
            }
        }

        private ShortcutInfo getShortcutInfoLocked(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId");
            ShortcutService.this.throwIfUserLockedL(userId);
            ShortcutService.this.throwIfUserLockedL(launcherUserId);
            ShortcutPackage p = ShortcutService.this.getUserShortcutsLocked(userId).getPackageShortcutsIfExists(packageName);
            if (p == null) {
                return null;
            }
            ArrayList<ShortcutInfo> list = new ArrayList<ShortcutInfo>(1);
            p.findAll(list, ShortcutService$LocalService$$Lambda$166.get$Lambda(shortcutId), 0, callingPackage, launcherUserId);
            return list.size() == 0 ? null : list.get(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pinShortcuts(int launcherUserId, String callingPackage, String packageName, List<String> shortcutIds, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName");
            Preconditions.checkNotNull(shortcutIds, "shortcutIds");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutLauncher launcher = ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId);
                launcher.attemptToRestoreIfNeededAndSave();
                launcher.pinShortcuts(userId, packageName, shortcutIds);
            }
            ShortcutService.this.packageShortcutsChanged(packageName, userId);
            ShortcutService.this.verifyStates();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Intent[] createShortcutIntents(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkStringNotEmpty(packageName, "packageName can't be empty");
            Preconditions.checkStringNotEmpty(shortcutId, "shortcutId can't be empty");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                ShortcutInfo si = this.getShortcutInfoLocked(launcherUserId, callingPackage, packageName, shortcutId, userId);
                if (si == null || !si.isEnabled() || !si.isAlive()) {
                    Log.e(ShortcutService.TAG, "Shortcut " + shortcutId + " does not exist or disabled");
                    return null;
                }
                return si.getIntents();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(ShortcutServiceInternal.ShortcutChangeListener listener) {
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.mListeners.add(Preconditions.checkNotNull(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getShortcutIconResId(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkNotNull(callingPackage, "callingPackage");
            Preconditions.checkNotNull(packageName, "packageName");
            Preconditions.checkNotNull(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                ShortcutPackage p = ShortcutService.this.getUserShortcutsLocked(userId).getPackageShortcutsIfExists(packageName);
                if (p == null) {
                    return 0;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : var6_6
                ShortcutInfo shortcutInfo = p.findShortcutById(shortcutId);
                return shortcutInfo != null && shortcutInfo.hasIconResource() ? shortcutInfo.getIconResourceId() : 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor getShortcutIconFd(int launcherUserId, String callingPackage, String packageName, String shortcutId, int userId) {
            Preconditions.checkNotNull(callingPackage, "callingPackage");
            Preconditions.checkNotNull(packageName, "packageName");
            Preconditions.checkNotNull(shortcutId, "shortcutId");
            Object object = ShortcutService.this.mLock;
            synchronized (object) {
                ShortcutService.this.throwIfUserLockedL(userId);
                ShortcutService.this.throwIfUserLockedL(launcherUserId);
                ShortcutService.this.getLauncherShortcutsLocked(callingPackage, userId, launcherUserId).attemptToRestoreIfNeededAndSave();
                ShortcutPackage p = ShortcutService.this.getUserShortcutsLocked(userId).getPackageShortcutsIfExists(packageName);
                if (p == null) {
                    return null;
                }
                ShortcutInfo shortcutInfo = p.findShortcutById(shortcutId);
                if (shortcutInfo == null || !shortcutInfo.hasIconFile()) {
                    return null;
                }
                try {
                    if (shortcutInfo.getBitmapPath() == null) {
                        Slog.w(ShortcutService.TAG, "null bitmap detected in getShortcutIconFd()");
                        return null;
                    }
                    return ParcelFileDescriptor.open(new File(shortcutInfo.getBitmapPath()), 0x10000000);
                }
                catch (FileNotFoundException e) {
                    Slog.e(ShortcutService.TAG, "Icon file not found: " + shortcutInfo.getBitmapPath());
                    return null;
                }
            }
        }

        @Override
        public boolean hasShortcutHostPermission(int launcherUserId, String callingPackage) {
            return ShortcutService.this.hasShortcutHostPermission(callingPackage, launcherUserId);
        }

        @Override
        public boolean requestPinAppWidget(String callingPackage, AppWidgetProviderInfo appWidget, IntentSender resultIntent, int userId) {
            Preconditions.checkNotNull(appWidget);
            return ShortcutService.this.requestPinItem(callingPackage, userId, null, appWidget, resultIntent);
        }

        @Override
        public boolean isRequestPinItemSupported(int callingUserId, int requestType) {
            return ShortcutService.this.isRequestPinItemSupported(callingUserId, requestType);
        }

        static final /* synthetic */ boolean lambda$getShortcutInfoLocked$151$ShortcutService$LocalService(String string2, ShortcutInfo si) {
            return string2.equals(si.getId());
        }

        static final /* synthetic */ boolean lambda$getShortcutsInnerLocked$150$ShortcutService$LocalService(long l, ArraySet arraySet, ComponentName componentName, int n, ShortcutInfo si) {
            if (si.getLastChangedTimestamp() < l) {
                return false;
            }
            if (arraySet != null && !arraySet.contains(si.getId())) {
                return false;
            }
            if (componentName != null && si.getActivity() != null && !si.getActivity().equals(componentName)) {
                return false;
            }
            if ((n & 1) != 0 && si.isDynamic()) {
                return true;
            }
            if ((n & 2) != 0 && si.isPinned()) {
                return true;
            }
            return (n & 8) != 0 && si.isManifestShortcut();
        }

        final /* synthetic */ void lambda$getShortcuts$149$ShortcutService$LocalService(int n, String string2, List list, long l, ComponentName componentName, int n2, int n3, ArrayList arrayList, int n4, ShortcutPackage p) {
            this.getShortcutsInnerLocked(n, string2, p.getPackageName(), list, l, componentName, n2, n3, arrayList, n4);
        }
    }

    static class FileOutputStreamWithPath
    extends FileOutputStream {
        private final File mFile;

        public FileOutputStreamWithPath(File file) throws FileNotFoundException {
            super(file);
            this.mFile = file;
        }

        public File getFile() {
            return this.mFile;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        final ShortcutService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new ShortcutService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService(ShortcutService.KEY_SHORTCUT, this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            this.mService.onBootPhase(phase);
        }

        @Override
        public void onCleanupUser(int userHandle) {
            this.mService.handleCleanupUser(userHandle);
        }

        @Override
        public void onUnlockUser(int userId) {
            this.mService.handleUnlockUser(userId);
        }
    }

    static class InvalidFileFormatException
    extends Exception {
        public InvalidFileFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    static @interface ShortcutOperation {
    }

    static interface Stats {
        public static final int GET_DEFAULT_HOME = 0;
        public static final int GET_PACKAGE_INFO = 1;
        public static final int GET_PACKAGE_INFO_WITH_SIG = 2;
        public static final int GET_APPLICATION_INFO = 3;
        public static final int LAUNCHER_PERMISSION_CHECK = 4;
        public static final int CLEANUP_DANGLING_BITMAPS = 5;
        public static final int GET_ACTIVITY_WITH_METADATA = 6;
        public static final int GET_INSTALLED_PACKAGES = 7;
        public static final int CHECK_PACKAGE_CHANGES = 8;
        public static final int GET_APPLICATION_RESOURCES = 9;
        public static final int RESOURCE_NAME_LOOKUP = 10;
        public static final int GET_LAUNCHER_ACTIVITY = 11;
        public static final int CHECK_LAUNCHER_ACTIVITY = 12;
        public static final int IS_ACTIVITY_ENABLED = 13;
        public static final int PACKAGE_UPDATE_CHECK = 14;
        public static final int ASYNC_PRELOAD_USER_DELAY = 15;
        public static final int GET_DEFAULT_LAUNCHER = 16;
        public static final int COUNT = 17;
    }

    static interface ConfigConstants {
        public static final String KEY_SAVE_DELAY_MILLIS = "save_delay_ms";
        public static final String KEY_RESET_INTERVAL_SEC = "reset_interval_sec";
        public static final String KEY_MAX_UPDATES_PER_INTERVAL = "max_updates_per_interval";
        public static final String KEY_MAX_ICON_DIMENSION_DP = "max_icon_dimension_dp";
        public static final String KEY_MAX_ICON_DIMENSION_DP_LOWRAM = "max_icon_dimension_dp_lowram";
        public static final String KEY_MAX_SHORTCUTS = "max_shortcuts";
        public static final String KEY_ICON_QUALITY = "icon_quality";
        public static final String KEY_ICON_FORMAT = "icon_format";
    }
}

