/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.os.Build;
import android.util.AtomicFile;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastPrintWriter;
import com.android.server.pm.AbstractStatsBase;
import com.android.server.pm.PackageManagerServiceUtils;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import libcore.io.IoUtils;

public class PackageDexUsage
extends AbstractStatsBase<Void> {
    private static final String TAG = "PackageDexUsage";
    private static final int PACKAGE_DEX_USAGE_VERSION = 1;
    private static final String PACKAGE_DEX_USAGE_VERSION_HEADER = "PACKAGE_MANAGER__PACKAGE_DEX_USAGE__";
    private static final String SPLIT_CHAR = ",";
    private static final String DEX_LINE_CHAR = "#";
    @GuardedBy(value="mPackageUseInfoMap")
    private Map<String, PackageUseInfo> mPackageUseInfoMap = new HashMap<String, PackageUseInfo>();

    public PackageDexUsage() {
        super("package-dex-usage.list", "PackageDexUsage_DiskWriter", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean record(String owningPackageName, String dexPath, int ownerUserId, String loaderIsa, boolean isUsedByOtherApps, boolean primaryOrSplit) {
        if (!PackageManagerServiceUtils.checkISA(loaderIsa)) {
            throw new IllegalArgumentException("loaderIsa " + loaderIsa + " is unsupported");
        }
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo packageUseInfo = this.mPackageUseInfoMap.get(owningPackageName);
            if (packageUseInfo == null) {
                packageUseInfo = new PackageUseInfo();
                if (primaryOrSplit) {
                    packageUseInfo.mIsUsedByOtherApps = isUsedByOtherApps;
                } else {
                    packageUseInfo.mDexUseInfoMap.put(dexPath, new DexUseInfo(isUsedByOtherApps, ownerUserId, loaderIsa));
                }
                this.mPackageUseInfoMap.put(owningPackageName, packageUseInfo);
                return true;
            }
            if (primaryOrSplit) {
                return packageUseInfo.merge(isUsedByOtherApps);
            }
            DexUseInfo newData = new DexUseInfo(isUsedByOtherApps, ownerUserId, loaderIsa);
            DexUseInfo existingData = (DexUseInfo)packageUseInfo.mDexUseInfoMap.get(dexPath);
            if (existingData == null) {
                packageUseInfo.mDexUseInfoMap.put(dexPath, newData);
                return true;
            }
            if (ownerUserId != existingData.mOwnerUserId) {
                throw new IllegalArgumentException("Trying to change ownerUserId for  dex path " + dexPath + " from " + existingData.mOwnerUserId + " to " + ownerUserId);
            }
            return existingData.merge(newData);
        }
    }

    public void read() {
        this.read((Void)null);
    }

    public void maybeWriteAsync() {
        this.maybeWriteAsync(null);
    }

    @Override
    protected void writeInternal(Void data) {
        AtomicFile file = this.getFile();
        FileOutputStream f = null;
        try {
            f = file.startWrite();
            OutputStreamWriter osw = new OutputStreamWriter(f);
            this.write(osw);
            osw.flush();
            file.finishWrite(f);
        }
        catch (IOException e) {
            if (f != null) {
                file.failWrite(f);
            }
            Slog.e(TAG, "Failed to write usage for dex files", e);
        }
    }

    void write(Writer out) {
        Map<String, PackageUseInfo> packageUseInfoMapClone = this.clonePackageUseInfoMap();
        FastPrintWriter fpw = new FastPrintWriter(out);
        fpw.print(PACKAGE_DEX_USAGE_VERSION_HEADER);
        fpw.println(1);
        for (Map.Entry<String, PackageUseInfo> pEntry : packageUseInfoMapClone.entrySet()) {
            String packageName = pEntry.getKey();
            PackageUseInfo packageUseInfo = pEntry.getValue();
            fpw.println(String.join((CharSequence)SPLIT_CHAR, packageName, this.writeBoolean(packageUseInfo.mIsUsedByOtherApps)));
            for (Map.Entry dEntry : packageUseInfo.mDexUseInfoMap.entrySet()) {
                String dexPath = (String)dEntry.getKey();
                DexUseInfo dexUseInfo = (DexUseInfo)dEntry.getValue();
                fpw.println(DEX_LINE_CHAR + dexPath);
                fpw.print(String.join((CharSequence)SPLIT_CHAR, Integer.toString(dexUseInfo.mOwnerUserId), this.writeBoolean(dexUseInfo.mIsUsedByOtherApps)));
                for (String isa : dexUseInfo.mLoaderIsas) {
                    fpw.print(SPLIT_CHAR + isa);
                }
                fpw.println();
            }
        }
        fpw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void readInternal(Void data) {
        AtomicFile file = this.getFile();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(file.openRead()));
            this.read(in);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IoUtils.closeQuietly(in);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to parse package dex usage.", e);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(in);
        }
        IoUtils.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void read(Reader reader) throws IOException {
        HashMap<String, PackageUseInfo> data = new HashMap<String, PackageUseInfo>();
        BufferedReader in = new BufferedReader(reader);
        String versionLine = in.readLine();
        if (versionLine == null) {
            throw new IllegalStateException("No version line found.");
        }
        if (!versionLine.startsWith(PACKAGE_DEX_USAGE_VERSION_HEADER)) {
            throw new IllegalStateException("Invalid version line: " + versionLine);
        }
        int version = Integer.parseInt(versionLine.substring(PACKAGE_DEX_USAGE_VERSION_HEADER.length()));
        if (version != 1) {
            throw new IllegalStateException("Unexpected version: " + version);
        }
        String s = null;
        String currentPakage = null;
        PackageUseInfo currentPakageData = null;
        HashSet<String> supportedIsas = new HashSet<String>();
        for (String abi : Build.SUPPORTED_ABIS) {
            supportedIsas.add(VMRuntime.getInstructionSet(abi));
        }
        while ((s = in.readLine()) != null) {
            if (s.startsWith(DEX_LINE_CHAR)) {
                if (currentPakage == null) {
                    throw new IllegalStateException("Malformed PackageDexUsage file. Expected package line before dex line.");
                }
                String string2 = s.substring(DEX_LINE_CHAR.length());
                s = in.readLine();
                if (s == null) {
                    throw new IllegalStateException("Could not fine dexUseInfo for line: " + s);
                }
                String[] elems = s.split(SPLIT_CHAR);
                if (elems.length < 3) {
                    throw new IllegalStateException("Invalid PackageDexUsage line: " + s);
                }
                int ownerUserId = Integer.parseInt(elems[0]);
                boolean isUsedByOtherApps = this.readBoolean(elems[1]);
                DexUseInfo dexUseInfo = new DexUseInfo(isUsedByOtherApps, ownerUserId);
                for (int i = 2; i < elems.length; ++i) {
                    String isa = elems[i];
                    if (supportedIsas.contains(isa)) {
                        dexUseInfo.mLoaderIsas.add(elems[i]);
                        continue;
                    }
                    Slog.wtf(TAG, "Unsupported ISA when parsing PackageDexUsage: " + isa);
                }
                if (supportedIsas.isEmpty()) {
                    Slog.wtf(TAG, "Ignore dexPath when parsing PackageDexUsage because of unsupported isas. dexPath=" + string2);
                    continue;
                }
                currentPakageData.mDexUseInfoMap.put(string2, dexUseInfo);
                continue;
            }
            String[] stringArray = s.split(SPLIT_CHAR);
            if (stringArray.length != 2) {
                throw new IllegalStateException("Invalid PackageDexUsage line: " + s);
            }
            currentPakage = stringArray[0];
            currentPakageData = new PackageUseInfo();
            currentPakageData.mIsUsedByOtherApps = this.readBoolean(stringArray[1]);
            data.put(currentPakage, currentPakageData);
        }
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            this.mPackageUseInfoMap.clear();
            this.mPackageUseInfoMap.putAll(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncData(Map<String, Set<Integer>> packageToUsersMap) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            Iterator<Map.Entry<String, PackageUseInfo>> pIt = this.mPackageUseInfoMap.entrySet().iterator();
            while (pIt.hasNext()) {
                Map.Entry<String, PackageUseInfo> pEntry = pIt.next();
                String packageName = pEntry.getKey();
                PackageUseInfo packageUseInfo = pEntry.getValue();
                Set<Integer> users = packageToUsersMap.get(packageName);
                if (users == null) {
                    pIt.remove();
                    continue;
                }
                Iterator dIt = packageUseInfo.mDexUseInfoMap.entrySet().iterator();
                while (dIt.hasNext()) {
                    DexUseInfo dexUseInfo = (DexUseInfo)dIt.next().getValue();
                    if (users.contains(dexUseInfo.mOwnerUserId)) continue;
                    dIt.remove();
                }
                if (packageUseInfo.mIsUsedByOtherApps || !packageUseInfo.mDexUseInfoMap.isEmpty()) continue;
                pIt.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUserPackage(String packageName, int userId) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo packageUseInfo = this.mPackageUseInfoMap.get(packageName);
            if (packageUseInfo == null) {
                return false;
            }
            boolean updated = false;
            Iterator dIt = packageUseInfo.mDexUseInfoMap.entrySet().iterator();
            while (dIt.hasNext()) {
                DexUseInfo dexUseInfo = (DexUseInfo)dIt.next().getValue();
                if (dexUseInfo.mOwnerUserId != userId) continue;
                dIt.remove();
                updated = true;
            }
            return updated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDexFile(String packageName, String dexFile, int userId) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo packageUseInfo = this.mPackageUseInfoMap.get(packageName);
            if (packageUseInfo == null) {
                return false;
            }
            return this.removeDexFile(packageUseInfo, dexFile, userId);
        }
    }

    private boolean removeDexFile(PackageUseInfo packageUseInfo, String dexFile, int userId) {
        DexUseInfo dexUseInfo = (DexUseInfo)packageUseInfo.mDexUseInfoMap.get(dexFile);
        if (dexUseInfo == null) {
            return false;
        }
        if (dexUseInfo.mOwnerUserId == userId) {
            packageUseInfo.mDexUseInfoMap.remove(dexFile);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageUseInfo getPackageUseInfo(String packageName) {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            PackageUseInfo useInfo = this.mPackageUseInfoMap.get(packageName);
            return useInfo == null ? null : new PackageUseInfo(useInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllPackagesWithSecondaryDexFiles() {
        HashSet<String> packages = new HashSet<String>();
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            for (Map.Entry<String, PackageUseInfo> entry : this.mPackageUseInfoMap.entrySet()) {
                if (entry.getValue().mDexUseInfoMap.isEmpty()) continue;
                packages.add(entry.getKey());
            }
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            this.mPackageUseInfoMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PackageUseInfo> clonePackageUseInfoMap() {
        HashMap<String, PackageUseInfo> clone = new HashMap<String, PackageUseInfo>();
        Map<String, PackageUseInfo> map = this.mPackageUseInfoMap;
        synchronized (map) {
            for (Map.Entry<String, PackageUseInfo> e : this.mPackageUseInfoMap.entrySet()) {
                clone.put(e.getKey(), new PackageUseInfo(e.getValue()));
            }
        }
        return clone;
    }

    private String writeBoolean(boolean bool2) {
        return bool2 ? "1" : "0";
    }

    private boolean readBoolean(String bool2) {
        if ("0".equals(bool2)) {
            return false;
        }
        if ("1".equals(bool2)) {
            return true;
        }
        throw new IllegalArgumentException("Unknown bool encoding: " + bool2);
    }

    private boolean contains(int[] array2, int elem) {
        for (int i = 0; i < array2.length; ++i) {
            if (elem != array2[i]) continue;
            return true;
        }
        return false;
    }

    public String dump() {
        StringWriter sw = new StringWriter();
        this.write(sw);
        return sw.toString();
    }

    public static class DexUseInfo {
        private boolean mIsUsedByOtherApps;
        private final int mOwnerUserId;
        private final Set<String> mLoaderIsas;

        public DexUseInfo(boolean isUsedByOtherApps, int ownerUserId) {
            this(isUsedByOtherApps, ownerUserId, null);
        }

        public DexUseInfo(boolean isUsedByOtherApps, int ownerUserId, String loaderIsa) {
            this.mIsUsedByOtherApps = isUsedByOtherApps;
            this.mOwnerUserId = ownerUserId;
            this.mLoaderIsas = new HashSet<String>();
            if (loaderIsa != null) {
                this.mLoaderIsas.add(loaderIsa);
            }
        }

        public DexUseInfo(DexUseInfo other) {
            this.mIsUsedByOtherApps = other.mIsUsedByOtherApps;
            this.mOwnerUserId = other.mOwnerUserId;
            this.mLoaderIsas = new HashSet<String>(other.mLoaderIsas);
        }

        private boolean merge(DexUseInfo dexUseInfo) {
            boolean oldIsUsedByOtherApps = this.mIsUsedByOtherApps;
            this.mIsUsedByOtherApps = this.mIsUsedByOtherApps || dexUseInfo.mIsUsedByOtherApps;
            boolean updateIsas = this.mLoaderIsas.addAll(dexUseInfo.mLoaderIsas);
            return updateIsas || oldIsUsedByOtherApps != this.mIsUsedByOtherApps;
        }

        public boolean isUsedByOtherApps() {
            return this.mIsUsedByOtherApps;
        }

        public int getOwnerUserId() {
            return this.mOwnerUserId;
        }

        public Set<String> getLoaderIsas() {
            return this.mLoaderIsas;
        }
    }

    public static class PackageUseInfo {
        private boolean mIsUsedByOtherApps;
        private final Map<String, DexUseInfo> mDexUseInfoMap;

        public PackageUseInfo() {
            this.mIsUsedByOtherApps = false;
            this.mDexUseInfoMap = new HashMap<String, DexUseInfo>();
        }

        public PackageUseInfo(PackageUseInfo other) {
            this.mIsUsedByOtherApps = other.mIsUsedByOtherApps;
            this.mDexUseInfoMap = new HashMap<String, DexUseInfo>();
            for (Map.Entry<String, DexUseInfo> e : other.mDexUseInfoMap.entrySet()) {
                this.mDexUseInfoMap.put(e.getKey(), new DexUseInfo(e.getValue()));
            }
        }

        private boolean merge(boolean isUsedByOtherApps) {
            boolean oldIsUsedByOtherApps = this.mIsUsedByOtherApps;
            this.mIsUsedByOtherApps = this.mIsUsedByOtherApps || isUsedByOtherApps;
            return oldIsUsedByOtherApps != this.mIsUsedByOtherApps;
        }

        public boolean isUsedByOtherApps() {
            return this.mIsUsedByOtherApps;
        }

        public Map<String, DexUseInfo> getDexUseInfoMap() {
            return this.mDexUseInfoMap;
        }
    }
}

