/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.os.Handler;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.android.server.policy.AccessibilityShortcutController$$Lambda$118;
import com.android.server.policy.AccessibilityShortcutController$$Lambda$119;

public class AccessibilityShortcutController {
    private static final String TAG = "AccessibilityShortcutController";
    private final Context mContext;
    private AlertDialog mAlertDialog;
    private boolean mIsShortcutEnabled;
    public FrameworkObjectProvider mFrameworkObjectProvider = new FrameworkObjectProvider();

    public static String getTargetServiceComponentNameString(Context context, int userId) {
        String currentShortcutServiceId = Settings.Secure.getStringForUser(context.getContentResolver(), "accessibility_shortcut_target_service", userId);
        if (currentShortcutServiceId != null) {
            return currentShortcutServiceId;
        }
        return context.getString(0x1040104);
    }

    public AccessibilityShortcutController(Context context, Handler handler) {
        this.mContext = context;
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("accessibility_shortcut_target_service"), false, new ContentObserver(handler){

            @Override
            public void onChange(boolean selfChange) {
                AccessibilityShortcutController.this.onSettingsChanged();
            }
        }, -1);
        this.updateShortcutEnabled();
    }

    public boolean isAccessibilityShortcutAvailable() {
        return this.mIsShortcutEnabled;
    }

    public void onSettingsChanged() {
        this.updateShortcutEnabled();
    }

    public void performAccessibilityShortcut() {
        Slog.d(TAG, "Accessibility shortcut activated");
        ContentResolver cr = this.mContext.getContentResolver();
        int userId = ActivityManager.getCurrentUser();
        int dialogAlreadyShown = Settings.Secure.getIntForUser(cr, "accessibility_shortcut_dialog_shown", 0, userId);
        Ringtone tone = RingtoneManager.getRingtone(this.mContext, Settings.System.DEFAULT_NOTIFICATION_URI);
        if (tone != null) {
            tone.setAudioAttributes(new AudioAttributes.Builder().setUsage(10).build());
            tone.play();
        }
        if (dialogAlreadyShown == 0) {
            this.mAlertDialog = this.createShortcutWarningDialog(userId);
            if (this.mAlertDialog == null) {
                return;
            }
            Window w = this.mAlertDialog.getWindow();
            WindowManager.LayoutParams attr2 = w.getAttributes();
            attr2.type = 2009;
            w.setAttributes(attr2);
            this.mAlertDialog.show();
            Settings.Secure.putIntForUser(cr, "accessibility_shortcut_dialog_shown", 1, userId);
        } else {
            AccessibilityServiceInfo serviceInfo;
            if (this.mAlertDialog != null) {
                this.mAlertDialog.dismiss();
                this.mAlertDialog = null;
            }
            if ((serviceInfo = this.getInfoForTargetService()) == null) {
                Slog.e(TAG, "Accessibility shortcut set to invalid service");
                return;
            }
            String toastMessageFormatString = this.mContext.getString(this.isServiceEnabled(serviceInfo) ? 17039420 : 17039421);
            String toastMessage = String.format(toastMessageFormatString, serviceInfo.getResolveInfo().loadLabel(this.mContext.getPackageManager()).toString());
            Toast warningToast = this.mFrameworkObjectProvider.makeToastFromText(this.mContext, toastMessage, 1);
            warningToast.getWindowParams().privateFlags |= 0x10;
            warningToast.show();
            this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext).performAccessibilityShortcut();
        }
    }

    private void updateShortcutEnabled() {
        this.mIsShortcutEnabled = !TextUtils.isEmpty(AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, UserHandle.myUserId()));
    }

    private AlertDialog createShortcutWarningDialog(int userId) {
        AccessibilityServiceInfo serviceInfo = this.getInfoForTargetService();
        if (serviceInfo == null) {
            return null;
        }
        String warningMessage = String.format(this.mContext.getString(17039422), serviceInfo.getResolveInfo().loadLabel(this.mContext.getPackageManager()).toString());
        AlertDialog alertDialog = this.mFrameworkObjectProvider.getAlertDialogBuilder(this.mContext).setTitle(17039423).setMessage(warningMessage).setCancelable(false).setPositiveButton(17040048, null).setNegativeButton(17039742, AccessibilityShortcutController$$Lambda$118.get$Lambda(this, userId)).setOnCancelListener(AccessibilityShortcutController$$Lambda$119.get$Lambda(this, userId)).create();
        return alertDialog;
    }

    private AccessibilityServiceInfo getInfoForTargetService() {
        String currentShortcutServiceString = AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, UserHandle.myUserId());
        if (currentShortcutServiceString == null) {
            return null;
        }
        AccessibilityManager accessibilityManager = this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext);
        return accessibilityManager.getInstalledServiceInfoWithComponentName(ComponentName.unflattenFromString(currentShortcutServiceString));
    }

    private boolean isServiceEnabled(AccessibilityServiceInfo serviceInfo) {
        AccessibilityManager accessibilityManager = this.mFrameworkObjectProvider.getAccessibilityManagerInstance(this.mContext);
        return accessibilityManager.getEnabledAccessibilityServiceList(-1).contains(serviceInfo);
    }

    final /* synthetic */ void lambda$createShortcutWarningDialog$170$AccessibilityShortcutController(int n, DialogInterface d) {
        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_shortcut_dialog_shown", 0, n);
    }

    final /* synthetic */ void lambda$createShortcutWarningDialog$169$AccessibilityShortcutController(int n, DialogInterface d, int which) {
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "accessibility_shortcut_target_service", "", n);
    }

    public static class FrameworkObjectProvider {
        public AccessibilityManager getAccessibilityManagerInstance(Context context) {
            return AccessibilityManager.getInstance(context);
        }

        public AlertDialog.Builder getAlertDialogBuilder(Context context) {
            return new AlertDialog.Builder(context);
        }

        public Toast makeToastFromText(Context context, CharSequence charSequence, int duration) {
            return Toast.makeText(context, charSequence, duration);
        }
    }
}

