/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.print;

import android.companion.AssociationRequest;
import android.companion.ICompanionDeviceDiscoveryService;
import android.companion.ICompanionDeviceDiscoveryServiceCallback;
import android.companion.ICompanionDeviceManager;
import android.companion.IFindDeviceCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.NetworkPolicyManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.SystemService;

public class CompanionDeviceManagerService
extends SystemService {
    private static final ComponentName SERVICE_TO_BIND_TO = ComponentName.createRelative("com.android.companiondevicemanager", ".DeviceDiscoveryService");
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "CompanionDeviceManagerService";
    private final CompanionDeviceManagerImpl mImpl = new CompanionDeviceManagerImpl();

    public CompanionDeviceManagerService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("companion_device", this.mImpl);
    }

    private ServiceConnection getServiceConnection(final AssociationRequest<?> request, final IFindDeviceCallback findDeviceCallback, final String callingPackage) {
        return new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                try {
                    ICompanionDeviceDiscoveryService.Stub.asInterface(service).startDiscovery(request, callingPackage, findDeviceCallback, CompanionDeviceManagerService.this.getServiceCallback());
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
            }
        };
    }

    private ICompanionDeviceDiscoveryServiceCallback.Stub getServiceCallback() {
        return new ICompanionDeviceDiscoveryServiceCallback.Stub(){

            @Override
            public void onDeviceSelected(String packageName, int userId) {
                CompanionDeviceManagerService.this.grantSpecialAccessPermissionsIfNeeded(packageName, userId);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantSpecialAccessPermissionsIfNeeded(String packageName, int userId) {
        PackageInfo packageInfo;
        long identity = Binder.clearCallingIdentity();
        try {
            packageInfo = this.getContext().getPackageManager().getPackageInfoAsUser(packageName, 4096, userId);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(LOG_TAG, "Error granting special access permissions to package:" + packageName, e);
            return;
        }
        try {
            if (ArrayUtils.contains(packageInfo.requestedPermissions, "android.permission.RUN_IN_BACKGROUND")) {
                IDeviceIdleController idleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
                try {
                    idleController.addPowerSaveWhitelistApp(packageName);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (ArrayUtils.contains(packageInfo.requestedPermissions, "android.permission.USE_DATA_IN_BACKGROUND")) {
                NetworkPolicyManager.from(this.getContext()).addUidPolicy(packageInfo.applicationInfo.uid, 4);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    class CompanionDeviceManagerImpl
    extends ICompanionDeviceManager.Stub {
        CompanionDeviceManagerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void associate(AssociationRequest request, IFindDeviceCallback callback, String callingPackage) {
            Preconditions.checkNotNull(request);
            Preconditions.checkNotNull(callback);
            long callingIdentity = Binder.clearCallingIdentity();
            try {
                CompanionDeviceManagerService.this.getContext().bindService(new Intent().setComponent(SERVICE_TO_BIND_TO), CompanionDeviceManagerService.this.getServiceConnection(request, callback, callingPackage), 1);
            }
            finally {
                Binder.restoreCallingIdentity(callingIdentity);
            }
        }
    }
}

