/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.retaildemo;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.RetailDemoModeServiceInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.media.AudioManager;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.CallLog;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.KeyValueListParser;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.BackgroundThread;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.am.ActivityManagerService;
import com.android.server.retaildemo.PreloadAppsInstaller;
import com.android.server.retaildemo.RetailDemoModeService$SettingsObserver$$Lambda$1;
import com.android.server.retaildemo.UserInactivityCountdownDialog;
import java.io.File;
import java.util.ArrayList;

public class RetailDemoModeService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = RetailDemoModeService.class.getSimpleName();
    private static final String DEMO_USER_NAME = "Demo";
    private static final String ACTION_RESET_DEMO = "com.android.server.retaildemo.ACTION_RESET_DEMO";
    static final String SYSTEM_PROPERTY_RETAIL_DEMO_ENABLED = "sys.retaildemo.enabled";
    private static final int MSG_TURN_SCREEN_ON = 0;
    private static final int MSG_INACTIVITY_TIME_OUT = 1;
    private static final int MSG_START_NEW_SESSION = 2;
    private static final long SCREEN_WAKEUP_DELAY = 2500L;
    private static final long USER_INACTIVITY_TIMEOUT_MIN = 10000L;
    private static final long USER_INACTIVITY_TIMEOUT_DEFAULT = 90000L;
    private static final long WARNING_DIALOG_TIMEOUT_DEFAULT = 0L;
    private static final long MILLIS_PER_SECOND = 1000L;
    static final int[] VOLUME_STREAMS_TO_MUTE = new int[]{2, 3};
    private static final String DEMO_SESSION_COUNT = "retail_demo_session_count";
    private static final String DEMO_SESSION_DURATION = "retail_demo_session_duration";
    boolean mDeviceInDemoMode;
    boolean mIsCarrierDemoMode;
    int mCurrentUserId = 0;
    long mUserInactivityTimeout;
    long mWarningDialogTimeout;
    private Injector mInjector;
    Handler mHandler;
    private ServiceThread mHandlerThread;
    private String[] mCameraIdsWithFlash;
    private PreloadAppsInstaller mPreloadAppsInstaller;
    final Object mActivityLock = new Object();
    @GuardedBy(value="mActivityLock")
    boolean mUserUntouched;
    @GuardedBy(value="mActivityLock")
    long mFirstUserActivityTime;
    @GuardedBy(value="mActivityLock")
    long mLastUserActivityTime;
    private boolean mSafeBootRestrictionInitialState;
    private int mPackageVerifierEnableInitialState;
    private IntentReceiver mBroadcastReceiver = null;
    private RetailDemoModeServiceInternal mLocalService = new RetailDemoModeServiceInternal(){
        private static final long USER_ACTIVITY_DEBOUNCE_TIME = 2000L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUserActivity() {
            if (!RetailDemoModeService.this.mDeviceInDemoMode || RetailDemoModeService.this.mIsCarrierDemoMode) {
                return;
            }
            long timeOfActivity = SystemClock.uptimeMillis();
            Object object = RetailDemoModeService.this.mActivityLock;
            synchronized (object) {
                if (timeOfActivity < RetailDemoModeService.this.mLastUserActivityTime + 2000L) {
                    return;
                }
                RetailDemoModeService.this.mLastUserActivityTime = timeOfActivity;
                if (RetailDemoModeService.this.mUserUntouched && RetailDemoModeService.this.isDemoLauncherDisabled()) {
                    Slog.d(TAG, "retail_demo first touch");
                    RetailDemoModeService.this.mUserUntouched = false;
                    RetailDemoModeService.this.mFirstUserActivityTime = timeOfActivity;
                }
            }
            RetailDemoModeService.this.mHandler.removeMessages(1);
            RetailDemoModeService.this.mHandler.sendEmptyMessageDelayed(1, RetailDemoModeService.this.mUserInactivityTimeout);
        }
    };

    private void showInactivityCountdownDialog() {
        UserInactivityCountdownDialog dialog = new UserInactivityCountdownDialog(this.getContext(), this.mWarningDialogTimeout, 1000L);
        dialog.setNegativeButtonClickListener(null);
        dialog.setPositiveButtonClickListener(new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialog, int which) {
                RetailDemoModeService.this.mHandler.sendEmptyMessage(2);
            }
        });
        dialog.setOnCountDownExpiredListener(new UserInactivityCountdownDialog.OnCountDownExpiredListener(){

            @Override
            public void onCountDownExpired() {
                RetailDemoModeService.this.mHandler.sendEmptyMessage(2);
            }
        });
        dialog.show();
    }

    public RetailDemoModeService(Context context) {
        this(new Injector(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RetailDemoModeService(Injector injector) {
        super(injector.getContext());
        this.mInjector = injector;
        Object object = this.mActivityLock;
        synchronized (object) {
            this.mFirstUserActivityTime = this.mLastUserActivityTime = SystemClock.uptimeMillis();
        }
    }

    boolean isDemoLauncherDisabled() {
        int enabledState = 0;
        try {
            IPackageManager iPm = this.mInjector.getIPackageManager();
            String demoLauncherComponent = this.getContext().getString(17039629);
            enabledState = iPm.getComponentEnabledSetting(ComponentName.unflattenFromString(demoLauncherComponent), this.mCurrentUserId);
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Error retrieving demo launcher enabled setting", re);
        }
        return enabledState == 2;
    }

    private void setupDemoUser(UserInfo userInfo) {
        UserManager um = this.mInjector.getUserManager();
        UserHandle user = UserHandle.of(userInfo.id);
        um.setUserRestriction("no_config_wifi", true, user);
        um.setUserRestriction("no_install_unknown_sources", true, user);
        um.setUserRestriction("no_config_mobile_networks", true, user);
        um.setUserRestriction("no_usb_file_transfer", true, user);
        um.setUserRestriction("no_modify_accounts", true, user);
        um.setUserRestriction("no_config_bluetooth", true, user);
        um.setUserRestriction("no_outgoing_calls", false, user);
        um.setUserRestriction("no_safe_boot", true, UserHandle.SYSTEM);
        if (this.mIsCarrierDemoMode) {
            um.setUserRestriction("no_sms", false, user);
        }
        Settings.Secure.putIntForUser(this.mInjector.getContentResolver(), "skip_first_use_hints", 1, userInfo.id);
        Settings.Global.putInt(this.mInjector.getContentResolver(), "package_verifier_enable", 0);
        this.grantRuntimePermissionToCamera(user);
        this.clearPrimaryCallLog();
        if (!this.mIsCarrierDemoMode) {
            String demoLauncher = this.getContext().getString(17039629);
            if (!TextUtils.isEmpty(demoLauncher)) {
                ComponentName componentToEnable = ComponentName.unflattenFromString(demoLauncher);
                String packageName = componentToEnable.getPackageName();
                try {
                    IPackageManager iPm = AppGlobals.getPackageManager();
                    iPm.setComponentEnabledSetting(componentToEnable, 1, 0, userInfo.id);
                    iPm.setApplicationEnabledSetting(packageName, 1, 0, userInfo.id, null);
                }
                catch (RemoteException iPm) {}
            }
        } else {
            String carrierDemoModeSetting = this.getContext().getString(17039611);
            Settings.Secure.putIntForUser(this.getContext().getContentResolver(), carrierDemoModeSetting, 1, userInfo.id);
            String packageList = this.getContext().getString(17039609);
            String[] packageNames = packageList == null ? new String[]{} : TextUtils.split(packageList, ",");
            IPackageManager iPm = AppGlobals.getPackageManager();
            for (String packageName : packageNames) {
                try {
                    iPm.setApplicationEnabledSetting(packageName, 1, 0, userInfo.id, null);
                }
                catch (RemoteException re) {
                    Slog.e(TAG, "Error enabling application: " + packageName, re);
                }
            }
        }
    }

    private void grantRuntimePermissionToCamera(UserHandle user) {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        PackageManager pm = this.mInjector.getPackageManager();
        ResolveInfo handler = pm.resolveActivityAsUser(cameraIntent, 786432, user.getIdentifier());
        if (handler == null || handler.activityInfo == null) {
            return;
        }
        try {
            pm.grantRuntimePermission(handler.activityInfo.packageName, "android.permission.ACCESS_FINE_LOCATION", user);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearPrimaryCallLog() {
        ContentResolver resolver = this.mInjector.getContentResolver();
        Uri uri = CallLog.Calls.CONTENT_URI;
        try {
            resolver.delete(uri, null, null);
        }
        catch (Exception e) {
            Slog.w(TAG, "Deleting call log failed: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSessionDuration() {
        int sessionDuration;
        Object object = this.mActivityLock;
        synchronized (object) {
            sessionDuration = (int)((this.mLastUserActivityTime - this.mFirstUserActivityTime) / 1000L);
        }
        this.mInjector.logSessionDuration(sessionDuration);
    }

    private boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.mInjector.getContentResolver(), "device_provisioned", 0) != 0;
    }

    private boolean deletePreloadsFolderContents() {
        File dir = this.mInjector.getDataPreloadsDirectory();
        File[] files = FileUtils.listFilesOrEmpty(dir);
        File fileCacheDirectory = this.mInjector.getDataPreloadsFileCacheDirectory();
        Slog.i(TAG, "Deleting contents of " + dir);
        boolean success = true;
        for (File file : files) {
            if (file.isFile()) {
                if (file.delete()) continue;
                success = false;
                Slog.w(TAG, "Cannot delete file " + file);
                continue;
            }
            if (!file.equals(fileCacheDirectory)) {
                if (FileUtils.deleteContentsAndDir(file)) continue;
                success = false;
                Slog.w(TAG, "Cannot delete dir and its content " + file);
                continue;
            }
            Slog.i(TAG, "Skipping directory with file cache " + file);
        }
        return success;
    }

    private void registerBroadcastReceiver() {
        if (this.mBroadcastReceiver != null) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        if (!this.mIsCarrierDemoMode) {
            filter.addAction("android.intent.action.SCREEN_OFF");
        }
        filter.addAction(ACTION_RESET_DEMO);
        this.mBroadcastReceiver = new IntentReceiver();
        this.getContext().registerReceiver(this.mBroadcastReceiver, filter);
    }

    private void unregisterBroadcastReceiver() {
        if (this.mBroadcastReceiver != null) {
            this.getContext().unregisterReceiver(this.mBroadcastReceiver);
            this.mBroadcastReceiver = null;
        }
    }

    private String[] getCameraIdsWithFlash() {
        ArrayList<String> cameraIdsList = new ArrayList<String>();
        CameraManager cm = this.mInjector.getCameraManager();
        if (cm != null) {
            try {
                for (String cameraId : cm.getCameraIdList()) {
                    CameraCharacteristics c = cm.getCameraCharacteristics(cameraId);
                    if (!Boolean.TRUE.equals(c.get(CameraCharacteristics.FLASH_INFO_AVAILABLE))) continue;
                    cameraIdsList.add(cameraId);
                }
            }
            catch (CameraAccessException e) {
                Slog.e(TAG, "Unable to access camera while getting camera id list", e);
            }
        }
        return cameraIdsList.toArray(new String[cameraIdsList.size()]);
    }

    private void muteVolumeStreams() {
        for (int stream : VOLUME_STREAMS_TO_MUTE) {
            this.mInjector.getAudioManager().setStreamVolume(stream, this.mInjector.getAudioManager().getStreamMinVolume(stream), 0);
        }
    }

    private void startDemoMode() {
        this.mDeviceInDemoMode = true;
        this.mPreloadAppsInstaller = this.mInjector.getPreloadAppsInstaller();
        this.mInjector.initializeWakeLock();
        if (this.mCameraIdsWithFlash == null) {
            this.mCameraIdsWithFlash = this.getCameraIdsWithFlash();
        }
        this.registerBroadcastReceiver();
        String carrierDemoModeSetting = this.getContext().getString(17039611);
        this.mIsCarrierDemoMode = !TextUtils.isEmpty(carrierDemoModeSetting) && Settings.Secure.getInt(this.getContext().getContentResolver(), carrierDemoModeSetting, 0) == 1;
        this.mInjector.systemPropertiesSet(SYSTEM_PROPERTY_RETAIL_DEMO_ENABLED, "1");
        this.mHandler.sendEmptyMessage(2);
        this.mSafeBootRestrictionInitialState = this.mInjector.getUserManager().hasUserRestriction("no_safe_boot", UserHandle.SYSTEM);
        this.mPackageVerifierEnableInitialState = Settings.Global.getInt(this.mInjector.getContentResolver(), "package_verifier_enable", 0);
    }

    private void stopDemoMode() {
        this.mDeviceInDemoMode = false;
        this.mIsCarrierDemoMode = false;
        this.mPreloadAppsInstaller = null;
        this.mCameraIdsWithFlash = null;
        this.mInjector.destroyWakeLock();
        this.unregisterBroadcastReceiver();
        this.mInjector.getUserManager().setUserRestriction("no_safe_boot", this.mSafeBootRestrictionInitialState, UserHandle.SYSTEM);
        Settings.Global.putInt(this.mInjector.getContentResolver(), "package_verifier_enable", this.mPackageVerifierEnableInitialState);
    }

    @Override
    public void onStart() {
        this.mHandlerThread = new ServiceThread(TAG, -2, false);
        this.mHandlerThread.start();
        this.mHandler = new MainHandler(this.mHandlerThread.getLooper());
        this.mInjector.publishLocalService(this, this.mLocalService);
    }

    @Override
    public void onBootPhase(int bootPhase) {
        switch (bootPhase) {
            case 600: {
                SettingsObserver settingsObserver = new SettingsObserver(this.mHandler);
                settingsObserver.register();
                settingsObserver.refreshTimeoutConstants();
                break;
            }
            case 1000: {
                if (!UserManager.isDeviceInDemoMode(this.getContext())) break;
                this.startDemoMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(final int userId) {
        if (!this.mDeviceInDemoMode) {
            return;
        }
        UserInfo ui = this.mInjector.getUserManager().getUserInfo(userId);
        if (!ui.isDemo()) {
            Slog.wtf(TAG, "Should not allow switch to non-demo user in demo mode");
            return;
        }
        if (!this.mIsCarrierDemoMode && !this.mInjector.isWakeLockHeld()) {
            this.mInjector.acquireWakeLock();
        }
        this.mCurrentUserId = userId;
        this.mInjector.getActivityManagerInternal().updatePersistentConfigurationForUser(this.mInjector.getSystemUsersConfiguration(), userId);
        this.mInjector.turnOffAllFlashLights(this.mCameraIdsWithFlash);
        this.muteVolumeStreams();
        if (!this.mInjector.getWifiManager().isWifiEnabled()) {
            this.mInjector.getWifiManager().setWifiEnabled(true);
        }
        this.mInjector.getLockPatternUtils().setLockScreenDisabled(true, userId);
        if (!this.mIsCarrierDemoMode) {
            this.mInjector.getNotificationManager().notifyAsUser(TAG, 1, this.mInjector.createResetNotification(), UserHandle.of(userId));
            Object object = this.mActivityLock;
            synchronized (object) {
                this.mUserUntouched = true;
            }
            this.mInjector.logSessionCount(1);
            this.mHandler.removeMessages(1);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    RetailDemoModeService.this.mPreloadAppsInstaller.installApps(userId);
                }
            });
        }
    }

    static class Injector {
        private Context mContext;
        private UserManager mUm;
        private PackageManager mPm;
        private NotificationManager mNm;
        private ActivityManagerService mAms;
        private ActivityManagerInternal mAmi;
        private AudioManager mAudioManager;
        private PowerManager mPowerManager;
        private CameraManager mCameraManager;
        private PowerManager.WakeLock mWakeLock;
        private WifiManager mWifiManager;
        private Configuration mSystemUserConfiguration;
        private PendingIntent mResetDemoPendingIntent;
        private PreloadAppsInstaller mPreloadAppsInstaller;

        Injector(Context context) {
            this.mContext = context;
        }

        Context getContext() {
            return this.mContext;
        }

        WifiManager getWifiManager() {
            if (this.mWifiManager == null) {
                this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            }
            return this.mWifiManager;
        }

        UserManager getUserManager() {
            if (this.mUm == null) {
                this.mUm = this.getContext().getSystemService(UserManager.class);
            }
            return this.mUm;
        }

        void switchUser(int userId) {
            if (this.mAms == null) {
                this.mAms = (ActivityManagerService)ActivityManager.getService();
            }
            this.mAms.switchUser(userId);
        }

        AudioManager getAudioManager() {
            if (this.mAudioManager == null) {
                this.mAudioManager = this.getContext().getSystemService(AudioManager.class);
            }
            return this.mAudioManager;
        }

        private PowerManager getPowerManager() {
            if (this.mPowerManager == null) {
                this.mPowerManager = (PowerManager)this.getContext().getSystemService("power");
            }
            return this.mPowerManager;
        }

        NotificationManager getNotificationManager() {
            if (this.mNm == null) {
                this.mNm = NotificationManager.from(this.getContext());
            }
            return this.mNm;
        }

        ActivityManagerInternal getActivityManagerInternal() {
            if (this.mAmi == null) {
                this.mAmi = LocalServices.getService(ActivityManagerInternal.class);
            }
            return this.mAmi;
        }

        CameraManager getCameraManager() {
            if (this.mCameraManager == null) {
                this.mCameraManager = (CameraManager)this.getContext().getSystemService("camera");
            }
            return this.mCameraManager;
        }

        PackageManager getPackageManager() {
            if (this.mPm == null) {
                this.mPm = this.getContext().getPackageManager();
            }
            return this.mPm;
        }

        IPackageManager getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        ContentResolver getContentResolver() {
            return this.getContext().getContentResolver();
        }

        PreloadAppsInstaller getPreloadAppsInstaller() {
            if (this.mPreloadAppsInstaller == null) {
                this.mPreloadAppsInstaller = new PreloadAppsInstaller(this.getContext());
            }
            return this.mPreloadAppsInstaller;
        }

        void systemPropertiesSet(String key, String value) {
            SystemProperties.set(key, value);
        }

        void turnOffAllFlashLights(String[] cameraIdsWithFlash) {
            for (String cameraId : cameraIdsWithFlash) {
                try {
                    this.getCameraManager().setTorchMode(cameraId, false);
                }
                catch (CameraAccessException e) {
                    Slog.e(TAG, "Unable to access camera " + cameraId + " while turning off flash", e);
                }
            }
        }

        void initializeWakeLock() {
            if (this.mWakeLock == null) {
                this.mWakeLock = this.getPowerManager().newWakeLock(0x1000001A, TAG);
            }
        }

        void destroyWakeLock() {
            this.mWakeLock = null;
        }

        boolean isWakeLockHeld() {
            return this.mWakeLock != null && this.mWakeLock.isHeld();
        }

        void acquireWakeLock() {
            this.mWakeLock.acquire();
        }

        void releaseWakeLock() {
            this.mWakeLock.release();
        }

        void logSessionDuration(int duration) {
            MetricsLogger.histogram(this.getContext(), RetailDemoModeService.DEMO_SESSION_DURATION, duration);
        }

        void logSessionCount(int count) {
            MetricsLogger.count(this.getContext(), RetailDemoModeService.DEMO_SESSION_COUNT, count);
        }

        Configuration getSystemUsersConfiguration() {
            if (this.mSystemUserConfiguration == null) {
                this.mSystemUserConfiguration = new Configuration();
                Settings.System.getConfiguration(this.getContentResolver(), this.mSystemUserConfiguration);
            }
            return this.mSystemUserConfiguration;
        }

        LockPatternUtils getLockPatternUtils() {
            return new LockPatternUtils(this.getContext());
        }

        Notification createResetNotification() {
            return new Notification.Builder(this.getContext()).setContentTitle(this.getContext().getString(17040629)).setContentText(this.getContext().getString(17040628)).setOngoing(true).setSmallIcon(17302902).setShowWhen(false).setVisibility(1).setContentIntent(this.getResetDemoPendingIntent()).setColor(this.getContext().getColor(17170762)).build();
        }

        private PendingIntent getResetDemoPendingIntent() {
            if (this.mResetDemoPendingIntent == null) {
                Intent intent = new Intent(RetailDemoModeService.ACTION_RESET_DEMO);
                this.mResetDemoPendingIntent = PendingIntent.getBroadcast(this.getContext(), 0, intent, 0);
            }
            return this.mResetDemoPendingIntent;
        }

        File getDataPreloadsDirectory() {
            return Environment.getDataPreloadsDirectory();
        }

        File getDataPreloadsFileCacheDirectory() {
            return Environment.getDataPreloadsFileCacheDirectory();
        }

        void publishLocalService(RetailDemoModeService service, RetailDemoModeServiceInternal localService) {
            service.publishLocalService(RetailDemoModeServiceInternal.class, localService);
        }
    }

    class SettingsObserver
    extends ContentObserver {
        private static final String KEY_USER_INACTIVITY_TIMEOUT = "user_inactivity_timeout_ms";
        private static final String KEY_WARNING_DIALOG_TIMEOUT = "warning_dialog_timeout_ms";
        private final Uri mDeviceDemoModeUri;
        private final Uri mDeviceProvisionedUri;
        private final Uri mRetailDemoConstantsUri;
        private final KeyValueListParser mParser;

        public SettingsObserver(Handler handler) {
            super(handler);
            this.mDeviceDemoModeUri = Settings.Global.getUriFor("device_demo_mode");
            this.mDeviceProvisionedUri = Settings.Global.getUriFor("device_provisioned");
            this.mRetailDemoConstantsUri = Settings.Global.getUriFor("retail_demo_mode_constants");
            this.mParser = new KeyValueListParser(',');
        }

        public void register() {
            ContentResolver cr = RetailDemoModeService.this.mInjector.getContentResolver();
            cr.registerContentObserver(this.mDeviceDemoModeUri, false, this, 0);
            cr.registerContentObserver(this.mDeviceProvisionedUri, false, this, 0);
            cr.registerContentObserver(this.mRetailDemoConstantsUri, false, this, 0);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mRetailDemoConstantsUri.equals(uri)) {
                this.refreshTimeoutConstants();
                return;
            }
            if (RetailDemoModeService.this.isDeviceProvisioned()) {
                if (UserManager.isDeviceInDemoMode(RetailDemoModeService.this.getContext())) {
                    RetailDemoModeService.this.startDemoMode();
                } else {
                    RetailDemoModeService.this.mInjector.systemPropertiesSet(RetailDemoModeService.SYSTEM_PROPERTY_RETAIL_DEMO_ENABLED, "0");
                    BackgroundThread.getHandler().post(RetailDemoModeService$SettingsObserver$$Lambda$1.get$Lambda(this));
                    RetailDemoModeService.this.stopDemoMode();
                    if (RetailDemoModeService.this.mInjector.isWakeLockHeld()) {
                        RetailDemoModeService.this.mInjector.releaseWakeLock();
                    }
                }
            }
        }

        private void refreshTimeoutConstants() {
            try {
                this.mParser.setString(Settings.Global.getString(RetailDemoModeService.this.mInjector.getContentResolver(), "retail_demo_mode_constants"));
            }
            catch (IllegalArgumentException exc) {
                Slog.e(TAG, "Invalid string passed to KeyValueListParser");
            }
            RetailDemoModeService.this.mWarningDialogTimeout = this.mParser.getLong(KEY_WARNING_DIALOG_TIMEOUT, 0L);
            RetailDemoModeService.this.mUserInactivityTimeout = this.mParser.getLong(KEY_USER_INACTIVITY_TIMEOUT, 90000L);
            RetailDemoModeService.this.mUserInactivityTimeout = Math.max(RetailDemoModeService.this.mUserInactivityTimeout, 10000L);
        }

        final /* synthetic */ void lambda$onChange$0$RetailDemoModeService$SettingsObserver() {
            if (!RetailDemoModeService.this.deletePreloadsFolderContents()) {
                Slog.w(TAG, "Failed to delete preloads folder contents");
            }
        }
    }

    final class MainHandler
    extends Handler {
        MainHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            if (!RetailDemoModeService.this.mDeviceInDemoMode) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    if (RetailDemoModeService.this.mInjector.isWakeLockHeld()) {
                        RetailDemoModeService.this.mInjector.releaseWakeLock();
                    }
                    RetailDemoModeService.this.mInjector.acquireWakeLock();
                    break;
                }
                case 1: {
                    if (RetailDemoModeService.this.mIsCarrierDemoMode || !RetailDemoModeService.this.isDemoLauncherDisabled()) break;
                    Slog.i(TAG, "User inactivity timeout reached");
                    RetailDemoModeService.this.showInactivityCountdownDialog();
                    break;
                }
                case 2: {
                    this.removeMessages(2);
                    this.removeMessages(1);
                    if (!RetailDemoModeService.this.mIsCarrierDemoMode && RetailDemoModeService.this.mCurrentUserId != 0) {
                        RetailDemoModeService.this.logSessionDuration();
                    }
                    UserManager um = RetailDemoModeService.this.mInjector.getUserManager();
                    UserInfo demoUser = null;
                    if (RetailDemoModeService.this.mIsCarrierDemoMode) {
                        for (UserInfo user : um.getUsers()) {
                            if (!user.isDemo()) continue;
                            demoUser = user;
                            break;
                        }
                    }
                    if (demoUser == null) {
                        int flags = 0x200 | (RetailDemoModeService.this.mIsCarrierDemoMode ? 0 : 256);
                        demoUser = um.createUser(RetailDemoModeService.DEMO_USER_NAME, flags);
                    }
                    if (demoUser == null || RetailDemoModeService.this.mCurrentUserId == demoUser.id) break;
                    RetailDemoModeService.this.setupDemoUser(demoUser);
                    RetailDemoModeService.this.mInjector.switchUser(demoUser.id);
                }
            }
        }
    }

    private final class IntentReceiver
    extends BroadcastReceiver {
        private IntentReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action;
            if (!RetailDemoModeService.this.mDeviceInDemoMode) {
                return;
            }
            switch (action = intent.getAction()) {
                case "android.intent.action.SCREEN_OFF": {
                    RetailDemoModeService.this.mHandler.removeMessages(0);
                    RetailDemoModeService.this.mHandler.sendEmptyMessageDelayed(0, 2500L);
                    break;
                }
                case "com.android.server.retaildemo.ACTION_RESET_DEMO": {
                    RetailDemoModeService.this.mHandler.sendEmptyMessage(2);
                }
            }
        }
    }
}

