/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.statusbar;

import android.content.ComponentName;
import android.os.RemoteException;
import android.os.ShellCommand;
import com.android.internal.statusbar.IStatusBarService;
import com.android.server.statusbar.StatusBarManagerService;
import java.io.PrintWriter;

public class StatusBarShellCommand
extends ShellCommand {
    private final IStatusBarService mInterface;

    public StatusBarShellCommand(StatusBarManagerService service) {
        this.mInterface = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        try {
            switch (cmd) {
                case "expand-notifications": {
                    return this.runExpandNotifications();
                }
                case "expand-settings": {
                    return this.runExpandSettings();
                }
                case "collapse": {
                    return this.runCollapse();
                }
                case "add-tile": {
                    return this.runAddTile();
                }
                case "remove-tile": {
                    return this.runRemoveTile();
                }
                case "click-tile": {
                    return this.runClickTile();
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private int runAddTile() throws RemoteException {
        this.mInterface.addTile(ComponentName.unflattenFromString(this.getNextArgRequired()));
        return 0;
    }

    private int runRemoveTile() throws RemoteException {
        this.mInterface.remTile(ComponentName.unflattenFromString(this.getNextArgRequired()));
        return 0;
    }

    private int runClickTile() throws RemoteException {
        this.mInterface.clickTile(ComponentName.unflattenFromString(this.getNextArgRequired()));
        return 0;
    }

    private int runCollapse() throws RemoteException {
        this.mInterface.collapsePanels();
        return 0;
    }

    private int runExpandSettings() throws RemoteException {
        this.mInterface.expandSettingsPanel(null);
        return 0;
    }

    private int runExpandNotifications() throws RemoteException {
        this.mInterface.expandNotificationsPanel();
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Status bar commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("");
        pw.println("  expand-notifications");
        pw.println("    Open the notifications panel.");
        pw.println("");
        pw.println("  expand-settings");
        pw.println("    Open the notifications panel and expand quick settings if present.");
        pw.println("");
        pw.println("  collapse");
        pw.println("    Collapse the notifications and settings panel.");
        pw.println("");
        pw.println("  add-tile COMPONENT");
        pw.println("    Add a TileService of the specified component");
        pw.println("");
        pw.println("  remove-tile COMPONENT");
        pw.println("    Remove a TileService of the specified component");
        pw.println("");
        pw.println("  click-tile COMPONENT");
        pw.println("    Click on a TileService of the specified component");
        pw.println("");
    }
}

