/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.PackageManager;
import android.content.pm.PackageStats;
import android.content.pm.UserInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserManager;
import android.os.storage.VolumeInfo;
import android.util.Log;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class AppCollector {
    private static String TAG = "AppCollector";
    private CompletableFuture<List<PackageStats>> mStats;
    private final BackgroundHandler mBackgroundHandler;

    public AppCollector(Context context, VolumeInfo volume) {
        Preconditions.checkNotNull(volume);
        this.mBackgroundHandler = new BackgroundHandler(BackgroundThread.get().getLooper(), volume, context.getPackageManager(), (UserManager)context.getSystemService("user"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PackageStats> getPackageStats(long timeoutMillis) {
        AppCollector appCollector = this;
        synchronized (appCollector) {
            if (this.mStats == null) {
                this.mStats = new CompletableFuture();
                this.mBackgroundHandler.sendEmptyMessage(0);
            }
        }
        List<PackageStats> value = null;
        try {
            value = this.mStats.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            Log.e(TAG, "An exception occurred while getting app storage", e);
        }
        catch (TimeoutException e) {
            Log.e(TAG, "AppCollector timed out");
        }
        return value;
    }

    private class BackgroundHandler
    extends Handler {
        static final int MSG_START_LOADING_SIZES = 0;
        private final VolumeInfo mVolume;
        private final PackageManager mPm;
        private final UserManager mUm;

        BackgroundHandler(Looper looper, VolumeInfo volume, PackageManager pm, UserManager um) {
            super(looper);
            this.mVolume = volume;
            this.mPm = pm;
            this.mUm = um;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    List<ApplicationInfo> apps = this.mPm.getInstalledApplications(8704);
                    ArrayList<ApplicationInfo> volumeApps = new ArrayList<ApplicationInfo>();
                    for (ApplicationInfo app : apps) {
                        if (!Objects.equals(app.volumeUuid, this.mVolume.getFsUuid())) continue;
                        volumeApps.add(app);
                    }
                    List<UserInfo> users = this.mUm.getUsers();
                    int count = users.size() * volumeApps.size();
                    if (count == 0) {
                        AppCollector.this.mStats.complete(new ArrayList());
                    }
                    StatsObserver observer = new StatsObserver(count);
                    for (UserInfo user : users) {
                        for (ApplicationInfo app : volumeApps) {
                            this.mPm.getPackageSizeInfoAsUser(app.packageName, user.id, observer);
                        }
                    }
                    break;
                }
            }
        }
    }

    private class StatsObserver
    extends IPackageStatsObserver.Stub {
        private AtomicInteger mCount;
        private final ArrayList<PackageStats> mPackageStats;

        public StatsObserver(int count) {
            this.mCount = new AtomicInteger(count);
            this.mPackageStats = new ArrayList(count);
        }

        @Override
        public void onGetStatsCompleted(PackageStats packageStats, boolean succeeded) throws RemoteException {
            if (succeeded) {
                this.mPackageStats.add(packageStats);
            }
            if (this.mCount.decrementAndGet() == 0) {
                AppCollector.this.mStats.complete(this.mPackageStats);
            }
        }
    }
}

