/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.BlockingQueue;
import libcore.io.IoUtils;

public class AppFuseBridge
implements Runnable,
AutoCloseable {
    public static final String TAG = "AppFuseBridge";
    private static final String APPFUSE_MOUNT_NAME_TEMPLATE = "/mnt/appfuse/%d_%d";
    private final IMountScope mMountScope;
    private final ParcelFileDescriptor mProxyFd;
    private final BlockingQueue<Boolean> mChannel;

    public AppFuseBridge(IMountScope mountScope, ParcelFileDescriptor proxyFd, BlockingQueue<Boolean> channel) {
        Preconditions.checkNotNull(mountScope);
        Preconditions.checkNotNull(proxyFd);
        Preconditions.checkNotNull(channel);
        this.mMountScope = mountScope;
        this.mProxyFd = proxyFd;
        this.mChannel = channel;
    }

    @Override
    public void run() {
        try {
            this.native_start_loop(this.mMountScope.getDeviceFileDescriptor().detachFd(), this.mProxyFd.detachFd());
        }
        finally {
            this.close();
        }
    }

    public static ParcelFileDescriptor openFile(int uid, int mountId, int fileId, int mode) throws FileNotFoundException {
        File mountPoint = AppFuseBridge.getMountPoint(uid, mountId);
        try {
            if (Os.stat((String)mountPoint.getPath()).st_ino != 1L) {
                throw new FileNotFoundException("Could not find bridge mount point.");
            }
        }
        catch (ErrnoException e) {
            throw new FileNotFoundException("Failed to stat mount point: " + mountPoint.getParent());
        }
        return ParcelFileDescriptor.open(new File(mountPoint, String.valueOf(fileId)), mode);
    }

    private static File getMountPoint(int uid, int mountId) {
        return new File(String.format(APPFUSE_MOUNT_NAME_TEMPLATE, uid, mountId));
    }

    @Override
    public void close() {
        IoUtils.closeQuietly(this.mMountScope);
        IoUtils.closeQuietly(this.mProxyFd);
        this.mChannel.offer(false);
    }

    private void onMount() {
        this.mChannel.offer(true);
    }

    private native boolean native_start_loop(int var1, int var2);

    public static interface IMountScope
    extends AutoCloseable {
        public ParcelFileDescriptor getDeviceFileDescriptor();
    }
}

