/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.app.usage.CacheQuotaHint;
import android.app.usage.ICacheQuotaService;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.pm.Installer;
import java.util.ArrayList;
import java.util.List;

public class CacheQuotaStrategy
implements RemoteCallback.OnResultListener {
    private static final String TAG = "CacheQuotaStrategy";
    private final Object mLock = new Object();
    private final Context mContext;
    private final UsageStatsManagerInternal mUsageStats;
    private final Installer mInstaller;
    private ServiceConnection mServiceConnection;
    private ICacheQuotaService mRemoteService;

    public CacheQuotaStrategy(Context context, UsageStatsManagerInternal usageStatsManager, Installer installer) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mUsageStats = Preconditions.checkNotNull(usageStatsManager);
        this.mInstaller = Preconditions.checkNotNull(installer);
    }

    public void recalculateQuotas() {
        this.createServiceConnection();
        ComponentName component = this.getServiceComponentName();
        if (component != null) {
            Intent intent = new Intent();
            intent.setComponent(component);
            this.mContext.bindServiceAsUser(intent, this.mServiceConnection, 1, UserHandle.CURRENT);
        }
    }

    private void createServiceConnection() {
        if (this.mServiceConnection != null) {
            return;
        }
        this.mServiceConnection = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, final IBinder service) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = CacheQuotaStrategy.this.mLock;
                        synchronized (object) {
                            CacheQuotaStrategy.this.mRemoteService = ICacheQuotaService.Stub.asInterface(service);
                            List requests = CacheQuotaStrategy.this.getUnfulfilledRequests();
                            RemoteCallback remoteCallback = new RemoteCallback(CacheQuotaStrategy.this);
                            try {
                                CacheQuotaStrategy.this.mRemoteService.computeCacheQuotaHints(remoteCallback, requests);
                            }
                            catch (RemoteException ex) {
                                Slog.w(CacheQuotaStrategy.TAG, "Remote exception occurred while trying to get cache quota", ex);
                            }
                        }
                    }
                };
                AsyncTask.execute(runnable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDisconnected(ComponentName name) {
                Object object = CacheQuotaStrategy.this.mLock;
                synchronized (object) {
                    CacheQuotaStrategy.this.mRemoteService = null;
                }
            }
        };
    }

    private List<CacheQuotaHint> getUnfulfilledRequests() {
        long timeNow = System.currentTimeMillis();
        long oneYearAgo = timeNow - 31449600000L;
        ArrayList<CacheQuotaHint> requests = new ArrayList<CacheQuotaHint>();
        UserManager um = this.mContext.getSystemService(UserManager.class);
        List<UserInfo> users = um.getUsers();
        int userCount = users.size();
        PackageManager packageManager = this.mContext.getPackageManager();
        for (int i = 0; i < userCount; ++i) {
            UserInfo info = users.get(i);
            List<UsageStats> stats = this.mUsageStats.queryUsageStatsForUser(info.id, 4, oneYearAgo, timeNow);
            if (stats == null) continue;
            for (UsageStats stat : stats) {
                String packageName = stat.getPackageName();
                try {
                    ApplicationInfo appInfo = packageManager.getApplicationInfo(packageName, 0);
                    requests.add(new CacheQuotaHint.Builder().setVolumeUuid(appInfo.volumeUuid).setUid(appInfo.uid).setUsageStats(stat).setQuota(-1L).build());
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(TAG, "Unable to find package for quota calculation", e);
                }
            }
        }
        return requests;
    }

    @Override
    public void onResult(Bundle data) {
        ArrayList processedRequests = data.getParcelableArrayList("requests");
        int requestSize = processedRequests.size();
        for (int i = 0; i < requestSize; ++i) {
            CacheQuotaHint request = (CacheQuotaHint)processedRequests.get(i);
            long proposedQuota = request.getQuota();
            if (proposedQuota == -1L) continue;
            try {
                int uid = request.getUid();
                this.mInstaller.setAppQuota(request.getVolumeUuid(), UserHandle.getUserId(uid), UserHandle.getAppId(uid), proposedQuota);
                continue;
            }
            catch (Installer.InstallerException ex) {
                Slog.w(TAG, "Failed to set cache quota for " + request.getUid(), ex);
            }
        }
        this.disconnectService();
    }

    private void disconnectService() {
        this.mContext.unbindService(this.mServiceConnection);
        this.mServiceConnection = null;
    }

    private ComponentName getServiceComponentName() {
        String packageName = this.mContext.getPackageManager().getServicesSystemSharedLibraryPackageName();
        if (packageName == null) {
            Slog.w(TAG, "could not access the cache quota service: no package!");
            return null;
        }
        Intent intent = new Intent("android.app.usage.CacheQuotaService");
        intent.setPackage(packageName);
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveService(intent, 132);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Slog.w(TAG, "No valid components found.");
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }
}

