/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageStats;
import android.os.AsyncTask;
import android.os.BatteryManager;
import android.os.Environment;
import android.os.UserHandle;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.util.Log;
import com.android.server.storage.AppCollector;
import com.android.server.storage.DiskStatsFileLogger;
import com.android.server.storage.FileCollector;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DiskStatsLoggingService
extends JobService {
    private static final String TAG = "DiskStatsLogService";
    public static final String DUMPSYS_CACHE_PATH = "/data/system/diskstats_cache.json";
    private static final int JOB_DISKSTATS_LOGGING = 1145656139;
    private static ComponentName sDiskStatsLoggingService = new ComponentName("android", DiskStatsLoggingService.class.getName());

    @Override
    public boolean onStartJob(JobParameters params) {
        if (!DiskStatsLoggingService.isCharging(this) || !DiskStatsLoggingService.isDumpsysTaskEnabled(this.getContentResolver())) {
            this.jobFinished(params, true);
            return false;
        }
        VolumeInfo volume = this.getPackageManager().getPrimaryStorageCurrentVolume();
        if (volume == null) {
            return false;
        }
        AppCollector collector = new AppCollector(this, volume);
        int userId = UserHandle.myUserId();
        Environment.UserEnvironment environment = new Environment.UserEnvironment(userId);
        LogRunnable task = new LogRunnable();
        task.setRootDirectory(environment.getExternalStorageDirectory());
        task.setDownloadsDirectory(environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS));
        task.setSystemSize(FileCollector.getSystemSize(this));
        task.setLogOutputFile(new File(DUMPSYS_CACHE_PATH));
        task.setAppCollector(collector);
        task.setJobService(this, params);
        AsyncTask.execute(task);
        return true;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return false;
    }

    public static void schedule(Context context) {
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        js.schedule(new JobInfo.Builder(1145656139, sDiskStatsLoggingService).setRequiresDeviceIdle(true).setRequiresCharging(true).setPeriodic(TimeUnit.DAYS.toMillis(1L)).build());
    }

    private static boolean isCharging(Context context) {
        BatteryManager batteryManager = context.getSystemService(BatteryManager.class);
        if (batteryManager != null) {
            return batteryManager.isCharging();
        }
        return false;
    }

    static boolean isDumpsysTaskEnabled(ContentResolver resolver) {
        return Settings.Global.getInt(resolver, "enable_diskstats_logging", 1) != 0;
    }

    static class LogRunnable
    implements Runnable {
        private static final long TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(10L);
        private JobService mJobService;
        private JobParameters mParams;
        private AppCollector mCollector;
        private File mOutputFile;
        private File mRootDirectory;
        private File mDownloadsDirectory;
        private long mSystemSize;

        LogRunnable() {
        }

        public void setRootDirectory(File file) {
            this.mRootDirectory = file;
        }

        public void setDownloadsDirectory(File file) {
            this.mDownloadsDirectory = file;
        }

        public void setAppCollector(AppCollector collector) {
            this.mCollector = collector;
        }

        public void setLogOutputFile(File file) {
            this.mOutputFile = file;
        }

        public void setSystemSize(long size) {
            this.mSystemSize = size;
        }

        public void setJobService(JobService jobService, JobParameters params) {
            this.mJobService = jobService;
            this.mParams = params;
        }

        @Override
        public void run() {
            FileCollector.MeasurementResult mainCategories = FileCollector.getMeasurementResult(this.mRootDirectory);
            FileCollector.MeasurementResult downloads = FileCollector.getMeasurementResult(this.mDownloadsDirectory);
            boolean needsReschedule = true;
            List<PackageStats> stats = this.mCollector.getPackageStats(TIMEOUT_MILLIS);
            if (stats != null) {
                needsReschedule = false;
                this.logToFile(mainCategories, downloads, stats, this.mSystemSize);
            } else {
                Log.w("TAG", "Timed out while fetching package stats.");
            }
            if (this.mJobService != null) {
                this.mJobService.jobFinished(this.mParams, needsReschedule);
            }
        }

        private void logToFile(FileCollector.MeasurementResult mainCategories, FileCollector.MeasurementResult downloads, List<PackageStats> stats, long systemSize) {
            DiskStatsFileLogger logger = new DiskStatsFileLogger(mainCategories, downloads, stats, systemSize);
            try {
                this.mOutputFile.createNewFile();
                logger.dumpToFile(this.mOutputFile);
            }
            catch (IOException e) {
                Log.e(DiskStatsLoggingService.TAG, "Exception while writing opportunistic disk file cache.", e);
            }
        }
    }
}

