/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.text;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.ITextClassificationService;
import android.util.Slog;
import com.android.server.SystemService;
import java.io.File;

public class TextClassificationService
extends ITextClassificationService.Stub {
    private static final String LOG_TAG = "TextClassificationService";

    @Override
    public synchronized ParcelFileDescriptor getModelFileFd() throws RemoteException {
        try {
            return ParcelFileDescriptor.open(new File("/etc/assistant/smart-selection.model"), 0x10000000);
        }
        catch (Throwable t) {
            Slog.e(LOG_TAG, "Error retrieving an fd to the text classification model file.", t);
            throw new RemoteException(t.getMessage());
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private TextClassificationService mService = new TextClassificationService();

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            try {
                this.publishBinderService("textclassification", this.mService);
            }
            catch (Throwable t) {
                Slog.e(TextClassificationService.LOG_TAG, "Could not start the TextClassificationService.", t);
            }
        }
    }
}

