/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.os.Environment;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AppIdleHistory {
    private static final String TAG = "AppIdleHistory";
    private SparseArray<ArrayMap<String, PackageHistory>> mIdleHistory = new SparseArray();
    private long mLastPeriod = 0L;
    private static final long ONE_MINUTE = 60000L;
    private static final int HISTORY_SIZE = 100;
    private static final int FLAG_LAST_STATE = 2;
    private static final int FLAG_PARTIAL_ACTIVE = 1;
    private static final long PERIOD_DURATION = 3600000L;
    static final String APP_IDLE_FILENAME = "app_idle_stats.xml";
    private static final String TAG_PACKAGES = "packages";
    private static final String TAG_PACKAGE = "package";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SCREEN_IDLE = "screenIdleTime";
    private static final String ATTR_ELAPSED_IDLE = "elapsedIdleTime";
    private long mElapsedSnapshot;
    private long mElapsedDuration;
    private long mScreenOnSnapshot;
    private long mScreenOnDuration;
    private long mElapsedTimeThreshold;
    private long mScreenOnTimeThreshold;
    private final File mStorageDir;
    private boolean mScreenOn;

    AppIdleHistory(long elapsedRealtime) {
        this(Environment.getDataSystemDirectory(), elapsedRealtime);
    }

    AppIdleHistory(File storageDir, long elapsedRealtime) {
        this.mElapsedSnapshot = elapsedRealtime;
        this.mScreenOnSnapshot = elapsedRealtime;
        this.mStorageDir = storageDir;
        this.readScreenOnTimeLocked();
    }

    public void setThresholds(long elapsedTimeThreshold, long screenOnTimeThreshold) {
        this.mElapsedTimeThreshold = elapsedTimeThreshold;
        this.mScreenOnTimeThreshold = screenOnTimeThreshold;
    }

    public void updateDisplayLocked(boolean screenOn, long elapsedRealtime) {
        if (screenOn == this.mScreenOn) {
            return;
        }
        this.mScreenOn = screenOn;
        if (this.mScreenOn) {
            this.mScreenOnSnapshot = elapsedRealtime;
        } else {
            this.mScreenOnDuration += elapsedRealtime - this.mScreenOnSnapshot;
            this.mElapsedDuration += elapsedRealtime - this.mElapsedSnapshot;
            this.mElapsedSnapshot = elapsedRealtime;
        }
    }

    public long getScreenOnTimeLocked(long elapsedRealtime) {
        long screenOnTime = this.mScreenOnDuration;
        if (this.mScreenOn) {
            screenOnTime += elapsedRealtime - this.mScreenOnSnapshot;
        }
        return screenOnTime;
    }

    File getScreenOnTimeFile() {
        return new File(this.mStorageDir, "screen_on_time");
    }

    private void readScreenOnTimeLocked() {
        File screenOnTimeFile = this.getScreenOnTimeFile();
        if (screenOnTimeFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(screenOnTimeFile));
                this.mScreenOnDuration = Long.parseLong(reader.readLine());
                this.mElapsedDuration = Long.parseLong(reader.readLine());
                reader.close();
            }
            catch (IOException | NumberFormatException exception) {}
        } else {
            this.writeScreenOnTimeLocked();
        }
    }

    private void writeScreenOnTimeLocked() {
        AtomicFile screenOnTimeFile = new AtomicFile(this.getScreenOnTimeFile());
        FileOutputStream fos = null;
        try {
            fos = screenOnTimeFile.startWrite();
            fos.write((Long.toString(this.mScreenOnDuration) + "\n" + Long.toString(this.mElapsedDuration) + "\n").getBytes());
            screenOnTimeFile.finishWrite(fos);
        }
        catch (IOException ioe) {
            screenOnTimeFile.failWrite(fos);
        }
    }

    public void writeAppIdleDurationsLocked() {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.mElapsedDuration += elapsedRealtime - this.mElapsedSnapshot;
        this.mElapsedSnapshot = elapsedRealtime;
        this.writeScreenOnTimeLocked();
    }

    public void reportUsageLocked(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, PackageHistory> userHistory = this.getUserHistoryLocked(userId);
        PackageHistory packageHistory = this.getPackageHistoryLocked(userHistory, packageName, elapsedRealtime);
        this.shiftHistoryToNow(userHistory, elapsedRealtime);
        packageHistory.lastUsedElapsedTime = this.mElapsedDuration + (elapsedRealtime - this.mElapsedSnapshot);
        packageHistory.lastUsedScreenTime = this.getScreenOnTimeLocked(elapsedRealtime);
        packageHistory.recent[99] = 3;
    }

    public void setIdle(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, PackageHistory> userHistory = this.getUserHistoryLocked(userId);
        PackageHistory packageHistory = this.getPackageHistoryLocked(userHistory, packageName, elapsedRealtime);
        this.shiftHistoryToNow(userHistory, elapsedRealtime);
        packageHistory.recent[99] = (byte)(packageHistory.recent[99] & 0xFFFFFFFD);
    }

    private void shiftHistoryToNow(ArrayMap<String, PackageHistory> userHistory, long elapsedRealtime) {
        long thisPeriod = elapsedRealtime / 3600000L;
        if (this.mLastPeriod != 0L && this.mLastPeriod < thisPeriod && thisPeriod - this.mLastPeriod < 99L) {
            int diff = (int)(thisPeriod - this.mLastPeriod);
            int NUSERS = this.mIdleHistory.size();
            for (int u = 0; u < NUSERS; ++u) {
                userHistory = this.mIdleHistory.valueAt(u);
                for (PackageHistory idleState : userHistory.values()) {
                    System.arraycopy((byte[])idleState.recent, (int)diff, (byte[])idleState.recent, (int)0, (int)(100 - diff));
                    for (int i = 0; i < diff; ++i) {
                        idleState.recent[100 - i - 1] = (byte)(idleState.recent[100 - diff - 1] & 2);
                    }
                }
            }
        }
        this.mLastPeriod = thisPeriod;
    }

    private ArrayMap<String, PackageHistory> getUserHistoryLocked(int userId) {
        ArrayMap<String, PackageHistory> userHistory = this.mIdleHistory.get(userId);
        if (userHistory == null) {
            userHistory = new ArrayMap();
            this.mIdleHistory.put(userId, userHistory);
            this.readAppIdleTimesLocked(userId, userHistory);
        }
        return userHistory;
    }

    private PackageHistory getPackageHistoryLocked(ArrayMap<String, PackageHistory> userHistory, String packageName, long elapsedRealtime) {
        PackageHistory packageHistory = userHistory.get(packageName);
        if (packageHistory == null) {
            packageHistory = new PackageHistory();
            packageHistory.lastUsedElapsedTime = this.getElapsedTimeLocked(elapsedRealtime);
            packageHistory.lastUsedScreenTime = this.getScreenOnTimeLocked(elapsedRealtime);
            userHistory.put(packageName, packageHistory);
        }
        return packageHistory;
    }

    public void onUserRemoved(int userId) {
        this.mIdleHistory.remove(userId);
    }

    public boolean isIdleLocked(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, PackageHistory> userHistory = this.getUserHistoryLocked(userId);
        PackageHistory packageHistory = this.getPackageHistoryLocked(userHistory, packageName, elapsedRealtime);
        if (packageHistory == null) {
            return false;
        }
        return this.hasPassedThresholdsLocked(packageHistory, elapsedRealtime);
    }

    private long getElapsedTimeLocked(long elapsedRealtime) {
        return elapsedRealtime - this.mElapsedSnapshot + this.mElapsedDuration;
    }

    public void setIdleLocked(String packageName, int userId, boolean idle, long elapsedRealtime) {
        ArrayMap<String, PackageHistory> userHistory = this.getUserHistoryLocked(userId);
        PackageHistory packageHistory = this.getPackageHistoryLocked(userHistory, packageName, elapsedRealtime);
        packageHistory.lastUsedElapsedTime = this.getElapsedTimeLocked(elapsedRealtime) - this.mElapsedTimeThreshold;
        packageHistory.lastUsedScreenTime = this.getScreenOnTimeLocked(elapsedRealtime) - (idle ? this.mScreenOnTimeThreshold : 0L) - 1000L;
    }

    public void clearUsageLocked(String packageName, int userId) {
        ArrayMap<String, PackageHistory> userHistory = this.getUserHistoryLocked(userId);
        userHistory.remove(packageName);
    }

    private boolean hasPassedThresholdsLocked(PackageHistory packageHistory, long elapsedRealtime) {
        return packageHistory.lastUsedScreenTime <= this.getScreenOnTimeLocked(elapsedRealtime) - this.mScreenOnTimeThreshold && packageHistory.lastUsedElapsedTime <= this.getElapsedTimeLocked(elapsedRealtime) - this.mElapsedTimeThreshold;
    }

    private File getUserFile(int userId) {
        return new File(new File(new File(this.mStorageDir, "users"), Integer.toString(userId)), APP_IDLE_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAppIdleTimesLocked(int userId, ArrayMap<String, PackageHistory> userHistory) {
        int type;
        XmlPullParser parser;
        FileInputStream fis;
        block9: {
            block8: {
                fis = null;
                AtomicFile appIdleFile = new AtomicFile(this.getUserFile(userId));
                fis = appIdleFile.openRead();
                parser = Xml.newPullParser();
                parser.setInput(fis, StandardCharsets.UTF_8.name());
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type == 2) break block8;
                Slog.e(TAG, "Unable to read app idle file for user " + userId);
                IoUtils.closeQuietly(fis);
                return;
            }
            if (parser.getName().equals(TAG_PACKAGES)) break block9;
            IoUtils.closeQuietly(fis);
            return;
        }
        try {
            while ((type = parser.next()) != 1) {
                String name;
                if (type != 2 || !(name = parser.getName()).equals(TAG_PACKAGE)) continue;
                String packageName = parser.getAttributeValue(null, ATTR_NAME);
                PackageHistory packageHistory = new PackageHistory();
                packageHistory.lastUsedElapsedTime = Long.parseLong(parser.getAttributeValue(null, ATTR_ELAPSED_IDLE));
                packageHistory.lastUsedScreenTime = Long.parseLong(parser.getAttributeValue(null, ATTR_SCREEN_IDLE));
                userHistory.put(packageName, packageHistory);
            }
        }
        catch (IOException | XmlPullParserException e) {
            try {
                Slog.e(TAG, "Unable to read app idle file for user " + userId);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fis);
                throw throwable;
            }
            IoUtils.closeQuietly(fis);
        }
        IoUtils.closeQuietly(fis);
    }

    public void writeAppIdleTimesLocked(int userId) {
        FileOutputStream fos = null;
        AtomicFile appIdleFile = new AtomicFile(this.getUserFile(userId));
        try {
            fos = appIdleFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer xml2 = new FastXmlSerializer();
            xml2.setOutput(bos, StandardCharsets.UTF_8.name());
            xml2.startDocument(null, true);
            xml2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            xml2.startTag(null, TAG_PACKAGES);
            ArrayMap<String, PackageHistory> userHistory = this.getUserHistoryLocked(userId);
            int N = userHistory.size();
            for (int i = 0; i < N; ++i) {
                String packageName = userHistory.keyAt(i);
                PackageHistory history = userHistory.valueAt(i);
                xml2.startTag(null, TAG_PACKAGE);
                xml2.attribute(null, ATTR_NAME, packageName);
                xml2.attribute(null, ATTR_ELAPSED_IDLE, Long.toString(history.lastUsedElapsedTime));
                xml2.attribute(null, ATTR_SCREEN_IDLE, Long.toString(history.lastUsedScreenTime));
                xml2.endTag(null, TAG_PACKAGE);
            }
            xml2.endTag(null, TAG_PACKAGES);
            xml2.endDocument();
            appIdleFile.finishWrite(fos);
        }
        catch (Exception e) {
            appIdleFile.failWrite(fos);
            Slog.e(TAG, "Error writing app idle file for user " + userId);
        }
    }

    public void dump(IndentingPrintWriter idpw, int userId) {
        idpw.println("Package idle stats:");
        idpw.increaseIndent();
        ArrayMap<String, PackageHistory> userHistory = this.mIdleHistory.get(userId);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long totalElapsedTime = this.getElapsedTimeLocked(elapsedRealtime);
        long screenOnTime = this.getScreenOnTimeLocked(elapsedRealtime);
        if (userHistory == null) {
            return;
        }
        int P = userHistory.size();
        for (int p = 0; p < P; ++p) {
            String packageName = userHistory.keyAt(p);
            PackageHistory packageHistory = userHistory.valueAt(p);
            idpw.print("package=" + packageName);
            idpw.print(" lastUsedElapsed=");
            TimeUtils.formatDuration(totalElapsedTime - packageHistory.lastUsedElapsedTime, idpw);
            idpw.print(" lastUsedScreenOn=");
            TimeUtils.formatDuration(screenOnTime - packageHistory.lastUsedScreenTime, idpw);
            idpw.print(" idle=" + (this.isIdleLocked(packageName, userId, elapsedRealtime) ? "y" : "n"));
            idpw.println();
        }
        idpw.println();
        idpw.print("totalElapsedTime=");
        TimeUtils.formatDuration(this.getElapsedTimeLocked(elapsedRealtime), idpw);
        idpw.println();
        idpw.print("totalScreenOnTime=");
        TimeUtils.formatDuration(this.getScreenOnTimeLocked(elapsedRealtime), idpw);
        idpw.println();
        idpw.decreaseIndent();
    }

    public void dumpHistory(IndentingPrintWriter idpw, int userId) {
        ArrayMap<String, PackageHistory> userHistory = this.mIdleHistory.get(userId);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        if (userHistory == null) {
            return;
        }
        int P = userHistory.size();
        for (int p = 0; p < P; ++p) {
            String packageName = userHistory.keyAt(p);
            byte[] history = userHistory.valueAt((int)p).recent;
            for (int i = 0; i < 100; ++i) {
                idpw.print(history[i] == 0 ? (char)'.' : 'A');
            }
            idpw.print(" idle=" + (this.isIdleLocked(packageName, userId, elapsedRealtime) ? "y" : "n"));
            idpw.print("  " + packageName);
            idpw.println();
        }
    }

    private static class PackageHistory {
        final byte[] recent = new byte[100];
        long lastUsedElapsedTime;
        long lastUsedScreenTime;

        private PackageHistory() {
        }
    }
}

